/*
 * Decompiled with CFR 0.152.
 */
package com.timesten.jdbc;

import com.timesten.jdbc.JdbcOdbcInputStream;

public class JdbcOdbcBoundCol {
    static final int BYTE_ARRAY = 0;
    static final int INTEGER_ARRAY = 1;
    static final int CHAR_ARRAY = 2;
    public boolean hasCachedValue = false;
    public boolean cachedNull;
    public int cachedInt;
    public short cachedShort;
    public long cachedLong;
    public double cachedDouble;
    public float cachedReal;
    public String cachedString;
    private int colLength;
    private int displayLength;
    private JdbcOdbcInputStream inputStream;
    private char[] charBuf = null;
    private int[] intBuf = null;

    public JdbcOdbcBoundCol(int n, int n2) {
        this.colLength = n2;
        this.displayLength = JdbcOdbcBoundCol.calcDisplayLength(n, n2);
    }

    public void clearCachedValue() {
        this.hasCachedValue = false;
        this.cachedNull = false;
    }

    int getDisplayLength() {
        return this.displayLength;
    }

    void setInputStream(JdbcOdbcInputStream jdbcOdbcInputStream) {
        this.inputStream = jdbcOdbcInputStream;
    }

    void closeInputStream() {
        if (this.inputStream != null) {
            this.inputStream.invalidate();
            this.inputStream = null;
        }
    }

    Object allocateBuffer(int n, boolean bl, int n2) {
        switch (n2) {
            case 2: {
                if (bl || this.charBuf == null || this.charBuf != null && this.charBuf.length < n) {
                    this.charBuf = new char[n];
                }
                return this.charBuf;
            }
            case 1: {
                if (bl || this.intBuf == null || this.intBuf != null && this.intBuf.length < n) {
                    this.intBuf = new int[n];
                }
                return this.intBuf;
            }
        }
        return null;
    }

    static int calcDisplayLength(int n, int n2) {
        switch (n) {
            case 4: {
                return 11;
            }
            case -4: 
            case -3: 
            case -2: {
                return n2 * 2;
            }
            case 9: {
                return 10;
            }
            case 10: {
                return 8;
            }
            case 11: {
                return 26;
            }
            case 2: 
            case 3: {
                return n2 + 2;
            }
            case -7: {
                return 1;
            }
            case -6: {
                return 4;
            }
            case 5: {
                return 6;
            }
            case -5: {
                return 20;
            }
            case 7: {
                return 13;
            }
            case 6: 
            case 8: {
                return 22;
            }
        }
        return n2;
    }
}

