/*
 * Decompiled with CFR 0.152.
 */
package com.timesten.jdbc;

import com.timesten.jdbc.JdbcOdbcPreparedStatement;
import com.timesten.jdbc.Logger;
import com.timesten.jdbc.OdbcDef;
import com.timesten.jdbc.TimesTenConnection;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class JdbcOdbcCallableStatement
extends JdbcOdbcPreparedStatement
implements CallableStatement {
    private boolean lastParameterNull;
    public byte[] scalez = new byte[200];

    protected JdbcOdbcCallableStatement() {
    }

    public JdbcOdbcCallableStatement(TimesTenConnection timesTenConnection, String string) throws SQLException {
        super(timesTenConnection, string);
        this.lastParameterNull = false;
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.registerOutParameter(n, n2, 0);
    }

    public synchronized void registerOutParameter(int n, int n2, int n3) throws SQLException {
        int n4;
        if (n > this.numParams) {
            throw new SQLException("Driver not capable", "S1C00");
        }
        this.setSqlType(n, n2);
        if (n <= 200) {
            this.scalez[n] = (byte)n3;
        }
        this.setOutputParameter(n, true);
        switch (n2) {
            case 91: {
                n4 = 10;
                break;
            }
            case 92: {
                n4 = 8;
                break;
            }
            case 93: {
                n4 = 19;
                if (n3 <= 0) break;
                n4 += n3 + 1;
                break;
            }
            case -7: {
                n4 = 1;
                break;
            }
            case -6: {
                n4 = 4;
                break;
            }
            case 5: {
                n4 = 6;
                break;
            }
            case 4: {
                n4 = 11;
                break;
            }
            case -5: {
                n4 = 20;
                break;
            }
            case 7: {
                n4 = 13;
                break;
            }
            case 6: 
            case 8: {
                n4 = 22;
                break;
            }
            case 2: 
            case 3: {
                n4 = 38;
                break;
            }
            default: {
                n4 = 0;
                if (n4 > 0 && n4 <= 2000) break;
                n4 = 2000;
            }
        }
        byte[] byArray = this.allocBindBuf(n, n4 + 1);
        byte[] byArray2 = this.getLengthBuf(n);
        n2 = OdbcDef.jdbcTypeToOdbc(n2);
        int[] nArray = new int[]{0, 0, 0, 0};
        this.OdbcApi.SQLBindOutParameterString(this.hStmt.getValue(), n, n2, n3, byArray, byArray2, nArray);
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
        this.boundParams[n - 1].pB1 = nArray[2];
        this.boundParams[n - 1].pB2 = nArray[3];
    }

    public boolean wasNull() throws SQLException {
        return this.lastParameterNull;
    }

    public synchronized String getString(int n) throws SQLException {
        if (this.isNull(n)) {
            return null;
        }
        String string = null;
        try {
            string = JdbcOdbcCallableStatement.BytesToChars(this.OdbcApi.charSet, this.getDataBuf(n)).trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (string == null) {
            string = new String();
        }
        Logger.logln("*CallableStatement.getString: String value for OUT parameter " + n + "=" + string);
        return string;
    }

    public boolean getBoolean(int n) throws SQLException {
        if (this.isNull(n)) {
            return false;
        }
        boolean bl = false;
        if (this.getString(n).equals("1")) {
            bl = true;
        }
        return bl;
    }

    public byte getByte(int n) throws SQLException {
        return (byte)this.getInt(n);
    }

    public short getShort(int n) throws SQLException {
        return (short)this.getInt(n);
    }

    public int getInt(int n) throws SQLException {
        if (this.isNull(n)) {
            return 0;
        }
        Integer n2 = new Integer(this.getString(n));
        return n2;
    }

    public long getLong(int n) throws SQLException {
        if (this.isNull(n)) {
            return 0L;
        }
        Integer n2 = new Integer(this.getString(n));
        return n2.longValue();
    }

    public float getFloat(int n) throws SQLException {
        if (this.isNull(n)) {
            return 0.0f;
        }
        Float f = new Float(this.getString(n));
        return f.floatValue();
    }

    public double getDouble(int n) throws SQLException {
        if (this.isNull(n)) {
            return 0.0;
        }
        Double d = new Double(this.getString(n));
        return d;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (this.isNull(n)) {
            return null;
        }
        BigDecimal bigDecimal = new BigDecimal(this.getString(n));
        return bigDecimal.setScale(n2, 6);
    }

    public byte[] getBytes(int n) throws SQLException {
        if (this.isNull(n)) {
            return null;
        }
        return JdbcOdbcCallableStatement.hexStringToByteArray(this.getString(n));
    }

    public Date getDate(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return Date.valueOf(string);
    }

    public Time getTime(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return Time.valueOf(string);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        if (string.length() == 10) {
            string = string + " 00:00:00";
        }
        Timestamp timestamp = Timestamp.valueOf(string);
        return timestamp;
    }

    public Object getObject(int n) throws SQLException {
        Object object = null;
        int n2 = this.getSqlType(n);
        if (this.isNull(n)) {
            return null;
        }
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                object = this.getString(n);
                break;
            }
            case 2: 
            case 3: {
                if (n <= 200) {
                    object = this.getBigDecimal(n, this.scalez[n]);
                    break;
                }
                object = this.getBigDecimal(n, 4);
                break;
            }
            case -7: {
                object = new Boolean(this.getBoolean(n));
                break;
            }
            case -6: {
                object = new Integer(this.getByte(n));
                break;
            }
            case 5: {
                object = new Integer(this.getShort(n));
                break;
            }
            case 4: {
                object = new Integer(this.getInt(n));
                break;
            }
            case -5: {
                object = new Long(this.getLong(n));
                break;
            }
            case 6: 
            case 7: {
                object = new Float(this.getFloat(n));
                break;
            }
            case 8: {
                object = new Double(this.getDouble(n));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                object = this.getBytes(n);
                break;
            }
            case 91: {
                object = this.getDate(n);
                break;
            }
            case 92: {
                object = this.getTime(n);
                break;
            }
            case 93: {
                object = this.getTimestamp(n);
            }
        }
        return object;
    }

    protected boolean isNull(int n) throws SQLException {
        if (!this.isOutputParameter(n)) {
            throw new SQLException("Parameter " + n + " is not an OUTPUT parameter");
        }
        boolean bl = false;
        bl = this.getParamLength(n) == -1;
        Logger.logln("*CallableStatement.isNull: Output Parameter " + n + " null? : " + bl);
        this.lastParameterNull = bl;
        return bl;
    }

    protected void setSqlType(int n, int n2) {
        if (n >= 1 && n <= this.numParams) {
            this.boundParams[n - 1].setSqlType(n2);
        }
    }

    protected int getSqlType(int n) {
        int n2 = 1111;
        if (n >= 1 && n <= this.numParams) {
            n2 = this.boundParams[n - 1].getSqlType();
        }
        return n2;
    }

    protected void setOutputParameter(int n, boolean bl) {
        if (n >= 1 && n <= this.numParams) {
            this.boundParams[n - 1].setOutputParameter(bl);
        }
    }

    protected boolean isOutputParameter(int n) {
        boolean bl = false;
        if (n >= 1 && n <= this.numParams) {
            bl = this.boundParams[n - 1].isOutputParameter();
        }
        return bl;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Ref getRef(int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Blob getBlob(int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Clob getClob(int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Array getArray(int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public URL getURL(int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setURL(String string, URL uRL) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setNull(String string, int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setByte(String string, byte by) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setShort(String string, short s) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setInt(String string, int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setLong(String string, long l) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setFloat(String string, float f) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setDouble(String string, double d) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setString(String string, String string2) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setDate(String string, Date date) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setTime(String string, Time time) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setObject(String string, Object object) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public String getString(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public boolean getBoolean(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public byte getByte(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public short getShort(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public int getInt(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public long getLong(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public float getFloat(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public double getDouble(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public byte[] getBytes(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Date getDate(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Time getTime(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Object getObject(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Ref getRef(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Blob getBlob(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Clob getClob(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Array getArray(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public URL getURL(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }
}

