/*
 * Decompiled with CFR 0.152.
 */
package com.timesten.jdbc;

import com.timesten.jdbc.BasicPhantomReference;
import com.timesten.jdbc.JdbcOdbc;
import com.timesten.jdbc.JdbcOdbcCallableStatement;
import com.timesten.jdbc.JdbcOdbcClient;
import com.timesten.jdbc.JdbcOdbcDatabaseMetaData;
import com.timesten.jdbc.JdbcOdbcDirect;
import com.timesten.jdbc.JdbcOdbcObject;
import com.timesten.jdbc.JdbcOdbcPreparedStatement;
import com.timesten.jdbc.JdbcOdbcSQLWarning;
import com.timesten.jdbc.JdbcOdbcStatement;
import com.timesten.jdbc.Logger;
import com.timesten.jdbc.ObservableConnection;
import com.timesten.jdbc.ReferenceManager;
import com.timesten.jdbc.TimesTenConnection;
import com.timesten.jdbc.TimesTenDriverBase;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public class JdbcOdbcConnection
extends JdbcOdbcObject
implements TimesTenConnection {
    private String myUrl;
    private String myDsn;
    private Properties properties;
    private boolean isCSConn;
    private JdbcOdbc odbcApi;
    private int hEnv;
    private int hDbc;
    private Boolean isConnOpen = false;
    private static final int CONNECTION_OPEN = 1;
    private static final int CONNECTION_CLOSING = 2;
    private static final int CONNECTION_CLOSED = 4;
    private Integer connectionState = new Integer(4);
    private SQLWarning lastWarning;
    private int odbcVer;
    private Map statements;
    private final ReferenceManager referenceManager;
    private Map typeMap;
    protected TimeZone tz = null;
    protected int tzOffset = 0;
    private static final boolean commitInvalidConnectionFlag = Boolean.getBoolean("com.timesten.jdbc.unittest.commitInvalidConnectionFlag");

    public JdbcOdbcConnection() {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbcConnection.constructor");
        }
        this.odbcApi = null;
        this.tz = TimeZone.getDefault();
        this.tzOffset = this.tz.getRawOffset();
        this.resetConnAttrs();
        this.referenceManager = ReferenceManager.getInstance();
    }

    protected void finalize() {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.finalize(): " + this);
        }
        try {
            if (!this.isClosed()) {
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized Statement createStatement() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbcConnection.createStatement()");
        }
        this.validateConnectionInternal();
        this.clearWarningsInternal();
        JdbcOdbcStatement jdbcOdbcStatement = null;
        jdbcOdbcStatement = new JdbcOdbcStatement(this);
        if (jdbcOdbcStatement.getWarnings() != null) {
            this.setWarning(jdbcOdbcStatement.getWarnings());
        }
        this.registerStatement(jdbcOdbcStatement);
        return jdbcOdbcStatement;
    }

    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.prepareStatement(" + string + ")");
        }
        this.validateArgNotNull(string);
        this.validateConnectionInternal();
        this.clearWarningsInternal();
        JdbcOdbcPreparedStatement jdbcOdbcPreparedStatement = null;
        jdbcOdbcPreparedStatement = new JdbcOdbcPreparedStatement(this, string);
        if (jdbcOdbcPreparedStatement.getWarnings() != null) {
            this.setWarning(jdbcOdbcPreparedStatement.getWarnings());
        }
        this.registerStatement(jdbcOdbcPreparedStatement);
        return jdbcOdbcPreparedStatement;
    }

    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.prepareCall(" + string + ")");
        }
        this.validateArgNotNull(string);
        this.validateConnectionInternal();
        this.clearWarningsInternal();
        JdbcOdbcCallableStatement jdbcOdbcCallableStatement = null;
        jdbcOdbcCallableStatement = new JdbcOdbcCallableStatement(this, string);
        if (jdbcOdbcCallableStatement.getWarnings() != null) {
            this.setWarning(jdbcOdbcCallableStatement.getWarnings());
        }
        this.registerStatement(jdbcOdbcCallableStatement);
        return jdbcOdbcCallableStatement;
    }

    public synchronized String nativeSQL(String string) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.nativeSQL(" + string + ")");
        }
        this.validateArgNotNull(string);
        this.validateConnectionInternal();
        this.clearWarningsInternal();
        String string2 = "";
        try {
            string2 = this.odbcApi.SQLNativeSql(this.hDbc, string);
        }
        catch (SQLWarning sQLWarning) {
            this.setWarning(sQLWarning);
        }
        return string2;
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.setAutoCommit(" + bl + "), force a commit");
        }
        if (this.IsInActiveTransaction()) {
            this.commit();
        }
        int n = 0;
        if (bl) {
            n = 1;
        }
        this.setConnectOption((short)102, n);
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.getAutoCommit()");
        }
        return this.getConnectOption((short)102) == 1;
    }

    public synchronized void commit() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.commit()");
        }
        this.validateConnectionInternal();
        this.clearWarningsInternal();
        try {
            this.odbcApi.SQLTransact(this.hEnv, this.hDbc, (short)0);
        }
        catch (SQLWarning sQLWarning) {
            this.setWarning(sQLWarning);
        }
    }

    public synchronized void rollback() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.rollback()");
        }
        this.validateConnectionInternal();
        this.clearWarningsInternal();
        try {
            this.odbcApi.SQLTransact(this.hEnv, this.hDbc, (short)1);
        }
        catch (SQLWarning sQLWarning) {
            this.setWarning(sQLWarning);
        }
    }

    public synchronized void close() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.close()");
        }
        if (this.isClosed()) {
            return;
        }
        this.clearWarningsInternal();
        this.referenceManager.reap();
        try {
            this.closeAllStatements(true);
            try {
                block15: {
                    if (this.IsInActiveTransaction()) {
                        if (this.getAutoCommit()) {
                            try {
                                if (this.isDataStoreValid() || commitInvalidConnectionFlag) {
                                    this.commit();
                                }
                                break block15;
                            }
                            catch (SQLException sQLException) {
                                if (this.isClosed()) {
                                    return;
                                }
                                if (!JdbcOdbcConnection.isConnectionBroken(sQLException)) {
                                    this.rollback();
                                }
                                break block15;
                            }
                        }
                        try {
                            this.rollback();
                        }
                        catch (SQLException sQLException) {
                            if (JdbcOdbcConnection.isConnectionBroken(sQLException)) break block15;
                            throw sQLException;
                        }
                    }
                }
                this.disconnectOdbcConnection(this.hDbc);
            }
            catch (SQLException sQLException) {
                Logger.log(sQLException);
                throw sQLException;
            }
            this.odbcApi.SQLFreeConnect(this.hDbc);
            this.odbcApi.SQLFreeEnv(this.hEnv);
            this.resetConnAttrs();
        }
        catch (SQLWarning sQLWarning) {
            this.setWarning(sQLWarning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.isClosed()");
        }
        Integer n = this.connectionState;
        synchronized (n) {
            return this.connectionState != 1;
        }
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.getMetaData()");
        }
        this.validateConnectionInternal();
        this.clearWarningsInternal();
        JdbcOdbcDatabaseMetaData jdbcOdbcDatabaseMetaData = null;
        jdbcOdbcDatabaseMetaData = new JdbcOdbcDatabaseMetaData(this);
        return jdbcOdbcDatabaseMetaData;
    }

    public synchronized void setReadOnly(boolean bl) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.setReadOnly(" + bl + ")");
        }
        int n = 1;
        if (!bl) {
            n = 0;
        }
        try {
            this.setConnectOption((short)101, n);
        }
        catch (SQLException sQLException) {
            Logger.logln("*Connection.setReadOnly: Exception ignored");
            Logger.log(sQLException);
        }
    }

    public synchronized boolean isReadOnly() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.isReadOnly()");
        }
        return this.getConnectOption((short)101) == 1;
    }

    public synchronized void setCatalog(String string) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.setCatalog(" + string + ")");
        }
        this.clearWarningsInternal();
    }

    public synchronized String getCatalog() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.getCatalog()");
        }
        this.clearWarningsInternal();
        return null;
    }

    public synchronized void setTransactionIsolation(int n) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.setTransactionIsolation(" + n + ")");
        }
        short s = 108;
        int n2 = n;
        switch (n) {
            case 0: {
                throw new SQLException("Driver not capable", "S1C00");
            }
            case 1: {
                s = 108;
                n2 = 1;
                break;
            }
            case 2: {
                s = 108;
                n2 = 2;
                break;
            }
            case 4: {
                s = 108;
                n2 = 4;
                break;
            }
            case 8: {
                s = 108;
                n2 = 8;
                break;
            }
        }
        this.setConnectOption(s, n2);
    }

    public synchronized int getTransactionIsolation() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.getTransactionIsolation()");
        }
        int n = 0;
        int n2 = this.getConnectOption((short)108);
        switch (n2) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 8: {
                n = 8;
                break;
            }
            default: {
                n = n2;
            }
        }
        return n;
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.getWarnings()");
        }
        return this.lastWarning;
    }

    public synchronized void clearWarnings() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.clearWarnings()");
        }
        this.clearWarningsInternal();
    }

    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        List list = this.validateResultSetType(n, n2, 2);
        Statement statement = this.createStatement();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.setWarning((SQLWarning)iterator.next());
            }
        }
        return statement;
    }

    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        List list = this.validateResultSetType(n, n2, 2);
        PreparedStatement preparedStatement = this.prepareStatement(string);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.setWarning((SQLWarning)iterator.next());
            }
        }
        return preparedStatement;
    }

    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        List list = this.validateResultSetType(n, n2, 2);
        CallableStatement callableStatement = this.prepareCall(string);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.setWarning((SQLWarning)iterator.next());
            }
        }
        return callableStatement;
    }

    public synchronized Map getTypeMap() throws SQLException {
        this.clearWarningsInternal();
        if (this.typeMap != null) {
            return this.typeMap;
        }
        return new HashMap();
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        this.clearWarningsInternal();
        this.typeMap = map;
    }

    public void setHoldability(int n) throws SQLException {
        if (n != 2) {
            throw new SQLException("Driver not capable", "S1C00");
        }
    }

    public int getHoldability() throws SQLException {
        return 2;
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        List list = this.validateResultSetType(n, n2, n3);
        Statement statement = this.createStatement();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.setWarning((SQLWarning)iterator.next());
            }
        }
        return statement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        List list = this.validateResultSetType(n, n2, n3);
        PreparedStatement preparedStatement = this.prepareStatement(string);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.setWarning((SQLWarning)iterator.next());
            }
        }
        return preparedStatement;
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        List list = this.validateResultSetType(n, n2, n3);
        CallableStatement callableStatement = this.prepareCall(string);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.setWarning((SQLWarning)iterator.next());
            }
        }
        return callableStatement;
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public int getHENV() {
        return this.hEnv;
    }

    public int getHDBC() {
        return this.hDbc;
    }

    public String getURL() {
        return this.myUrl;
    }

    public String getDSN() {
        return this.myDsn;
    }

    public synchronized int getODBCVer() {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.getODBCVer()");
        }
        if (this.odbcVer == 0) {
            try {
                String string = this.odbcApi.SQLGetInfoString(this.hDbc, (short)77);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                String string = (String)jdbcOdbcSQLWarning.value;
                this.lastWarning = jdbcOdbcSQLWarning;
            }
            catch (SQLException sQLException) {
                String string = "-1";
                Integer n = new Integer(string.substring(0, 2));
                this.odbcVer = n;
            }
        }
        return this.odbcVer;
    }

    public synchronized void validateConnection() throws SQLException {
        this.validateConnectionInternal();
    }

    public synchronized void setTtPrefetchClose(boolean bl) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.setTtPrefetchClose(" + bl + ")");
        }
        int n = 1;
        if (!bl) {
            n = 0;
        }
        this.setConnectOption((short)3000, n);
    }

    public synchronized boolean getTtPrefetchClose() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.getTtPrefetchClose()");
        }
        return this.getConnectOption((short)3000) == 1;
    }

    public synchronized void setTtPrefetchCount(int n) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.setTtPrefetchCount(" + n + ")");
        }
        this.setConnectOption((short)3001, n);
    }

    public synchronized int getTtPrefetchCount() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.getTtPrefetchCount()");
        }
        int n = this.getConnectOption((short)3001);
        return n;
    }

    public void setObserver(ObservableConnection observableConnection) {
        this.odbcApi.setObserver(observableConnection);
    }

    public boolean isCSConn() throws SQLException {
        return this.isCSConn;
    }

    public Properties getProperties() {
        return this.properties;
    }

    TimeZone getTimeZone() {
        return this.tz;
    }

    int getRawTZOffset() {
        return this.tzOffset;
    }

    synchronized void connect(String string, Properties properties, int n) throws SQLException {
        String string2;
        String string3;
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbcConnection.connect(" + string + ")");
        }
        if (!this.isClosed()) {
            this.close();
        }
        this.myUrl = string;
        this.isCSConn = TimesTenDriverBase.isCSConnection(string);
        if (properties != null) {
            this.properties = properties;
        }
        if (this.odbcApi == null) {
            string3 = this.properties.getProperty("charSet", System.getProperty("file.encoding", ""));
            try {
                this.odbcApi = this.isCSConn ? new JdbcOdbcClient(false, string3) : new JdbcOdbcDirect(false, string3);
            }
            catch (Exception exception) {
                Logger.logln("*JdbcOdbcConnection.connect: Unable to load JNI shared library");
                Logger.log(exception);
                throw new SQLException(exception.getMessage());
            }
        }
        this.hEnv = this.odbcApi.SQLAllocEnv();
        this.hDbc = this.odbcApi.SQLAllocConnect(this.hEnv);
        if (n > 0) {
            this.setLoginTimeout(n);
        }
        string3 = this.properties.getProperty("user", "");
        String string4 = this.properties.getProperty("password", "");
        String string5 = this.properties.getProperty("oraclePassword", "");
        this.myDsn = TimesTenDriverBase.getSubName(this.myUrl);
        int n2 = this.myDsn.indexOf(59);
        int n3 = this.myDsn.indexOf(61);
        String string6 = "";
        string6 = n3 < 0 || n2 >= 0 && n2 < n3 ? "DSN=" + this.myDsn : this.myDsn;
        if (string3.length() > 0) {
            string6 = string6 + ";UID=" + string3;
        }
        if (string4.length() > 0) {
            string6 = string6 + ";PWD=" + string4;
        }
        if (string5.length() > 0) {
            string6 = string6 + ";OraclePWD=" + string5;
        }
        if ((string2 = this.properties.getProperty("xaConn", "")).length() > 0) {
            string6 = string6 + ";XAConnection=" + string2;
        }
        try {
            this.odbcApi.SQLDriverConnect(this.hDbc, string6);
        }
        catch (SQLWarning sQLWarning) {
            this.setWarning(sQLWarning);
        }
        catch (SQLException sQLException) {
            this.odbcApi.SQLFreeConnect(this.hDbc);
            throw sQLException;
        }
        this.setConnectionState(1);
        this.statements = Collections.synchronizedMap(new HashMap());
        this.odbcApi.SQLSetConnectOption(this.hDbc, (short)3050, 1);
        if (Logger.isTracingOn()) {
            DatabaseMetaData databaseMetaData = this.getMetaData();
            Logger.logln("*JdbcOdbcConnection.connect: Driver name:    " + databaseMetaData.getDriverName());
            Logger.logln("*JdbcOdbcConnection.connect: Driver version: " + databaseMetaData.getDriverVersion());
        }
    }

    boolean IsInActiveTransaction() throws SQLException {
        int n;
        block5: {
            if (Logger.isTracingOn()) {
                Logger.logln("*Connection.IsInActiveTransaction()");
            }
            n = 0;
            try {
                this.validateConnectionInternal();
                n = this.odbcApi.SQLGetInfo(this.hDbc, (short)3050);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                Integer n2 = (Integer)jdbcOdbcSQLWarning.value;
                n = n2;
                this.setWarning(jdbcOdbcSQLWarning);
            }
            catch (SQLException sQLException) {
                if (JdbcOdbcConnection.isConnectionBroken(sQLException)) break block5;
                throw sQLException;
            }
        }
        if (n == 0) {
            return false;
        }
        return (n & 2) != 2;
    }

    JdbcOdbc getJdbcOdbcBridge() {
        return this.odbcApi;
    }

    private void resetConnAttrs() {
        this.setConnectionState(4);
        this.myUrl = null;
        this.isCSConn = false;
        this.hEnv = 0;
        this.hDbc = 0;
        this.odbcVer = 0;
        this.lastWarning = null;
        this.statements = null;
        this.typeMap = null;
        this.properties = new Properties();
    }

    private void validateConnectionInternal() throws SQLException {
        if (this.isClosed()) {
            String string = "Connection not open";
            String string2 = "08003";
            Logger.logln("*Connection.validateConnectionInternal: Returning exception: " + string2 + " " + string);
            throw new SQLException(string, string2);
        }
    }

    private void validateArgNotNull(String string) throws SQLException {
        if (string == null) {
            String string2 = "Invalid argument value";
            String string3 = "S1009";
            Logger.logln("*Connection.validateArgNotNull: Returning exception: " + string3 + " " + string2);
            throw new SQLException(string2, string3);
        }
    }

    private void setLoginTimeout(int n) throws SQLException {
        this.setConnectOption((short)103, n);
    }

    private void registerStatement(JdbcOdbcStatement jdbcOdbcStatement) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.registerStatement(" + jdbcOdbcStatement + ")");
        }
        BasicPhantomReference basicPhantomReference = this.referenceManager.addReference(jdbcOdbcStatement);
        jdbcOdbcStatement.setRegisteredReference(basicPhantomReference);
        this.statements.put(basicPhantomReference, Boolean.TRUE);
    }

    void deregisterStatement(BasicPhantomReference basicPhantomReference) {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.deregisterStatement(" + basicPhantomReference + ")");
        }
        this.statements.remove(basicPhantomReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllStatements(boolean bl) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Connection.closeAllStatements: " + this.statements.size() + " Statement(s) to clean up");
        }
        if (this.statements.size() == 0) {
            return;
        }
        ArrayList arrayList = new ArrayList(this.statements.size());
        Object object = this.statements;
        synchronized (object) {
            Iterator iterator = this.statements.keySet().iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
                iterator.remove();
            }
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            BasicPhantomReference basicPhantomReference = (BasicPhantomReference)object.next();
            JdbcOdbcStatement jdbcOdbcStatement = (JdbcOdbcStatement)basicPhantomReference.get();
            if (jdbcOdbcStatement == null) {
                this.referenceManager.handleReference(basicPhantomReference);
            } else if (bl) {
                jdbcOdbcStatement.closePooledStatement();
            } else {
                jdbcOdbcStatement.close();
            }
            object.remove();
        }
    }

    private int getConnectOption(short s) throws SQLException {
        int n = 0;
        this.clearWarningsInternal();
        try {
            n = this.odbcApi.SQLGetConnectOption(this.hDbc, s);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            Integer n2 = (Integer)jdbcOdbcSQLWarning.value;
            n = n2;
            this.setWarning(jdbcOdbcSQLWarning);
        }
        return n;
    }

    private void setConnectOption(short s, int n) throws SQLException {
        this.clearWarningsInternal();
        try {
            this.odbcApi.SQLSetConnectOption(this.hDbc, s, n);
        }
        catch (SQLWarning sQLWarning) {
            this.setWarning(sQLWarning);
        }
    }

    private void setWarning(SQLWarning sQLWarning) throws SQLException {
        if (this.lastWarning == null) {
            this.lastWarning = sQLWarning;
        } else {
            this.lastWarning.setNextWarning(sQLWarning);
        }
    }

    public synchronized void clearWarningsInternal() {
        this.lastWarning = null;
    }

    public boolean isDataStoreValid() throws SQLException {
        return this.odbcApi.isDataStoreValid(this.hDbc);
    }

    private List validateResultSetType(int n, int n2, int n3) throws SQLException {
        ArrayList<SQLWarning> arrayList = null;
        SQLWarning sQLWarning = null;
        switch (n) {
            case 1003: {
                break;
            }
            case 1004: 
            case 1005: {
                if (arrayList == null) {
                    arrayList = new ArrayList<SQLWarning>();
                }
                sQLWarning = new SQLWarning("Driver not capable of result set type " + n + ", supports TYPE_FORWARD_ONLY", "S1C00");
                arrayList.add(sQLWarning);
                break;
            }
            default: {
                throw new SQLException("Invalid argument value " + n, "S1009");
            }
        }
        switch (n2) {
            case 1007: {
                break;
            }
            case 1008: {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                sQLWarning = new SQLWarning("Driver not capable of result set concurrency " + n2 + ", supports CONCUR_READ_ONLY", "S1C00");
                arrayList.add(sQLWarning);
                break;
            }
            default: {
                throw new SQLException("Invalid argument value " + n2, "S1009");
            }
        }
        switch (n3) {
            case 2: {
                break;
            }
            case 1: {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                sQLWarning = new SQLWarning("Driver not capable of open cursors across commit " + n3 + ", supports CLOSE_CURSORS_AT_COMMIT only", "S1C00");
                arrayList.add(sQLWarning);
                break;
            }
            default: {
                throw new SQLException("Invalid argument value " + n3, "S1009");
            }
        }
        return arrayList;
    }

    public final ReferenceManager getReferenceManager() {
        return this.referenceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setConnectionState(int n) {
        Integer n2 = this.connectionState;
        synchronized (n2) {
            this.connectionState = new Integer(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dropOdbcStatement(int n) throws SQLException {
        Integer n2 = this.connectionState;
        synchronized (n2) {
            if (this.connectionState == 4) {
                if (Logger.isTracingOn()) {
                    Logger.logln("*Connection.dropOdbcStatement(): connection is closed/closing." + this.connectionState);
                }
                return;
            }
            this.odbcApi.SQLFreeStmt(n, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void disconnectOdbcConnection(int n) throws SQLException {
        Integer n2 = this.connectionState;
        synchronized (n2) {
            this.odbcApi.SQLDisconnect(this.hDbc);
            this.connectionState = new Integer(4);
            if (Logger.isTracingOn()) {
                Logger.logln("*Connection.disconnectOdbcConnection(): successful." + this.connectionState);
            }
        }
    }

    final synchronized void prepareForReuse() throws SQLException {
        block9: {
            if (Logger.isTracingOn()) {
                Logger.logln("*Connection.prepareForReuse()");
            }
            this.referenceManager.reap();
            this.closeAllStatements(false);
            if (!this.IsInActiveTransaction()) {
                return;
            }
            if (this.getAutoCommit()) {
                try {
                    if (this.isDataStoreValid()) {
                        this.commit();
                    }
                    break block9;
                }
                catch (SQLException sQLException) {
                    if (!JdbcOdbcConnection.isConnectionBroken(sQLException)) {
                        this.rollback();
                    }
                    break block9;
                }
            }
            try {
                this.rollback();
            }
            catch (SQLException sQLException) {
                if (JdbcOdbcConnection.isConnectionBroken(sQLException)) break block9;
                throw sQLException;
            }
        }
    }
}

