/*
 * Decompiled with CFR 0.152.
 */
package com.timesten.jdbc;

import com.timesten.jdbc.JdbcOdbc;
import com.timesten.jdbc.JdbcOdbcConnection;
import com.timesten.jdbc.JdbcOdbcObject;
import com.timesten.jdbc.JdbcOdbcPseudoCol;
import com.timesten.jdbc.JdbcOdbcResultSet;
import com.timesten.jdbc.JdbcOdbcStatement;
import com.timesten.jdbc.Logger;
import com.timesten.jdbc.TimesTenConnection;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class JdbcOdbcDatabaseMetaData
extends JdbcOdbcObject
implements DatabaseMetaData {
    protected TimesTenConnection Con;
    protected int hDbc;
    protected JdbcOdbc OdbcApi;

    public JdbcOdbcDatabaseMetaData(TimesTenConnection timesTenConnection) {
        this.Con = timesTenConnection;
        this.hDbc = this.Con.getHDBC();
        this.OdbcApi = ((JdbcOdbcConnection)this.Con).getJdbcOdbcBridge();
    }

    void changeOwnerConnection(TimesTenConnection timesTenConnection) {
        this.Con = timesTenConnection;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        Logger.log("*DatabaseMetaData.allProceduresAreCallable");
        return this.getInfoBooleanString((short)20);
    }

    public boolean allTablesAreSelectable() throws SQLException {
        Logger.logln("*DatabaseMetaData.allTablesAreSelectable");
        return this.getInfoBooleanString((short)19);
    }

    public String getURL() throws SQLException {
        Logger.logln("*DatabaseMetaData.getURL");
        return this.Con.getURL();
    }

    public String getUserName() throws SQLException {
        Logger.logln("*DatabaseMetaData.getUserName");
        return this.getInfoString((short)47);
    }

    public boolean isReadOnly() throws SQLException {
        Logger.logln("*DatabaseMetaData.isReadOnly");
        return this.getInfoBooleanString((short)25);
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        Logger.logln("*DatabaseMetaData.nullsAreSortedHigh");
        int n = this.getInfoShort((short)85);
        return n == 0;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        Logger.logln("*DatabaseMetaData.nullsAreSortedLow");
        int n = this.getInfo((short)85);
        return n == 1;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        Logger.logln("*DatabaseMetaData.nullsAreSortedAtStart");
        int n = this.getInfo((short)85);
        return n == 2;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        Logger.logln("*DatabaseMetaData.nullsAreSortedAtEnd");
        int n = this.getInfo((short)85);
        return n == 4;
    }

    public String getDatabaseProductName() throws SQLException {
        Logger.logln("*DatabaseMetaData.getDatabaseProductName");
        return this.getInfoString((short)17);
    }

    public String getDatabaseProductVersion() throws SQLException {
        Logger.logln("*DatabaseMetaData.getDatabaseProductVersion");
        return this.getInfoString((short)18);
    }

    public String getDriverName() throws SQLException {
        Logger.logln("*DatabaseMetaData.getDriverName");
        return "JDBC-ODBC Bridge (" + this.getInfoString((short)6) + ")";
    }

    public String getDriverVersion() throws SQLException {
        Logger.logln("*DatabaseMetaData.getDriverVersion");
        return "6.0 (" + this.getInfoString((short)7) + ")";
    }

    public int getDriverMajorVersion() {
        return 6;
    }

    public int getDriverMinorVersion() {
        return 0;
    }

    public boolean usesLocalFiles() throws SQLException {
        Logger.logln("*DatabaseMetaData.usesLocalFiles");
        int n = this.getInfoShort((short)84);
        return n == 2;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        Logger.logln("*DatabaseMetaData.usesLocalFilePerTable");
        int n = this.getInfoShort((short)84);
        return n == 1;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsMixedCaseIdentifiers");
        int n = this.getInfoShort((short)28);
        return n == 3;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        Logger.logln("*DatabaseMetaData.storesUpperCaseIdentifiers");
        int n = this.getInfoShort((short)28);
        return n == 1;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        Logger.logln("*DatabaseMetaData.storesLowerCaseIdentifiers");
        int n = this.getInfoShort((short)28);
        return n == 2;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        Logger.logln("*DatabaseMetaData.storesMixedCaseIdentifiers");
        int n = this.getInfoShort((short)28);
        return n == 4;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsMixedCaseQuotedIdentifiers");
        int n = this.getInfoShort((short)93);
        return n == 4 || n == 1 || n == 2;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        Logger.logln("*DatabaseMetaData.storesUpperCaseQuotedIdentifiers");
        int n = this.getInfoShort((short)93);
        return n == 1;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        Logger.logln("*DatabaseMetaData.storesLowerCaseQuotedIdentifiers");
        int n = this.getInfoShort((short)93);
        return n == 2;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        Logger.logln("*DatabaseMetaData.storesMixedCaseQuotedIdentifiers");
        int n = this.getInfoShort((short)93);
        return n == 4;
    }

    public String getIdentifierQuoteString() throws SQLException {
        Logger.logln("*DatabaseMetaData.getIdentifierQuoteString");
        return this.getInfoString((short)29);
    }

    public String getSQLKeywords() throws SQLException {
        Logger.logln("*DatabaseMetaData.getSQLKeywords");
        return this.getInfoString((short)89, 8300);
    }

    public String getNumericFunctions() throws SQLException {
        int n;
        Logger.logln("*DatabaseMetaData.getNumericFunctions");
        int n2 = this.getInfo((short)49);
        StringBuffer stringBuffer = new StringBuffer(128);
        if ((n2 & 1) != 0) {
            stringBuffer.append("ABS,");
        }
        if ((n2 & 2) != 0) {
            stringBuffer.append("ACOS,");
        }
        if ((n2 & 4) != 0) {
            stringBuffer.append("ASIN,");
        }
        if ((n2 & 8) != 0) {
            stringBuffer.append("ATAN,");
        }
        if ((n2 & 0x10) != 0) {
            stringBuffer.append("ATAN2,");
        }
        if ((n2 & 0x20) != 0) {
            stringBuffer.append("CEILING,");
        }
        if ((n2 & 0x40) != 0) {
            stringBuffer.append("COS,");
        }
        if ((n2 & 0x80) != 0) {
            stringBuffer.append("COT,");
        }
        if ((n2 & 0x40000) != 0) {
            stringBuffer.append("DEGREES,");
        }
        if ((n2 & 0x100) != 0) {
            stringBuffer.append("EXP,");
        }
        if ((n2 & 0x200) != 0) {
            stringBuffer.append("FLOOR,");
        }
        if ((n2 & 0x400) != 0) {
            stringBuffer.append("LOG,");
        }
        if ((n2 & 0x80000) != 0) {
            stringBuffer.append("LOG10,");
        }
        if ((n2 & 0x800) != 0) {
            stringBuffer.append("MOD,");
        }
        if ((n2 & 0x10000) != 0) {
            stringBuffer.append("PI,");
        }
        if ((n2 & 0x100000) != 0) {
            stringBuffer.append("POWER,");
        }
        if ((n2 & 0x200000) != 0) {
            stringBuffer.append("RADIANS,");
        }
        if ((n2 & 0x20000) != 0) {
            stringBuffer.append("RAND,");
        }
        if ((n2 & 0x400000) != 0) {
            stringBuffer.append("ROUND,");
        }
        if ((n2 & 0x1000) != 0) {
            stringBuffer.append("SIGN,");
        }
        if ((n2 & 0x2000) != 0) {
            stringBuffer.append("SIN,");
        }
        if ((n2 & 0x4000) != 0) {
            stringBuffer.append("SQRT,");
        }
        if ((n2 & 0x8000) != 0) {
            stringBuffer.append("TAN,");
        }
        if ((n2 & 0x800000) != 0) {
            stringBuffer.append("TRUNCATE,");
        }
        if ((n = stringBuffer.length()) > 0) {
            return stringBuffer.substring(0, n - 1);
        }
        return "";
    }

    public String getStringFunctions() throws SQLException {
        int n;
        Logger.logln("*DatabaseMetaData.getStringFunctions");
        int n2 = this.getInfo((short)50);
        StringBuffer stringBuffer = new StringBuffer(128);
        if ((n2 & 0x2000) != 0) {
            stringBuffer.append("ASCII,");
        }
        if ((n2 & 0x4000) != 0) {
            stringBuffer.append("CHAR,");
        }
        if ((n2 & 1) != 0) {
            stringBuffer.append("CONCAT,");
        }
        if ((n2 & 0x8000) != 0) {
            stringBuffer.append("DIFFERENCE,");
        }
        if ((n2 & 2) != 0) {
            stringBuffer.append("INSERT,");
        }
        if ((n2 & 0x40) != 0) {
            stringBuffer.append("LCASE,");
        }
        if ((n2 & 4) != 0) {
            stringBuffer.append("LEFT,");
        }
        if ((n2 & 0x10) != 0) {
            stringBuffer.append("LENGTH,");
        }
        if ((n2 & 0x20) != 0) {
            stringBuffer.append("LOCATE,");
        }
        if ((n2 & 0x10000) != 0) {
            stringBuffer.append("LOCATE_2,");
        }
        if ((n2 & 8) != 0) {
            stringBuffer.append("LTRIM,");
        }
        if ((n2 & 0x80) != 0) {
            stringBuffer.append("REPEAT,");
        }
        if ((n2 & 0x100) != 0) {
            stringBuffer.append("REPLACE,");
        }
        if ((n2 & 0x200) != 0) {
            stringBuffer.append("RIGHT,");
        }
        if ((n2 & 0x400) != 0) {
            stringBuffer.append("RTRIM,");
        }
        if ((n2 & 0x20000) != 0) {
            stringBuffer.append("SOUNDEX,");
        }
        if ((n2 & 0x40000) != 0) {
            stringBuffer.append("SPACE,");
        }
        if ((n2 & 0x800) != 0) {
            stringBuffer.append("SUBSTRING,");
        }
        if ((n2 & 0x1000) != 0) {
            stringBuffer.append("UCASE,");
        }
        if ((n = stringBuffer.length()) > 0) {
            return stringBuffer.substring(0, n - 1);
        }
        return "";
    }

    public String getSystemFunctions() throws SQLException {
        int n;
        Logger.logln("*DatabaseMetaData.getSystemFunctions");
        int n2 = this.getInfo((short)51);
        StringBuffer stringBuffer = new StringBuffer(32);
        if ((n2 & 2) != 0) {
            stringBuffer.append("DATABASE,");
        }
        if ((n2 & 4) != 0) {
            stringBuffer.append("IFNULL,");
        }
        if ((n2 & 1) != 0) {
            stringBuffer.append("USER,");
        }
        if ((n = stringBuffer.length()) > 0) {
            return stringBuffer.substring(0, n - 1);
        }
        return "";
    }

    public String getTimeDateFunctions() throws SQLException {
        int n;
        Logger.logln("*DatabaseMetaData.getTimeDateFunctions");
        int n2 = this.getInfo((short)52);
        StringBuffer stringBuffer = new StringBuffer(128);
        if ((n2 & 2) != 0) {
            stringBuffer.append("CURDATE,");
        }
        if ((n2 & 0x200) != 0) {
            stringBuffer.append("CURTIME,");
        }
        if ((n2 & 0x8000) != 0) {
            stringBuffer.append("DAYNAME,");
        }
        if ((n2 & 4) != 0) {
            stringBuffer.append("DAYOFMONTH,");
        }
        if ((n2 & 8) != 0) {
            stringBuffer.append("DAYOFWEEK,");
        }
        if ((n2 & 0x10) != 0) {
            stringBuffer.append("DAYOFYEAR,");
        }
        if ((n2 & 0x400) != 0) {
            stringBuffer.append("HOUR,");
        }
        if ((n2 & 0x800) != 0) {
            stringBuffer.append("MINUTE,");
        }
        if ((n2 & 0x20) != 0) {
            stringBuffer.append("MONTH,");
        }
        if ((n2 & 0x10000) != 0) {
            stringBuffer.append("MONTHNAME,");
        }
        if ((n2 & 1) != 0) {
            stringBuffer.append("NOW,");
        }
        if ((n2 & 0x40) != 0) {
            stringBuffer.append("QUARTER,");
        }
        if ((n2 & 0x1000) != 0) {
            stringBuffer.append("SECOND,");
        }
        if ((n2 & 0x2000) != 0) {
            stringBuffer.append("TIMESTAMPADD,");
        }
        if ((n2 & 0x4000) != 0) {
            stringBuffer.append("TIMESTAMPDIFF,");
        }
        if ((n2 & 0x80) != 0) {
            stringBuffer.append("WEEK,");
        }
        if ((n2 & 0x100) != 0) {
            stringBuffer.append("YEAR,");
        }
        if ((n = stringBuffer.length()) > 0) {
            return stringBuffer.substring(0, n - 1);
        }
        return "";
    }

    public String getSearchStringEscape() throws SQLException {
        Logger.logln("*DatabaseMetaData.getSearchStringEscape");
        return this.getInfoString((short)14);
    }

    public String getExtraNameCharacters() throws SQLException {
        Logger.logln("*DatabaseMetaData.getExtraNameCharacters");
        return this.getInfoString((short)94);
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsAlterTableWithAddColumn");
        int n = this.getInfo((short)86);
        return (n & 1) > 0;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsAlterTableWithDropColumn");
        int n = this.getInfo((short)86);
        return (n & 2) > 0;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsColumnAliasing");
        return this.getInfoBooleanString((short)87);
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        Logger.logln("*DatabaseMetaData.nullPlusNullIsNull");
        int n = this.getInfoShort((short)22);
        return n == 0;
    }

    public boolean supportsConvert() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsConvert");
        int n = this.getInfo((short)48);
        return n == 1;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsConvert (" + n + "," + n2 + ")");
        short s = 0;
        boolean bl = false;
        int n3 = 0;
        switch (n) {
            case -7: {
                s = 55;
                break;
            }
            case -6: {
                s = 68;
                break;
            }
            case 5: {
                s = 65;
                break;
            }
            case 4: {
                s = 61;
                break;
            }
            case -5: {
                s = 53;
                break;
            }
            case 6: {
                s = 60;
                break;
            }
            case 7: {
                s = 64;
                break;
            }
            case 8: {
                s = 59;
                break;
            }
            case 2: {
                s = 63;
                break;
            }
            case 3: {
                s = 58;
                break;
            }
            case 1: {
                s = 56;
                break;
            }
            case 12: {
                s = 70;
                break;
            }
            case -1: {
                s = 62;
                break;
            }
            case 91: {
                s = 57;
                break;
            }
            case 92: {
                s = 66;
                break;
            }
            case 93: {
                s = 67;
                break;
            }
            case -2: {
                s = 54;
                break;
            }
            case -3: {
                s = 69;
                break;
            }
            case -4: {
                s = 71;
            }
        }
        int n4 = this.getInfo(s);
        switch (n2) {
            case -7: {
                n3 = 4096;
                break;
            }
            case -6: {
                n3 = 8192;
                break;
            }
            case 5: {
                n3 = 16;
                break;
            }
            case 4: {
                n3 = 8;
                break;
            }
            case -5: {
                n3 = 16384;
                break;
            }
            case 6: {
                n3 = 32;
                break;
            }
            case 7: {
                n3 = 64;
                break;
            }
            case 8: {
                n3 = 128;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
            case 3: {
                n3 = 4;
                break;
            }
            case 1: {
                n3 = 1;
                break;
            }
            case 12: {
                n3 = 256;
                break;
            }
            case -1: {
                n3 = 512;
                break;
            }
            case 91: {
                n3 = 32768;
                break;
            }
            case 92: {
                n3 = 65536;
                break;
            }
            case 93: {
                n3 = 131072;
                break;
            }
            case -2: {
                n3 = 1024;
                break;
            }
            case -3: {
                n3 = 2048;
                break;
            }
            case -4: {
                n3 = 262144;
            }
        }
        return (n4 & n3) > 0;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsTableCorrelationNames");
        int n = this.getInfoShort((short)74);
        return n == 1 || n == 2;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsDifferentTableCorrelationNames");
        int n = this.getInfoShort((short)74);
        return n == 1;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsExpressionsInOrderBy");
        return this.getInfoBooleanString((short)27);
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsOrderByUnrelated");
        return this.getInfoBooleanString((short)90);
    }

    public boolean supportsGroupBy() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsGroupBy");
        int n = this.getInfoShort((short)88);
        return n != 0;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsGroupByUnrelated");
        int n = this.getInfoShort((short)88);
        return n == 3;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsGroupByBeyondSelect");
        int n = this.getInfoShort((short)88);
        return n == 2;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsLikeEscapeClause");
        return this.getInfoBooleanString((short)113);
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsMultipleResultSets");
        return this.getInfoBooleanString((short)36);
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsMultipleTransactions");
        return this.getInfoBooleanString((short)37);
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsNonNullableColumns");
        int n = this.getInfoShort((short)75);
        return n == 1;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsMinimumSQLGrammar");
        int n = this.getInfoShort((short)15);
        return n == 0 || n == 1 || n == 2;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsCoreSQLGrammar");
        int n = this.getInfoShort((short)15);
        return n == 1 || n == 2;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsExtendedSQLGrammar");
        int n = this.getInfoShort((short)15);
        return n == 2;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsIntegrityEnhancementFacility");
        return this.getInfoBooleanString((short)73);
    }

    public boolean supportsOuterJoins() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsOuterJoins");
        String string = this.getInfoString((short)38);
        return !string.equalsIgnoreCase("N");
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsFullOuterJoins");
        String string = this.getInfoString((short)38);
        return string.equalsIgnoreCase("F");
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsLimitedOuterJoins");
        String string = this.getInfoString((short)38);
        return string.equalsIgnoreCase("P");
    }

    public String getSchemaTerm() throws SQLException {
        Logger.logln("*DatabaseMetaData.getSchemaTerm");
        return this.getInfoString((short)39);
    }

    public String getProcedureTerm() throws SQLException {
        Logger.logln("*DatabaseMetaData.getProcedureTerm");
        return this.getInfoString((short)40);
    }

    public String getCatalogTerm() throws SQLException {
        Logger.logln("*DatabaseMetaData.getCatalogTerm");
        return this.getInfoString((short)42);
    }

    public boolean isCatalogAtStart() throws SQLException {
        Logger.logln("*DatabaseMetaData.isCatalogAtStart");
        int n = this.getInfoShort((short)114);
        return n == 1;
    }

    public String getCatalogSeparator() throws SQLException {
        Logger.logln("*DatabaseMetaData.getCatalogSeparator");
        return this.getInfoString((short)41);
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsSchemasInDataManipulation");
        int n = this.getInfo((short)91);
        return (n & 1) > 0;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsSchemasInProcedureCalls");
        int n = this.getInfo((short)91);
        return (n & 2) > 0;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsSchemasInTableDefinitions");
        int n = this.getInfo((short)91);
        return (n & 4) > 0;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsSchemasInIndexDefintions");
        int n = this.getInfo((short)91);
        return (n & 8) > 0;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsSchemasInPrivilegeDefintions");
        int n = this.getInfo((short)91);
        return (n & 0x10) > 0;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsCatalogsInDataManipulation");
        int n = this.getInfo((short)92);
        return (n & 1) > 0;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsCatalogsInProcedureCalls");
        int n = this.getInfo((short)92);
        return (n & 2) > 0;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsCatalogsInTableDefinitions");
        int n = this.getInfo((short)92);
        return (n & 4) > 0;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsCatalogsInIndexDefinitions");
        int n = this.getInfo((short)92);
        return (n & 8) > 0;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsCatalogsInPrivilegeDefintions");
        int n = this.getInfo((short)92);
        return (n & 0x10) > 0;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsPositionedDelete");
        int n = this.getInfo((short)80);
        return (n & 1) > 0;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsPositionedUpdate");
        int n = this.getInfo((short)80);
        return (n & 2) > 0;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsSelectForUpdate");
        int n = this.getInfo((short)80);
        return (n & 4) > 0;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsStoredProcedures");
        return this.getInfoBooleanString((short)21);
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsSubqueriesInComparisions");
        int n = this.getInfo((short)95);
        return (n & 1) > 0;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsSubqueriesInExists");
        int n = this.getInfo((short)95);
        return (n & 2) > 0;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsSubqueriesInIns");
        int n = this.getInfo((short)95);
        return (n & 4) > 0;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsSubqueriesInQuantifieds");
        int n = this.getInfo((short)95);
        return (n & 8) > 0;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsCorrelatedSubqueries");
        int n = this.getInfo((short)95);
        return (n & 0x10) > 0;
    }

    public boolean supportsUnion() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsUnion");
        int n = this.getInfo((short)96);
        return (n & 1) > 0;
    }

    public boolean supportsUnionAll() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsUnionAll");
        int n = this.getInfo((short)96);
        return (n & 2) > 0;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsOpenCursorsAcrossCommit");
        int n = this.getInfoShort((short)23);
        return n == 2;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsOpenCursorsAcrossRollback");
        int n = this.getInfoShort((short)24);
        return n == 2;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsOpenStatementsAcrossCommit");
        int n = this.getInfoShort((short)23);
        return n == 2 || n == 1;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsOpenStatementsAcrossRollback");
        int n = this.getInfoShort((short)24);
        return n == 2 || n == 1;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        Logger.logln("*DatabaseMetaData.getMaxBinaryLiteralLength");
        return this.getInfo((short)112);
    }

    public int getMaxCharLiteralLength() throws SQLException {
        Logger.logln("*DatabaseMetaData.getMaxCharLiteralLength");
        return this.getInfo((short)108);
    }

    public int getMaxColumnNameLength() throws SQLException {
        Logger.logln("*DatabaseMetaData.getMaxColumnNameLength");
        return this.getInfoShort((short)30);
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        Logger.logln("*DatabaseMetaData.getMaxColumnsInGroupBy");
        return this.getInfoShort((short)97);
    }

    public int getMaxColumnsInIndex() throws SQLException {
        Logger.logln("*DatabaseMetaData.getMaxColumnsInIndex");
        return this.getInfoShort((short)98);
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        Logger.logln("*DatabaseMetaData.getMaxColumnsInOrderBy");
        return this.getInfoShort((short)99);
    }

    public int getMaxColumnsInSelect() throws SQLException {
        Logger.logln("*DatabaseMetaData.getMaxColumnsInSeleted");
        return this.getInfoShort((short)100);
    }

    public int getMaxColumnsInTable() throws SQLException {
        Logger.logln("*DatabaseMetaData.getMaxColumnsInTable");
        return this.getInfoShort((short)101);
    }

    public int getMaxConnections() throws SQLException {
        Logger.logln("*DatabaseMetaData.getMaxConnections");
        return this.getInfoShort((short)0);
    }

    public int getMaxCursorNameLength() throws SQLException {
        Logger.logln("*DatabaseMetaData.getMaxCursorNameLength");
        return this.getInfo((short)31);
    }

    public int getMaxIndexLength() throws SQLException {
        Logger.logln("*DatabaseMetaData.getMaxIndexLength");
        return this.getInfo((short)102);
    }

    public int getMaxSchemaNameLength() throws SQLException {
        Logger.logln("*DatabaseMetaData.getMaxSchemaNameLength");
        return this.getInfoShort((short)32);
    }

    public int getMaxProcedureNameLength() throws SQLException {
        Logger.logln("*DatabaseMetaData.getMaxProcedureNameLength");
        return this.getInfoShort((short)33);
    }

    public int getMaxCatalogNameLength() throws SQLException {
        Logger.logln("*DatabaseMetaData.getMaxCatalogNameLength");
        return this.getInfoShort((short)34);
    }

    public int getMaxRowSize() throws SQLException {
        Logger.logln("*DatabaseMetaData.getMaxRowSize");
        return this.getInfo((short)104);
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        Logger.logln("*DatabaseMetaData.doesMaxRowSizeIncludeBlobs");
        return this.getInfoBooleanString((short)103);
    }

    public int getMaxStatementLength() throws SQLException {
        Logger.logln("*DatabaseMetaData.getMaxStatementLength");
        return this.getInfo((short)105);
    }

    public int getMaxStatements() throws SQLException {
        Logger.logln("*DatabaseMetaData.getMaxStatements");
        return this.getInfoShort((short)1);
    }

    public int getMaxTableNameLength() throws SQLException {
        Logger.logln("*DatabaseMetaData.getMaxTableNameLength");
        return this.getInfoShort((short)35);
    }

    public int getMaxTablesInSelect() throws SQLException {
        Logger.logln("*DatabaseMetaData.getMaxTablesInSelect");
        return this.getInfoShort((short)106);
    }

    public int getMaxUserNameLength() throws SQLException {
        Logger.logln("*DatabaseMetaData.getMaxUserNameLength");
        return this.getInfoShort((short)107);
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        Logger.logln("*DatabaseMetaData.getDefaultTransactionIsolation");
        int n = this.getInfo((short)26);
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 4;
                break;
            }
            case 8: {
                n2 = 8;
            }
        }
        return n2;
    }

    public boolean supportsTransactions() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsTransactions");
        int n = this.getInfoShort((short)46);
        return n != 0;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsTransactionIsolationLevel (" + n + ")");
        if (n == 0) {
            return !this.supportsTransactions();
        }
        int n2 = this.getInfo((short)72);
        boolean bl = false;
        switch (n) {
            case 1: {
                bl = (n2 & 1) > 0;
                break;
            }
            case 2: {
                bl = (n2 & 2) > 0;
                break;
            }
            case 4: {
                bl = (n2 & 4) > 0;
                break;
            }
            case 8: {
                bl = (n2 & 8) > 0;
            }
        }
        return bl;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsDataDefinitionAndDataManipulationTransactions");
        int n = this.getInfoShort((short)46);
        return n == 2;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        Logger.logln("*DatabaseMetaData.supportsDataManipulationTransactionsOnly");
        int n = this.getInfoShort((short)46);
        return n == 1;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        Logger.logln("*DatabaseMetaData.dataDefintionCausesTransactionCommit");
        int n = this.getInfoShort((short)46);
        return n == 3;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        Logger.logln("*DatabaseMetaData.dataDefintionIgnoredInTransactions");
        int n = this.getInfoShort((short)46);
        return n == 4;
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        Logger.logln("*DatabaseMetaData.getProcedures (" + string + "," + string2 + "," + string3 + ")");
        if (string != null && string.length() != 0 || string2 != null && string2.length() != 0 && !string2.equals("%")) {
            String string4 = "SELECT TBLNAME AS PROCEDURE_CAT, TBLNAME AS PROCEDURE_SCHEM, TBLNAME AS PROCEDURE_NAME, NUMCOLS AS NUM_INPUT_PARAMS, NUMCOLS AS NUM_OUTPUT_PARAMS, NUMCOLS AS NUM_RESULTS_SETS, TBLNAME AS REMARKS, NUMCOLS AS PROCEDURE_TYPE FROM SYS.TABLES WHERE 0 > 1";
            return this.getResultSet(string4);
        }
        JdbcOdbcStatement jdbcOdbcStatement = (JdbcOdbcStatement)this.Con.createStatement();
        int n = jdbcOdbcStatement.getODBCStatementHandle();
        try {
            this.OdbcApi.SQLProcedures(n, string, string2, string3);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            jdbcOdbcStatement.close();
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet(this.OdbcApi, n, false, jdbcOdbcStatement);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray = new JdbcOdbcPseudoCol[]{new JdbcOdbcPseudoCol("PROCEDURE_CAT", jdbcOdbcResultSet.getColumnType(1), jdbcOdbcResultSet.getColumnLength(1), jdbcOdbcResultSet.getDisplaySize(1)), new JdbcOdbcPseudoCol("PROCEDURE_SCHEM", jdbcOdbcResultSet.getColumnType(2), jdbcOdbcResultSet.getColumnLength(2), jdbcOdbcResultSet.getDisplaySize(2))};
        jdbcOdbcResultSet.setPseudoCols(9, 10, jdbcOdbcPseudoColArray);
        int[] nArray = new int[10];
        int[] nArray2 = new int[10];
        for (int i = 0; i < 10; ++i) {
            nArray[i] = i + 1;
            nArray2[i] = i + 1;
        }
        nArray[8] = 1;
        nArray[9] = 2;
        nArray2[0] = 9;
        nArray2[1] = 10;
        jdbcOdbcResultSet.setColumnMappings(nArray, nArray2);
        jdbcOdbcStatement.setResultSet(jdbcOdbcResultSet);
        return jdbcOdbcResultSet;
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        Logger.logln("*DatabaseMetaData.getProcedureColumns (" + string + "," + string2 + "," + string3 + "," + string4 + ")");
        if (string != null && string.length() != 0 || string2 != null && string2.length() != 0 && !string2.equals("%")) {
            String string5 = "SELECT TBLNAME AS PROCEDURE_CAT, TBLNAME AS PROCEDURE_SCHEM, TBLNAME AS PROCEDURE_NAME, TBLNAME AS COLUMN_NAME, NUMCOLS AS COLUMN_TYPE, NUMCOLS AS DATA_TYPE, TBLNAME AS TYPE_NAME, LENGTH AS \"PRECISION\", LENGTH AS LENGTH, NUMCOLS AS SCALE, NUMCOLS AS RADIX, NUMCOLS AS NULLABLE, TBLNAME AS REMARKS FROM SYS.TABLES WHERE 0 > 1";
            return this.getResultSet(string5);
        }
        JdbcOdbcStatement jdbcOdbcStatement = (JdbcOdbcStatement)this.Con.createStatement();
        int n = jdbcOdbcStatement.getODBCStatementHandle();
        try {
            this.OdbcApi.SQLProcedureColumns(n, string, string2, string3, string4);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            jdbcOdbcStatement.close();
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet(this.OdbcApi, n, false, jdbcOdbcStatement);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        jdbcOdbcResultSet.setSQLTypeColumn(6);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray = new JdbcOdbcPseudoCol[]{new JdbcOdbcPseudoCol("PROCEDURE_CAT", jdbcOdbcResultSet.getColumnType(1), jdbcOdbcResultSet.getColumnLength(1), jdbcOdbcResultSet.getDisplaySize(1)), new JdbcOdbcPseudoCol("PROCEDURE_SCHEM", jdbcOdbcResultSet.getColumnType(2), jdbcOdbcResultSet.getColumnLength(2), jdbcOdbcResultSet.getDisplaySize(2))};
        jdbcOdbcResultSet.setPseudoCols(14, 15, jdbcOdbcPseudoColArray);
        int[] nArray = new int[15];
        int[] nArray2 = new int[15];
        for (int i = 0; i < 15; ++i) {
            nArray[i] = i + 1;
            nArray2[i] = i + 1;
        }
        nArray[13] = 1;
        nArray[14] = 2;
        nArray2[0] = 14;
        nArray2[1] = 15;
        jdbcOdbcResultSet.setColumnMappings(nArray, nArray2);
        jdbcOdbcStatement.setResultSet(jdbcOdbcResultSet);
        return jdbcOdbcResultSet;
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray;
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        String string4 = null;
        SQLWarning sQLWarning = null;
        Logger.logln("*DatabaseMetaData.getTables (" + string + "," + string2 + "," + string3 + "," + string4 + ")");
        if (string != null && string.length() != 0) {
            String string5 = "SELECT TBLNAME AS TABLE_CAT, TBLNAME AS TABLE_SCHEM, TBLNAME AS TABLE_NAME, TBLNAME AS TABLE_TYPE, TBLNAME AS REMARKS FROM SYS.TABLES WHERE 0 > 1";
            return this.getResultSet(string5);
        }
        if (stringArray != null) {
            string4 = "";
            int n = 0;
            for (n = 0; n < stringArray.length; n = (int)((short)(n + 1))) {
                jdbcOdbcPseudoColArray = stringArray[n];
                if (n > 0) {
                    string4 = string4 + ",";
                }
                string4 = string4 + (String)jdbcOdbcPseudoColArray;
            }
        }
        JdbcOdbcStatement jdbcOdbcStatement = (JdbcOdbcStatement)this.Con.createStatement();
        int n = jdbcOdbcStatement.getODBCStatementHandle();
        try {
            this.OdbcApi.SQLTables(n, string, string2, string3, string4);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            jdbcOdbcStatement.close();
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet(this.OdbcApi, n, false, jdbcOdbcStatement);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        jdbcOdbcPseudoColArray = new JdbcOdbcPseudoCol[]{new JdbcOdbcPseudoCol("TABLE_CAT", jdbcOdbcResultSet.getColumnType(1), jdbcOdbcResultSet.getColumnLength(1), jdbcOdbcResultSet.getDisplaySize(1)), new JdbcOdbcPseudoCol("TABLE_SCHEM", jdbcOdbcResultSet.getColumnType(2), jdbcOdbcResultSet.getColumnLength(2), jdbcOdbcResultSet.getDisplaySize(2))};
        jdbcOdbcResultSet.setPseudoCols(6, 7, jdbcOdbcPseudoColArray);
        int[] nArray = new int[7];
        int[] nArray2 = new int[7];
        for (int i = 0; i < 7; ++i) {
            nArray[i] = i + 1;
            nArray2[i] = i + 1;
        }
        nArray[5] = 1;
        nArray[6] = 2;
        nArray2[0] = 6;
        nArray2[1] = 7;
        jdbcOdbcResultSet.setColumnMappings(nArray, nArray2);
        jdbcOdbcStatement.setResultSet(jdbcOdbcResultSet);
        return jdbcOdbcResultSet;
    }

    public ResultSet getSchemas() throws SQLException {
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        Object var3_2 = null;
        SQLWarning sQLWarning = null;
        Logger.logln("*DatabaseMetaData.getSchemas");
        JdbcOdbcStatement jdbcOdbcStatement = (JdbcOdbcStatement)this.Con.createStatement();
        int n = jdbcOdbcStatement.getODBCStatementHandle();
        try {
            this.OdbcApi.SQLTables(n, "", "%", "", null);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            jdbcOdbcStatement.close();
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet(this.OdbcApi, n, false, jdbcOdbcStatement);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray = new JdbcOdbcPseudoCol[]{new JdbcOdbcPseudoCol("TABLE_SCHEM", jdbcOdbcResultSet.getColumnType(2), jdbcOdbcResultSet.getColumnLength(2), jdbcOdbcResultSet.getDisplaySize(2))};
        jdbcOdbcResultSet.setPseudoCols(1, 1, jdbcOdbcPseudoColArray);
        int[] nArray = new int[]{2};
        jdbcOdbcResultSet.setColumnMappings(nArray, null);
        jdbcOdbcResultSet.setMetadataColCount(1);
        jdbcOdbcStatement.setResultSet(jdbcOdbcResultSet);
        return jdbcOdbcResultSet;
    }

    public ResultSet getCatalogs() throws SQLException {
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        Object var3_2 = null;
        SQLWarning sQLWarning = null;
        Logger.logln("*DatabaseMetaData.getCatalogs");
        JdbcOdbcStatement jdbcOdbcStatement = (JdbcOdbcStatement)this.Con.createStatement();
        int n = jdbcOdbcStatement.getODBCStatementHandle();
        try {
            this.OdbcApi.SQLTables(n, "%", "", "", null);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            jdbcOdbcStatement.close();
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet(this.OdbcApi, n, false, jdbcOdbcStatement);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray = new JdbcOdbcPseudoCol[]{new JdbcOdbcPseudoCol("TABLE_CAT", jdbcOdbcResultSet.getColumnType(1), jdbcOdbcResultSet.getColumnLength(1), jdbcOdbcResultSet.getDisplaySize(1))};
        jdbcOdbcResultSet.setPseudoCols(1, 1, jdbcOdbcPseudoColArray);
        int[] nArray = new int[]{1};
        jdbcOdbcResultSet.setMetadataColCount(1);
        jdbcOdbcResultSet.setColumnMappings(nArray, null);
        jdbcOdbcStatement.setResultSet(jdbcOdbcResultSet);
        return jdbcOdbcResultSet;
    }

    public ResultSet getTableTypes() throws SQLException {
        Logger.logln("*DatabaseMetaData.getTableTypes");
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        JdbcOdbcStatement jdbcOdbcStatement = (JdbcOdbcStatement)this.Con.createStatement();
        int n = jdbcOdbcStatement.getODBCStatementHandle();
        try {
            this.OdbcApi.SQLTables(n, "", "", "", "%");
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            jdbcOdbcStatement.close();
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet(this.OdbcApi, n, false, jdbcOdbcStatement);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        int[] nArray = new int[]{4};
        int[] nArray2 = new int[]{4};
        jdbcOdbcResultSet.setMetadataColCount(1);
        jdbcOdbcResultSet.setColumnMappings(nArray, nArray2);
        jdbcOdbcStatement.setResultSet(jdbcOdbcResultSet);
        return jdbcOdbcResultSet;
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        int n;
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        Logger.logln("*DatabaseMetaData.getColumns (" + string + "," + string2 + "," + string3 + "," + string4 + ")");
        if (string != null && string.length() != 0) {
            String string5 = "SELECT TBLNAME AS TABLE_CAT, TBLNAME AS TABLE_SCHEM, TBLNAME AS TABLE_NAME, TBLNAME AS COLUMN_NAME, NUMCOLS AS DATA_TYPE, TBLNAME AS TYPE_NAME, LENGTH AS COLUMN_SIZE, LENGTH AS BUFFER_LENGTH, LENGTH AS DECIMAL_DIGITS, LENGTH AS NUM_PREC_RADIX, LENGTH AS NULLABLE, TBLNAME AS REMARKS, TBLNAME AS COLUMN_DEF, LENGTH AS SQL_DATA_TYPE, LENGTH AS SQL_DATETIME_SUB, LENGTH AS CHAR_OCTET_LENGTH, LENGTH AS ORDINAL_POSITION, TBLNAME AS IS_NULLABLE FROM SYS.TABLES WHERE 0 > 1";
            return this.getResultSet(string5);
        }
        JdbcOdbcStatement jdbcOdbcStatement = (JdbcOdbcStatement)this.Con.createStatement();
        int n2 = jdbcOdbcStatement.getODBCStatementHandle();
        try {
            this.OdbcApi.SQLColumns(n2, string, string2, string3, string4);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            jdbcOdbcStatement.close();
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet(this.OdbcApi, n2, false, jdbcOdbcStatement);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        jdbcOdbcResultSet.setSQLTypeColumn(5);
        JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray = new JdbcOdbcPseudoCol[]{new JdbcOdbcPseudoCol("TABLE_CAT", jdbcOdbcResultSet.getColumnType(1), jdbcOdbcResultSet.getColumnLength(1), jdbcOdbcResultSet.getDisplaySize(1)), new JdbcOdbcPseudoCol("TABLE_SCHEM", jdbcOdbcResultSet.getColumnType(2), jdbcOdbcResultSet.getColumnLength(2), jdbcOdbcResultSet.getDisplaySize(2)), new JdbcOdbcPseudoCol("COLUMN_SIZE", jdbcOdbcResultSet.getColumnType(7), jdbcOdbcResultSet.getColumnLength(7), jdbcOdbcResultSet.getDisplaySize(7)), new JdbcOdbcPseudoCol("BUFFER_LENGTH", jdbcOdbcResultSet.getColumnType(8), jdbcOdbcResultSet.getColumnLength(8), jdbcOdbcResultSet.getDisplaySize(8)), new JdbcOdbcPseudoCol("DECIMAL_DIGITS", jdbcOdbcResultSet.getColumnType(9), jdbcOdbcResultSet.getColumnLength(9), jdbcOdbcResultSet.getDisplaySize(9)), new JdbcOdbcPseudoCol("NUM_PREC_RADIX", jdbcOdbcResultSet.getColumnType(10), jdbcOdbcResultSet.getColumnLength(10), jdbcOdbcResultSet.getDisplaySize(10))};
        jdbcOdbcResultSet.setPseudoCols(20, 25, jdbcOdbcPseudoColArray);
        int[] nArray = new int[25];
        int[] nArray2 = new int[25];
        for (n = 0; n < 25; ++n) {
            nArray[n] = n + 1;
            nArray2[n] = n + 1;
        }
        nArray[19] = 1;
        nArray[20] = 2;
        nArray[21] = 7;
        nArray[22] = 8;
        nArray[23] = 9;
        nArray[24] = 10;
        nArray2[0] = 20;
        nArray2[1] = 21;
        nArray2[6] = 22;
        nArray2[7] = 23;
        nArray2[8] = 24;
        nArray2[9] = 25;
        jdbcOdbcResultSet.setColumnMappings(nArray, nArray2);
        n = jdbcOdbcResultSet.getColumnCount();
        jdbcOdbcResultSet.setMetadataColCount(n);
        jdbcOdbcStatement.setResultSet(jdbcOdbcResultSet);
        return jdbcOdbcResultSet;
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = "SELECT TBLNAME AS TABLE_CAT, TBLNAME AS TABLE_SCHEM, TBLNAME AS TABLE_NAME, TBLNAME AS COLUMN_NAME, TBLNAME AS GRANTOR, TBLNAME AS GRANTEE, TBLNAME AS PRIVILEGE, TBLNAME AS IS_GRANTABLE FROM SYS.TABLES WHERE 0 > 1";
        Logger.logln("*DatabaseMetaData.getColumnPrivileges");
        return this.getResultSet(string5);
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        String string4 = "SELECT TBLNAME AS TABLE_CAT, TBLNAME AS TABLE_SCHEM, TBLNAME AS TABLE_NAME, TBLNAME AS GRANTOR, TBLNAME AS GRANTEE, TBLNAME AS PRIVILEGE, TBLNAME AS IS_GRANTABLE FROM SYS.TABLES WHERE 0 > 1";
        Logger.logln("*DatabaseMetaData.getTablePrivileges");
        return this.getResultSet(string4);
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        Logger.logln("*DatabaseMetaData.getBestRowIdentifier (" + string + "," + string2 + "," + string3 + "," + n + "," + bl + ")");
        if (string != null && string.length() != 0) {
            String string4 = "SELECT NUMCOLS AS SCOPE, TBLNAME AS COLUMN_NAME, NUMCOLS AS DATA_TYPE, TBLNAME AS TYPE_NAME, LENGTH AS COLUMN_SIZE, LENGTH AS BUFFER_LENGTH, NUMCOLS AS DECIMAL_DIGITS, NUMCOLS AS PSEUDO_COLUMN FROM SYS.TABLES WHERE 0 > 1";
            return this.getResultSet(string4);
        }
        JdbcOdbcStatement jdbcOdbcStatement = (JdbcOdbcStatement)this.Con.createStatement();
        int n2 = jdbcOdbcStatement.getODBCStatementHandle();
        try {
            this.OdbcApi.SQLSpecialColumns(n2, (short)1, string, string2, string3, n, bl);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            jdbcOdbcStatement.close();
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet(this.OdbcApi, n2, false, jdbcOdbcStatement);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        jdbcOdbcResultSet.setSQLTypeColumn(3);
        this.createAdditionalSpecialColumns(jdbcOdbcResultSet);
        jdbcOdbcStatement.setResultSet(jdbcOdbcResultSet);
        return jdbcOdbcResultSet;
    }

    protected void createAdditionalSpecialColumns(JdbcOdbcResultSet jdbcOdbcResultSet) throws SQLException {
        JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray = new JdbcOdbcPseudoCol[]{new JdbcOdbcPseudoCol("COLUMN_SIZE", jdbcOdbcResultSet.getColumnType(5), jdbcOdbcResultSet.getColumnLength(5), jdbcOdbcResultSet.getDisplaySize(5)), new JdbcOdbcPseudoCol("BUFFER_LENGTH", jdbcOdbcResultSet.getColumnType(6), jdbcOdbcResultSet.getColumnLength(6), jdbcOdbcResultSet.getDisplaySize(6)), new JdbcOdbcPseudoCol("DECIMAL_DIGITS", jdbcOdbcResultSet.getColumnType(7), jdbcOdbcResultSet.getColumnLength(7), jdbcOdbcResultSet.getDisplaySize(7))};
        jdbcOdbcResultSet.setPseudoCols(9, 11, jdbcOdbcPseudoColArray);
        int[] nArray = new int[11];
        int[] nArray2 = new int[11];
        for (int i = 0; i < 11; ++i) {
            nArray[i] = i + 1;
            nArray2[i] = i + 1;
        }
        nArray[8] = 5;
        nArray[9] = 6;
        nArray[10] = 7;
        nArray2[4] = 9;
        nArray2[5] = 10;
        nArray2[6] = 11;
        jdbcOdbcResultSet.setColumnMappings(nArray, nArray2);
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        Logger.logln("*DatabaseMetaData.getVersionColumns (" + string + "," + string2 + "," + string3 + ")");
        if (string != null && string.length() != 0) {
            String string4 = "SELECT NUMCOLS AS SCOPE, TBLNAME AS COLUMN_NAME, NUMCOLS AS DATA_TYPE, TBLNAME AS TYPE_NAME, LENGTH AS COLUMN_SIZE, LENGTH AS BUFFER_LENGTH, NUMCOLS AS DECIMAL_DIGITS, NUMCOLS AS PSEUDO_COLUMN FROM SYS.TABLES WHERE 0 > 1";
            return this.getResultSet(string4);
        }
        JdbcOdbcStatement jdbcOdbcStatement = (JdbcOdbcStatement)this.Con.createStatement();
        int n = jdbcOdbcStatement.getODBCStatementHandle();
        try {
            this.OdbcApi.SQLSpecialColumns(n, (short)2, string, string2, string3, 0, false);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            jdbcOdbcStatement.close();
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet(this.OdbcApi, n, false, jdbcOdbcStatement);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        jdbcOdbcResultSet.setSQLTypeColumn(3);
        this.createAdditionalSpecialColumns(jdbcOdbcResultSet);
        jdbcOdbcStatement.setResultSet(jdbcOdbcResultSet);
        return jdbcOdbcResultSet;
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        Logger.logln("*DatabaseMetaData.getPrimaryKeys (" + string + "," + string2 + "," + string3 + ")");
        if (string != null && string.length() != 0) {
            String string4 = "SELECT TBLNAME AS TABLE_CAT, TBLNAME AS TABLE_SCHEM, TBLNAME AS TABLE_NAME, TBLNAME AS COLUMN_NAME, NUMCOLS AS KEY_SEQ, TBLNAME AS PK_NAME FROM SYS.TABLES WHERE 0 > 1";
            return this.getResultSet(string4);
        }
        JdbcOdbcStatement jdbcOdbcStatement = (JdbcOdbcStatement)this.Con.createStatement();
        int n = jdbcOdbcStatement.getODBCStatementHandle();
        try {
            this.OdbcApi.SQLPrimaryKeys(n, string, string2, string3);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            jdbcOdbcStatement.close();
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet(this.OdbcApi, n, false, jdbcOdbcStatement);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray = new JdbcOdbcPseudoCol[]{new JdbcOdbcPseudoCol("TABLE_CAT", jdbcOdbcResultSet.getColumnType(1), jdbcOdbcResultSet.getColumnLength(1), jdbcOdbcResultSet.getDisplaySize(1)), new JdbcOdbcPseudoCol("TABLE_SCHEM", jdbcOdbcResultSet.getColumnType(2), jdbcOdbcResultSet.getColumnLength(2), jdbcOdbcResultSet.getDisplaySize(2))};
        jdbcOdbcResultSet.setPseudoCols(7, 8, jdbcOdbcPseudoColArray);
        int[] nArray = new int[8];
        int[] nArray2 = new int[8];
        for (int i = 0; i < 8; ++i) {
            nArray[i] = i + 1;
            nArray2[i] = i + 1;
        }
        nArray[6] = 1;
        nArray[7] = 2;
        nArray2[0] = 7;
        nArray2[1] = 8;
        jdbcOdbcResultSet.setColumnMappings(nArray, nArray2);
        jdbcOdbcStatement.setResultSet(jdbcOdbcResultSet);
        return jdbcOdbcResultSet;
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        Logger.logln("*DatabaseMetaData.getImportedKeys (" + string + "," + string2 + "," + string3 + ")");
        if (string != null && string.length() != 0) {
            String string4 = "SELECT TBLNAME AS PKTABLE_CAT, TBLNAME AS PKTABLE_SCHEM, TBLNAME AS PKTABLE_NAME, TBLNAME AS PKCOLUMN_NAME, TBLNAME AS FKTABLE_CAT, TBLNAME AS FKTABLE_SCHEM, TBLNAME AS FKTABLE_NAME, TBLNAME AS FKCOLUMN_NAME, NUMCOLS AS KEY_SEQ, NUMCOLS AS UPDATE_RULE, NUMCOLS AS DELETE_RULE, TBLNAME AS FK_NAME, TBLNAME AS PK_NAME, NUMCOLS AS DEFERRABILITY, NUMCOLS AS \"REQUIRED\" FROM SYS.TABLES WHERE 0 > 1";
            return this.getResultSet(string4);
        }
        JdbcOdbcStatement jdbcOdbcStatement = (JdbcOdbcStatement)this.Con.createStatement();
        int n = jdbcOdbcStatement.getODBCStatementHandle();
        try {
            this.OdbcApi.SQLForeignKeys(n, null, null, null, string, string2, string3);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            jdbcOdbcStatement.close();
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet(this.OdbcApi, n, false, jdbcOdbcStatement);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        this.createAdditionalForeignKeyColumns(jdbcOdbcResultSet);
        jdbcOdbcStatement.setResultSet(jdbcOdbcResultSet);
        return jdbcOdbcResultSet;
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        Logger.logln("*DatabaseMetaData.getExportedKeys (" + string + "," + string2 + "," + string3 + ")");
        if (string != null && string.length() != 0) {
            String string4 = "SELECT TBLNAME AS PKTABLE_CAT, TBLNAME AS PKTABLE_SCHEM, TBLNAME AS PKTABLE_NAME, TBLNAME AS PKCOLUMN_NAME, TBLNAME AS FKTABLE_CAT, TBLNAME AS FKTABLE_SCHEM, TBLNAME AS FKTABLE_NAME, TBLNAME AS FKCOLUMN_NAME, NUMCOLS AS KEY_SEQ, NUMCOLS AS UPDATE_RULE, NUMCOLS AS DELETE_RULE, TBLNAME AS FK_NAME, TBLNAME AS PK_NAME, NUMCOLS AS DEFERRABILITY, NUMCOLS AS \"REQUIRED\" FROM SYS.TABLES WHERE 0 > 1";
            return this.getResultSet(string4);
        }
        JdbcOdbcStatement jdbcOdbcStatement = (JdbcOdbcStatement)this.Con.createStatement();
        int n = jdbcOdbcStatement.getODBCStatementHandle();
        try {
            this.OdbcApi.SQLForeignKeys(n, string, string2, string3, null, null, null);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            jdbcOdbcStatement.close();
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet(this.OdbcApi, n, false, jdbcOdbcStatement);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        this.createAdditionalForeignKeyColumns(jdbcOdbcResultSet);
        jdbcOdbcStatement.setResultSet(jdbcOdbcResultSet);
        return jdbcOdbcResultSet;
    }

    protected void createAdditionalForeignKeyColumns(JdbcOdbcResultSet jdbcOdbcResultSet) throws SQLException {
        JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray = new JdbcOdbcPseudoCol[]{new JdbcOdbcPseudoCol("PKTABLE_CAT", jdbcOdbcResultSet.getColumnType(1), jdbcOdbcResultSet.getColumnLength(1), jdbcOdbcResultSet.getDisplaySize(1)), new JdbcOdbcPseudoCol("PKTABLE_SCHEM", jdbcOdbcResultSet.getColumnType(2), jdbcOdbcResultSet.getColumnLength(2), jdbcOdbcResultSet.getDisplaySize(2)), new JdbcOdbcPseudoCol("FKTABLE_CAT", jdbcOdbcResultSet.getColumnType(5), jdbcOdbcResultSet.getColumnLength(5), jdbcOdbcResultSet.getDisplaySize(5)), new JdbcOdbcPseudoCol("FKTABLE_SCHEM", jdbcOdbcResultSet.getColumnType(6), jdbcOdbcResultSet.getColumnLength(6), jdbcOdbcResultSet.getDisplaySize(6))};
        jdbcOdbcResultSet.setPseudoCols(16, 19, jdbcOdbcPseudoColArray);
        int[] nArray = new int[19];
        int[] nArray2 = new int[19];
        for (int i = 0; i < 19; ++i) {
            nArray[i] = i + 1;
            nArray2[i] = i + 1;
        }
        nArray[15] = 1;
        nArray[16] = 2;
        nArray[17] = 5;
        nArray[18] = 6;
        nArray2[0] = 16;
        nArray2[1] = 17;
        nArray2[4] = 18;
        nArray2[5] = 19;
        jdbcOdbcResultSet.setColumnMappings(nArray, nArray2);
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        Logger.logln("*DatabaseMetaData.getCrossReference (" + string + "," + string2 + "," + string3 + "," + string4 + "," + string5 + "," + string6 + ")");
        if (string != null && string.length() != 0 || string4 != null && string4.length() != 0) {
            String string7 = "SELECT TBLNAME AS PKTABLE_CAT, TBLNAME AS PKTABLE_SCHEM, TBLNAME AS PKTABLE_NAME, TBLNAME AS PKCOLUMN_NAME, TBLNAME AS FKTABLE_CAT, TBLNAME AS FKTABLE_SCHEM, TBLNAME AS FKTABLE_NAME, TBLNAME AS FKCOLUMN_NAME, NUMCOLS AS KEY_SEQ, NUMCOLS AS UPDATE_RULE, NUMCOLS AS DELETE_RULE, TBLNAME AS FK_NAME, TBLNAME AS PK_NAME, NUMCOLS AS DEFERRABILITY, NUMCOLS AS \"REQUIRED\" FROM SYS.TABLES WHERE 0 > 1";
            return this.getResultSet(string7);
        }
        JdbcOdbcStatement jdbcOdbcStatement = (JdbcOdbcStatement)this.Con.createStatement();
        int n = jdbcOdbcStatement.getODBCStatementHandle();
        try {
            this.OdbcApi.SQLForeignKeys(n, string, string2, string3, string4, string5, string6);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            jdbcOdbcStatement.close();
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet(this.OdbcApi, n, false, jdbcOdbcStatement);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        this.createAdditionalForeignKeyColumns(jdbcOdbcResultSet);
        jdbcOdbcStatement.setResultSet(jdbcOdbcResultSet);
        return jdbcOdbcResultSet;
    }

    public ResultSet getTypeInfo() throws SQLException {
        int n;
        Logger.logln("*DatabaseMetaData.getTypeInfo");
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        JdbcOdbcStatement jdbcOdbcStatement = (JdbcOdbcStatement)this.Con.createStatement();
        int n2 = jdbcOdbcStatement.getODBCStatementHandle();
        try {
            this.OdbcApi.SQLGetTypeInfo(n2, (short)0);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            jdbcOdbcStatement.close();
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet(this.OdbcApi, n2, false, jdbcOdbcStatement);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray = new JdbcOdbcPseudoCol[]{new JdbcOdbcPseudoCol("SQL_DATA_TYPE", 5, 0), new JdbcOdbcPseudoCol("SQL_DATETIME_SUB", 5, 0), new JdbcOdbcPseudoCol("NUM_PREC_RADIX", 5, 0), new JdbcOdbcPseudoCol("FIXED_PREC_SCALE", jdbcOdbcResultSet.getColumnType(11), jdbcOdbcResultSet.getColumnLength(11), jdbcOdbcResultSet.getDisplaySize(11))};
        jdbcOdbcResultSet.setPseudoCols(16, 19, jdbcOdbcPseudoColArray);
        jdbcOdbcResultSet.setSQLTypeColumn(2);
        int[] nArray = new int[19];
        int[] nArray2 = new int[19];
        for (n = 0; n < 19; ++n) {
            nArray[n] = n + 1;
            nArray2[n] = n + 1;
        }
        nArray[18] = 11;
        nArray2[10] = 19;
        jdbcOdbcResultSet.setColumnMappings(nArray, nArray2);
        n = jdbcOdbcResultSet.getColumnCount();
        jdbcOdbcResultSet.setMetadataColCount(n + 3);
        jdbcOdbcStatement.setResultSet(jdbcOdbcResultSet);
        return jdbcOdbcResultSet;
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        SQLWarning sQLWarning = null;
        Logger.logln("*DatabaseMetaData.getIndexInfo (" + string + "," + string2 + "," + string3 + bl + "," + bl2 + ")");
        if (string != null && string.length() != 0) {
            String string4 = "SELECT TBLNAME AS TABLE_CAT, TBLNAME AS TABLE_SCHEM, TBLNAME AS TABLE_NAME, NUMCOLS AS NON_UNIQUE, TBLNAME AS INDEX_QUALIFIER, TBLNAME AS INDEX_NAME, NUMCOLS AS TYPE, NUMCOLS AS ORDINAL_POSITION, TBLNAME AS COLUMN_NAME, TBLNAME AS ASC_OR_DESC, LENGTH AS CARDINALITY, LENGTH AS \"PAGES\", TBLNAME AS FILTER_CONDITION, TBLNAME AS TT_INDEX_USAGE FROM SYS.TABLES WHERE 0 > 1";
            return this.getResultSet(string4);
        }
        JdbcOdbcStatement jdbcOdbcStatement = (JdbcOdbcStatement)this.Con.createStatement();
        int n = jdbcOdbcStatement.getODBCStatementHandle();
        try {
            this.OdbcApi.SQLStatistics(n, string, string2, string3, bl, bl2);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            jdbcOdbcStatement.close();
            throw sQLException;
        }
        jdbcOdbcResultSet = new JdbcOdbcResultSet(this.OdbcApi, n, false, jdbcOdbcStatement);
        jdbcOdbcResultSet.setWarning(sQLWarning);
        int n2 = jdbcOdbcResultSet.getColumnCount();
        int n3 = 4;
        JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray = new JdbcOdbcPseudoCol[n3];
        jdbcOdbcPseudoColArray[0] = new JdbcOdbcPseudoCol("TABLE_CAT", jdbcOdbcResultSet.getColumnType(1), jdbcOdbcResultSet.getColumnLength(1), jdbcOdbcResultSet.getDisplaySize(1));
        jdbcOdbcPseudoColArray[1] = new JdbcOdbcPseudoCol("TABLE_SCHEM", jdbcOdbcResultSet.getColumnType(2), jdbcOdbcResultSet.getColumnLength(2), jdbcOdbcResultSet.getDisplaySize(2));
        jdbcOdbcPseudoColArray[2] = new JdbcOdbcPseudoCol("ORDINAL_POSITION", jdbcOdbcResultSet.getColumnType(8), jdbcOdbcResultSet.getColumnLength(8), jdbcOdbcResultSet.getDisplaySize(8));
        jdbcOdbcPseudoColArray[3] = new JdbcOdbcPseudoCol("ASC_OR_DESC", jdbcOdbcResultSet.getColumnType(10), jdbcOdbcResultSet.getColumnLength(10), jdbcOdbcResultSet.getDisplaySize(10));
        jdbcOdbcResultSet.setPseudoCols(n2 + 1, n2 + n3, jdbcOdbcPseudoColArray);
        int[] nArray = new int[n2 + n3];
        int[] nArray2 = new int[n2 + n3];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = i + 1;
            nArray2[i] = i + 1;
        }
        nArray[n2] = 1;
        nArray[n2 + 1] = 2;
        nArray[n2 + 2] = 8;
        nArray[n2 + 3] = 10;
        nArray2[0] = n2 + 1;
        nArray2[1] = n2 + 2;
        nArray2[7] = n2 + 3;
        nArray2[9] = n2 + 4;
        jdbcOdbcResultSet.setColumnMappings(nArray, nArray2);
        jdbcOdbcStatement.setResultSet(jdbcOdbcResultSet);
        return jdbcOdbcResultSet;
    }

    protected void validateConnection() throws SQLException {
        this.Con.validateConnection();
    }

    protected int getInfo(short s) throws SQLException {
        this.validateConnection();
        return this.OdbcApi.SQLGetInfo(this.hDbc, s);
    }

    protected int getInfoShort(short s) throws SQLException {
        this.validateConnection();
        return this.OdbcApi.SQLGetInfoShort(this.hDbc, s);
    }

    protected boolean getInfoBooleanString(short s) throws SQLException {
        this.validateConnection();
        String string = this.OdbcApi.SQLGetInfoString(this.hDbc, s);
        return string.equalsIgnoreCase("Y");
    }

    protected String getInfoString(short s) throws SQLException {
        this.validateConnection();
        return this.OdbcApi.SQLGetInfoString(this.hDbc, s);
    }

    protected String getInfoString(short s, int n) throws SQLException {
        this.validateConnection();
        return this.OdbcApi.SQLGetInfoString(this.hDbc, s, n);
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        return n == 1003;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        return n == 1003 && n2 == 1007;
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return n == 1003;
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return n == 1003;
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return n == 1003;
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        String string4 = "SELECT TBLNAME AS TYPE_CAT, TBLNAME AS TYPE_SCHEM, TBLNAME AS TYPE_NAME, TBLNAME AS CLASS_NAME, NUMCOLS AS DATA_TYPE, TBLNAME AS REMARKS FROM SYS.TABLES WHERE 0 > 1 ";
        Logger.logln("*DatabaseMetaData.getUDTs");
        return this.getResultSet(string4);
    }

    public Connection getConnection() throws SQLException {
        return this.Con;
    }

    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        String string4 = "SELECT TBLNAME AS TYPE_CAT, TBLNAME AS TYPE_SCHEM, TBLNAME AS TYPE_NAME, TBLNAME AS SUPERTYPE_CAT, TBLNAME AS SUPERTYPE_SCHEM, TBLNAME AS SUPERTYPE_NAME FROM TABLES WHERE 0>1 ";
        Logger.logln("*DatabaseMetaData.getSuperTypes");
        return this.getResultSet(string4);
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        String string4 = "SELECT TBLNAME AS TABLE_CAT, TBLNAME AS TABLE_SCHEM, TBLNAME AS TABLE_NAME, TBLNAME AS SUPERTABLE_NAME FROM TABLES WHERE 0>1";
        Logger.logln("*DatabaseMetaData.getSuperTables");
        return this.getResultSet(string4);
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = "SELECT  TBLNAME AS TYPE_CAT, TBLNAME AS TYPE_SCHEM, TBLNAME AS TYPE_NAME, TBLNAME AS ATTR_NAME, NUMCOLS AS DATA_TYPE, TBLNAME AS ATTR_TYPE_NAME, LENGTH AS ATTR_SIZE, LENGTH AS DECIMAL_DIGITS, LENGTH AS NUM_PREC_RADIX, LENGTH AS NULLABLE, TBLNAME AS REMARKS, TBLNAME AS ATTR_DEF, LENGTH AS SQL_DATA_TYPE, LENGTH AS SQL_DATETIME_SUB, LENGTH AS CHAR_OCTET_LENGTH, LENGTH AS ORDINAL_POSITION, TBLNAME AS IS_NULLABLE, TBLNAME AS SCOPE_CATALOG, TBLNAME AS SCOPE_SCHEMA, TBLNAME AS SCOPE_TABLE, NUMCOLS AS SOURCE_DATA_TYPE FROM TABLES WHERE 0>1";
        Logger.logln("*DatabaseMetaData.getAttributes");
        return this.getResultSet(string5);
    }

    public boolean supportsResultSetHoldability(int n) throws SQLException {
        return false;
    }

    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return 6;
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return 0;
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 1;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 4;
    }

    public int getSQLStateType() throws SQLException {
        return 2;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return true;
    }

    private synchronized ResultSet getResultSet(String string) throws SQLException {
        Statement statement = this.Con.createStatement();
        JdbcOdbcResultSet jdbcOdbcResultSet = (JdbcOdbcResultSet)statement.executeQuery(string);
        jdbcOdbcResultSet.keepHSTMT = false;
        return jdbcOdbcResultSet;
    }
}

