/*
 * Decompiled with CFR 0.152.
 */
package com.timesten.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class JdbcOdbcInputStream
extends InputStream {
    protected boolean invalid = false;
    protected int streamLen;
    protected byte[] streamData;
    protected int offset;

    public JdbcOdbcInputStream(byte[] byArray, int n) throws SQLException {
        this.streamData = byArray;
        this.streamLen = n;
        this.offset = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        JdbcOdbcInputStream jdbcOdbcInputStream = this;
        synchronized (jdbcOdbcInputStream) {
            byte[] byArray = new byte[1];
            int n = this.read(byArray, 0, 1);
            if (n != -1) {
                n = byArray[0] & 0xFF;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n, int n2) throws IOException {
        JdbcOdbcInputStream jdbcOdbcInputStream = this;
        synchronized (jdbcOdbcInputStream) {
            int n3 = 0;
            if (byArray == null) {
                throw new NullPointerException("Invalid buffer, reference is null.");
            }
            if (n < 0) {
                throw new IndexOutOfBoundsException("Illegal offset value " + n);
            }
            if (n2 < 0) {
                throw new IndexOutOfBoundsException("Illegal length value " + n2);
            }
            if (n + n2 > byArray.length) {
                throw new IndexOutOfBoundsException("Inadequate buffer, capacity = " + byArray.length + " off = " + n + " len = " + n2);
            }
            if (byArray.length == 0) {
                return n3;
            }
            if (this.invalid) {
                throw new IOException("InputStream is no longer valid - the Statement has been closed, or the cursor has been moved");
            }
            if (this.offset >= this.streamLen) {
                return -1;
            }
            n3 = n2;
            if (n3 > this.streamLen - this.offset) {
                n3 = this.streamLen - this.offset;
            }
            System.arraycopy(this.streamData, this.offset, byArray, n, n3);
            this.offset += n3;
            return n3;
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        JdbcOdbcInputStream jdbcOdbcInputStream = this;
        synchronized (jdbcOdbcInputStream) {
            return this.streamLen - this.offset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        JdbcOdbcInputStream jdbcOdbcInputStream = this;
        synchronized (jdbcOdbcInputStream) {
            this.invalid = true;
        }
    }
}

