/*
 * Decompiled with CFR 0.152.
 */
package com.timesten.jdbc;

import com.timesten.jdbc.BasicPhantomReference;
import com.timesten.jdbc.JdbcOdbc;
import com.timesten.jdbc.JdbcOdbcBatchParams;
import com.timesten.jdbc.JdbcOdbcBoundParam;
import com.timesten.jdbc.JdbcOdbcResultSet;
import com.timesten.jdbc.JdbcOdbcSQLWarning;
import com.timesten.jdbc.JdbcOdbcStatement;
import com.timesten.jdbc.JpointerWrapper;
import com.timesten.jdbc.Logger;
import com.timesten.jdbc.ParameterMetaDataImpl;
import com.timesten.jdbc.TimesTenConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;

public class JdbcOdbcPreparedStatement
extends JdbcOdbcStatement
implements PreparedStatement {
    protected int numParams;
    protected JdbcOdbcBoundParam[] boundParams;
    private short[] paramTypes;
    private int[] paramLengths;
    private boolean[] paramSetFlags;
    private byte[] errorCode = new byte[2];
    protected JpointerWrapper pBoundParams = new JpointerWrapper(0);
    private JdbcOdbcBatchParams batchUpdateParams;
    private boolean pooledStatementFlag;
    private Boolean pooledStatementInUseFlag = Boolean.TRUE;
    private SoftReference parmMetaData;

    protected JdbcOdbcPreparedStatement() {
    }

    public JdbcOdbcPreparedStatement(TimesTenConnection timesTenConnection, String string) throws SQLException {
        super(timesTenConnection);
        try {
            this.OdbcApi.SQLPrepare(this.hStmt.getValue(), string);
        }
        catch (SQLWarning sQLWarning) {
            this.setWarning(sQLWarning);
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(this.hStmt.getValue(), 1);
            this.hStmt.setValue(0);
            throw sQLException;
        }
        try {
            this.initBoundParam();
        }
        catch (SQLWarning sQLWarning) {
            this.setWarning(sQLWarning);
        }
        this.initBatchParams();
    }

    void setPooledStatementFlag(boolean bl) {
        this.pooledStatementFlag = true;
    }

    public JdbcOdbcPreparedStatement(TimesTenConnection timesTenConnection, String string, boolean bl) throws SQLException {
        this(timesTenConnection, string);
        this.pooledStatementFlag = bl;
    }

    public ResultSet executeQuery() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.executeQuery()");
        }
        this.execute();
        return this.getResultSet();
    }

    public ResultSet executeQuery(String string) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.executeQuery(" + string + ")");
        }
        throw new SQLException("Driver does not support this function", "IM001");
    }

    public int executeUpdate() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.executeUpdate()");
        }
        this.execute();
        return this.getUpdateCount();
    }

    public int executeUpdate(String string) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.executeUpdate(" + string + ")");
        }
        throw new SQLException("Driver does not support this function", "IM001");
    }

    public synchronized boolean execute() throws SQLException {
        int n;
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.execute()");
        }
        this.validateStatement();
        this.referenceManager.reap();
        if (!this.isBatchEmpty) {
            throw new SQLException("Batch is not empty. Batch must be executed or cleared.", "S1000");
        }
        for (n = 0; n < this.numParams; ++n) {
            if (this.paramSetFlags[n]) continue;
            throw new SQLException("Wrong number of parameters.", "07001");
        }
        if (this.hasResultSet) {
            this.closeResultSet(false);
            this.hasResultSet = false;
        }
        this.lastWarning = null;
        n = 0;
        try {
            n = this.OdbcApi.SQLExecute(this.hStmt.getValue()) ? 1 : 0;
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            n = ((Boolean)jdbcOdbcSQLWarning.value).booleanValue() ? 1 : 0;
            if (this.getColumnCount() > 0) {
                this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
            } else {
                if (jdbcOdbcSQLWarning.getSQLState().trim().equals("01004")) {
                    throw new DataTruncation(-1, true, false, 0, 0);
                }
                this.setWarning(jdbcOdbcSQLWarning);
            }
        }
        catch (SQLException sQLException) {
            DataTruncation dataTruncation;
            if (sQLException.getSQLState().trim().equals("37000") && sQLException.getErrorCode() == 2438) {
                dataTruncation = new DataTruncation(-1, true, false, 0, 0);
            }
            throw dataTruncation;
        }
        while (n != 0) {
            int n2;
            try {
                n2 = this.OdbcApi.SQLParamData(this.hStmt.getValue());
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                n2 = (Integer)jdbcOdbcSQLWarning.value;
                this.setWarning(jdbcOdbcSQLWarning);
            }
            if (n2 == -1) {
                n = 0;
                continue;
            }
            try {
                this.putParamData(n2);
            }
            catch (SQLWarning sQLWarning) {
                this.setWarning(sQLWarning);
            }
        }
        this.executed = true;
        if (this.getColumnCount() > 0) {
            this.hasResultSet = true;
        }
        return this.hasResultSet;
    }

    public synchronized void setNull(int n, int n2) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.setNull(" + n + ", " + n2 + ")");
        }
        this.validateStatement();
        this.validateParameterNumber(n);
        int n3 = n - 1;
        this.paramSetFlags[n3] = true;
        this.batchUpdateParams.setNull(n3);
        if (!this.isBatchEmpty) {
            return;
        }
        this.OdbcApi.setNull(this.hStmt.getValue(), this.pBoundParams.getValue(), this.errorCode, n);
        if (this.errorCode[1] == -97) {
            throw new SQLException("Jdbc Internal Error", "S1000");
        }
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.setBoolean(" + n + ", " + bl + ")");
        }
        switch (this.paramTypes[n - 1]) {
            case -1: 
            case 1: 
            case 12: {
                String string = null;
                if (bl) {
                    string = "1";
                }
                this.setString(n, string);
                break;
            }
            default: {
                int n2 = 0;
                if (bl) {
                    n2 = 1;
                }
                this.setInt(n, n2);
            }
        }
    }

    public void setByte(int n, byte by) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.setByte(" + n + ", " + by + ")");
        }
        if (this.paramTypes[n - 1] == -6) {
            this.setInt(n, by & 0xFF);
        } else {
            this.setInt(n, by);
        }
    }

    public void setShort(int n, short s) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.setShort(" + n + ", " + s + ")");
        }
        this.setInt(n, s);
    }

    public synchronized void setInt(int n, int n2) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.setInt(" + n + ", " + n2 + ")");
        }
        this.validateStatement();
        this.validateParameterNumber(n);
        int n3 = n - 1;
        this.paramSetFlags[n3] = true;
        this.batchUpdateParams.setIntegral(n3, n2);
        if (!this.isBatchEmpty) {
            return;
        }
        short s = this.OdbcApi.setInteger(this.hStmt.getValue(), this.pBoundParams.getValue(), n2, n);
        if (s == -97) {
            throw new SQLException("Jdbc Internal Error", "S1000");
        }
    }

    public synchronized void setLong(int n, long l) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.setLong(" + n + ", " + l + ")");
        }
        this.validateStatement();
        this.validateParameterNumber(n);
        int n2 = n - 1;
        this.paramSetFlags[n2] = true;
        this.batchUpdateParams.setIntegral(n2, l);
        if (!this.isBatchEmpty) {
            return;
        }
        short s = this.OdbcApi.setLong(this.hStmt.getValue(), this.pBoundParams.getValue(), l, n);
        if (s == -97) {
            throw new SQLException("Jdbc Internal Error", "S1000");
        }
    }

    public void setReal(int n, float f) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.setReal(" + n + ", " + f + ")");
        }
        this.setFloat(n, f);
    }

    public synchronized void setFloat(int n, float f) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.setFloat(" + n + ", " + f + ")");
        }
        this.validateStatement();
        this.validateParameterNumber(n);
        int n2 = n - 1;
        this.paramSetFlags[n2] = true;
        this.batchUpdateParams.setFloat(n2, f);
        if (!this.isBatchEmpty) {
            return;
        }
        short s = this.OdbcApi.setFloat(this.hStmt.getValue(), this.pBoundParams.getValue(), f, n);
        if (s == -97) {
            throw new SQLException("Jdbc Internal Error", "S1000");
        }
    }

    public synchronized void setDouble(int n, double d) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.setFloat(" + n + ", " + d + ")");
        }
        this.validateStatement();
        this.validateParameterNumber(n);
        int n2 = n - 1;
        this.paramSetFlags[n2] = true;
        this.batchUpdateParams.setFloat(n2, d);
        if (!this.isBatchEmpty) {
            return;
        }
        short s = this.OdbcApi.setDouble(this.hStmt.getValue(), this.pBoundParams.getValue(), d, n);
        if (s == -97) {
            throw new SQLException("Jdbc Internal Error", "S1000");
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.setBigDecimal(" + n + ", " + bigDecimal + ")");
        }
        if (bigDecimal == null) {
            this.setNull(n, 2);
        } else {
            String string = null;
            string = bigDecimal.toPlainString();
            this.setString(n, string);
        }
    }

    public synchronized void setString(int n, String string) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.setString(" + n + ", " + string + ")");
        }
        this.validateStatement();
        this.validateParameterNumber(n);
        int n2 = n - 1;
        this.paramSetFlags[n2] = true;
        this.batchUpdateParams.setString(n2, string);
        if (!this.isBatchEmpty) {
            return;
        }
        if (string == null) {
            this.OdbcApi.setNull(this.hStmt.getValue(), this.pBoundParams.getValue(), this.errorCode, n);
        } else {
            this.OdbcApi.setString(this.hStmt.getValue(), this.pBoundParams.getValue(), string, this.errorCode, n);
            if (this.errorCode[1] == -98) {
                this.paramSetFlags[n2] = false;
                throw new SQLException("Char conversion error");
            }
        }
        if (this.errorCode[1] == -97) {
            this.paramSetFlags[n2] = false;
            throw new SQLException("Jdbc Internal Error", "S1000");
        }
    }

    public synchronized void setBytes(int n, byte[] byArray) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.setBytes(" + n + ", value[])");
        }
        this.validateStatement();
        this.validateParameterNumber(n);
        int n2 = n - 1;
        this.paramSetFlags[n2] = true;
        this.batchUpdateParams.setBytes(n2, byArray);
        if (!this.isBatchEmpty) {
            return;
        }
        if (byArray == null) {
            this.OdbcApi.setNull(this.hStmt.getValue(), this.pBoundParams.getValue(), this.errorCode, n);
        } else {
            this.OdbcApi.setBytes(this.hStmt.getValue(), this.pBoundParams.getValue(), byArray, this.errorCode, n);
        }
        if (this.errorCode[1] == -97) {
            throw new SQLException("Jdbc Internal Error", "S1000");
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.setDate(" + n + ", " + date + ")");
        }
        if (date == null) {
            this.setNull(n, 91);
        } else {
            this.setString(n, date.toString());
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.setTime(" + n + ", " + time + ")");
        }
        if (time == null) {
            this.setNull(n, 92);
        } else {
            this.setString(n, time.toString());
        }
    }

    public synchronized void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.setTimestamp(" + n + ", " + timestamp + ")");
        }
        this.setTimestamp(n, timestamp, null);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.setAsciiStream(" + n + ", InputStream x, " + n2 + ")");
        }
        if (inputStream == null) {
            this.setNull(n, 12);
        } else {
            this.setStream(n, inputStream, n2, 12, 1);
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        int n3;
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.setUnicodeStream(" + n + ", InputStream x, " + n2 + ")");
        }
        this.validateParameterNumber(n);
        switch (this.paramTypes[n - 1]) {
            case -10: 
            case -9: 
            case -8: {
                n3 = -9;
                break;
            }
            default: {
                n3 = 12;
            }
        }
        if (inputStream == null) {
            this.setNull(n, n3);
        } else {
            this.setStream(n, inputStream, n2, n3, 2);
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.setBinaryStream(" + n + ", InputStream x, " + n2 + ")");
        }
        if (inputStream == null) {
            this.setNull(n, -3);
        } else {
            this.setStream(n, inputStream, n2, -3, 3);
        }
    }

    public synchronized void clearParameters() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.clearParameters()");
        }
        for (int i = 0; i < this.numParams; ++i) {
            this.paramSetFlags[i] = false;
        }
    }

    public void setObject(int n, Object object) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.setObject(" + n + ", " + object.toString() + ")");
        }
        if (object == null) {
            this.setNull(n, 12);
        } else {
            this.setObject(n, object, JdbcOdbcPreparedStatement.getTypeFromObject(object));
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.setObject(" + n + ", " + object.toString() + ", " + n2 + ")");
        }
        if (object == null) {
            this.setNull(n, n2);
        } else {
            this.setObject(n, object, n2, 0);
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.setObject(" + n + ", " + object.toString() + ", " + n2 + ", " + n3 + ")");
        }
        if (object == null) {
            this.setNull(n, n2);
        } else {
            int n4 = JdbcOdbcPreparedStatement.getTypeFromObject(object);
            switch (n4) {
                case -1: 
                case 1: 
                case 12: {
                    if (object instanceof Character) {
                        this.setString(n, ((Character)object).toString());
                        break;
                    }
                    this.setString(n, (String)object);
                    break;
                }
                case 2: 
                case 3: {
                    this.setString(n, object.toString());
                    break;
                }
                case -7: {
                    this.setBoolean(n, (Boolean)object);
                    break;
                }
                case -6: {
                    this.setByte(n, (Byte)object);
                    break;
                }
                case 5: {
                    this.setShort(n, (Short)object);
                    break;
                }
                case 4: {
                    this.setInt(n, (Integer)object);
                    break;
                }
                case -5: {
                    this.setLong(n, (Long)object);
                    break;
                }
                case 6: 
                case 7: {
                    this.setFloat(n, ((Float)object).floatValue());
                    break;
                }
                case 8: {
                    this.setDouble(n, (Double)object);
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    this.setBytes(n, (byte[])object);
                    break;
                }
                case 91: {
                    this.setString(n, ((Date)object).toString());
                    break;
                }
                case 92: {
                    this.setString(n, ((Time)object).toString());
                    break;
                }
                case 93: {
                    this.setTimestamp(n, (Timestamp)object);
                    break;
                }
                default: {
                    throw new SQLException("Unknown SQL Type for PreparedStatement.setObject (SQL Type=" + n2);
                }
            }
        }
    }

    protected void initBoundParam() throws SQLException {
        this.numParams = this.OdbcApi.SQLNumParams(this.hStmt.getValue());
        if (this.numParams > 0) {
            this.boundParams = new JdbcOdbcBoundParam[this.numParams];
            this.paramSetFlags = new boolean[this.numParams];
            for (int i = 0; i < this.numParams; ++i) {
                this.boundParams[i] = new JdbcOdbcBoundParam();
                this.boundParams[i].initialize();
                this.paramSetFlags[i] = false;
            }
            this.paramTypes = new short[this.numParams];
            this.paramLengths = new int[this.numParams];
            this.pBoundParams.setValue(this.OdbcApi.SQLBindAllParams(this.hStmt.getValue(), this.paramTypes, this.paramLengths, this.errorCode));
        }
    }

    private void initBatchParams() {
        this.batchUpdateParams = new JdbcOdbcBatchParams(1024, this.paramTypes);
        this.isBatchEmpty = true;
    }

    protected byte[] allocBindBuf(int n, int n2) {
        byte[] byArray = this.boundParams[n - 1].allocBindDataBuffer(n2);
        return byArray;
    }

    protected byte[] getDataBuf(int n) {
        byte[] byArray = this.boundParams[n - 1].getBindDataBuffer();
        return byArray;
    }

    protected byte[] getLengthBuf(int n) {
        byte[] byArray = this.boundParams[n - 1].getBindLengthBuffer();
        return byArray;
    }

    protected int getParamLength(int n) {
        int n2 = this.OdbcApi.bufferToInt(this.boundParams[n - 1].getBindLengthBuffer());
        return n2;
    }

    protected void putParamData(int n) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.putParamData(" + n + ")");
        }
        this.validateParameterNumber(n);
        int n2 = n - 1;
        InputStream inputStream = this.boundParams[n2].getInputStream();
        int n3 = this.boundParams[n2].getInputStreamLen();
        int n4 = this.boundParams[n2].getStreamType();
        boolean bl = false;
        while (!bl) {
            byte[] byArray = new byte[2000];
            boolean bl2 = true;
            int n5 = 0;
            try {
                n5 = inputStream.read(byArray);
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
            if (n5 == -1) {
                bl = true;
                if (n3 > 0) {
                    throw new SQLException("End of InputStream reached before satisfying length specified when InputStream was set", "");
                }
                if (!bl2) break;
                n5 = 0;
            } else if (n5 > n3) {
                throw new SQLException("Data that was read exceeded the stream length specified in setStream functions", "");
            }
            int n6 = n5;
            if (n4 == 2) {
                switch (this.paramTypes[n2]) {
                    case -10: 
                    case -9: 
                    case -8: {
                        int n7;
                        if (!this.OdbcApi.isLittleEndianPlatform()) break;
                        for (n7 = 0; n7 < n5 / 2; ++n7) {
                            byte by = byArray[n7 * 2 + 1];
                            byArray[n7 * 2 + 1] = byArray[n7 * 2];
                            byArray[n7 * 2] = by;
                        }
                        break;
                    }
                    default: {
                        int n7;
                        n6 = n5 / 2;
                        for (n7 = 0; n7 < n6; ++n7) {
                            byArray[n7] = byArray[n7 * 2 + 1];
                        }
                    }
                }
            }
            this.OdbcApi.SQLPutData(this.hStmt.getValue(), byArray, n6);
            if ((n3 -= n5) == 0) {
                bl = true;
            }
            bl2 = false;
        }
    }

    private synchronized void setStream(int n, InputStream inputStream, int n2, int n3, int n4) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.setAsciiStream(" + n + ", InputStream x, " + n2 + ", " + n3 + ", " + n4 + ")");
        }
        this.validateStatement();
        this.validateParameterNumber(n);
        int n5 = n - 1;
        this.paramSetFlags[n5] = true;
        this.batchUpdateParams.setInputStream(n5, inputStream, n4);
        if (!this.isBatchEmpty) {
            return;
        }
        byte[] byArray = this.getLengthBuf(n);
        this.FreeParam(n);
        byte[] byArray2 = this.allocBindBuf(n, 4);
        int[] nArray = new int[]{0, 0, 0, 0};
        this.OdbcApi.SQLBindInParameterAtExec(this.pBoundParams.getValue(), this.hStmt.getValue(), n, n3, n2, byArray2, byArray, nArray);
        this.boundParams[n5].pA1 = nArray[0];
        this.boundParams[n5].pA2 = nArray[1];
        this.boundParams[n5].pB1 = nArray[2];
        this.boundParams[n5].pB2 = nArray[3];
        this.boundParams[n5].setInputStream(inputStream, n2);
        this.boundParams[n5].setStreamType(n4);
    }

    private static int getTypeFromObject(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof String || object instanceof Character) {
            return 1;
        }
        if (object instanceof Integer) {
            return 4;
        }
        if (object instanceof Timestamp) {
            return 93;
        }
        if (object instanceof Long) {
            return -5;
        }
        if (object instanceof Float) {
            return 6;
        }
        if (object instanceof Double) {
            return 8;
        }
        if (object instanceof byte[]) {
            return -3;
        }
        if (object instanceof Byte) {
            return -6;
        }
        if (object instanceof Short) {
            return 5;
        }
        if (object instanceof BigDecimal) {
            return 2;
        }
        if (object instanceof Date) {
            return 91;
        }
        if (object instanceof Time) {
            return 92;
        }
        if (object instanceof Boolean) {
            return -7;
        }
        return 1111;
    }

    synchronized void closePooledStatement() throws SQLException {
        this.pooledStatementFlag = false;
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbcPreparedStatement.unconditionalClose()");
        }
        this.close();
    }

    public synchronized void close() throws SQLException {
        if (this.pooledStatementFlag) {
            this.prepareForReuse();
            return;
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbcPreparedStatement.close(), physical close");
        }
        super.close();
        if (this.pBoundParams.getValue() != 0 && this.OdbcApi != null) {
            this.OdbcApi.freeBoundParams(this.pBoundParams.getValue(), this.numParams);
            this.FreeParams();
            this.pBoundParams.setValue(0);
        }
    }

    protected void FreeParams() {
        for (int i = 1; i <= this.boundParams.length; ++i) {
            if (this.boundParams[i - 1].pA1 != 0) {
                this.OdbcApi.ReleaseStoredBytes(this.boundParams[i - 1].pA1, this.boundParams[i - 1].pA2);
                this.boundParams[i - 1].pA1 = 0;
            }
            if (this.boundParams[i - 1].pB1 != 0) {
                this.OdbcApi.ReleaseStoredBytes(this.boundParams[i - 1].pB1, this.boundParams[i - 1].pB2);
                this.boundParams[i - 1].pB1 = 0;
            }
            if (this.boundParams[i - 1].pC1 != 0) {
                this.OdbcApi.ReleaseStoredBytes(this.boundParams[i - 1].pC1, this.boundParams[i - 1].pC2);
                this.boundParams[i - 1].pC1 = 0;
            }
            if (this.boundParams[i - 1].pS1 == 0) continue;
            this.OdbcApi.ReleaseStoredChars(this.boundParams[i - 1].pS1, this.boundParams[i - 1].pS2);
            this.boundParams[i - 1].pS1 = 0;
        }
    }

    protected void FreeParam(int n) {
        if (this.boundParams[n - 1].pA1 != 0) {
            this.OdbcApi.ReleaseStoredBytes(this.boundParams[n - 1].pA1, this.boundParams[n - 1].pA2);
            this.boundParams[n - 1].pA1 = 0;
        }
        if (this.boundParams[n - 1].pB1 != 0) {
            this.OdbcApi.ReleaseStoredBytes(this.boundParams[n - 1].pB1, this.boundParams[n - 1].pB2);
            this.boundParams[n - 1].pB1 = 0;
        }
        if (this.boundParams[n - 1].pC1 != 0) {
            this.OdbcApi.ReleaseStoredBytes(this.boundParams[n - 1].pC1, this.boundParams[n - 1].pC2);
            this.boundParams[n - 1].pC1 = 0;
        }
        if (this.boundParams[n - 1].pS1 != 0) {
            this.OdbcApi.ReleaseStoredChars(this.boundParams[n - 1].pS1, this.boundParams[n - 1].pS2);
            this.boundParams[n - 1].pS1 = 0;
        }
    }

    private void validateParameterNumber(int n) throws SQLException {
        if (n < 1 || n > this.numParams) {
            throw new SQLException("Invalid parameter index", "S1093");
        }
    }

    public synchronized void addBatch() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.addBatch()");
        }
        for (int i = 0; i < this.numParams; ++i) {
            if (this.paramSetFlags[i]) continue;
            throw new SQLException("Wrong number of parameters.", "07001");
        }
        this.batchUpdateParams.addParamRow();
        this.isBatchEmpty = false;
    }

    public synchronized void clearBatch() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.clearBatch()");
        }
        this.batchUpdateParams.clear();
        this.isBatchEmpty = true;
        this.clearParameters();
    }

    public synchronized int[] executeBatch() throws SQLException, BatchUpdateException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.executeBatch()");
        }
        this.validateStatement();
        if (this.hasResultSet) {
            this.closeResultSet(false);
            this.hasResultSet = false;
        }
        this.clearWarnings();
        int n = this.batchUpdateParams.size();
        int[] nArray = new int[n];
        if (n == 0) {
            return nArray;
        }
        Arrays.fill(nArray, -2);
        short s = this.OdbcApi.execPreparedStatementBatch(this.hStmt.getValue(), this, this.pBoundParams.getValue(), this.paramTypes, this.numParams, n, this.batchUpdateParams.getBatchCTypes(), this.batchUpdateParams.getBatch(), this.batchUpdateParams.getBatchPrimitiveNulls(), nArray);
        try {
            this.processBatchError(s, this.hStmt.getValue(), nArray);
        }
        catch (BatchUpdateException batchUpdateException) {
            this.OdbcApi.rebindAllParams(this.hStmt.getValue(), this.pBoundParams.getValue(), this.paramTypes, this.numParams);
            throw batchUpdateException;
        }
        finally {
            this.clearBatch();
        }
        return nArray;
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setClob(int n, Clob clob) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setArray(int n, Array array) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*PreparedStatement.setTimestamp(" + n + ", " + timestamp + ")");
        }
        if (timestamp == null) {
            this.setNull(n, 93);
        } else {
            this.validateParameterNumber(n);
            int n2 = n - 1;
            if (this.paramTypes[n2] != 11) {
                this.setString(n, timestamp.toString());
            } else {
                this.validateStatement();
                this.paramSetFlags[n2] = true;
                long l = timestamp.getTime();
                long l2 = l / 1000L * 1000L;
                if (l2 != l) {
                    l = l < 0L ? l2 - 1000L : l2;
                }
                Timestamp timestamp2 = null;
                long l3 = this.tz.getOffset(l);
                if (calendar == null) {
                    l += l3;
                    timestamp2 = timestamp;
                } else {
                    l += (long)calendar.getTimeZone().getOffset(l);
                    timestamp2 = new Timestamp(l - l3);
                    timestamp2.setNanos(timestamp.getNanos());
                }
                this.batchUpdateParams.setTimestamp(n2, timestamp2);
                if (!this.isBatchEmpty) {
                    return;
                }
                int n3 = timestamp.getNanos() / 1000;
                this.OdbcApi.setTimestamp(this.hStmt.getValue(), this.pBoundParams.getValue(), (l += 6847804800000L) * 1000L + (long)n3, this.errorCode, n);
            }
        }
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void setURL(int n, URL uRL) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        ParameterMetaDataImpl parameterMetaDataImpl = null;
        if (this.parmMetaData == null || (parameterMetaDataImpl = (ParameterMetaDataImpl)this.parmMetaData.get()) == null) {
            if (parameterMetaDataImpl == null) {
                Logger.logln("*PreparedStatement.SoftReference for ParameterDataImpl cleared, recreate.");
            }
            parameterMetaDataImpl = new ParameterMetaDataImpl(this.hStmt.getValue(), this.OdbcApi);
            this.parmMetaData = new SoftReference<ParameterMetaDataImpl>(parameterMetaDataImpl);
            return parameterMetaDataImpl;
        }
        return parameterMetaDataImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean testAndSetInUseFlag() {
        Boolean bl = this.pooledStatementInUseFlag;
        synchronized (bl) {
            if (!this.pooledStatementInUseFlag.booleanValue()) {
                this.pooledStatementInUseFlag = Boolean.TRUE;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareForReuse() throws SQLException {
        Object object;
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbcPreparedStatement.prepareForReuse()");
        }
        this.clearWarnings();
        this.clearBatch();
        this.clearParameters();
        BasicPhantomReference basicPhantomReference = (BasicPhantomReference)this.mutableReferenceContainer.get("RESULT_SET_KEY");
        if (basicPhantomReference != null) {
            object = (JdbcOdbcResultSet)basicPhantomReference.get();
            if (object != null) {
                ((JdbcOdbcResultSet)object).close(false);
            } else if (Logger.isTracingOn()) {
                Logger.logln("*PreparedStatement.prepareForReuse(), result set is already out of scope.");
            }
            this.mutableReferenceContainer.remove("RESULT_SET_KEY");
        }
        this.executed = false;
        object = this.pooledStatementInUseFlag;
        synchronized (object) {
            this.pooledStatementInUseFlag = Boolean.FALSE;
        }
    }
}

