/*
 * Decompiled with CFR 0.152.
 */
package com.timesten.jdbc;

import com.timesten.jdbc.JdbcOdbc;
import com.timesten.jdbc.JdbcOdbcBoundCol;
import com.timesten.jdbc.JdbcOdbcInputStream;
import com.timesten.jdbc.JdbcOdbcObject;
import com.timesten.jdbc.JdbcOdbcPseudoCol;
import com.timesten.jdbc.JdbcOdbcResultSetMetaData;
import com.timesten.jdbc.JdbcOdbcSQLWarning;
import com.timesten.jdbc.JdbcOdbcStatement;
import com.timesten.jdbc.Logger;
import com.timesten.jdbc.OdbcDef;
import com.timesten.jdbc.PostFinalization;
import com.timesten.jdbc.RetVal;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class JdbcOdbcResultSet
extends JdbcOdbcObject
implements ResultSet,
PostFinalization,
Cloneable {
    private Hashtable colNameToNum;
    private Hashtable colNumToName;
    private boolean lastColumnNull = false;
    protected static final String closedFlagKey = "CLOSED_FLAG";
    private int sqlTypeColnum;
    private boolean callGetData;
    private byte[] errorCode = new byte[2];
    private int pBoundBuffer = 0;
    private static final String inputStreamExistsKey = "INPUT_STREAM_EXISTS";
    private boolean firstFetch = false;
    private int cursorAtRowNum = 0;
    private boolean lastFetch = false;
    private int tzOffset = 0;
    protected JdbcOdbc OdbcApi = null;
    protected int hStmt = 0;
    protected SQLWarning lastWarning = null;
    protected boolean keepHSTMT = false;
    protected int numberOfCols = -1;
    protected int metadataColCount = -1;
    protected int firstPseudoCol = 0;
    protected int lastPseudoCol = 0;
    protected JdbcOdbcPseudoCol[] pseudoCols = null;
    protected ResultSetMetaData rsmd = null;
    protected JdbcOdbcStatement ownerStatement = null;
    protected int[] colMappings = null;
    protected int[] reverseColMap = null;
    Map mutableReferenceContainer = new HashMap();

    protected JdbcOdbcResultSet() {
    }

    public JdbcOdbcResultSet(JdbcOdbc jdbcOdbc, int n, boolean bl, JdbcOdbcStatement jdbcOdbcStatement) throws SQLException {
        this.OdbcApi = jdbcOdbc;
        this.hStmt = n;
        this.keepHSTMT = bl;
        this.ownerStatement = jdbcOdbcStatement;
        jdbcOdbcStatement.initCols();
        this.numberOfCols = jdbcOdbcStatement.getColumnCount();
        this.pBoundBuffer = jdbcOdbcStatement.getCBoundColsP();
        this.tzOffset = this.ownerStatement.getRawTZOffset();
        this.mutableReferenceContainer.put(closedFlagKey, false);
        this.mutableReferenceContainer.put(inputStreamExistsKey, false);
    }

    public synchronized boolean next() throws SQLException {
        int n;
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbcResultSet.next()");
        }
        this.validateResultSet();
        if (this.lastFetch) {
            return false;
        }
        this.lastWarning = null;
        this.lastColumnNull = false;
        this.callGetData = false;
        this.closeInputStreams();
        for (n = 0; n < this.numberOfCols; n += 1) {
            this.ownerStatement.getBoundCol(n).clearCachedValue();
        }
        n = 1;
        try {
            n = this.OdbcApi.SQLFetch(this.hStmt, this.errorCode, this.ownerStatement.getCBoundColsP(), this.ownerStatement.getBoundCols(), this.numberOfCols) ? 1 : 0;
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        if (!this.firstFetch) {
            this.firstFetch = true;
        }
        ++this.cursorAtRowNum;
        if (!n) {
            this.lastFetch = true;
            if (!this.keepHSTMT) {
                this.close();
            }
        } else if (this.errorCode[1] == -94) {
            this.callGetData = true;
        }
        return n != 0;
    }

    public void close() throws SQLException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean bl) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbcResultSet.close()");
        }
        JdbcOdbcResultSet jdbcOdbcResultSet = this;
        synchronized (jdbcOdbcResultSet) {
            if (this.isClosed()) {
                return;
            }
        }
        if (this.ownerStatement.isClosed()) {
            if (Logger.isTracingOn()) {
                Logger.logln("*JdbcOdbcResultSet.close(), statement is closed, return.");
            }
            return;
        }
        jdbcOdbcResultSet = this;
        synchronized (jdbcOdbcResultSet) {
            this.lastWarning = null;
            this.closeInputStreams();
            if (this.OdbcApi != null && this.hStmt != 0) {
                this.OdbcApi.SQLFreeStmt(this.hStmt, 0);
            }
            if (!this.keepHSTMT && bl) {
                if (Logger.isTracingOn()) {
                    Logger.logln("*JdbcOdbcResultSet.close() Close temporary statement as well.");
                }
                this.ownerStatement.close(false);
            }
            this.ownerStatement = null;
            this.hStmt = 0;
            this.mutableReferenceContainer.put(closedFlagKey, true);
        }
    }

    public boolean wasNull() throws SQLException {
        return this.lastColumnNull;
    }

    public synchronized String getString(int n) throws SQLException {
        Object object;
        this.validateResultSet();
        if (!this.firstFetch || this.lastFetch) {
            throw new SQLException("Invalid cursor state", "24000");
        }
        this.lastWarning = null;
        if (this.colMappings != null) {
            n = this.mapColumn(n);
        }
        if (this.pseudoCols != null && n >= this.firstPseudoCol && n <= this.lastPseudoCol) {
            this.lastColumnNull = true;
            return null;
        }
        this.lastColumnNull = false;
        if (n < 1 || n > this.numberOfCols) {
            throw new SQLException("Invalid column index", "S1002");
        }
        int n2 = n - 1;
        String string = null;
        int n3 = this.ownerStatement.getColCType(n);
        JdbcOdbcBoundCol jdbcOdbcBoundCol = this.ownerStatement.getBoundCol(n2);
        if (!(this.callGetData || n3 != 1 && n3 != -8)) {
            if (jdbcOdbcBoundCol.hasCachedValue && jdbcOdbcBoundCol.cachedNull) {
                this.lastColumnNull = true;
                return null;
            }
            object = new RetVal();
            this.OdbcApi.getString(this.pBoundBuffer, n, (RetVal)object, n3);
            if (((RetVal)object).getErr1() == -97) {
                throw new SQLException("Jdbc Internal Error");
            }
            if (((RetVal)object).getErr1() == -1) {
                this.lastColumnNull = true;
                return null;
            }
            string = (String)((RetVal)object).getObject();
        } else {
            int n4 = jdbcOdbcBoundCol.getDisplayLength();
            object = n3 == 1 || n3 == -8 ? (Object)((char[])jdbcOdbcBoundCol.allocateBuffer(n4, false, 2)) : (Object)((char[])jdbcOdbcBoundCol.allocateBuffer(n4, true, 2));
            int n5 = -1;
            try {
                n5 = this.OdbcApi.SQLGetDataString(this.hStmt, this.pBoundBuffer, (char[])object, this.errorCode, n, n4, this.ownerStatement.getColType(n2));
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                String string2 = (String)jdbcOdbcSQLWarning.value;
                int n6 = 0;
                if (string2 != null) {
                    n6 = string2.length();
                }
                if (this.rsmd == null) {
                    this.rsmd = this.getMetaData();
                }
                this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning, n, this.rsmd.getPrecision(n), n6));
            }
            if (n5 == -1) {
                this.lastColumnNull = true;
                return null;
            }
            int n7 = n5;
            if (n5 > n4 || n5 == -4) {
                n7 = n4;
            }
            string = new String((char[])object, 0, n7);
            if (n3 != 1 && n3 != -8) {
                try {
                    this.OdbcApi.SQLBindCol(this.hStmt, this.pBoundBuffer, 1, n4, n, this.errorCode);
                }
                catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                    this.setWarning(jdbcOdbcSQLWarning);
                }
                this.ownerStatement.setColCType(n, 1);
            }
        }
        if (n == this.sqlTypeColnum) {
            int n8 = OdbcDef.odbcTypeToJdbc(Integer.parseInt(string));
            string = String.valueOf(n8);
        }
        return string;
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        this.validateResultSet();
        if (!this.firstFetch || this.lastFetch) {
            throw new SQLException("Invalid cursor state", "24000");
        }
        this.lastWarning = null;
        if (this.colMappings != null) {
            n = this.mapColumn(n);
        }
        if (this.pseudoCols != null && n >= this.firstPseudoCol && n <= this.lastPseudoCol) {
            this.lastColumnNull = true;
            return false;
        }
        this.lastColumnNull = false;
        if (n < 1 || n > this.numberOfCols) {
            throw new SQLException("Invalid column index", "S1002");
        }
        boolean bl = false;
        switch (this.ownerStatement.getColType(n - 1)) {
            case -1: 
            case 1: 
            case 12: {
                String string = this.getString(n);
                bl = string != null;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 9: 
            case 10: 
            case 11: {
                throw new SQLException("Cannot use getBoolean to retrieve this field type", "07006");
            }
            default: {
                bl = this.getDouble(n) != 0.0;
            }
        }
        return bl;
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public synchronized byte getByte(int n) throws SQLException {
        short s = this.getShort(n);
        boolean bl = false;
        if (this.ownerStatement.getColType(n - 1) == -6) {
            if (s < 0 || s > 255) {
                bl = true;
            }
        } else if (s < -128 || s > 127) {
            bl = true;
        }
        if (bl) {
            String string = "Numeric value out of range";
            String string2 = "22003";
            if (Logger.isTracingOn()) {
                Logger.logln("ERROR - " + string2 + " " + string);
            }
            throw new SQLException(string, string2);
        }
        byte by = (byte)s;
        return by;
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public synchronized short getShort(int n) throws SQLException {
        this.validateResultSet();
        if (!this.firstFetch || this.lastFetch) {
            throw new SQLException("Invalid cursor state", "24000");
        }
        this.lastWarning = null;
        if (this.colMappings != null) {
            n = this.mapColumn(n);
        }
        if (this.pseudoCols != null && n >= this.firstPseudoCol && n <= this.lastPseudoCol) {
            this.lastColumnNull = true;
            return 0;
        }
        this.lastColumnNull = false;
        if (n < 1 || n > this.numberOfCols) {
            throw new SQLException("Invalid column index", "S1002");
        }
        int n2 = n - 1;
        short s = 0;
        int n3 = this.ownerStatement.getColCType(n);
        JdbcOdbcBoundCol jdbcOdbcBoundCol = this.ownerStatement.getBoundCol(n2);
        if (!this.callGetData && n3 == -15) {
            if (jdbcOdbcBoundCol.hasCachedValue) {
                if (jdbcOdbcBoundCol.cachedNull) {
                    this.lastColumnNull = true;
                    return 0;
                }
                this.errorCode[0] = 0;
                this.errorCode[1] = 0;
                s = jdbcOdbcBoundCol.cachedShort;
            } else {
                s = this.OdbcApi.getShort(this.pBoundBuffer, this.errorCode, n);
                if (this.errorCode[1] == -97) {
                    throw new SQLException("Jdbc Internal Error");
                }
                if (this.errorCode[1] == -1) {
                    this.lastColumnNull = true;
                    return 0;
                }
            }
        } else {
            try {
                s = this.OdbcApi.SQLGetDataShort(this.hStmt, this.pBoundBuffer, n, this.errorCode);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                s = (Short)jdbcOdbcSQLWarning.value;
                this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning, n, 2, 2));
            }
            if (this.errorCode[1] == -1) {
                this.lastColumnNull = true;
                return 0;
            }
            if (n3 != -15) {
                try {
                    this.OdbcApi.SQLBindCol(this.hStmt, this.pBoundBuffer, -15, 2, n, this.errorCode);
                    jdbcOdbcBoundCol.hasCachedValue = false;
                }
                catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                    this.setWarning(jdbcOdbcSQLWarning);
                }
                this.ownerStatement.setColCType(n, -15);
            }
        }
        if (n == this.sqlTypeColnum) {
            s = (short)OdbcDef.odbcTypeToJdbc(s);
        }
        return s;
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public synchronized int getInt(int n) throws SQLException {
        this.validateResultSet();
        if (!this.firstFetch || this.lastFetch) {
            throw new SQLException("Invalid cursor state", "24000");
        }
        this.lastWarning = null;
        if (this.colMappings != null) {
            n = this.mapColumn(n);
        }
        if (this.pseudoCols != null && n >= this.firstPseudoCol && n <= this.lastPseudoCol) {
            this.lastColumnNull = true;
            return 0;
        }
        this.lastColumnNull = false;
        if (n < 1 || n > this.numberOfCols) {
            throw new SQLException("Invalid column index", "S1002");
        }
        int n2 = n - 1;
        int n3 = 0;
        boolean bl = true;
        int n4 = this.ownerStatement.getColCType(n);
        JdbcOdbcBoundCol jdbcOdbcBoundCol = this.ownerStatement.getBoundCol(n2);
        if (!this.callGetData) {
            boolean bl2 = jdbcOdbcBoundCol.hasCachedValue;
            if (jdbcOdbcBoundCol.cachedNull) {
                this.lastColumnNull = true;
                return 0;
            }
            switch (n4) {
                case -16: {
                    if (bl2) {
                        this.errorCode[0] = 0;
                        this.errorCode[1] = 0;
                        n3 = jdbcOdbcBoundCol.cachedInt;
                        break;
                    }
                    n3 = this.OdbcApi.getInteger(this.pBoundBuffer, this.errorCode, n);
                    break;
                }
                case -15: {
                    if (bl2) {
                        this.errorCode[0] = 0;
                        this.errorCode[1] = 0;
                        n3 = jdbcOdbcBoundCol.cachedShort;
                        break;
                    }
                    n3 = this.OdbcApi.getShort(this.pBoundBuffer, this.errorCode, n);
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (bl) {
                if (this.errorCode[1] == -97) {
                    throw new SQLException("Jdbc Internal Error");
                }
                if (this.errorCode[1] == -1) {
                    this.lastColumnNull = true;
                    return 0;
                }
            }
        }
        if (this.callGetData || !bl) {
            try {
                n3 = this.OdbcApi.SQLGetDataInteger(this.hStmt, this.pBoundBuffer, n, this.errorCode);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                n3 = (Integer)jdbcOdbcSQLWarning.value;
                this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning, n, 4, 4));
            }
            if (this.errorCode[1] == -1) {
                this.lastColumnNull = true;
                return 0;
            }
            if (!bl) {
                try {
                    this.OdbcApi.SQLBindCol(this.hStmt, this.pBoundBuffer, -16, 4, n, this.errorCode);
                    jdbcOdbcBoundCol.hasCachedValue = false;
                }
                catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                    this.setWarning(jdbcOdbcSQLWarning);
                }
                this.ownerStatement.setColCType(n, -16);
            }
        }
        if (n == this.sqlTypeColnum) {
            n3 = OdbcDef.odbcTypeToJdbc(n3);
        }
        return n3;
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public synchronized long getLong(int n) throws SQLException {
        this.validateResultSet();
        if (!this.firstFetch || this.lastFetch) {
            throw new SQLException("Invalid cursor state", "24000");
        }
        this.lastWarning = null;
        if (this.colMappings != null) {
            n = this.mapColumn(n);
        }
        if (this.pseudoCols != null && n >= this.firstPseudoCol && n <= this.lastPseudoCol) {
            this.lastColumnNull = true;
            return 0L;
        }
        this.lastColumnNull = false;
        if (n < 1 || n > this.numberOfCols) {
            throw new SQLException("Invalid column index", "S1002");
        }
        int n2 = n - 1;
        long l = 0L;
        boolean bl = true;
        int n3 = this.ownerStatement.getColCType(n);
        JdbcOdbcBoundCol jdbcOdbcBoundCol = this.ownerStatement.getBoundCol(n2);
        if (!this.callGetData) {
            boolean bl2 = jdbcOdbcBoundCol.hasCachedValue;
            if (jdbcOdbcBoundCol.cachedNull) {
                this.lastColumnNull = true;
                return 0L;
            }
            switch (n3) {
                case -25: {
                    if (bl2) {
                        this.errorCode[0] = 0;
                        this.errorCode[1] = 0;
                        l = jdbcOdbcBoundCol.cachedLong;
                        break;
                    }
                    l = this.OdbcApi.getLong(this.pBoundBuffer, this.errorCode, n);
                    break;
                }
                case -16: {
                    if (bl2) {
                        this.errorCode[0] = 0;
                        this.errorCode[1] = 0;
                        l = jdbcOdbcBoundCol.cachedInt;
                        break;
                    }
                    l = this.OdbcApi.getInteger(this.pBoundBuffer, this.errorCode, n);
                    break;
                }
                case -15: {
                    if (bl2) {
                        this.errorCode[0] = 0;
                        this.errorCode[1] = 0;
                        l = jdbcOdbcBoundCol.cachedShort;
                        break;
                    }
                    l = this.OdbcApi.getShort(this.pBoundBuffer, this.errorCode, n);
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (bl) {
                if (this.errorCode[1] == -97) {
                    throw new SQLException("Jdbc Internal Error");
                }
                if (this.errorCode[1] == -1) {
                    this.lastColumnNull = true;
                    return 0L;
                }
            }
        }
        if (this.callGetData || !bl) {
            try {
                l = this.OdbcApi.SQLGetDataLong(this.hStmt, this.pBoundBuffer, n, this.errorCode);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                l = (Long)jdbcOdbcSQLWarning.value;
                this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning, n, 8, 8));
            }
            if (this.errorCode[1] == -1) {
                this.lastColumnNull = true;
                return 0L;
            }
            if (!bl) {
                try {
                    this.OdbcApi.SQLBindCol(this.hStmt, this.pBoundBuffer, -25, 8, n, this.errorCode);
                    jdbcOdbcBoundCol.hasCachedValue = false;
                }
                catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                    this.setWarning(jdbcOdbcSQLWarning);
                }
                this.ownerStatement.setColCType(n, -25);
            }
        }
        if (n == this.sqlTypeColnum) {
            l = OdbcDef.odbcTypeToJdbc((int)l);
        }
        return l;
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public synchronized float getFloat(int n) throws SQLException {
        this.validateResultSet();
        if (!this.firstFetch || this.lastFetch) {
            throw new SQLException("Invalid cursor state", "24000");
        }
        this.lastWarning = null;
        if (this.colMappings != null) {
            n = this.mapColumn(n);
        }
        if (this.pseudoCols != null && n >= this.firstPseudoCol && n <= this.lastPseudoCol) {
            this.lastColumnNull = true;
            return 0.0f;
        }
        this.lastColumnNull = false;
        if (n < 1 || n > this.numberOfCols) {
            throw new SQLException("Invalid column index", "S1002");
        }
        int n2 = n - 1;
        float f = 0.0f;
        int n3 = this.ownerStatement.getColCType(n);
        if (!this.callGetData && n3 == 7) {
            JdbcOdbcBoundCol jdbcOdbcBoundCol = this.ownerStatement.getBoundCol(n2);
            if (jdbcOdbcBoundCol.hasCachedValue) {
                if (jdbcOdbcBoundCol.cachedNull) {
                    this.lastColumnNull = true;
                    return 0.0f;
                }
                this.errorCode[0] = 0;
                this.errorCode[1] = 0;
                f = jdbcOdbcBoundCol.cachedReal;
            } else {
                f = this.OdbcApi.getFloat(this.pBoundBuffer, this.errorCode, n);
                if (this.errorCode[1] == -97) {
                    throw new SQLException("Jdbc Internal Error");
                }
                if (this.errorCode[1] == -1) {
                    this.lastColumnNull = true;
                    return 0.0f;
                }
            }
        } else {
            try {
                f = this.OdbcApi.SQLGetDataFloat(this.hStmt, this.pBoundBuffer, n, this.errorCode);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                f = ((Float)jdbcOdbcSQLWarning.value).floatValue();
                this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning, n, 4, 4));
            }
            if (this.errorCode[1] == -1) {
                this.lastColumnNull = true;
                return 0.0f;
            }
            if (n3 != 7) {
                try {
                    this.OdbcApi.SQLBindCol(this.hStmt, this.pBoundBuffer, 7, 4, n, this.errorCode);
                }
                catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                    this.setWarning(jdbcOdbcSQLWarning);
                }
                this.ownerStatement.setColCType(n, 7);
            }
        }
        if (n == this.sqlTypeColnum) {
            f = OdbcDef.odbcTypeToJdbc((int)f);
        }
        return f;
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public synchronized double getDouble(int n) throws SQLException {
        this.validateResultSet();
        if (!this.firstFetch || this.lastFetch) {
            throw new SQLException("Invalid cursor state", "24000");
        }
        this.lastWarning = null;
        if (this.colMappings != null) {
            n = this.mapColumn(n);
        }
        if (this.pseudoCols != null && n >= this.firstPseudoCol && n <= this.lastPseudoCol) {
            this.lastColumnNull = true;
            return 0.0;
        }
        this.lastColumnNull = false;
        if (n < 1 || n > this.numberOfCols) {
            throw new SQLException("Invalid column index", "S1002");
        }
        int n2 = n - 1;
        double d = 0.0;
        boolean bl = true;
        int n3 = this.ownerStatement.getColCType(n);
        if (!this.callGetData) {
            JdbcOdbcBoundCol jdbcOdbcBoundCol = this.ownerStatement.getBoundCol(n2);
            boolean bl2 = jdbcOdbcBoundCol.hasCachedValue;
            if (jdbcOdbcBoundCol.cachedNull) {
                this.lastColumnNull = true;
                return 0.0;
            }
            switch (n3) {
                case 8: {
                    if (bl2) {
                        this.errorCode[0] = 0;
                        this.errorCode[1] = 0;
                        d = jdbcOdbcBoundCol.cachedDouble;
                        break;
                    }
                    d = this.OdbcApi.getDouble(this.pBoundBuffer, this.errorCode, n);
                    break;
                }
                case 7: {
                    if (this.ownerStatement.getColType(n2) == 7) {
                        if (bl2) {
                            this.errorCode[0] = 0;
                            this.errorCode[1] = 0;
                            d = jdbcOdbcBoundCol.cachedReal;
                            break;
                        }
                        d = this.OdbcApi.getFloat(this.pBoundBuffer, this.errorCode, n);
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (bl) {
                if (this.errorCode[1] == -97) {
                    throw new SQLException("Jdbc Internal Error");
                }
                if (this.errorCode[1] == -1) {
                    this.lastColumnNull = true;
                    return 0.0;
                }
            }
        }
        if (this.callGetData || !bl) {
            try {
                d = this.OdbcApi.SQLGetDataDouble(this.hStmt, this.pBoundBuffer, n, this.errorCode);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                d = (Double)jdbcOdbcSQLWarning.value;
                this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning, n, 8, 8));
            }
            if (this.errorCode[1] == -1) {
                this.lastColumnNull = true;
                return 0.0;
            }
            if (!bl) {
                try {
                    this.OdbcApi.SQLBindCol(this.hStmt, this.pBoundBuffer, 8, 8, n, this.errorCode);
                }
                catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                    this.setWarning(jdbcOdbcSQLWarning);
                }
                this.ownerStatement.setColCType(n, 8);
            }
        }
        if (n == this.sqlTypeColnum) {
            d = OdbcDef.odbcTypeToJdbc((int)d);
        }
        return d;
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(n);
        if (bigDecimal == null) {
            return null;
        }
        bigDecimal.setScale(n2, 6);
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        this.validateResultSet();
        if (!this.firstFetch || this.lastFetch) {
            throw new SQLException("Invalid cursor state", "24000");
        }
        this.lastWarning = null;
        if (this.colMappings != null) {
            n = this.mapColumn(n);
        }
        if (this.pseudoCols != null && n >= this.firstPseudoCol && n <= this.lastPseudoCol) {
            this.lastColumnNull = true;
            return null;
        }
        this.lastColumnNull = false;
        if (n < 1 || n > this.numberOfCols) {
            throw new SQLException("Invalid column index", "S1002");
        }
        int n2 = n - 1;
        byte[] byArray = null;
        int n3 = 0;
        int n4 = this.ownerStatement.getColCType(n);
        switch (this.ownerStatement.getColType(n2)) {
            case -2: {
                n3 = this.ownerStatement.getColLength(n2);
                break;
            }
            case -4: 
            case -3: {
                if (!this.callGetData && n4 == -2) {
                    n3 = this.OdbcApi.getDataLength(this.pBoundBuffer, this.errorCode, n);
                    if (this.errorCode[1] == -97) {
                        throw new SQLException("Jdbc Internal Error");
                    }
                    if (n3 != -1) break;
                    this.lastColumnNull = true;
                    return null;
                }
                n3 = this.ownerStatement.getColLength(n2);
                break;
            }
            default: {
                throw new SQLException("Cannot use getBytes to retrieve this field type", "07006");
            }
        }
        byArray = new byte[n3];
        if (!this.callGetData && n4 == -2) {
            this.OdbcApi.getBytes(this.pBoundBuffer, byArray, this.errorCode, n);
            if (this.errorCode[1] == -97) {
                throw new SQLException("Jdbc Internal Error");
            }
            if (this.errorCode[1] == -1) {
                this.lastColumnNull = true;
                return null;
            }
        } else {
            int n5 = 0;
            try {
                n5 = this.OdbcApi.SQLGetDataBinary(this.hStmt, this.pBoundBuffer, n, -2, byArray, n3, this.errorCode);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                this.setWarning(jdbcOdbcSQLWarning);
            }
            if (this.errorCode[1] == -1) {
                this.lastColumnNull = true;
                return null;
            }
            if (n4 != -2) {
                try {
                    int n6 = this.ownerStatement.getColLength(n2);
                    this.OdbcApi.SQLBindCol(this.hStmt, this.pBoundBuffer, -2, n6, n, this.errorCode);
                }
                catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                    this.setWarning(jdbcOdbcSQLWarning);
                }
                this.ownerStatement.setColCType(n, -2);
            }
            if (n5 < n3) {
                byte[] byArray2 = byArray;
                byArray = new byte[n5];
                System.arraycopy(byArray2, 0, byArray, 0, n5);
            }
        }
        return byArray;
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public synchronized Date getDate(int n) throws SQLException {
        this.validateResultSet();
        if (!this.firstFetch || this.lastFetch) {
            throw new SQLException("Invalid cursor state", "24000");
        }
        this.lastWarning = null;
        if (this.colMappings != null) {
            n = this.mapColumn(n);
        }
        if (this.pseudoCols != null && n >= this.firstPseudoCol && n <= this.lastPseudoCol) {
            this.lastColumnNull = true;
            return null;
        }
        this.lastColumnNull = false;
        if (n < 1 || n > this.numberOfCols) {
            throw new SQLException("Invalid column index", "S1002");
        }
        int n2 = n - 1;
        int[] nArray = null;
        int n3 = this.ownerStatement.getColCType(n);
        nArray = n3 == 9 ? (int[])this.ownerStatement.getBoundCol(n2).allocateBuffer(3, false, 1) : (int[])this.ownerStatement.getBoundCol(n2).allocateBuffer(3, true, 1);
        if (!this.callGetData && n3 == 9) {
            this.OdbcApi.getDate(this.pBoundBuffer, this.errorCode, n, nArray);
            if (this.errorCode[1] == -97) {
                throw new SQLException("Jdbc Internal Error");
            }
            if (this.errorCode[1] == -1) {
                this.lastColumnNull = true;
                return null;
            }
        } else {
            try {
                this.OdbcApi.SQLGetDataDate(this.hStmt, this.pBoundBuffer, nArray, this.errorCode, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning, n, 6, 6));
            }
            if (this.errorCode[1] == -1) {
                this.lastColumnNull = true;
                return null;
            }
            if (n3 != 9) {
                try {
                    this.OdbcApi.SQLBindCol(this.hStmt, this.pBoundBuffer, 9, 6, n, this.errorCode);
                }
                catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                    this.setWarning(jdbcOdbcSQLWarning);
                }
                this.ownerStatement.setColCType(n, 9);
            }
        }
        return new Date(nArray[0] - 1900, nArray[1] - 1, nArray[2]);
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public synchronized Time getTime(int n) throws SQLException {
        this.validateResultSet();
        if (!this.firstFetch || this.lastFetch) {
            throw new SQLException("Invalid cursor state", "24000");
        }
        this.lastWarning = null;
        if (this.colMappings != null) {
            n = this.mapColumn(n);
        }
        if (this.pseudoCols != null && n >= this.firstPseudoCol && n <= this.lastPseudoCol) {
            this.lastColumnNull = true;
            return null;
        }
        this.lastColumnNull = false;
        if (n < 1 || n > this.numberOfCols) {
            throw new SQLException("Invalid column index", "S1002");
        }
        int n2 = n - 1;
        int[] nArray = null;
        int n3 = this.ownerStatement.getColCType(n);
        nArray = n3 == 10 ? (int[])this.ownerStatement.getBoundCol(n2).allocateBuffer(3, false, 1) : (int[])this.ownerStatement.getBoundCol(n2).allocateBuffer(3, true, 1);
        if (!this.callGetData && n3 == 10) {
            this.OdbcApi.getTime(this.pBoundBuffer, this.errorCode, n, nArray);
            if (this.errorCode[1] == -97) {
                throw new SQLException("Jdbc Internal Error");
            }
            if (this.errorCode[1] == -1) {
                this.lastColumnNull = true;
                return null;
            }
        } else {
            try {
                this.OdbcApi.SQLGetDataTime(this.hStmt, this.pBoundBuffer, nArray, this.errorCode, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning, n, 6, 6));
            }
            if (this.errorCode[1] == -1) {
                this.lastColumnNull = true;
                return null;
            }
            if (n3 != 10) {
                try {
                    this.OdbcApi.SQLBindCol(this.hStmt, this.pBoundBuffer, 10, 6, n, this.errorCode);
                }
                catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                    this.setWarning(jdbcOdbcSQLWarning);
                }
                this.ownerStatement.setColCType(n, 10);
            }
        }
        DecimalFormat decimalFormat = new DecimalFormat("00");
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(decimalFormat.format(nArray[0]));
        stringBuffer.append(":");
        stringBuffer.append(decimalFormat.format(nArray[1]));
        stringBuffer.append(":");
        stringBuffer.append(decimalFormat.format(nArray[2]));
        return Time.valueOf(stringBuffer.toString());
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, null);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        return this.getXXXStream(1, n);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getXXXStream(1, this.findColumn(string));
    }

    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        return this.getXXXStream(3, n);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getXXXStream(3, this.findColumn(string));
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        return this.getXXXStream(2, n);
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getXXXStream(2, this.findColumn(string));
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        this.validateResultSet();
        return this.lastWarning;
    }

    public synchronized void clearWarnings() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSet.clearWarnings()");
        }
        this.lastWarning = null;
    }

    public synchronized String getCursorName() throws SQLException {
        this.validateResultSet();
        String string = "";
        try {
            string = this.OdbcApi.SQLGetCursorName(this.hStmt);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        return string.trim();
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSet.getMetaData()");
        }
        this.validateResultSet();
        return new JdbcOdbcResultSetMetaData(this, this.OdbcApi, this.hStmt);
    }

    public synchronized Object getObject(int n) throws SQLException {
        this.validateResultSet();
        if (!this.firstFetch || this.lastFetch) {
            throw new SQLException("Invalid cursor state", "24000");
        }
        this.lastWarning = null;
        if (this.colMappings != null) {
            n = this.mapColumn(n);
        }
        if (this.pseudoCols != null && n >= this.firstPseudoCol && n <= this.lastPseudoCol) {
            this.lastColumnNull = true;
            return null;
        }
        this.lastColumnNull = false;
        if (n < 1 || n > this.numberOfCols) {
            throw new SQLException("Invalid column index", "S1002");
        }
        Object object = null;
        int n2 = this.ownerStatement.getColType(n - 1);
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                object = this.getString(n);
                break;
            }
            case 2: 
            case 3: {
                object = this.getBigDecimal(n);
                break;
            }
            case -7: {
                object = new Boolean(this.getBoolean(n));
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                object = new Integer(this.getInt(n));
                break;
            }
            case -5: {
                object = new Long(this.getLong(n));
                break;
            }
            case 7: {
                object = new Float(this.getFloat(n));
                break;
            }
            case 6: 
            case 8: {
                object = new Double(this.getDouble(n));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                object = this.getBytes(n);
                break;
            }
            case 9: {
                object = this.getDate(n);
                break;
            }
            case 10: {
                object = this.getTime(n);
                break;
            }
            case 11: {
                object = this.getTimestamp(n);
                break;
            }
            case -10: 
            case -9: 
            case -8: {
                object = this.getString(n);
            }
        }
        if (this.wasNull()) {
            object = null;
        }
        return object;
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public synchronized int findColumn(String string) throws SQLException {
        this.validateResultSet();
        Integer n = null;
        if (this.colNameToNum == null) {
            this.colNameToNum = new Hashtable();
        } else {
            n = (Integer)this.colNameToNum.get(string);
        }
        if (n == null) {
            int n2;
            String string2 = null;
            if (this.rsmd == null) {
                this.rsmd = this.getMetaData();
            }
            if (this.colNumToName == null) {
                this.colNumToName = new Hashtable();
            }
            for (n2 = 1; n2 <= this.numberOfCols; ++n2) {
                string2 = (String)this.colNumToName.get(new Integer(n2));
                if (string2 == null) {
                    string2 = this.rsmd.getColumnName(n2);
                    this.colNameToNum.put(string2, new Integer(n2));
                    this.colNumToName.put(new Integer(n2), string2);
                }
                if (!string2.equalsIgnoreCase(string)) continue;
                return n2;
            }
            if (this.firstPseudoCol > 0 && this.lastPseudoCol >= this.firstPseudoCol) {
                for (n2 = 0; n2 <= this.lastPseudoCol - this.firstPseudoCol; ++n2) {
                    int n3 = this.firstPseudoCol + n2;
                    string2 = (String)this.colNumToName.get(new Integer(n3));
                    if (string2 == null) {
                        string2 = this.pseudoCols[n2].getColumnLabel();
                        this.colNameToNum.put(string2, new Integer(n3));
                        this.colNumToName.put(new Integer(n3), string2);
                    }
                    if (!string2.equalsIgnoreCase(string)) continue;
                    return n3;
                }
            }
            throw new SQLException("Column not found", "S0022");
        }
        return n;
    }

    public Reader getCharacterStream(int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Reader getCharacterStream(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public synchronized BigDecimal getBigDecimal(int n) throws SQLException {
        int n2;
        this.validateResultSet();
        if (!this.firstFetch || this.lastFetch) {
            throw new SQLException("Invalid cursor state", "24000");
        }
        this.lastWarning = null;
        if (this.colMappings != null) {
            n = this.mapColumn(n);
        }
        if (this.pseudoCols != null && n >= this.firstPseudoCol && n <= this.lastPseudoCol) {
            this.lastColumnNull = true;
            return null;
        }
        this.lastColumnNull = false;
        if (n < 1 || n > this.numberOfCols) {
            throw new SQLException("Invalid column index", "S1002");
        }
        int n3 = n - 1;
        BigDecimal bigDecimal = null;
        int n4 = this.ownerStatement.getColCType(n);
        try {
            switch (this.ownerStatement.getColType(n3)) {
                case -1: 
                case 1: 
                case 12: {
                    n2 = !this.callGetData && n4 == 1 ? 1 : 0;
                    String string = this.getString(n);
                    if (string == null) {
                        return null;
                    }
                    if (string.indexOf(101) != -1 || string.indexOf(69) != -1) {
                        bigDecimal = new BigDecimal(Double.parseDouble(string));
                        break;
                    }
                    if (n2 != 0) {
                        bigDecimal = this.OdbcApi.getBigDecimal(this.pBoundBuffer, n);
                        if (bigDecimal == null) {
                            this.lastColumnNull = true;
                            return null;
                        }
                        break;
                    }
                    try {
                        bigDecimal = new BigDecimal(string.trim());
                        break;
                    }
                    catch (Exception exception) {
                        Logger.log(exception);
                        throw new SQLException("Error in assignment", "22005");
                    }
                }
                case -5: 
                case 2: 
                case 3: {
                    if (!this.callGetData && n4 == 1) {
                        bigDecimal = this.OdbcApi.getBigDecimal(this.pBoundBuffer, n);
                        if (bigDecimal == null) {
                            this.lastColumnNull = true;
                            return null;
                        }
                        break;
                    }
                    String string = this.getString(n);
                    if (string == null) {
                        return null;
                    }
                    bigDecimal = new BigDecimal(string);
                    break;
                }
                case -7: 
                case -6: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    double d = this.getDouble(n);
                    if (this.lastColumnNull) {
                        return null;
                    }
                    bigDecimal = new BigDecimal(d);
                    break;
                }
                default: {
                    throw new SQLException("Cannot use getBigDecimal to retrieve this field type", "07006");
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            Logger.log(numberFormatException);
            throw new SQLException("Error in assignment", "22005");
        }
        if (n == this.sqlTypeColnum) {
            n2 = OdbcDef.odbcTypeToJdbc(bigDecimal.intValue());
            bigDecimal = new BigDecimal("" + n2);
        }
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        this.validateResultSet();
        return !this.firstFetch && this.numberOfCols > 0;
    }

    public synchronized boolean isAfterLast() throws SQLException {
        this.validateResultSet();
        return this.lastFetch && this.numberOfCols > 0;
    }

    public synchronized boolean isFirst() throws SQLException {
        this.validateResultSet();
        return this.cursorAtRowNum == 1;
    }

    public boolean isLast() throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void beforeFirst() throws SQLException {
        throw new SQLException("Driver not capable: Result set is TYPE_FORWARD_ONLY", "S1C00");
    }

    public void afterLast() throws SQLException {
        throw new SQLException("Driver not capable: Result set is TYPE_FORWARD_ONLY", "S1C00");
    }

    public boolean first() throws SQLException {
        throw new SQLException("Driver not capable: Result set is TYPE_FORWARD_ONLY", "S1C00");
    }

    public boolean last() throws SQLException {
        throw new SQLException("Driver not capable: Result set is TYPE_FORWARD_ONLY", "S1C00");
    }

    public synchronized int getRow() throws SQLException {
        return this.cursorAtRowNum;
    }

    public boolean absolute(int n) throws SQLException {
        throw new SQLException("Driver not capable: Result set is TYPE_FORWARD_ONLY", "S1C00");
    }

    public boolean relative(int n) throws SQLException {
        switch (n) {
            case 0: {
                return this.cursorAtRowNum != 0;
            }
            case 1: {
                return this.next();
            }
        }
        throw new SQLException("Driver not capable: Result set is TYPE_FORWARD_ONLY", "S1C00");
    }

    public boolean previous() throws SQLException {
        throw new SQLException("Driver not capable: Result set is TYPE_FORWARD_ONLY", "S1C00");
    }

    public void setFetchDirection(int n) throws SQLException {
        if (n != 1000) {
            throw new SQLException("Driver not capable: Result set is TYPE_FORWARD_ONLY", "S1C00");
        }
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSet.setFetchSize(" + n + ")");
        }
        this.validateResultSet();
        this.lastWarning = null;
        if (n != 0) {
            this.OdbcApi.SQLSetStmtOption(this.hStmt, (short)3001, n);
        }
    }

    public synchronized int getFetchSize() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSet.getFetchSize()");
        }
        this.validateResultSet();
        this.lastWarning = null;
        int n = 0;
        try {
            n = this.OdbcApi.SQLGetStmtOption(this.hStmt, (short)3001);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)jdbcOdbcSQLWarning.value;
            n = bigDecimal.intValue();
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        return n;
    }

    public int getType() throws SQLException {
        return 1003;
    }

    public int getConcurrency() throws SQLException {
        return 1007;
    }

    public boolean rowUpdated() throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public boolean rowInserted() throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public boolean rowDeleted() throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateNull(int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateByte(int n, byte by) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateShort(int n, short s) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateInt(int n, int n2) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateLong(int n, long l) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateFloat(int n, float f) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateDouble(int n, double d) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateString(int n, String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateDate(int n, Date date) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateTime(int n, Time time) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateObject(int n, Object object) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateNull(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateByte(String string, byte by) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateShort(String string, short s) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateInt(String string, int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateLong(String string, long l) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateFloat(String string, float f) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateDouble(String string, double d) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateString(String string, String string2) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateDate(String string, Date date) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateTime(String string, Time time) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateObject(String string, Object object) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void insertRow() throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateRow() throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void deleteRow() throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void refreshRow() throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void moveToInsertRow() throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public synchronized Statement getStatement() throws SQLException {
        return this.ownerStatement;
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Ref getRef(int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Blob getBlob(int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Clob getClob(int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Array getArray(int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Ref getRef(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Blob getBlob(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Clob getClob(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Array getArray(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.validateResultSet();
        if (!this.firstFetch || this.lastFetch) {
            throw new SQLException("Invalid cursor state", "24000");
        }
        this.lastWarning = null;
        if (this.colMappings != null) {
            n = this.mapColumn(n);
        }
        if (this.pseudoCols != null && n >= this.firstPseudoCol && n <= this.lastPseudoCol) {
            this.lastColumnNull = true;
            return null;
        }
        this.lastColumnNull = false;
        if (n < 1 || n > this.numberOfCols) {
            throw new SQLException("Invalid column index", "S1002");
        }
        int n2 = n - 1;
        int[] nArray = null;
        Object var5_5 = null;
        int n3 = this.ownerStatement.getColCType(n);
        if (this.ownerStatement.getColType(n2) == 11 && n3 == -2) {
            long l = 0L;
            if (!this.callGetData) {
                l = this.OdbcApi.getTimestampRaw(this.pBoundBuffer, this.errorCode, n);
            } else {
                try {
                    l = this.OdbcApi.SQLGetDataTimestampRaw(this.hStmt, this.pBoundBuffer, this.errorCode, n);
                }
                catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                    this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning, n, 8, 8));
                }
            }
            if (this.errorCode[1] == -97) {
                throw new SQLException("Jdbc Internal Error");
            }
            if (this.errorCode[1] == -1) {
                this.lastColumnNull = true;
                return null;
            }
            int n4 = (int)(l % 1000000L);
            long l2 = (l - (long)n4) / 1000L;
            int n5 = n4 * 1000;
            l2 -= 6847804800000L;
            if (calendar == null) {
                l2 -= (long)this.tzOffset;
                l2 -= (long)this.ownerStatement.getDSTOffsetForDate(l2);
            } else {
                l2 -= (long)calendar.getTimeZone().getOffset(l2);
            }
            Timestamp timestamp = new Timestamp(l2);
            timestamp.setNanos(n5);
            return timestamp;
        }
        nArray = n3 == 11 ? (int[])this.ownerStatement.getBoundCol(n2).allocateBuffer(7, false, 1) : (int[])this.ownerStatement.getBoundCol(n2).allocateBuffer(7, true, 1);
        if (!this.callGetData && n3 == 11) {
            this.OdbcApi.getTimestamp(this.pBoundBuffer, this.errorCode, n, nArray);
            if (this.errorCode[1] == -97) {
                throw new SQLException("Jdbc Internal Error");
            }
            if (this.errorCode[1] == -1) {
                this.lastColumnNull = true;
                return null;
            }
        } else {
            try {
                this.OdbcApi.SQLGetDataTimestamp(this.hStmt, this.pBoundBuffer, nArray, this.errorCode, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning, n, 16, 16));
            }
            if (this.errorCode[1] == -1) {
                this.lastColumnNull = true;
                return null;
            }
            if (n3 != 11) {
                try {
                    this.OdbcApi.SQLBindCol(this.hStmt, this.pBoundBuffer, 11, 16, n, this.errorCode);
                }
                catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                    this.setWarning(jdbcOdbcSQLWarning);
                }
                this.ownerStatement.setColCType(n, 11);
            }
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(nArray[0], nArray[1] - 1, nArray[2], nArray[3], nArray[4], nArray[5]);
        Timestamp timestamp = new Timestamp(gregorianCalendar.getTimeInMillis());
        timestamp.setNanos(nArray[6]);
        return timestamp;
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public URL getURL(int n) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public URL getURL(String string) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public void updateArray(String string, Array array) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    synchronized int getRowNumber() throws SQLException {
        this.validateResultSet();
        if (!this.firstFetch || this.lastFetch) {
            throw new SQLException("Invalid cursor state", "24000");
        }
        this.lastWarning = null;
        int n = 0;
        try {
            n = this.OdbcApi.SQLGetStmtOption(this.hStmt, (short)14);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)jdbcOdbcSQLWarning.value;
            n = bigDecimal.intValue();
            this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        return n;
    }

    synchronized int getColumnCount() throws SQLException {
        this.validateResultSet();
        this.lastWarning = null;
        if (this.metadataColCount != -1) {
            return this.metadataColCount;
        }
        return this.ownerStatement.getColumnCount();
    }

    void setWarning(SQLWarning sQLWarning) {
        if (this.lastWarning == null) {
            this.lastWarning = sQLWarning;
        } else {
            this.lastWarning.setNextWarning(sQLWarning);
        }
    }

    int getColumnType(int n) throws SQLException {
        int n2 = 9999;
        if (n > 0 && n <= this.numberOfCols) {
            n2 = this.ownerStatement.getColType(n - 1);
        }
        return n2;
    }

    int getColumnLength(int n) throws SQLException {
        int n2 = -1;
        if (n > 0 && n <= this.numberOfCols) {
            n2 = this.ownerStatement.getColLength(n - 1);
        }
        return n2;
    }

    int getDisplaySize(int n) {
        if (n > 0 && n <= this.numberOfCols) {
            return this.ownerStatement.getDisplayLength(n - 1);
        }
        return 9999;
    }

    synchronized void setPseudoCols(int n, int n2, JdbcOdbcPseudoCol[] jdbcOdbcPseudoColArray) {
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSet.setPseudoCols(first=" + n + ", last=" + n2 + ")");
        }
        this.firstPseudoCol = n;
        this.lastPseudoCol = n2;
        this.pseudoCols = jdbcOdbcPseudoColArray;
    }

    JdbcOdbcPseudoCol getPseudoCol(int n) {
        if (n > 0 && n >= this.firstPseudoCol && n <= this.lastPseudoCol) {
            return this.pseudoCols[n - this.firstPseudoCol];
        }
        return null;
    }

    void setSQLTypeColumn(int n) {
        this.sqlTypeColnum = n;
    }

    synchronized void setColumnMappings(int[] nArray, int[] nArray2) {
        this.colMappings = nArray;
        this.reverseColMap = nArray2;
    }

    int mapColumn(int n) {
        int n2 = n;
        if (this.colMappings != null) {
            n2 = n > 0 && n <= this.colMappings.length ? this.colMappings[n - 1] : -1;
        }
        return n2;
    }

    int reverseMap(int n) {
        int n2 = n;
        if (this.reverseColMap != null) {
            n2 = n > 0 && n <= this.reverseColMap.length ? this.reverseColMap[n - 1] : -1;
        }
        return n2;
    }

    void setMetadataColCount(int n) {
        this.metadataColCount = n;
    }

    protected InputStream getXXXStream(int n, int n2) throws SQLException {
        this.validateResultSet();
        if (!this.firstFetch || this.lastFetch) {
            throw new SQLException("Invalid cursor state", "24000");
        }
        this.lastWarning = null;
        if (this.colMappings != null) {
            n2 = this.mapColumn(n2);
        }
        if (this.pseudoCols != null && n2 >= this.firstPseudoCol && n2 <= this.lastPseudoCol) {
            this.lastColumnNull = true;
            return null;
        }
        this.lastColumnNull = false;
        if (n2 < 1 || n2 > this.numberOfCols) {
            throw new SQLException("Invalid column index", "S1002");
        }
        int n3 = n2 - 1;
        int n4 = this.ownerStatement.getColType(n3);
        if (!this.isGetStreamAllowedForType(n, n4)) {
            throw new SQLException("getXXX method on the column type is not allowed", "07006");
        }
        int n5 = -2;
        boolean bl = false;
        int n6 = this.ownerStatement.getColCType(n2);
        switch (n4) {
            case 1: 
            case 12: {
                if (n6 == 1) {
                    bl = true;
                }
                n5 = 1;
                break;
            }
            case -3: 
            case -2: {
                if (n6 == -2) {
                    bl = true;
                }
                n5 = -2;
                break;
            }
            case -9: 
            case -8: {
                if (n6 == -8) {
                    bl = true;
                }
                n5 = -8;
                break;
            }
            default: {
                throw new SQLException("getXXX method on the column type is not allowed", "07006");
            }
        }
        int n7 = 1;
        int n8 = 20;
        if (n == 1 && n5 == -2) {
            n8 = 21;
            n7 = 2;
        } else if (n == 3) {
            if (n5 == -2) {
                n8 = 22;
                n7 = 4;
            } else if (n5 == 1) {
                n8 = 23;
                n7 = 2;
            } else if (n5 == -8) {
                n8 = 24;
                n7 = 1;
            }
        } else {
            n8 = 20;
            n7 = 1;
        }
        byte[] byArray = null;
        int n9 = 0;
        int n10 = 0;
        if (!this.callGetData && bl) {
            n9 = this.OdbcApi.getDataLength(this.pBoundBuffer, this.errorCode, n2);
            if (this.errorCode[1] == -97) {
                throw new SQLException("Jdbc Internal Error");
            }
            if (n9 == -1) {
                this.lastColumnNull = true;
                return null;
            }
            n10 = n9 * n7;
            byArray = new byte[n10];
            this.OdbcApi.getStream(this.pBoundBuffer, byArray, this.errorCode, n2, n8);
            if (this.errorCode[1] == -97) {
                throw new SQLException("Jdbc Internal Error");
            }
        } else {
            n10 = this.ownerStatement.getColLength(n3) * n7;
            byArray = new byte[n10];
            try {
                n9 = this.OdbcApi.SQLGetDataStream(this.hStmt, this.pBoundBuffer, n2, n5, byArray, n10, n8, this.errorCode);
            }
            catch (SQLWarning sQLWarning) {
                this.setWarning(sQLWarning);
            }
            if (this.errorCode[1] == -1) {
                this.lastColumnNull = true;
                return null;
            }
            if (!bl) {
                try {
                    int n11 = this.ownerStatement.getColLength(n3);
                    this.OdbcApi.SQLBindCol(this.hStmt, this.pBoundBuffer, n5, n11, n2, this.errorCode);
                }
                catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                    this.setWarning(jdbcOdbcSQLWarning);
                }
                this.ownerStatement.setColCType(n2, n5);
            }
        }
        JdbcOdbcInputStream jdbcOdbcInputStream = new JdbcOdbcInputStream(byArray, n9 * n7);
        this.setInputStream(n2, jdbcOdbcInputStream);
        return jdbcOdbcInputStream;
    }

    protected void setInputStream(int n, JdbcOdbcInputStream jdbcOdbcInputStream) {
        this.mutableReferenceContainer.put(inputStreamExistsKey, true);
        this.ownerStatement.getBoundCol(n - 1).setInputStream(jdbcOdbcInputStream);
    }

    protected void closeInputStreams() {
        Boolean bl = (Boolean)this.mutableReferenceContainer.get(inputStreamExistsKey);
        boolean bl2 = false;
        if (bl != null) {
            bl2 = bl;
        }
        if (!bl2 || this.ownerStatement == null) {
            return;
        }
        for (int i = 0; i < this.numberOfCols; ++i) {
            this.ownerStatement.getBoundCol(i).closeInputStream();
        }
    }

    private boolean isGetStreamAllowedForType(int n, int n2) {
        switch (n) {
            case 3: {
                switch (n2) {
                    case -9: 
                    case -8: 
                    case -3: 
                    case -2: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 1: {
                switch (n2) {
                    case -3: 
                    case -2: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 2: {
                switch (n2) {
                    case -3: 
                    case -2: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void doPostFinalization() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbcResultSet.doPostFinalization(" + this + ")");
        }
        this.close();
    }

    private boolean isClosed() {
        Boolean bl = (Boolean)this.mutableReferenceContainer.get(closedFlagKey);
        return bl;
    }

    private void validateResultSet() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result set is closed", "S1010");
        }
    }
}

