/*
 * Decompiled with CFR 0.152.
 */
package com.timesten.jdbc;

import com.timesten.jdbc.JdbcOdbc;
import com.timesten.jdbc.JdbcOdbcObject;
import com.timesten.jdbc.JdbcOdbcPseudoCol;
import com.timesten.jdbc.JdbcOdbcResultSet;
import com.timesten.jdbc.JdbcOdbcSQLWarning;
import com.timesten.jdbc.Logger;
import com.timesten.jdbc.OdbcDef;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class JdbcOdbcResultSetMetaData
extends JdbcOdbcObject
implements ResultSetMetaData {
    protected JdbcOdbc OdbcApi;
    protected JdbcOdbcResultSet resultSet;
    protected int hStmt;

    public JdbcOdbcResultSetMetaData(JdbcOdbcResultSet jdbcOdbcResultSet, JdbcOdbc jdbcOdbc, int n) {
        this.resultSet = jdbcOdbcResultSet;
        this.OdbcApi = jdbcOdbc;
        this.hStmt = n;
    }

    public int getColumnCount() throws SQLException {
        return this.resultSet.getColumnCount();
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSetMetaData.isAutoIncrement(" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : this.getColAttributeBoolean(n, 11);
        return bl;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSetMetaData.isCaseSensitive(" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : this.getColAttributeBoolean(n, 12);
        return bl;
    }

    public boolean isSearchable(int n) throws SQLException {
        int n2;
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSetMetaData.isSearchable (" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : (n2 = this.getColAttribute(n, 13)) != 0;
        return bl;
    }

    public boolean isCurrency(int n) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSetMetaData.isCurrency(" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : this.getColAttributeBoolean(n, 9);
        return bl;
    }

    public int isNullable(int n) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSetMetaData.isNullable(" + n + ")");
        }
        int n2 = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? 0 : this.getColAttribute(n, 7);
        return n2;
    }

    public boolean isSigned(int n) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSetMetaData.isSigned(" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : !this.getColAttributeBoolean(n, 8);
        return bl;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol;
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSetMetaData.getColumnDisplaySize(" + n + ")");
        }
        int n2 = (jdbcOdbcPseudoCol = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n))) != null ? jdbcOdbcPseudoCol.getColumnDisplaySize() : this.getColAttribute(n, 6);
        return n2;
    }

    public String getColumnLabel(int n) throws SQLException {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol;
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSetMetaData.getColumnLabel(" + n + ")");
        }
        String string = (jdbcOdbcPseudoCol = this.resultSet.getPseudoCol(n = this.resultSet.reverseMap(n))) != null ? jdbcOdbcPseudoCol.getColumnLabel() : this.getColAttributeString(n, 18);
        return string;
    }

    public String getColumnName(int n) throws SQLException {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol;
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSetMetaData.getColumnName(" + n + ")");
        }
        String string = (jdbcOdbcPseudoCol = this.resultSet.getPseudoCol(n = this.resultSet.reverseMap(n))) != null ? jdbcOdbcPseudoCol.getColumnLabel() : this.getColAttributeString(n, 1);
        return string;
    }

    public String getSchemaName(int n) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSetMetaData.getSchemaName(" + n + ")");
        }
        if (this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null) {
            n = 1;
        }
        return this.getColAttributeString(n, 16);
    }

    public int getPrecision(int n) throws SQLException {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol;
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSetMetaData.getPrecision(" + n + ")");
        }
        int n2 = (jdbcOdbcPseudoCol = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n))) != null ? jdbcOdbcPseudoCol.getColumnDisplaySize() - 1 : this.getColAttribute(n, 4);
        return n2;
    }

    public int getScale(int n) throws SQLException {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol;
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSetMetaData.getScale(" + n + ")");
        }
        int n2 = (jdbcOdbcPseudoCol = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n))) != null ? 0 : this.getColAttribute(n, 5);
        return n2;
    }

    public String getTableName(int n) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSetMetaData.getTableName(" + n + ")");
        }
        if (this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null) {
            n = 1;
        }
        return this.getColAttributeString(n, 15);
    }

    public String getCatalogName(int n) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSetMetaData.getCatalogName(" + n + ")");
        }
        if (this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null) {
            n = 1;
        }
        return this.getColAttributeString(n, 17);
    }

    public int getColumnType(int n) throws SQLException {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol;
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSetMetaData.getColumnType(" + n + ")");
        }
        int n2 = (jdbcOdbcPseudoCol = this.resultSet.getPseudoCol(n)) != null ? jdbcOdbcPseudoCol.getColumnType() : OdbcDef.odbcTypeToJdbc(this.resultSet.getColumnType(n));
        return n2;
    }

    public String getColumnTypeName(int n) throws SQLException {
        JdbcOdbcPseudoCol jdbcOdbcPseudoCol;
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSetMetaData.getColumnTypeName(" + n + ")");
        }
        String string = (jdbcOdbcPseudoCol = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n))) != null ? jdbcOdbcPseudoCol.getColumnTypeName() : this.getColAttributeString(n, 14);
        return string;
    }

    public boolean isReadOnly(int n) throws SQLException {
        int n2;
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSetMetaData.isReadOnly(" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? true : (n2 = this.getColAttribute(n, 10)) == 0;
        return bl;
    }

    public boolean isWritable(int n) throws SQLException {
        int n2;
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSetMetaData.isWritable(" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : (n2 = this.getColAttribute(n, 10)) == 2;
        return bl;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        int n2;
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSetMetaData.isDefinitelyWritable(" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : (n2 = this.getColAttribute(n, 10)) == 1;
        return bl;
    }

    protected int getColAttribute(int n, int n2) throws SQLException {
        int n3 = 0;
        this.resultSet.clearWarnings();
        try {
            n3 = this.OdbcApi.SQLColAttributes(this.hStmt, n, n2);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)jdbcOdbcSQLWarning.value;
            n3 = bigDecimal.intValue();
            this.resultSet.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        return n3;
    }

    protected boolean getColAttributeBoolean(int n, int n2) throws SQLException {
        int n3 = this.getColAttribute(n, n2);
        boolean bl = false;
        if (n3 == 1) {
            bl = true;
        }
        return bl;
    }

    protected String getColAttributeString(int n, int n2) throws SQLException {
        String string = "";
        this.resultSet.clearWarnings();
        try {
            string = this.OdbcApi.SQLColAttributesString(this.hStmt, n, n2);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            string = (String)jdbcOdbcSQLWarning.value;
            this.resultSet.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
        }
        return string.trim();
    }

    public String getColumnClassName(int n) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*ResultSetMetaData.getColumnClassName(" + n + ")");
        }
        String string = null;
        int n2 = this.getColumnType(n);
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                string = "java.lang.String";
                break;
            }
            case 2: 
            case 3: {
                string = "java.math.BigDecimal";
                break;
            }
            case -7: {
                string = "java.lang.Boolean";
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                string = "java.lang.Integer";
                break;
            }
            case -5: {
                string = "java.lang.Long";
                break;
            }
            case 7: {
                string = "java.lang.Float";
                break;
            }
            case 6: 
            case 8: {
                string = "java.lang.Double";
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                string = "[B";
                break;
            }
            case 91: {
                string = "java.sql.Date";
                break;
            }
            case 92: {
                string = "java.sql.Time";
                break;
            }
            case 93: {
                string = "java.sql.Timestamp";
            }
        }
        return string;
    }
}

