/*
 * Decompiled with CFR 0.152.
 */
package com.timesten.jdbc;

import com.timesten.jdbc.BasicPhantomReference;
import com.timesten.jdbc.JdbcOdbc;
import com.timesten.jdbc.JdbcOdbcBoundCol;
import com.timesten.jdbc.JdbcOdbcConnection;
import com.timesten.jdbc.JdbcOdbcObject;
import com.timesten.jdbc.JdbcOdbcResultSet;
import com.timesten.jdbc.JdbcOdbcSQLWarning;
import com.timesten.jdbc.JpointerWrapper;
import com.timesten.jdbc.Logger;
import com.timesten.jdbc.PostFinalization;
import com.timesten.jdbc.ReferenceManager;
import com.timesten.jdbc.TimesTenConnection;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;

public class JdbcOdbcStatement
extends JdbcOdbcObject
implements Statement,
Cloneable,
PostFinalization {
    public static final boolean doCachePrimitives = true;
    public static final int BATCH_SUCCESS_NO_INFO = -2;
    public static final int BATCH_EXECUTE_FAILED = -3;
    private TimesTenConnection myConnection;
    private JdbcOdbcConnection realConnection;
    private JpointerWrapper cBoundColsP = new JpointerWrapper(0);
    protected static final String myResultSetKey = "RESULT_SET_KEY";
    private int colCount = -1;
    private boolean needBufferCheck = true;
    private JdbcOdbcBoundCol[] boundCols;
    private int[] colTypes;
    private int[] colLengths;
    private int[] colCTypes;
    private int oldColCount = 0;
    private int[] oldColTypes;
    private int[] oldColCTypes;
    private int[] oldColLengths;
    private Vector batchUpdateSQL;
    protected JdbcOdbc OdbcApi;
    protected JpointerWrapper hStmt = new JpointerWrapper(0);
    protected SQLWarning lastWarning;
    protected static final String closedFlagKey = "CLOSED_FLAG";
    protected boolean executed;
    protected boolean hasResultSet;
    protected boolean moreResults = true;
    protected boolean isBatchEmpty = true;
    protected TimeZone tz = null;
    protected int tzOffset = 0;
    protected Calendar cal = null;
    protected Date date = null;
    protected static final String registeredReferenceKey = "PHANTOM_REFERENCE";
    protected final ReferenceManager referenceManager;
    protected Map mutableReferenceContainer = new HashMap();

    protected JdbcOdbcStatement() {
        this.referenceManager = null;
    }

    public JdbcOdbcStatement(TimesTenConnection timesTenConnection) throws SQLException {
        this.myConnection = timesTenConnection;
        this.realConnection = (JdbcOdbcConnection)timesTenConnection;
        this.referenceManager = this.realConnection.getReferenceManager();
        this.OdbcApi = ((JdbcOdbcConnection)timesTenConnection).getJdbcOdbcBridge();
        this.batchUpdateSQL = new Vector(1024, 1024);
        try {
            this.hStmt.setValue(this.OdbcApi.SQLAllocStmt(timesTenConnection.getHDBC()));
        }
        catch (SQLWarning sQLWarning) {
            this.setWarning(sQLWarning);
        }
        this.tz = ((JdbcOdbcConnection)this.myConnection).getTimeZone();
        this.tzOffset = ((JdbcOdbcConnection)this.myConnection).getRawTZOffset();
        this.mutableReferenceContainer.put(closedFlagKey, false);
    }

    void changeOwnerConnection(TimesTenConnection timesTenConnection) {
        this.myConnection = timesTenConnection;
    }

    public synchronized ResultSet executeQuery(String string) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.executeQuery(" + string + ")");
        }
        this.execute(string);
        ResultSet resultSet = this.getResultSet();
        return resultSet;
    }

    public synchronized int executeUpdate(String string) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.executeUpdate(" + string + ")");
        }
        this.execute(string);
        return this.getUpdateCount();
    }

    public synchronized boolean execute(String string) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.execute(" + string + ")");
        }
        this.validateStatement();
        this.referenceManager.reap();
        if (!this.isBatchEmpty) {
            throw new SQLException("Batch is not empty. Batch must be executed or cleared.", "S1000");
        }
        this.checkIfStmtIsNullRef(string);
        if (this.hasResultSet) {
            this.closeResultSet(false);
            this.hasResultSet = false;
        }
        this.lastWarning = null;
        try {
            this.OdbcApi.SQLExecDirect(this.hStmt.getValue(), string);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            if (this.getColumnCount() > 0) {
                this.setWarning(JdbcOdbc.convertWarning(jdbcOdbcSQLWarning));
            } else {
                if (jdbcOdbcSQLWarning.getSQLState().trim().equals("01004")) {
                    throw new DataTruncation(-1, false, false, 0, 0);
                }
                this.setWarning(jdbcOdbcSQLWarning);
            }
        }
        catch (SQLException sQLException) {
            DataTruncation dataTruncation;
            if (sQLException.getSQLState().trim().equals("37000") && sQLException.getErrorCode() == 2438) {
                dataTruncation = new DataTruncation(-1, false, false, 0, 0);
            }
            throw dataTruncation;
        }
        this.needBufferCheck = true;
        this.initCols();
        this.executed = true;
        this.moreResults = true;
        return this.hasResultSet;
    }

    synchronized void closePooledStatement() throws SQLException {
        this.close();
    }

    public synchronized void close() throws SQLException {
        this.close(true);
    }

    public synchronized void close(boolean bl) throws SQLException {
        Object object;
        BasicPhantomReference basicPhantomReference;
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.close()");
        }
        if (this.isClosed()) {
            return;
        }
        this.lastWarning = null;
        if (this.cBoundColsP.getValue() != 0) {
            this.OdbcApi.freeBoundColBuffers(this.cBoundColsP.getValue(), this.oldColCount);
            this.cBoundColsP.setValue(0);
        }
        if ((basicPhantomReference = (BasicPhantomReference)this.mutableReferenceContainer.get(myResultSetKey)) != null) {
            object = (JdbcOdbcResultSet)basicPhantomReference.get();
            if (object != null) {
                if (bl) {
                    ((JdbcOdbcResultSet)object).close(false);
                }
            } else if (Logger.isTracingOn()) {
                Logger.logln("*Statement.close(), result set is already out of scope.");
            }
            this.mutableReferenceContainer.remove(myResultSetKey);
        }
        this.executed = false;
        this.mutableReferenceContainer.put(closedFlagKey, true);
        if (this.myConnection == null) {
            this.hStmt.setValue(0);
            return;
        }
        if (this.hStmt.getValue() != 0) {
            if (this.realConnection != null) {
                this.realConnection.dropOdbcStatement(this.hStmt.getValue());
            }
            this.hStmt.setValue(0);
        }
        object = (BasicPhantomReference)this.mutableReferenceContainer.get(registeredReferenceKey);
        this.realConnection.deregisterStatement((BasicPhantomReference)object);
        this.myConnection = null;
        this.realConnection = null;
        this.mutableReferenceContainer.remove(registeredReferenceKey);
    }

    public int getMaxFieldSize() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.getMaxFieldSize()");
        }
        return 0;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.setMaxFieldSize(" + n + ")");
        }
        if (n != 0) {
            this.setStmtOption((short)3, n);
        }
    }

    public int getMaxRows() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.getMaxRows()");
        }
        int n = this.getStmtOption((short)1);
        return n;
    }

    public void setMaxRows(int n) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.setMaxRows(" + n + ")");
        }
        this.setStmtOption((short)1, n);
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.setEscapeProcessing(" + bl + ")");
        }
        int n = 0;
        if (!bl) {
            n = 1;
        }
        this.setStmtOption((short)2, n);
    }

    public int getQueryTimeout() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.getQueryTimeout()");
        }
        int n = this.getStmtOption((short)0);
        return n;
    }

    public void setQueryTimeout(int n) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.setQueryTimeout(" + n + ")");
        }
        this.setStmtOption((short)0, n);
    }

    public synchronized void cancel() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.cancel()");
        }
        this.validateStatement();
        this.lastWarning = null;
        try {
            this.OdbcApi.SQLCancel(this.hStmt.getValue());
        }
        catch (SQLWarning sQLWarning) {
            this.setWarning(sQLWarning);
        }
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        this.validateStatement();
        return this.lastWarning;
    }

    public synchronized void clearWarnings() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.clearWarnings()");
        }
        this.lastWarning = null;
    }

    public synchronized void setCursorName(String string) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.setCursorName " + string + ")");
        }
        this.validateStatement();
        this.OdbcApi.SQLSetCursorName(this.hStmt.getValue(), string);
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.getResultSet()");
        }
        if (!this.executed) {
            throw new SQLException("Statement not executed", "S1010");
        }
        this.validateStatement();
        BasicPhantomReference basicPhantomReference = (BasicPhantomReference)this.mutableReferenceContainer.get(myResultSetKey);
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        if (basicPhantomReference != null) {
            jdbcOdbcResultSet = (JdbcOdbcResultSet)basicPhantomReference.get();
        }
        if (jdbcOdbcResultSet == null) {
            if (this.hasResultSet) {
                jdbcOdbcResultSet = new JdbcOdbcResultSet(this.OdbcApi, this.hStmt.getValue(), true, this);
                basicPhantomReference = this.referenceManager.addReference(jdbcOdbcResultSet);
                this.mutableReferenceContainer.put(myResultSetKey, basicPhantomReference);
            } else {
                this.setWarning(new SQLWarning("Statement does not have a ResultSet"));
            }
        }
        return jdbcOdbcResultSet;
    }

    public synchronized int getUpdateCount() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.getUpdateCount()");
        }
        this.validateStatement();
        if (!this.moreResults) {
            return -1;
        }
        int n = -1;
        if (!this.hasResultSet) {
            n = this.getRowCount();
        } else {
            this.setWarning(new SQLWarning("Statement has a ResultSet"));
        }
        return n;
    }

    public synchronized boolean getMoreResults() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.getMoreResults()");
        }
        this.validateStatement();
        if (this.hasResultSet) {
            this.closeResultSet(false);
            this.hasResultSet = false;
        }
        this.moreResults = false;
        return false;
    }

    public Connection getConnection() throws SQLException {
        return this.myConnection;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.setFetchDirection(" + n + ")");
        }
        this.validateStatement();
        if (n != 1000 && n != 1001 && n != 1002) {
            throw new SQLException("Invalid fetch direction.", "S1000");
        }
    }

    public int getFetchDirection() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.getFetchDirection()");
        }
        this.validateStatement();
        return 1000;
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.setFetchSize(" + n + ")");
        }
        this.validateStatement();
        if (n != 0) {
            this.setStmtOption((short)3001, n);
        }
    }

    public int getFetchSize() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.getFetchSize()");
        }
        this.validateStatement();
        int n = this.getStmtOption((short)3001);
        return n;
    }

    public int getResultSetConcurrency() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.getResultSetConcurrency()");
        }
        return 1007;
    }

    public int getResultSetType() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.getResultSetType()");
        }
        return 1003;
    }

    public synchronized void addBatch(String string) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.addBatch(" + string + ")");
        }
        if (string == null) {
            throw new SQLException("Batch command cannot be null.");
        }
        this.batchUpdateSQL.addElement(string);
        this.isBatchEmpty = false;
    }

    public synchronized void clearBatch() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.clearBatch()");
        }
        this.batchUpdateSQL.removeAllElements();
        this.isBatchEmpty = true;
    }

    public synchronized int[] executeBatch() throws SQLException, BatchUpdateException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.executeBatch()");
        }
        this.validateStatement();
        this.referenceManager.reap();
        this.clearWarnings();
        if (this.hasResultSet) {
            this.closeResultSet(false);
            this.hasResultSet = false;
        }
        int n = this.batchUpdateSQL.size();
        int[] nArray = new int[n];
        short s = this.OdbcApi.execStatementBatch(this.hStmt.getValue(), this, this.batchUpdateSQL.toArray(new String[n]), nArray);
        this.clearBatch();
        this.processBatchError(s, this.hStmt.getValue(), nArray);
        return nArray;
    }

    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    public boolean getMoreResults(int n) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.getMoreResults(" + n + ")");
        }
        this.validateStatement();
        switch (n) {
            case 1: 
            case 3: {
                if (!this.hasResultSet) break;
                this.closeResultSet(false);
                this.hasResultSet = false;
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new SQLException("Invalid argument value", "S1009");
            }
        }
        this.moreResults = false;
        return false;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public int executeUpdate(String string, int n) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.executeUpdate(" + string + ", " + n + ")");
        }
        int n2 = 0;
        switch (n) {
            case 2: {
                n2 = this.executeUpdate(string);
                break;
            }
            case 1: {
                throw new SQLException("Driver not capable", "S1C00");
            }
            default: {
                throw new SQLException("Invalid argument value", "S1009");
            }
        }
        return n2;
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public boolean execute(String string, int n) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*Statement.execute(" + string + ", " + n + ")");
        }
        boolean bl = false;
        switch (n) {
            case 2: {
                bl = this.execute(string);
                break;
            }
            case 1: {
                throw new SQLException("Driver not capable", "S1C00");
            }
            default: {
                throw new SQLException("Invalid argument value", "S1009");
            }
        }
        return bl;
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw new SQLException("Driver not capable", "S1C00");
    }

    int getRawTZOffset() {
        return this.tzOffset;
    }

    synchronized int getDSTOffsetForDate(long l) {
        if (this.tz.useDaylightTime()) {
            if (this.cal == null) {
                this.cal = Calendar.getInstance(this.tz);
            }
            this.cal.setTimeInMillis(l);
            return this.cal.get(16);
        }
        return 0;
    }

    int getDisplayLength(int n) {
        return this.boundCols[n].getDisplayLength();
    }

    int getColType(int n) {
        return this.colTypes[n];
    }

    int getColLength(int n) {
        return this.colLengths[n];
    }

    int getColCType(int n) {
        return this.colCTypes[n - 1];
    }

    void setColCType(int n, int n2) {
        this.colCTypes[n - 1] = n2;
    }

    int getColumnCount() throws SQLException {
        if (this.needBufferCheck) {
            try {
                this.colCount = this.OdbcApi.SQLNumResultCols(this.hStmt.getValue());
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                BigDecimal bigDecimal = (BigDecimal)jdbcOdbcSQLWarning.value;
                this.colCount = bigDecimal.intValue();
            }
        }
        return this.colCount;
    }

    int getRowCount() throws SQLException {
        int n = 0;
        try {
            n = this.OdbcApi.SQLRowCount(this.hStmt.getValue());
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)jdbcOdbcSQLWarning.value;
            n = bigDecimal.intValue();
        }
        return n;
    }

    int getCBoundColsP() {
        return this.cBoundColsP.getValue();
    }

    JdbcOdbcBoundCol[] getBoundCols() {
        return this.boundCols;
    }

    JdbcOdbcBoundCol getBoundCol(int n) {
        return this.boundCols[n];
    }

    void setResultSet(JdbcOdbcResultSet jdbcOdbcResultSet) throws SQLException {
        BasicPhantomReference basicPhantomReference = this.referenceManager.addReference(jdbcOdbcResultSet);
        this.mutableReferenceContainer.put(myResultSetKey, basicPhantomReference);
    }

    void initCols() throws SQLException {
        int n;
        if (this.getColumnCount() <= 0) {
            this.hasResultSet = false;
            return;
        }
        this.hasResultSet = true;
        if (!this.needBufferCheck) {
            return;
        }
        byte[] byArray = new byte[2];
        boolean bl = true;
        if (this.colCount == this.oldColCount) {
            this.OdbcApi.getStmtTypeInfo(this.hStmt.getValue(), this.colTypes, this.colLengths, byArray, this.colCount);
            for (n = 0; n < this.colCount && this.colTypes[n] == this.oldColTypes[n] && this.colLengths[n] == this.oldColLengths[n] && this.colCTypes[n] == this.oldColCTypes[n]; ++n) {
            }
            if (n == this.colCount) {
                bl = false;
            }
        }
        if (bl) {
            if (this.cBoundColsP.getValue() != 0) {
                this.OdbcApi.freeBoundColBuffers(this.cBoundColsP.getValue(), this.oldColCount);
                this.OdbcApi.SQLFreeStmt(this.hStmt.getValue(), 2);
                this.cBoundColsP.setValue(0);
            }
            if (this.colCount != this.oldColCount) {
                this.colTypes = new int[this.colCount];
                this.colCTypes = new int[this.colCount];
                this.colLengths = new int[this.colCount];
                this.oldColTypes = new int[this.colCount];
                this.oldColLengths = new int[this.colCount];
                this.oldColCTypes = new int[this.colCount];
                this.boundCols = new JdbcOdbcBoundCol[this.colCount];
                this.oldColCount = this.colCount;
            }
            this.cBoundColsP.setValue(this.OdbcApi.SQLAllocAndBindCols(this.hStmt.getValue(), this.colTypes, this.colLengths, this.colCTypes, byArray));
            for (n = 0; n < this.colCount; ++n) {
                this.boundCols[n] = new JdbcOdbcBoundCol(this.colTypes[n], this.colLengths[n]);
                this.oldColTypes[n] = this.colTypes[n];
                this.oldColLengths[n] = this.colLengths[n];
                this.oldColCTypes[n] = this.colCTypes[n];
            }
        }
        this.needBufferCheck = false;
    }

    protected void setWarning(SQLWarning sQLWarning) throws SQLException {
        if (this.lastWarning == null) {
            this.lastWarning = sQLWarning;
        } else {
            this.lastWarning.setNextWarning(sQLWarning);
        }
    }

    private synchronized int getStmtOption(short s) throws SQLException {
        int n = 0;
        this.validateStatement();
        this.lastWarning = null;
        try {
            n = this.OdbcApi.SQLGetStmtOption(this.hStmt.getValue(), s);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)jdbcOdbcSQLWarning.value;
            n = bigDecimal.intValue();
            this.setWarning(jdbcOdbcSQLWarning);
        }
        return n;
    }

    private synchronized void setStmtOption(short s, int n) throws SQLException {
        this.validateStatement();
        this.lastWarning = null;
        try {
            this.OdbcApi.SQLSetStmtOption(this.hStmt.getValue(), s, n);
        }
        catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
            this.setWarning(jdbcOdbcSQLWarning);
        }
    }

    synchronized boolean isClosed() {
        Boolean bl = (Boolean)this.mutableReferenceContainer.get(closedFlagKey);
        return bl;
    }

    protected void validateStatement() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Statement is closed", "S1000");
        }
    }

    protected void checkIfStmtIsNullRef(String string) throws SQLException {
        if (string == null) {
            throw new SQLException("Invalid argument value", "S1009");
        }
    }

    int getODBCStatementHandle() {
        return this.hStmt.getValue();
    }

    protected void processBatchError(short s, int n, int[] nArray) throws BatchUpdateException {
        byte[] byArray = new byte[2];
        int n2 = 0;
        byArray[0] = (byte)(s & 0xFF);
        byArray[1] = (byte)(s >> 8);
        if ((byArray[0] == 0 || byArray[0] == 1) && byArray[1] == 0) {
            return;
        }
        n2 = this.getBatchStmtErrorIndex(nArray);
        String string = "Batch command " + n2 + " failed: ";
        int[] nArray2 = this.truncateBatchUpdateCount(nArray);
        if (byArray[1] == -99) {
            throw new BatchUpdateException(string + "Memory allocation failure.", "S1001", nArray2);
        }
        if (byArray[1] == -98) {
            throw new BatchUpdateException(string + "Conversion from unicode to ASCII failed.", "S1000", nArray2);
        }
        if (byArray[1] == -93) {
            throw new BatchUpdateException(string + "Invalid batch command.", "S1000", nArray2);
        }
        if (byArray[1] == -97) {
            throw new BatchUpdateException(string + "Internal error.", "S1000", nArray2);
        }
        try {
            this.OdbcApi.standardError(byArray[0], 0, 0, n);
        }
        catch (SQLException sQLException) {
            SQLException sQLException2;
            BatchUpdateException batchUpdateException;
            BatchUpdateException batchUpdateException2 = batchUpdateException = new BatchUpdateException(string + sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray2);
            while (sQLException2.getNextException() != null) {
                sQLException2 = sQLException2.getNextException();
                batchUpdateException2.setNextException(new BatchUpdateException(string + sQLException2.getMessage(), sQLException2.getSQLState(), sQLException2.getErrorCode(), nArray2));
                batchUpdateException2 = (BatchUpdateException)batchUpdateException2.getNextException();
            }
            throw batchUpdateException;
        }
    }

    protected int getBatchStmtErrorIndex(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != -3) continue;
            return i;
        }
        return 0;
    }

    protected int[] truncateBatchUpdateCount(int[] nArray) {
        int n = this.getBatchStmtErrorIndex(nArray);
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = nArray[i];
        }
        return nArray2;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void doPostFinalization() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbcStatement.doPostFinalization(" + this + ")");
        }
        this.close();
    }

    final BasicPhantomReference getRegisteredReference() {
        BasicPhantomReference basicPhantomReference = (BasicPhantomReference)this.mutableReferenceContainer.get(registeredReferenceKey);
        return basicPhantomReference;
    }

    final void setRegisteredReference(BasicPhantomReference basicPhantomReference) {
        this.mutableReferenceContainer.put(registeredReferenceKey, basicPhantomReference);
    }

    protected void closeResultSet(boolean bl) throws SQLException {
        BasicPhantomReference basicPhantomReference = (BasicPhantomReference)this.mutableReferenceContainer.get(myResultSetKey);
        JdbcOdbcResultSet jdbcOdbcResultSet = null;
        if (basicPhantomReference != null) {
            jdbcOdbcResultSet = (JdbcOdbcResultSet)basicPhantomReference.get();
            if (jdbcOdbcResultSet != null) {
                jdbcOdbcResultSet.close(bl);
            } else {
                if (Logger.isTracingOn()) {
                    Logger.logln("*Statement.close(), result set is already out of scope.");
                }
                this.referenceManager.handleReference(basicPhantomReference);
            }
            this.mutableReferenceContainer.remove(myResultSetKey);
        } else if (this.OdbcApi != null && this.hStmt.getValue() != 0) {
            this.OdbcApi.SQLFreeStmt(this.hStmt.getValue(), 0);
        }
    }
}

