/*
 * Decompiled with CFR 0.152.
 */
package com.timesten.jdbc;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.DriverManager;

public class Logger {
    private static final String traceEnvKey = "timesten.tracefile";
    private static boolean doTrace = false;
    private static PrintWriter logWriter = null;

    private Logger() {
    }

    public static PrintWriter getLogWriter() {
        return logWriter;
    }

    public static void setLogWriter(PrintWriter printWriter) {
        logWriter = printWriter;
        doTrace = printWriter != null;
    }

    public static boolean isTracingOn() {
        return doTrace;
    }

    public static void logln(String string) {
        if (doTrace && logWriter != null) {
            logWriter.println(Thread.currentThread().getName() + string);
        }
    }

    public static void log(String string) {
        if (doTrace && logWriter != null) {
            logWriter.print(string);
        }
    }

    public static void log(Exception exception) {
        if (doTrace && logWriter != null) {
            exception.printStackTrace(logWriter);
        }
    }

    static {
        try {
            String string = System.getProperty(traceEnvKey);
            if (string != null && string.length() != 0) {
                doTrace = true;
                logWriter = new PrintWriter(new FileOutputStream(string, true), true);
            } else {
                logWriter = DriverManager.getLogWriter();
                if (logWriter != null) {
                    doTrace = true;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

