/*
 * Decompiled with CFR 0.152.
 */
package com.timesten.jdbc;

import com.timesten.jdbc.JdbcOdbcConnection;
import com.timesten.jdbc.JdbcOdbcObject;
import com.timesten.jdbc.JdbcOdbcPreparedStatement;
import com.timesten.jdbc.Logger;
import com.timesten.jdbc.ProxyConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class ObservableConnection
extends JdbcOdbcObject
implements PooledConnection {
    protected JdbcOdbcConnection realConn;
    protected ProxyConnection currProxyConn;
    protected List observers;
    private final int maxStatements;
    private Map psCache;

    public ObservableConnection(JdbcOdbcConnection jdbcOdbcConnection) {
        this(jdbcOdbcConnection, 0);
    }

    public ObservableConnection(JdbcOdbcConnection jdbcOdbcConnection, int n) {
        this.realConn = jdbcOdbcConnection;
        this.currProxyConn = null;
        this.observers = new Vector();
        this.maxStatements = n;
        this.psCache = new HashMap(n);
        if (this.realConn != null) {
            this.realConn.setObserver(this);
        }
    }

    protected void finalize() {
        if (Logger.isTracingOn()) {
            Logger.logln("*ObservableConnection.finalize(): " + this);
        }
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*ObservableConnection.getConnection()");
        }
        return this.getConnectionInternal(true);
    }

    protected Connection getConnectionInternal(boolean bl) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*ObservableConnection.getConnectionInternal()");
        }
        if (this.currProxyConn != null) {
            this.currProxyConn.closeProxyConnNow();
            this.currProxyConn = null;
        }
        this.currProxyConn = new ProxyConnection(this.realConn, this);
        if (bl && !this.currProxyConn.getAutoCommit()) {
            this.currProxyConn.setAutoCommit(true);
        }
        return this.currProxyConn;
    }

    public synchronized void close() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*ObservableConnection.close()");
        }
        if (this.realConn != null) {
            if (this.currProxyConn != null) {
                this.currProxyConn.closeProxyConnNow();
                this.currProxyConn = null;
            }
            this.psCache.clear();
            this.realConn.close();
            this.realConn = null;
            this.observers = null;
        }
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (Logger.isTracingOn()) {
            Logger.logln("*ObservableConnection.addConnectionEventListener(" + connectionEventListener + ")");
        }
        if (connectionEventListener != null) {
            this.observers.add(connectionEventListener);
        }
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (Logger.isTracingOn()) {
            Logger.logln("*ObservableConnection.removeConnectionEventListener(" + connectionEventListener + ")");
        }
        if (connectionEventListener != null) {
            this.observers.remove(connectionEventListener);
        }
    }

    synchronized void notifyClose() {
        if (Logger.isTracingOn()) {
            Logger.logln("*ObservableConnection.notifyClose()");
        }
        ListIterator listIterator = this.observers.listIterator();
        while (listIterator.hasNext()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)listIterator.next();
            ConnectionEvent connectionEvent = new ConnectionEvent(this);
            connectionEventListener.connectionClosed(connectionEvent);
        }
    }

    synchronized void notifyError(SQLException sQLException) {
        if (Logger.isTracingOn()) {
            Logger.logln("*ObservableConnection.notifyError(" + sQLException + ")");
        }
        ListIterator listIterator = this.observers.listIterator();
        while (listIterator.hasNext()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)listIterator.next();
            ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
            connectionEventListener.connectionErrorOccurred(connectionEvent);
        }
    }

    synchronized JdbcOdbcPreparedStatement getFromCache(String string) {
        if (this.psCache == null) {
            return null;
        }
        JdbcOdbcPreparedStatement jdbcOdbcPreparedStatement = (JdbcOdbcPreparedStatement)this.psCache.get(string);
        if (jdbcOdbcPreparedStatement != null && jdbcOdbcPreparedStatement.testAndSetInUseFlag()) {
            jdbcOdbcPreparedStatement = null;
        }
        if (Logger.isTracingOn() && jdbcOdbcPreparedStatement != null) {
            Logger.logln("*ObservableConnection.getFromCache(), returning from cache " + string);
        }
        return jdbcOdbcPreparedStatement;
    }

    synchronized boolean addToCache(String string, JdbcOdbcPreparedStatement jdbcOdbcPreparedStatement) {
        if (this.psCache == null) {
            return false;
        }
        if (this.psCache.containsKey(string)) {
            if (Logger.isTracingOn()) {
                Logger.logln("*ObservableConnection.addToCache(), already in cache" + string);
            }
            return false;
        }
        if (this.psCache.size() == this.maxStatements) {
            if (Logger.isTracingOn()) {
                Logger.logln("*ObservableConnection.addToCache(), cache full " + this.psCache.size());
            }
            return false;
        }
        this.psCache.put(string, jdbcOdbcPreparedStatement);
        if (Logger.isTracingOn()) {
            Logger.logln("*ObservableConnection.addToCache() " + string);
        }
        return true;
    }
}

