/*
 * Decompiled with CFR 0.152.
 */
package com.timesten.jdbc;

import com.timesten.jdbc.OdbcConstants;
import java.sql.SQLException;

public class OdbcDef
implements OdbcConstants {
    public static final short SQL_TYPE_UNKNOWN = 9999;
    public static final byte TT_TYPE_CONVERSION_ERROR_AT_FETCH = -94;

    public static int odbcTypeToJdbc(int n) {
        switch (n) {
            case 9: {
                return 91;
            }
            case 10: {
                return 92;
            }
            case 11: {
                return 93;
            }
            case -8: {
                return 1;
            }
            case -9: {
                return 12;
            }
            case -10: {
                return -1;
            }
        }
        return n;
    }

    public static int jdbcTypeToOdbc(int n) {
        int n2 = n;
        switch (n) {
            case 91: {
                n2 = 9;
                break;
            }
            case 92: {
                n2 = 10;
                break;
            }
            case 93: {
                n2 = 11;
            }
        }
        return n2;
    }

    public static boolean isOdbcTypeSigned(int n) {
        switch (n) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    static String getParameterType(int n) throws SQLException {
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                return "String";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case -7: 
            case 16: {
                return "boolean";
            }
            case -6: {
                return "byte";
            }
            case 5: {
                return "short";
            }
            case 4: {
                return "int";
            }
            case -5: {
                return "long";
            }
            case 7: {
                return "float";
            }
            case 6: 
            case 8: {
                return "double";
            }
            case -4: 
            case -3: 
            case -2: {
                return "byte[]";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
        }
        throw new SQLException("Unsupported Java type " + n);
    }

    static String getParameterClassName(int n) throws SQLException {
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                return "String";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case -7: 
            case 16: {
                return "Boolean";
            }
            case -6: {
                return "Byte";
            }
            case 5: {
                return "Short";
            }
            case 4: {
                return "Integer";
            }
            case -5: {
                return "Long";
            }
            case 7: {
                return "Float";
            }
            case 6: 
            case 8: {
                return "Double";
            }
            case -4: 
            case -3: 
            case -2: {
                return "byte[]";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
        }
        throw new SQLException("Unsupported Java type " + n);
    }
}

