/*
 * Decompiled with CFR 0.152.
 */
package com.timesten.jdbc;

import com.timesten.jdbc.JdbcOdbc;
import com.timesten.jdbc.OdbcDef;
import java.sql.ParameterMetaData;
import java.sql.SQLException;

public class ParameterMetaDataImpl
implements ParameterMetaData {
    private final int myHstmt;
    private final JdbcOdbc myOdbcApi;
    ParameterInfo[] myParameterInfo;
    int myParameterCount;

    public ParameterMetaDataImpl(int n, JdbcOdbc jdbcOdbc) throws SQLException {
        this.myHstmt = n;
        this.myOdbcApi = jdbcOdbc;
        this.myParameterCount = this.myOdbcApi.SQLNumParams(this.myHstmt);
        System.out.println("***** The count is " + this.myParameterCount);
        this.myParameterInfo = new ParameterInfo[this.myParameterCount];
        for (int i = 0; i < this.myParameterCount; ++i) {
            int n2 = this.myOdbcApi.SQLDescribeParamType(this.myHstmt, i + 1);
            this.myParameterInfo[i] = new ParameterInfo();
            this.myParameterInfo[i].myType = OdbcDef.odbcTypeToJdbc(n2);
            this.myParameterInfo[i].myPrecision = this.myOdbcApi.SQLDescribeParamPrecision(this.myHstmt, i + 1);
            this.myParameterInfo[i].myScale = this.myOdbcApi.SQLDescribeParamScale(this.myHstmt, i + 1);
            this.myParameterInfo[i].myNullability = this.myOdbcApi.SQLDescribeParamNullable(this.myHstmt, i + 1);
            this.myParameterInfo[i].mySignedFlag = OdbcDef.isOdbcTypeSigned(n2);
            this.myParameterInfo[i].myTypeName = OdbcDef.getParameterType(this.myParameterInfo[i].myType);
            this.myParameterInfo[i].myClassName = OdbcDef.getParameterClassName(this.myParameterInfo[i].myType);
        }
    }

    public int getParameterCount() throws SQLException {
        return this.myParameterCount;
    }

    public int getParameterMode(int n) throws SQLException {
        return 1;
    }

    public int getParameterType(int n) throws SQLException {
        return this.myParameterInfo[n - 1].myType;
    }

    public int getPrecision(int n) throws SQLException {
        return this.myParameterInfo[n - 1].myPrecision;
    }

    public int getScale(int n) throws SQLException {
        return this.myParameterInfo[n - 1].myScale;
    }

    public int isNullable(int n) throws SQLException {
        return this.myParameterInfo[n - 1].myNullability;
    }

    public boolean isSigned(int n) throws SQLException {
        return this.myParameterInfo[n - 1].mySignedFlag;
    }

    public String getParameterClassName(int n) throws SQLException {
        return this.myParameterInfo[n - 1].myClassName;
    }

    public String getParameterTypeName(int n) throws SQLException {
        return this.myParameterInfo[n - 1].myTypeName;
    }

    private static class ParameterInfo {
        public int myType;
        public int myPrecision;
        public int myScale;
        public int myNullability;
        public boolean mySignedFlag;
        public String myClassName;
        public String myTypeName;

        private ParameterInfo() {
        }
    }
}

