/*
 * Decompiled with CFR 0.152.
 */
package com.timesten.jdbc;

import com.timesten.jdbc.JdbcOdbcCallableStatement;
import com.timesten.jdbc.JdbcOdbcConnection;
import com.timesten.jdbc.JdbcOdbcDatabaseMetaData;
import com.timesten.jdbc.JdbcOdbcObject;
import com.timesten.jdbc.JdbcOdbcPreparedStatement;
import com.timesten.jdbc.JdbcOdbcStatement;
import com.timesten.jdbc.Logger;
import com.timesten.jdbc.ObservableConnection;
import com.timesten.jdbc.TimesTenConnection;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

public class ProxyConnection
extends JdbcOdbcObject
implements TimesTenConnection {
    protected boolean isProxyConnOpen;
    protected JdbcOdbcConnection realConn;
    protected ObservableConnection oc;

    ProxyConnection(JdbcOdbcConnection jdbcOdbcConnection, ObservableConnection observableConnection) throws SQLException {
        this.realConn = jdbcOdbcConnection;
        this.isProxyConnOpen = this.realConn != null;
        this.oc = observableConnection;
    }

    public Statement createStatement() throws SQLException {
        JdbcOdbcStatement jdbcOdbcStatement = null;
        this.validateProxyConnection();
        jdbcOdbcStatement = (JdbcOdbcStatement)this.realConn.createStatement();
        jdbcOdbcStatement.changeOwnerConnection(this);
        return jdbcOdbcStatement;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        boolean bl;
        JdbcOdbcPreparedStatement jdbcOdbcPreparedStatement = null;
        this.validateProxyConnection();
        jdbcOdbcPreparedStatement = this.oc.getFromCache(string);
        if (jdbcOdbcPreparedStatement == null && (bl = this.oc.addToCache(string, jdbcOdbcPreparedStatement = (JdbcOdbcPreparedStatement)this.realConn.prepareStatement(string)))) {
            jdbcOdbcPreparedStatement.setPooledStatementFlag(true);
        }
        jdbcOdbcPreparedStatement.changeOwnerConnection(this);
        return jdbcOdbcPreparedStatement;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        JdbcOdbcCallableStatement jdbcOdbcCallableStatement = null;
        this.validateProxyConnection();
        jdbcOdbcCallableStatement = (JdbcOdbcCallableStatement)this.realConn.prepareCall(string);
        jdbcOdbcCallableStatement.changeOwnerConnection(this);
        return jdbcOdbcCallableStatement;
    }

    public String nativeSQL(String string) throws SQLException {
        String string2 = null;
        this.validateProxyConnection();
        string2 = this.realConn.nativeSQL(string);
        return string2;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.validateProxyConnection();
        this.realConn.setAutoCommit(bl);
    }

    public boolean getAutoCommit() throws SQLException {
        boolean bl = false;
        this.validateProxyConnection();
        bl = this.realConn.getAutoCommit();
        return bl;
    }

    public void commit() throws SQLException {
        this.validateProxyConnection();
        this.realConn.commit();
    }

    public void rollback() throws SQLException {
        this.validateProxyConnection();
        this.realConn.rollback();
    }

    public void close() throws SQLException {
        if (this.isProxyConnOpen) {
            this.validateProxyConnection();
            this.realConn.prepareForReuse();
            this.isProxyConnOpen = false;
            this.oc.notifyClose();
        }
    }

    public boolean isClosed() throws SQLException {
        boolean bl = false;
        bl = !this.isProxyConnOpen;
        return bl;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        JdbcOdbcDatabaseMetaData jdbcOdbcDatabaseMetaData = null;
        this.validateProxyConnection();
        jdbcOdbcDatabaseMetaData = (JdbcOdbcDatabaseMetaData)this.realConn.getMetaData();
        jdbcOdbcDatabaseMetaData.changeOwnerConnection(this);
        return jdbcOdbcDatabaseMetaData;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.validateProxyConnection();
        this.realConn.setReadOnly(bl);
    }

    public boolean isReadOnly() throws SQLException {
        boolean bl = false;
        this.validateProxyConnection();
        bl = this.realConn.isReadOnly();
        return bl;
    }

    public void setCatalog(String string) throws SQLException {
        this.validateProxyConnection();
        this.realConn.setCatalog(string);
    }

    public String getCatalog() throws SQLException {
        String string = null;
        this.validateProxyConnection();
        string = this.realConn.getCatalog();
        return string;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.validateProxyConnection();
        this.realConn.setTransactionIsolation(n);
    }

    public int getTransactionIsolation() throws SQLException {
        int n = 0;
        this.validateProxyConnection();
        n = this.realConn.getTransactionIsolation();
        return n;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.realConn.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.realConn.clearWarnings();
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        return this.realConn.createStatement(n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.realConn.prepareStatement(string, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.realConn.prepareCall(string, n, n2);
    }

    public Map getTypeMap() throws SQLException {
        Map map = null;
        this.validateProxyConnection();
        map = this.realConn.getTypeMap();
        return map;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.validateProxyConnection();
        this.realConn.setTypeMap(map);
    }

    public void setHoldability(int n) throws SQLException {
        this.validateProxyConnection();
        this.realConn.setHoldability(n);
    }

    public int getHoldability() throws SQLException {
        return this.realConn.getHoldability();
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.realConn.setSavepoint();
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        return this.realConn.setSavepoint(string);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.validateProxyConnection();
        this.realConn.rollback(savepoint);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.validateProxyConnection();
        this.realConn.releaseSavepoint(savepoint);
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        return this.realConn.createStatement(n, n2, n3);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return this.realConn.prepareStatement(string, n, n2, n3);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        return this.realConn.prepareCall(string, n, n2, n3);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        return this.realConn.prepareStatement(string, n);
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        return this.realConn.prepareStatement(string, nArray);
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        return this.realConn.prepareStatement(string, stringArray);
    }

    public int getHENV() {
        return this.realConn.getHENV();
    }

    public int getHDBC() {
        return this.realConn.getHDBC();
    }

    public String getURL() {
        return this.realConn.getURL();
    }

    public String getDSN() {
        return this.realConn.getDSN();
    }

    public int getODBCVer() {
        return this.realConn.getODBCVer();
    }

    public void validateConnection() throws SQLException {
        this.validateProxyConnection();
    }

    public void setTtPrefetchClose(boolean bl) throws SQLException {
        this.realConn.setTtPrefetchClose(bl);
    }

    public boolean getTtPrefetchClose() throws SQLException {
        return this.realConn.getTtPrefetchClose();
    }

    public void setTtPrefetchCount(int n) throws SQLException {
        this.realConn.setTtPrefetchCount(n);
    }

    public int getTtPrefetchCount() throws SQLException {
        return this.realConn.getTtPrefetchCount();
    }

    public void closeProxyConnNow() throws SQLException {
        this.isProxyConnOpen = false;
    }

    protected void validateProxyConnection() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*ProxyConnection.validateProxyConnection()");
        }
        if (!this.isProxyConnOpen) {
            throw new SQLException("Connection not open", "08003");
        }
    }

    public boolean isDataStoreValid() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*ProxyConnection.isDataStoreValid()");
        }
        return this.realConn.isDataStoreValid();
    }
}

