/*
 * Decompiled with CFR 0.152.
 */
package com.timesten.jdbc;

import com.timesten.jdbc.BasicPhantomReference;
import com.timesten.jdbc.Logger;
import com.timesten.jdbc.PostFinalization;
import java.lang.ref.ReferenceQueue;
import java.sql.SQLException;

public class ReferenceManager
implements Runnable {
    private static ReferenceManager theInstance;
    private final ReferenceQueue theQueue;
    private static final boolean theDedicatedThreadFlag;
    private Thread theManagerThread;
    private static long theCollectedCount;
    private static long theRegisteredCount;
    private final Object theCollectedCountMutex = new Object();
    private final Object theRegisteredCountMutex = new Object();

    private ReferenceManager() {
        this.theQueue = new ReferenceQueue();
        if (theDedicatedThreadFlag) {
            this.theManagerThread = new Thread(null, this, "TimesTenJdbcReferenceManager");
            this.theManagerThread.start();
        }
    }

    public Thread getManagerThread() {
        return this.theManagerThread;
    }

    public void run() {
        BasicPhantomReference basicPhantomReference = null;
        while (true) {
            try {
                while (true) {
                    basicPhantomReference = (BasicPhantomReference)this.theQueue.remove();
                    this.handleReference(basicPhantomReference);
                    ReferenceManager.incReferenceCollected();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static synchronized ReferenceManager getInstance() {
        if (!theDedicatedThreadFlag) {
            return new ReferenceManager();
        }
        if (theInstance == null) {
            theInstance = new ReferenceManager();
        }
        return theInstance;
    }

    public BasicPhantomReference addReference(PostFinalization postFinalization) throws SQLException {
        if (!theDedicatedThreadFlag) {
            this.reap();
        }
        BasicPhantomReference basicPhantomReference = new BasicPhantomReference(postFinalization, this.theQueue);
        ReferenceManager.incRegisteredCount();
        return basicPhantomReference;
    }

    public BasicPhantomReference addReference(String string, PostFinalization postFinalization) throws SQLException {
        if (!theDedicatedThreadFlag) {
            this.reap();
        }
        BasicPhantomReference basicPhantomReference = new BasicPhantomReference(string, postFinalization, this.theQueue);
        ReferenceManager.incRegisteredCount();
        return basicPhantomReference;
    }

    public boolean getDedicatedThreadFlag() {
        return theDedicatedThreadFlag;
    }

    public void reap() {
        BasicPhantomReference basicPhantomReference;
        if (theDedicatedThreadFlag) {
            return;
        }
        while ((basicPhantomReference = (BasicPhantomReference)this.theQueue.poll()) != null) {
            try {
                this.handleReference(basicPhantomReference);
                ReferenceManager.incReferenceCollected();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    void handleReference(BasicPhantomReference basicPhantomReference) throws SQLException {
        PostFinalization postFinalization = null;
        try {
            if (Logger.isTracingOn()) {
                Logger.logln("*ReferenceManager.handleReference(" + basicPhantomReference + ")");
            }
            postFinalization = basicPhantomReference.getTheClone();
            postFinalization.doPostFinalization();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException(exception.getMessage(), "S1000");
        }
        finally {
            basicPhantomReference.clear();
        }
    }

    private static void incReferenceCollected() {
        ++theCollectedCount;
    }

    public static long getReferenceCollected() {
        return theCollectedCount;
    }

    private static void incRegisteredCount() {
        ++theRegisteredCount;
    }

    public static long getRegisteredCount() {
        return theRegisteredCount;
    }

    public static String getCollectionStatistics() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("Registered ");
        stringBuffer.append(ReferenceManager.getRegisteredCount());
        stringBuffer.append(" ");
        stringBuffer.append("Uncollected ");
        stringBuffer.append(ReferenceManager.getRegisteredCount() - ReferenceManager.getReferenceCollected());
        stringBuffer.append(" ");
        stringBuffer.append("%collected ");
        stringBuffer.append(100.0 * (double)ReferenceManager.getReferenceCollected() / (double)ReferenceManager.getRegisteredCount());
        return stringBuffer.toString();
    }

    static {
        theDedicatedThreadFlag = Boolean.getBoolean("com.timesten.jdbc.dedicatedReferenceManagerFlag");
    }
}

