/*
 * Decompiled with CFR 0.152.
 */
package com.timesten.jdbc;

import com.timesten.jdbc.Logger;
import com.timesten.jdbc.TimesTenDriver;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;

public class TimesTenClientDriver
extends TimesTenDriver
implements Driver {
    public boolean acceptsURL(String string) throws SQLException {
        Logger.logln("*TimesTenClientDriver.acceptsURL(" + string + ")");
        if (string != null && TimesTenClientDriver.getProtocol(string).equalsIgnoreCase("jdbc") && TimesTenClientDriver.getSubProtocol(string).equalsIgnoreCase("timesten")) {
            if (TimesTenClientDriver.getSubProtocolType(string).equalsIgnoreCase("client")) {
                return true;
            }
            if (!TimesTenClientDriver.getSubProtocolType(string).equalsIgnoreCase("direct")) {
                throw new SQLException("Not a valid TimesTen Connection url(" + string + ")", "28000");
            }
        }
        return false;
    }

    static {
        Logger.logln("*TimesTenClientDriver.staticInitializer");
        TimesTenClientDriver timesTenClientDriver = new TimesTenClientDriver();
        try {
            DriverManager.registerDriver(timesTenClientDriver);
        }
        catch (SQLException sQLException) {
            Logger.logln("*TimesTenClientDriver.staticInitializer: unable to register with DriverManager");
            Logger.log(sQLException);
        }
    }
}

