/*
 * Decompiled with CFR 0.152.
 */
package com.timesten.jdbc;

import com.timesten.jdbc.JdbcOdbcConnection;
import com.timesten.jdbc.Logger;
import com.timesten.jdbc.TimesTenDriverBase;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

public class TimesTenDataSource
extends TimesTenDriverBase
implements DataSource,
Serializable {
    protected PrintWriter m_logWriter = null;
    protected int m_loginTimeout = 0;
    protected String m_description = "com.timesten.jdbc.TimesTenDataSource";
    protected String m_url = null;
    protected String m_user = null;
    protected String m_password = null;
    protected String m_oraclePassword = null;
    protected Properties m_properties = new Properties();

    public synchronized Connection getConnection() throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*TimesTenDataSource.getConnection(m_url=" + this.m_url + ")");
        }
        if (this.m_user != null) {
            this.m_properties.setProperty("user", this.m_user);
        } else {
            this.m_properties.setProperty("user", "");
        }
        if (this.m_password != null) {
            this.m_properties.setProperty("password", this.m_password);
        } else {
            this.m_properties.setProperty("password", "");
        }
        if (this.m_oraclePassword != null) {
            this.m_properties.setProperty("oraclePassword", this.m_oraclePassword);
        } else {
            this.m_properties.setProperty("oraclePassword", "");
        }
        if (this.m_url == null) {
            throw new SQLException("No data source specified", "IM007");
        }
        JdbcOdbcConnection jdbcOdbcConnection = new JdbcOdbcConnection();
        jdbcOdbcConnection.connect(this.m_url, this.m_properties, this.m_loginTimeout);
        if (Logger.isTracingOn()) {
            Logger.logln("*TimesTenDataSource.getConnection(m_url=" + this.m_url + "): Created hEnv=" + jdbcOdbcConnection.getHENV() + ", hDbc=" + jdbcOdbcConnection.getHDBC());
        }
        return jdbcOdbcConnection;
    }

    public synchronized Connection getConnection(String string, String string2) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*TimesTenDataSource.getConnection(" + string + ", " + string2 + ")");
        }
        this.setUser(string);
        this.setPassword(string2);
        return this.getConnection();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.m_logWriter;
    }

    public synchronized void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.m_logWriter = printWriter;
        Logger.setLogWriter(printWriter);
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.m_loginTimeout = n;
    }

    public int getLoginTimeout() throws SQLException {
        return this.m_loginTimeout;
    }

    public void setDescription(String string) {
        this.m_description = string;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setUser(String string) {
        this.m_user = string;
    }

    public String getUser() {
        return this.m_user;
    }

    public void setPassword(String string) {
        this.m_password = string;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setOraclePassword(String string) {
        this.m_oraclePassword = string;
    }

    public String getOraclePassword() {
        return this.m_oraclePassword;
    }

    public void setUrl(String string) {
        this.m_url = string;
    }

    public String getUrl() {
        return this.m_url;
    }
}

