/*
 * Decompiled with CFR 0.152.
 */
package com.timesten.jdbc;

import com.timesten.jdbc.JdbcOdbcConnection;
import com.timesten.jdbc.Logger;
import com.timesten.jdbc.TimesTenDriverBase;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public class TimesTenDriver
extends TimesTenDriverBase
implements Driver {
    protected void finalize() {
    }

    public boolean acceptsURL(String string) throws SQLException {
        Logger.logln("*TimesTenDriver.acceptsURL(" + string + ")");
        return this.knownURL(string);
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        return this.connect(string, properties, DriverManager.getLoginTimeout());
    }

    public int getMajorVersion() {
        return 6;
    }

    public int getMinorVersion() {
        return 0;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        Logger.logln("*TimesTenDriver.getPropertyInfo (" + string + ")");
        if (!this.acceptsURL(string)) {
            return null;
        }
        return new DriverPropertyInfo[0];
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public Connection connect(String string, Properties properties, int n) throws SQLException {
        Logger.logln("*TimesTenDriver.connect(" + string + ")");
        if (!this.acceptsURL(string)) {
            return null;
        }
        JdbcOdbcConnection jdbcOdbcConnection = new JdbcOdbcConnection();
        jdbcOdbcConnection.connect(string, properties, n);
        return jdbcOdbcConnection;
    }

    static {
        Logger.logln("*TimesTenDriver.staticInitializer");
        TimesTenDriver timesTenDriver = new TimesTenDriver();
        try {
            DriverManager.registerDriver(timesTenDriver);
        }
        catch (SQLException sQLException) {
            Logger.logln("*TimesTenDriver.staticInitializer: unable to register with DriverManager");
            Logger.log(sQLException);
        }
    }
}

