/*
 * Decompiled with CFR 0.152.
 */
package com.timesten.jdbc.xa;

import com.timesten.jdbc.JdbcOdbcConnection;
import com.timesten.jdbc.Logger;
import com.timesten.jdbc.xa.Utils;
import com.timesten.jdbc.xa.XAJdbcOdbc;
import com.timesten.jdbc.xa.XAJdbcOdbcClient;
import com.timesten.jdbc.xa.XAJdbcOdbcDirect;
import java.sql.SQLException;
import java.util.Properties;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class TimesTenXAResource
implements XAResource {
    private JdbcOdbcConnection conn;
    private int hDBC;
    private XAJdbcOdbc xaApi;
    private boolean active;
    private boolean savedAutocommitState;
    private int transactionTimeout = 0;
    private static final String ILLEGAL_CONTEXT = "INFO - Current transaction is in an inproper state before transaction commit";

    public TimesTenXAResource(JdbcOdbcConnection jdbcOdbcConnection, boolean bl) {
        Logger.logln("New TimesTenXAResource(Connection) instance...");
        this.conn = jdbcOdbcConnection;
        this.hDBC = jdbcOdbcConnection.getHDBC();
        this.active = false;
        this.savedAutocommitState = false;
        Properties properties = jdbcOdbcConnection.getProperties();
        String string = properties.getProperty("charSet", System.getProperty("file.encoding", ""));
        this.xaApi = bl ? new XAJdbcOdbcClient(string) : new XAJdbcOdbcDirect(string);
    }

    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        Logger.logln("*TimesTenXAResource.setTransactionTimeout(" + n + ") -- TimesTenXAResource does not support setTransactionTimeout");
        return false;
    }

    public synchronized boolean isSameRM(XAResource xAResource) throws XAException {
        TimesTenXAResource timesTenXAResource;
        Logger.logln("*TimesTenXAResource.isSameRM(" + xAResource + ")");
        return xAResource instanceof TimesTenXAResource && (timesTenXAResource = (TimesTenXAResource)xAResource).getRealConn().getDSN().equalsIgnoreCase(this.getRealConn().getDSN());
    }

    public synchronized void start(Xid xid, int n) throws XAException {
        this.traceXA("xastart", xid, n, this.hDBC, Thread.currentThread().getName());
        if (xid == null) {
            throw new XAException(-4);
        }
        try {
            this.savedAutocommitState = this.conn.getAutoCommit();
            if (this.savedAutocommitState) {
                this.conn.setAutoCommit(false);
            }
            this.xaApi.SQLXAStart(this.hDBC, xid, n);
            this.active = true;
        }
        catch (SQLException sQLException) {
            Logger.log(sQLException);
            XAException xAException = new XAException(sQLException.getMessage());
            xAException.errorCode = -3;
            throw xAException;
        }
        catch (XAException xAException) {
            Logger.logln(XAJdbcOdbc.getXAErrMsg(xAException.errorCode));
            Logger.log(xAException);
            throw xAException;
        }
    }

    public synchronized void end(Xid xid, int n) throws XAException {
        this.traceXA("xaend", xid, n, this.hDBC, Thread.currentThread().getName());
        if (xid == null) {
            throw new XAException(-4);
        }
        try {
            this.xaApi.SQLXAEnd(this.hDBC, xid, n);
            this.active = false;
            if (this.conn.getAutoCommit() != this.savedAutocommitState) {
                this.conn.setAutoCommit(this.savedAutocommitState);
            }
        }
        catch (SQLException sQLException) {
            Logger.log(sQLException);
            XAException xAException = new XAException(sQLException.getMessage());
            xAException.errorCode = -3;
            throw xAException;
        }
        catch (XAException xAException) {
            Logger.logln(XAJdbcOdbc.getXAErrMsg(xAException.errorCode));
            Logger.log(xAException);
            throw xAException;
        }
    }

    public synchronized int prepare(Xid xid) throws XAException {
        this.traceXA("xaprepare", xid, 0, this.hDBC, Thread.currentThread().getName());
        if (xid == null) {
            throw new XAException(-4);
        }
        if (this.active) {
            Logger.logln(ILLEGAL_CONTEXT);
        }
        try {
            int n = this.xaApi.SQLXAPrepare(this.hDBC, xid);
            return n;
        }
        catch (XAException xAException) {
            Logger.logln(XAJdbcOdbc.getXAErrMsg(xAException.errorCode));
            Logger.log(xAException);
            throw xAException;
        }
    }

    public synchronized void commit(Xid xid, boolean bl) throws XAException {
        this.traceXA("xacommit", xid, bl ? 1 : 0, this.hDBC, Thread.currentThread().getName());
        if (xid == null) {
            throw new XAException(-4);
        }
        if (this.active && bl) {
            Logger.logln(ILLEGAL_CONTEXT);
        }
        try {
            int n = 0;
            if (bl) {
                n = 0x40000000;
            }
            this.xaApi.SQLXACommit(this.hDBC, xid, n);
        }
        catch (XAException xAException) {
            Logger.logln(XAJdbcOdbc.getXAErrMsg(xAException.errorCode));
            Logger.log(xAException);
            throw xAException;
        }
        if (this.active) {
            this.active = false;
        }
    }

    public synchronized void rollback(Xid xid) throws XAException {
        this.traceXA("xarollback", xid, 0, this.hDBC, Thread.currentThread().getName());
        if (xid == null) {
            throw new XAException(-4);
        }
        if (this.active) {
            Logger.logln(ILLEGAL_CONTEXT);
        }
        try {
            this.xaApi.SQLXARollback(this.hDBC, xid);
        }
        catch (XAException xAException) {
            Logger.logln(XAJdbcOdbc.getXAErrMsg(xAException.errorCode));
            Logger.log(xAException);
            throw xAException;
        }
        if (this.active) {
            this.active = false;
        }
    }

    public synchronized void forget(Xid xid) throws XAException {
        this.traceXA("xaforget", xid, 0, this.hDBC, Thread.currentThread().getName());
        if (xid == null) {
            throw new XAException(-4);
        }
        try {
            this.xaApi.SQLXAForget(this.hDBC, xid);
        }
        catch (XAException xAException) {
            Logger.logln(XAJdbcOdbc.getXAErrMsg(xAException.errorCode));
            Logger.log(xAException);
            throw xAException;
        }
    }

    public synchronized Xid[] recover(int n) throws XAException {
        this.traceXA("xarecover", null, n, this.hDBC, Thread.currentThread().getName());
        try {
            return this.xaApi.SQLXARecover(this.hDBC, n);
        }
        catch (XAException xAException) {
            Logger.logln(XAJdbcOdbc.getXAErrMsg(xAException.errorCode));
            Logger.log(xAException);
            throw xAException;
        }
    }

    synchronized boolean isXATransactionActive() {
        return this.active;
    }

    JdbcOdbcConnection getRealConn() {
        return this.conn;
    }

    private void traceXA(String string, Xid xid, int n, int n2, String string2) {
        if (Logger.isTracingOn()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append(": ");
            if (xid != null) {
                stringBuffer.append("xid = 0x");
                stringBuffer.append(Integer.toHexString(xid.getFormatId()));
                stringBuffer.append("-");
                stringBuffer.append(Utils.byteArrayToHexString(xid.getGlobalTransactionId()));
                stringBuffer.append("-");
                stringBuffer.append(Utils.byteArrayToHexString(xid.getBranchQualifier()));
            }
            stringBuffer.append(", hdbc=");
            stringBuffer.append(n2);
            stringBuffer.append(", flag=0x");
            stringBuffer.append(Integer.toHexString(n));
            stringBuffer.append(", <");
            stringBuffer.append(string2);
            stringBuffer.append(">\n");
            Logger.logln(stringBuffer.toString());
        }
    }
}

