/*
 * Decompiled with CFR 0.152.
 */
package com.timesten.jdbc.xa;

import com.timesten.jdbc.xa.Utils;
import javax.transaction.xa.Xid;

public class TimesTenXid
implements Xid {
    private int formatID;
    private int gtrid_length;
    private int bqual_length;
    byte[] data;

    public TimesTenXid(int n, int n2, int n3, byte[] byArray) {
        this.formatID = n;
        this.gtrid_length = n2;
        this.bqual_length = n3;
        this.data = byArray;
    }

    public TimesTenXid(int n, byte[] byArray, byte[] byArray2) {
        this.formatID = n;
        this.gtrid_length = byArray.length;
        this.bqual_length = byArray2.length;
        this.data = new byte[this.gtrid_length + this.bqual_length];
        System.arraycopy(byArray, 0, this.data, 0, this.gtrid_length);
        System.arraycopy(byArray2, 0, this.data, this.gtrid_length, this.bqual_length);
    }

    public int getFormatId() {
        return this.formatID;
    }

    public byte[] getBranchQualifier() {
        byte[] byArray = new byte[this.bqual_length];
        System.arraycopy(this.data, this.gtrid_length, byArray, 0, this.bqual_length);
        return byArray;
    }

    public byte[] getGlobalTransactionId() {
        byte[] byArray = new byte[this.gtrid_length];
        System.arraycopy(this.data, 0, byArray, 0, this.gtrid_length);
        return byArray;
    }

    public boolean equals(Xid xid) {
        if (this.getFormatId() != xid.getFormatId()) {
            return false;
        }
        if (!Utils.compareByteArray(this.getGlobalTransactionId(), xid.getGlobalTransactionId())) {
            return false;
        }
        return Utils.compareByteArray(this.getBranchQualifier(), xid.getBranchQualifier());
    }

    public boolean equals(Object object) {
        if (object instanceof Xid) {
            return this.equals((Xid)object);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("0x");
        stringBuffer.append(Integer.toHexString(this.formatID));
        stringBuffer.append('-');
        stringBuffer.append(Utils.byteArrayToHexString(this.data));
        stringBuffer.append("; gtrid_length=" + this.gtrid_length);
        stringBuffer.append("; bqual_length=" + this.bqual_length);
        return stringBuffer.toString();
    }

    int getGtridLength() {
        return this.gtrid_length;
    }

    int getBqualLength() {
        return this.bqual_length;
    }

    byte[] getXidData() {
        return this.data;
    }
}

