/*
 * Decompiled with CFR 0.152.
 */
package com.timesten.jdbc.xa;

import com.timesten.jdbc.JdbcOdbc;
import com.timesten.jdbc.Logger;
import com.timesten.jdbc.xa.TimesTenXAError;
import com.timesten.jdbc.xa.TimesTenXid;
import java.sql.SQLException;
import java.sql.SQLWarning;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

abstract class XAJdbcOdbc
extends JdbcOdbc {
    XAJdbcOdbc() {
    }

    public void SQLXAStart(int n, Xid xid, int n2) throws XAException {
        TimesTenXid timesTenXid = this.toTimesTenXid(xid);
        TimesTenXAError timesTenXAError = new TimesTenXAError();
        this.xaStart(n, timesTenXid.getFormatId(), timesTenXid.getGtridLength(), timesTenXid.getBqualLength(), timesTenXid.getXidData(), n2, timesTenXAError);
        if (timesTenXAError.getXAErrCode() != 0 || timesTenXAError.getRetCode() != 0) {
            this.XAStandardError(timesTenXAError, n);
        }
    }

    public void SQLXAEnd(int n, Xid xid, int n2) throws XAException {
        TimesTenXid timesTenXid = this.toTimesTenXid(xid);
        TimesTenXAError timesTenXAError = new TimesTenXAError();
        this.xaEnd(n, timesTenXid.getFormatId(), timesTenXid.getGtridLength(), timesTenXid.getBqualLength(), timesTenXid.getXidData(), n2, timesTenXAError);
        if (timesTenXAError.getXAErrCode() != 0 || timesTenXAError.getRetCode() != 0) {
            this.XAStandardError(timesTenXAError, n);
        }
    }

    public int SQLXAPrepare(int n, Xid xid) throws XAException {
        TimesTenXid timesTenXid = this.toTimesTenXid(xid);
        TimesTenXAError timesTenXAError = new TimesTenXAError();
        int n2 = this.xaPrepare(n, timesTenXid.getFormatId(), timesTenXid.getGtridLength(), timesTenXid.getBqualLength(), timesTenXid.getXidData(), 0, timesTenXAError);
        if (timesTenXAError.getXAErrCode() != 0 && timesTenXAError.getXAErrCode() != 3 || timesTenXAError.getRetCode() != 0) {
            this.XAStandardError(timesTenXAError, n);
        }
        return n2;
    }

    public void SQLXACommit(int n, Xid xid, int n2) throws XAException {
        TimesTenXid timesTenXid = this.toTimesTenXid(xid);
        TimesTenXAError timesTenXAError = new TimesTenXAError();
        int n3 = 0;
        this.xaCommit(n, timesTenXid.getFormatId(), timesTenXid.getGtridLength(), timesTenXid.getBqualLength(), timesTenXid.getXidData(), n2, n3, timesTenXAError);
        if (timesTenXAError.getXAErrCode() != 0 || timesTenXAError.getRetCode() != 0) {
            this.XAStandardError(timesTenXAError, n);
        }
    }

    public void SQLXARollback(int n, Xid xid) throws XAException {
        TimesTenXid timesTenXid = this.toTimesTenXid(xid);
        TimesTenXAError timesTenXAError = new TimesTenXAError();
        int n2 = 0;
        this.xaRollback(n, timesTenXid.getFormatId(), timesTenXid.getGtridLength(), timesTenXid.getBqualLength(), timesTenXid.getXidData(), 0, n2, timesTenXAError);
        if (timesTenXAError.getXAErrCode() != 0 || timesTenXAError.getRetCode() != 0) {
            this.XAStandardError(timesTenXAError, n);
        }
    }

    public void SQLXAForget(int n, Xid xid) throws XAException {
        TimesTenXAError timesTenXAError = new TimesTenXAError();
        TimesTenXid timesTenXid = this.toTimesTenXid(xid);
        this.xaForget(n, timesTenXid.getFormatId(), timesTenXid.getGtridLength(), timesTenXid.getBqualLength(), timesTenXid.getXidData(), 0, timesTenXAError);
        if (timesTenXAError.getXAErrCode() != 0 || timesTenXAError.getRetCode() != 0) {
            this.XAStandardError(timesTenXAError, n);
        }
    }

    public TimesTenXid[] SQLXARecover(int n, int n2) throws XAException {
        TimesTenXAError timesTenXAError = new TimesTenXAError();
        int n3 = 0;
        int n4 = 0;
        if (n2 == 0x1000000 || n2 == 0x1800000) {
            n4 = this.getPendingXidNum(n, timesTenXAError);
            Logger.logln("Total number of Pending Xids = " + n4);
        }
        TimesTenXid[] timesTenXidArray = new TimesTenXid[n4];
        if (n4 >= 0) {
            Logger.logln("Start recovering " + n4 + " Xids...");
            this.xaRecover(n, timesTenXidArray, n4, n2, timesTenXAError);
            if (timesTenXAError.getXAErrCode() < 0 || timesTenXAError.getRetCode() != 0) {
                if (timesTenXAError.getRetCode() == -99) {
                    XAException xAException = new XAException("Memory Allocation Failure");
                    xAException.errorCode = -3;
                    Logger.log(xAException);
                    throw xAException;
                }
                this.XAStandardError(timesTenXAError, n);
            } else if (timesTenXAError.getXAErrCode() >= 0) {
                n3 = timesTenXAError.getXAErrCode();
                if (n3 < n4) {
                    TimesTenXid[] timesTenXidArray2 = new TimesTenXid[n3];
                    for (int i = 0; i < n3; ++i) {
                        timesTenXidArray2[i] = new TimesTenXid(timesTenXidArray[i].getFormatId(), timesTenXidArray[i].getGlobalTransactionId(), timesTenXidArray[i].getBranchQualifier());
                    }
                    return timesTenXidArray2;
                }
                if (n3 > n4) {
                    // empty if block
                }
            }
        }
        return timesTenXidArray;
    }

    private TimesTenXid toTimesTenXid(Xid xid) {
        return new TimesTenXid(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
    }

    protected void XAStandardError(TimesTenXAError timesTenXAError, int n) throws XAException {
        short s = timesTenXAError.getRetCode();
        int n2 = timesTenXAError.getXAErrCode();
        Logger.logln("XAError happended on hdbc=" + n + "; XAErrorCode=" + n2 + "; SQLErrCode=" + s);
        if (n2 != 0 && n2 != 3) {
            if (s != 0) {
                try {
                    this.standardError(s, 0, n, 0);
                }
                catch (SQLException sQLException) {
                    Logger.log(sQLException);
                }
            }
            XAException xAException = new XAException(XAJdbcOdbc.getXAErrMsg(n2));
            xAException.errorCode = n2;
            throw xAException;
        }
        try {
            this.standardError(s, 0, n, 0);
        }
        catch (SQLWarning sQLWarning) {
            Logger.log(sQLWarning);
        }
        catch (SQLException sQLException) {
            Logger.log(sQLException);
            throw new XAException(sQLException.getMessage());
        }
    }

    static String getXAErrMsg(int n) {
        String string = "";
        switch (n) {
            case 100: {
                string = "errorCode=XA_RBROLLBACK, rollback was caused by unspecified reason.";
                break;
            }
            case 101: {
                string = "errorCode=XA_RBCOMMFAIL, rollback was caused by communication failure.";
                break;
            }
            case 102: {
                string = "errorCode=XA_RBDEADLOCK, a deadlock was detected.";
                break;
            }
            case 103: {
                string = "errorCode=XA_RBINTEGRITY, a condition that violates the integrity of the resource was detected.";
                break;
            }
            case 104: {
                string = "errorCode=XA_RBOTHER, the resource manager rolled back the transaction branch for a reason not on this list.";
                break;
            }
            case 105: {
                string = "errorCode=XA_RBPROTO, a protocol error occured in the resource manager.";
                break;
            }
            case 106: {
                string = "errorCode=XA_RBTIMEOUT, a transaction branch took too long";
                break;
            }
            case 107: {
                string = "errorCode=XA_RBTRANSIENT, may retry the transaction branch";
                break;
            }
            case 9: {
                string = "errorCode=XA_NOMIGRATE, resumption must occur where suspension occured.";
                break;
            }
            case 8: {
                string = "errorCode=XA_HEURHAZ, the transaction branch may have been heuristically completed.";
                break;
            }
            case 7: {
                string = "errorCode=XA_HEURCOM, the transaction branch has been heuristically committed.";
                break;
            }
            case 6: {
                string = "errorCode=XA_HEURRB, the transaction branch has been heuristically rolled back.";
                break;
            }
            case 5: {
                string = "errorCode=XA_HEURMIX, the transaction branch has been heuristically committed and rolled back.";
                break;
            }
            case 4: {
                string = "errorCode=XA_RETRY, routine returned with no effect and may be reissued.";
                break;
            }
            case 3: {
                string = "errorCode=XA_RDONLY, the transaction branch has been read-only and has been committed.";
                break;
            }
            case -2: {
                string = "errorCode=XAER_ASYNC, there is an asynchronous operation already outstanding.";
                break;
            }
            case -3: {
                string = "errorCode=XAER_RMERR, a resource manager error has occured in the transaction branch.";
                break;
            }
            case -4: {
                string = "errorCode=XAER_NOTA, the XID is not valid.";
                break;
            }
            case -5: {
                string = "errorCode=XAER_INVAL, invalid arguments were given.";
                break;
            }
            case -6: {
                string = "errorCode=XAER_PROTO, routine was invoked in an inproper context.";
                break;
            }
            case -7: {
                string = "errorCode=XAER_RMFAIL, resource manager is unavailable.";
                break;
            }
            case -8: {
                string = "errorCode=XAER_DUPID, the XID already exists.";
                break;
            }
            case -9: {
                string = "errorCode=XAER_OUTSIDE, the resource manager is doing work outside global transaction.";
                break;
            }
            default: {
                string = "errorCode=" + n + ", general XA exception...";
            }
        }
        return string;
    }

    protected native void xaStart(int var1, int var2, int var3, int var4, byte[] var5, int var6, TimesTenXAError var7);

    protected native void xaEnd(int var1, int var2, int var3, int var4, byte[] var5, int var6, TimesTenXAError var7);

    protected native int xaPrepare(int var1, int var2, int var3, int var4, byte[] var5, int var6, TimesTenXAError var7);

    protected native void xaCommit(int var1, int var2, int var3, int var4, byte[] var5, int var6, int var7, TimesTenXAError var8);

    protected native void xaRollback(int var1, int var2, int var3, int var4, byte[] var5, int var6, int var7, TimesTenXAError var8);

    protected native void xaForget(int var1, int var2, int var3, int var4, byte[] var5, int var6, TimesTenXAError var7);

    protected native void xaRecover(int var1, TimesTenXid[] var2, int var3, int var4, TimesTenXAError var5);

    protected native int getPendingXidNum(int var1, TimesTenXAError var2);

    protected native int error(int var1, int var2, int var3, byte[] var4, byte[] var5, byte[] var6);
}

