/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.log;

import java.awt.Component;
import java.net.URL;
import java.util.EventObject;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableView;
import oracle.ide.editor.EditorManager;
import oracle.ide.log.AbstractLogManager;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogRecognizer;
import oracle.ide.log.LogWindow;
import oracle.ide.log.MessagePage;
import oracle.ide.log.QueuedLoggingHandler;
import oracle.ide.net.URLChooser;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.LogArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.log.LogDockableFactory;
import oracle.ideimpl.log.LogWindowImpl;
import oracle.ideimpl.log.TabbedPage;

public class TabbedLogManager
extends AbstractLogManager
implements Addin {
    private LogPage _msgPage;
    private LogWindowImpl _logWindow;
    private TabbedPage _tabbedPage;

    private TabbedLogManager() {
    }

    public void addPage(LogPage page) {
        this.getTabbedPage().addPage(page);
        super.addPage(page);
    }

    public void removePage(LogPage page) {
        if (this._tabbedPage != null) {
            this.closePage(page);
        }
    }

    public LogPage getMsgPage() {
        if (this._msgPage == null) {
            this._msgPage = new MessagePage();
            1 runnable = new 1();
            SwingUtilities.invokeLater(runnable);
        }
        return this._msgPage;
    }

    public LogWindow getLogWindow() {
        return this.getLogWindowImpl();
    }

    protected LogWindowImpl getLogWindowImpl() {
        if (this._logWindow == null) {
            this._tabbedPage = new TabbedPage();
            this._logWindow = new LogWindowImpl((LogPage)this._tabbedPage);
            this.installMouseListener((LogPage)this._tabbedPage);
        }
        return this._logWindow;
    }

    public boolean isLogVisible() {
        if (this._logWindow == null) {
            return false;
        }
        return this._logWindow.isVisible();
    }

    public void showLog() {
        DockUtil.showDockableWindow((DockableView)this.getLogWindowImpl());
        LogPage logPage = this.getSelectedPage();
        if (logPage != null) {
            GraphicsUtils.focusComponentOrChild((Component)logPage.getLogPageView().getGUI(), (boolean)true);
        }
    }

    public void hideLog() {
        if (this._logWindow != null) {
            DockUtil.hideDockableWindow((DockableView)this.getLogWindowImpl());
        }
    }

    public void toggleLog(Context context) {
        DockUtil.smartToggleDockableWindow((DockableView)this.getLogWindowImpl(), (Context)context);
    }

    public void initialize() {
        LogManager.setLogManager((LogManager)this);
        DockStation dockStation = DockStation.getDockStation();
        if (dockStation != null) {
            dockStation.registerDockableFactory("LogWindow", (DockableFactory)LogDockableFactory.getInstance());
        }
        IdeAction action = IdeAction.get((int)34, (String)"oracle.ide.cmd.LogWindowCommand", (String)IdeArb.getString((int)382), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)IdeArb.getInteger((int)247), (ArrayResourceBundle)IdeArb.getInstance(), (int)423, null, (boolean)true);
        JMenuItem logMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_VIEW_LOG);
        Menubar menuMgr = Ide.getMenubar();
        JMenu viewMenu = MenuManager.getJMenu((String)"View");
        menuMgr.add((Component)logMenuItem, viewMenu, MenuConstants.SECTION_VIEW_CORE_TOOLS);
        IdeAction showDropdownAction = IdeAction.find((int)EditorManager.SHOW_DROPDOWN_CMD_ID);
        showDropdownAction.addController((Controller)this);
        this.startJavaLogging();
    }

    private QueuedLoggingHandler findQueuedLoggingHandler() {
        Handler[] handlers;
        Logger root = Logger.global.getParent();
        Handler[] handlerArray = handlers = root.getHandlers();
        int n = 0;
        while (n < handlerArray.length) {
            Handler handler = handlerArray[n];
            if (handler instanceof QueuedLoggingHandler) {
                return (QueuedLoggingHandler)handler;
            }
            ++n;
        }
        return null;
    }

    private void startJavaLogging() {
        Ide.addIdeListener((IdeListener)new 2());
    }

    private void startJavaLoggingImpl() {
        QueuedLoggingHandler qlh = this.findQueuedLoggingHandler();
        if (qlh == null) {
            return;
        }
        LogRecord record = qlh.poll();
        while (record != null) {
            this.getMsgPage().log((Object)qlh.getFormatter().format(record));
            record = qlh.poll();
        }
        3 poller = new 3(this, qlh);
        Thread t = new Thread((Runnable)poller, "Log Poller");
        t.setPriority(1);
        t.start();
    }

    public int getPageCount() {
        if (this._tabbedPage != null) {
            return this._tabbedPage.getPageCount();
        }
        return 0;
    }

    public LogPage[] getPages() {
        if (this._tabbedPage == null) {
            return new LogPage[0];
        }
        return this._tabbedPage.getPages();
    }

    public LogPage getSelectedPage() {
        if (this.getPageCount() > 0) {
            return this._tabbedPage.getSelectedPage();
        }
        return null;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == AbstractLogManager.CLEAR_LOG_CMD_ID) {
            LogPage page = this._tabbedPage.getSelectedPage();
            page.clearAll();
            return true;
        }
        if (cmdId == AbstractLogManager.CLOSE_LOG_CMD_ID) {
            if (context != null && context.getView() instanceof LogPage) {
                this.closePage((LogPage)context.getView());
            } else {
                this.closePage(this._tabbedPage.getSelectedPage());
            }
            return true;
        }
        if (cmdId == AbstractLogManager.CLOSE_OTHER_LOGS_CMD_ID) {
            this.removeAll(this._tabbedPage.getSelectedPage());
            return true;
        }
        if (cmdId == AbstractLogManager.CLOSE_ALL_LOGS_CMD_ID) {
            this.removeAll(null);
            return true;
        }
        if (cmdId == 30 || cmdId == 31) {
            return true;
        }
        if (cmdId == 70) {
            this._tabbedPage.navigateLeft();
            return true;
        }
        if (cmdId == 71) {
            this._tabbedPage.navigateRight();
            return true;
        }
        if (cmdId == EditorManager.SHOW_DROPDOWN_CMD_ID) {
            if (context != null && context.getView() instanceof LogPage) {
                this._tabbedPage.displayDropDownMenu();
                return true;
            }
        } else {
            if (cmdId == AbstractLogManager.OPEN_FILE_CMD_ID) {
                this.openPageFromFile();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == AbstractLogManager.CLOSE_OTHER_LOGS_CMD_ID) {
            boolean enabled = false;
            if (this._tabbedPage.getPageCount() > 1) {
                enabled = true;
            }
            action.setEnabled(enabled);
            return true;
        }
        if (cmdId == AbstractLogManager.CLOSE_LOG_CMD_ID) {
            if (this.getSelectedPage() == this.getMsgPage()) {
                action.setEnabled(false);
            } else {
                action.setEnabled(true);
            }
            return true;
        }
        if (cmdId == 30 || cmdId == 31) {
            action.setEnabled(false);
            return true;
        }
        if (cmdId == AbstractLogManager.OPEN_FILE_CMD_ID) {
            List recognizerList = this.getLogRecognizers();
            if (recognizerList.size() > 0) {
                action.setEnabled(true);
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        return false;
    }

    protected Context getContext(EventObject event) {
        return this.getTabbedPage().getContext(event);
    }

    protected TabbedPage getTabbedPage() {
        this.getLogWindowImpl();
        return this._tabbedPage;
    }

    private void removeAll(LogPage skipPage) {
        if (this._tabbedPage == null) {
            return;
        }
        LogPage[] pages = this._tabbedPage.getPages();
        int i = 0;
        while (i < pages.length) {
            LogPage page = pages[i];
            if (page != skipPage && page != this.getMsgPage()) {
                this.closePage(page);
            }
            ++i;
        }
        IdeUtil.tryToRestoreFocus(skipPage != null ? skipPage.getLogPageView().getGUI() : null);
    }

    private void closePage(LogPage page) {
        if (page != this.getMsgPage()) {
            this._tabbedPage.removePage(page);
            super.removePage(page);
            page.getLogPageView().close();
        }
    }

    private void openPageFromFile() {
        URL fileToOpen = null;
        URLChooser chooser = DialogUtil.newURLChooser();
        chooser.clearChooseableURLFilters();
        List recognizerList = this.getLogRecognizers();
        int size = recognizerList.size();
        int i = 0;
        while (i < size) {
            LogRecognizer recognizer = (LogRecognizer)recognizerList.get(i);
            chooser.addChooseableURLFilter(recognizer.getFilter());
            ++i;
        }
        if (chooser.showOpenDialog((Component)Ide.getMainWindow()) != 0) {
            return;
        }
        fileToOpen = chooser.getSelectedURL();
        LogRecognizer recognizerToUse = null;
        Class dataClass = null;
        int i2 = 0;
        while (i2 < size) {
            LogRecognizer recognizer = (LogRecognizer)recognizerList.get(i2);
            dataClass = recognizer.recognize(fileToOpen);
            if (dataClass != null) {
                recognizerToUse = recognizer;
                break;
            }
            ++i2;
        }
        if (recognizerToUse != null) {
            try {
                LogPage page = recognizerToUse.create(fileToOpen, dataClass);
                page.getLogPageView().show();
            }
            catch (Exception e) {
                this.showErrorDialog(LogArb.getString((int)26), LogArb.getString((int)16));
                e.printStackTrace();
            }
        } else {
            this.showErrorDialog(LogArb.getString((int)14), LogArb.getString((int)16));
        }
    }

    private void showErrorDialog(String message, String title) {
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message, title, 0);
    }

    static void mav$startJavaLoggingImpl(TabbedLogManager tabbedLogManager) {
        tabbedLogManager.startJavaLoggingImpl();
    }

    static TabbedPage ra$_tabbedPage(TabbedLogManager tabbedLogManager) {
        return tabbedLogManager._tabbedPage;
    }

    static LogPage ra$_msgPage(TabbedLogManager tabbedLogManager) {
        return tabbedLogManager._msgPage;
    }

    final class 1
    implements Runnable {
        public void run() {
            CustomTabPage tabPage = TabbedLogManager.ra$_tabbedPage(TabbedLogManager.this).getTabPageForLogPage(TabbedLogManager.ra$_msgPage(TabbedLogManager.this));
            if (tabPage != null) {
                tabPage.setCloseable(false);
            }
        }
    }

    final class 2
    implements IdeListener {
        public void addinsLoaded(IdeEvent e) {
        }

        public void mainWindowOpened(IdeEvent e) {
            Ide.removeIdeListener((IdeListener)this);
            TabbedLogManager.mav$startJavaLoggingImpl(TabbedLogManager.this);
        }

        public void mainWindowClosing(IdeEvent e) {
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ QueuedLoggingHandler v$qlh;
        final /* synthetic */ TabbedLogManager this$0;

        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.this$0.getMsgPage().log((Object)this.v$qlh.getFormatter().format(this.v$qlh.take()));
                    }
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    continue;
                }
                break;
            }
        }

        public 3(TabbedLogManager tabbedLogManager, QueuedLoggingHandler queuedLoggingHandler) {
            this.v$qlh = queuedLoggingHandler;
            this.this$0 = tabbedLogManager;
        }
    }
}

