/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.PlSqlAttribute;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDBObject
implements DBObject {
    private String m_name;
    private Map<Object, Object> m_props;
    private ChildSupport m_childLists;
    private DBObjectID m_id;

    protected AbstractDBObject() {
    }

    protected AbstractDBObject(String name) {
        this(name, null);
    }

    protected AbstractDBObject(String name, DBObjectID id) {
        this.m_name = name;
        this.m_id = id;
    }

    @Override
    public final Object copyTo(Object target) {
        return this.copyTo((DBObject)target, false);
    }

    @Override
    public final DBObject copyTo(DBObject target, boolean temporaryCopy) {
        return this.copyTo(target, temporaryCopy ? new IDPolicy.TemporaryIDPolicy() : new IDPolicy.DefaultIDPolicy());
    }

    @Override
    public final DBObject copyTo(DBObject target, IDPolicy idPolicy) {
        DBObject parent = null;
        if (target instanceof ChildDBObject) {
            parent = ((ChildDBObject)target).getParent();
        }
        if (parent == null && this instanceof ChildDBObject) {
            parent = ((ChildDBObject)((Object)this)).getParent();
        }
        DBObject copy = this.copyTo(target, parent, idPolicy);
        if (idPolicy != null) {
            DBUtil.replaceReferenceIDs(copy, idPolicy.getIDMap());
        }
        return copy;
    }

    protected abstract DBObject copyTo(DBObject var1, DBObject var2, IDPolicy var3);

    protected void copyToImpl(AbstractDBObject copy, DBObject copyParent, IDPolicy idPolicy) {
        if (this == copy) {
            throw new IllegalStateException("cannot copy an object to itself");
        }
        if (this.m_props == null) {
            copy.m_props = null;
        } else if (copy.m_props != null) {
            copy.m_props.clear();
        }
        if (idPolicy != null) {
            idPolicy.copyID(this, copy);
        }
        copy.m_name = this.m_name;
        if (this.m_props != null) {
            for (Object key : this.m_props.keySet()) {
                Object value = this.copyObject(this.m_props.get((String)key), copy, idPolicy);
                copy.setProperty((String)key, value);
            }
        }
        if (this.m_childLists == null) {
            if (copy.m_childLists != null) {
                ChildSupport.mav$clearAllChildren(copy.m_childLists);
                copy.m_childLists = null;
            }
        } else {
            ChildSupport.mav$copyChildren(this.m_childLists, copy.getChildSupport(), idPolicy);
        }
    }

    protected <T> T copyObject(T value, DBObject copy, IDPolicy idPolicy) {
        Object retval = null;
        if (value instanceof AbstractDBObject) {
            retval = ((AbstractDBObject)value).copyTo(null, copy, idPolicy);
        } else if (value instanceof Copyable) {
            retval = ((Copyable)value).copyTo(null);
        } else if (value instanceof Object[]) {
            Object[] newArray = (Object[])Array.newInstance(value.getClass().getComponentType(), ((Object[])value).length);
            int i = 0;
            while (i < newArray.length) {
                newArray[i] = this.copyObject(((Object[])value)[i], copy, idPolicy);
                ++i;
            }
            retval = newArray;
        } else if (value instanceof Map) {
            HashMap newMap = new HashMap();
            for (Map.Entry e : ((Map)value).entrySet()) {
                newMap.put(e.getKey(), this.copyObject(e.getValue(), copy, idPolicy));
            }
            retval = newMap;
        } else {
            retval = value;
        }
        return (T)retval;
    }

    protected boolean equalsImpl(AbstractDBObject other) {
        return ModelUtil.areEqual((Object)this.m_name, (Object)other.m_name) && DBUtil.areEqualIgnoreNullValues(this.m_props, other.m_props) && this.compareChildLists(other);
    }

    private boolean compareChildLists(AbstractDBObject other) {
        if (this.m_childLists == null || ChildSupport.mav$isEmpty(this.m_childLists)) {
            return other.m_childLists == null || ChildSupport.mav$isEmpty(other.m_childLists);
        }
        return ModelUtil.areEqual((Object)this.m_childLists, (Object)other.m_childLists);
    }

    protected int compareToImpl(AbstractDBObject target) {
        String otherName = target.getName();
        return this.m_name == null ? (otherName == null ? 0 : -1) : (otherName == null ? 1 : this.m_name.compareTo(otherName));
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.m_name != null ? this.m_name.hashCode() : 0;
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public void setID(DBObjectID id) {
        this.m_id = id;
    }

    @Override
    public final DBObjectID getID() {
        return this.m_id == null ? null : (DBObjectID)this.m_id.copyTo(null);
    }

    public Map getProperties() {
        return this.m_props == null || this.m_props.isEmpty() ? null : this.m_props;
    }

    public Object getProperty(String key) {
        return this.m_props == null ? null : this.m_props.get(key);
    }

    public Object getProperty(String key, Object defaultValue) {
        Object value = this.m_props == null ? defaultValue : this.m_props.get(key);
        return value == null ? defaultValue : value;
    }

    public void setProperties(Map properties) {
        this.m_props = properties;
    }

    public void setProperty(String key, Object value) {
        if (key != null) {
            if (this.m_props == null) {
                this.m_props = new HashMap<Object, Object>();
            }
            if (value == null) {
                this.m_props.remove(key);
            } else {
                if (value instanceof ChildDBObject) {
                    Object existing = this.m_props.get(key);
                    if (existing instanceof ChildDBObject) {
                        ((ChildDBObject)existing).setParent(null);
                    }
                    ((ChildDBObject)value).setParent(this);
                }
                this.m_props.put(key, value);
            }
        }
    }

    protected final void removeThisAsParent(ChildDBObject child) {
        if (child != null && child.getParent() == this) {
            child.setParent(null);
        }
    }

    protected final void changeParent(ChildDBObject oldChild, ChildDBObject newChild) {
        this.removeThisAsParent(oldChild);
        if (newChild != null) {
            newChild.setParent(this);
        }
    }

    @Override
    public final DBObject[] getOwnedObjects() {
        return this.getOwnedObjects(null);
    }

    @Override
    public final DBObject[] getOwnedObjects(String ... types) {
        ArrayList<DBObject> kids = new ArrayList<DBObject>();
        this.getOwnedObjectsImpl(kids, types);
        return kids.toArray(new DBObject[kids.size()]);
    }

    @Override
    public final DBObject findOwnedObject(String type, String name) {
        DBObject[] kids = this.getOwnedObjects(type);
        if (name == null) {
            if (kids.length == 1) {
                return kids[0];
            }
        } else {
            int i = 0;
            while (i < kids.length) {
                if (name.equals(kids[i].getName())) {
                    return kids[i];
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public DBObject findOwnedObject(DBObjectID id) {
        block6: {
            if (id instanceof TemporaryObjectID) {
                try {
                    DBObject obj = id.resolveID();
                    if (obj.getParent() == this) {
                        DBObject dBObject = obj;
                        return dBObject;
                    }
                    break block6;
                }
                catch (DBException e) {
                    DBObject dBObject = null;
                    return dBObject;
                }
            }
            DBObject[] kids = this.getOwnedObjects(id.getType());
            int i = 0;
            while (i < kids.length) {
                if (id.equals(kids[i].getID(), true)) {
                    return kids[i];
                }
                ++i;
            }
        }
        return null;
    }

    protected void getOwnedObjectsImpl(Collection<DBObject> objs, String ... types) {
        if (this.m_props != null) {
            for (Object value : this.m_props.values()) {
                if (value instanceof DBObject) {
                    this.includeOwnedObject(objs, (DBObject)value, types);
                    continue;
                }
                if (!(value instanceof DBObject[])) continue;
                DBObject[] dBObjectArray = (DBObject[])value;
                int n = 0;
                while (n < dBObjectArray.length) {
                    DBObject dbo = dBObjectArray[n];
                    this.includeOwnedObject(objs, dbo, types);
                    ++n;
                }
            }
        }
        if (this.m_childLists != null) {
            ChildSupport.mav$getOwnedChildObjects(this.m_childLists, objs, types);
        }
    }

    protected final void includeOwnedObject(Collection<DBObject> objs, DBObject obj, String ... types) {
        if (this.includesType(obj, types)) {
            objs.add(obj);
        }
    }

    protected final boolean includesType(String type, String ... types) {
        return this.includesType(type, (Class<? extends DBObject>)null, types);
    }

    protected final boolean includesType(DBObject obj, String ... types) {
        if (obj != null) {
            return this.includesType(obj.getType(), obj.getClass(), types);
        }
        return false;
    }

    private final boolean includesType(Class<? extends DBObject> clz, String ... types) {
        return this.includesType(Metadata.getType(clz), clz, types);
    }

    private final boolean includesType(String type, Class<? extends DBObject> clz, String ... types) {
        if (ModelUtil.hasNonNullElement((Object[])types)) {
            int i = 0;
            while (i < types.length) {
                if (types[i].equals(type)) {
                    return true;
                }
                ++i;
            }
            Metadata m = Metadata.getInstance();
            String[] stringArray = types;
            int n = 0;
            while (n < stringArray.length) {
                String searchType = stringArray[n];
                Class<? extends DBObject> searchClass = m.getObjectClass(searchType);
                if (searchClass != null) {
                    Collection<String> implTypes;
                    if (clz != null && searchClass.isAssignableFrom(clz)) {
                        return true;
                    }
                    if (!Metadata.isRealBean(searchClass) && (implTypes = m.getAllTypes(searchClass)).contains(type)) {
                        return true;
                    }
                }
                ++n;
            }
            return false;
        }
        return true;
    }

    @Override
    public final DBObjectID[] getReferenceIDs() {
        ArrayList<DBObjectID> refs = new ArrayList<DBObjectID>();
        this.getReferenceIDsImpl(refs);
        return refs.toArray(new DBObjectID[refs.size()]);
    }

    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> idMap) {
        boolean changed = false;
        if (this.m_props != null) {
            for (Map.Entry<Object, Object> entry : this.m_props.entrySet()) {
                Object value = entry.getValue();
                if (!(value instanceof DBObjectID) || !idMap.containsKey(value)) continue;
                entry.setValue(idMap.get(value));
                changed = true;
            }
        }
        return changed;
    }

    protected ChildSupport getChildSupport() {
        if (this.m_childLists == null) {
            this.m_childLists = new ChildSupport();
        }
        return this.m_childLists;
    }

    static boolean mav$includesType(AbstractDBObject abstractDBObject, Class clazz, String[] stringArray) {
        return abstractDBObject.includesType(clazz, stringArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ChildSupport {
        private List<ChildList> m_childLists;

        private void $init$() {
            this.m_childLists = new ArrayList<ChildList>();
        }

        private boolean isEmpty() {
            if (!this.m_childLists.isEmpty()) {
                for (ChildList list : this.m_childLists) {
                    if (ChildList.ra$m_list(list).isEmpty()) continue;
                    return false;
                }
            }
            return true;
        }

        private <T extends ChildDBObject> void addChildren(List<T> childList, T[] children) {
            if (children != null) {
                T[] TArray = children;
                int n = 0;
                while (n < TArray.length) {
                    T child = TArray[n];
                    if (child != null) {
                        this.addChild(childList, child);
                    }
                    ++n;
                }
            }
        }

        private <T extends ChildDBObject> void addChild(List<T> childList, T child) {
            if (this.canAddChild(childList, child)) {
                childList.add(child);
                child.setParent(AbstractDBObject.this);
            }
        }

        private <T extends ChildDBObject> void addChild(List<T> childList, T child, int idx) {
            if (this.canAddChild(childList, child)) {
                childList.add(idx, child);
                child.setParent(AbstractDBObject.this);
            }
        }

        private <T extends ChildDBObject> boolean canAddChild(List<T> childList, T child) {
            if (child != null) {
                for (ChildDBObject listed : childList) {
                    if (child != listed) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private void clearChildren(List<? extends ChildDBObject> childList) {
            if (childList != null) {
                for (ChildDBObject childDBObject : childList) {
                    if (childDBObject == null) continue;
                    AbstractDBObject.this.removeThisAsParent(childDBObject);
                }
                childList.clear();
            }
        }

        private boolean removeChild(List<? extends ChildDBObject> childList, ChildDBObject child) {
            if (childList != null && childList.remove(child)) {
                AbstractDBObject.this.removeThisAsParent(child);
                return true;
            }
            return false;
        }

        public <T extends ChildDBObject> void addChild(T child) {
            if (child != null) {
                this.addChild(child.getClass(), child);
            }
        }

        public <T extends ChildDBObject> void addChild(Class<T> clz, T child) {
            List<T> kids = this.getChildList(clz, true);
            this.addChild(kids, child);
        }

        public <T extends ChildDBObject> void addChild(int idx, T child) {
            if (child != null) {
                this.addChild(child.getClass(), idx, child);
            }
        }

        public <T extends ChildDBObject> void addChild(Class<T> clz, int idx, T child) {
            List<T> kids = this.getChildList(clz, true);
            this.addChild(kids, child, idx);
        }

        public <T extends ChildDBObject> boolean moveChild(T child, int newIdx) {
            int oldIndex;
            List<?> kids;
            if (child != null && (kids = this.getChildList(child.getClass(), false)) != null && (oldIndex = kids.indexOf(child)) != newIdx && kids.remove(child)) {
                kids.add(newIdx, child);
                return true;
            }
            return false;
        }

        public <T extends ChildDBObject> int indexOfChild(T child) {
            List<?> kids = child == null ? null : this.getChildList(child.getClass(), false);
            return kids == null ? -1 : kids.indexOf(child);
        }

        public <T extends ChildDBObject> T setChildAt(Class<T> clz, int index, T child) {
            List<T> kids = this.getChildList(clz, index == 0);
            if (kids == null || kids.size() <= index) {
                throw new IndexOutOfBoundsException(index + " too big");
            }
            ChildDBObject replaced = (ChildDBObject)kids.set(index, child);
            if (replaced != null) {
                AbstractDBObject.this.removeThisAsParent(replaced);
            }
            return (T)replaced;
        }

        public <T extends ChildDBObject> boolean removeChild(T child) {
            if (child != null) {
                return this.removeChild(child.getClass(), child);
            }
            return false;
        }

        public <T extends ChildDBObject> boolean removeChild(Class<T> clz, T child) {
            List<T> kids = this.getChildList(clz, false);
            return this.removeChild(kids, child);
        }

        public <T extends ChildDBObject> T findChild(Class<T> clz, String name) {
            List<T> kids;
            if (name != null && (kids = this.getChildList(clz, false)) != null) {
                for (ChildDBObject kid : kids) {
                    if (kid == null || !name.equals(kid.getName())) continue;
                    return (T)kid;
                }
            }
            return null;
        }

        public <T extends ChildDBObject> void clearChildren(Class<T> clz) {
            List<T> kids = this.getChildList(clz, false);
            this.clearChildren(kids);
        }

        public <T extends ChildDBObject> T[] getChildArray(Class<T> clz) {
            List<ChildDBObject> kids = this.getChildList(clz, false);
            return kids == null ? (ChildDBObject[])Array.newInstance(clz, 0) : kids.toArray((ChildDBObject[])Array.newInstance(clz, kids.size()));
        }

        public <T extends ChildDBObject> void setChildArray(Class<T> clz, T[] newKids) {
            this.clearChildren(clz);
            List<T> kids = this.getChildList(clz, true);
            this.addChildren(kids, (ChildDBObject[])newKids);
        }

        public <T extends ChildDBObject> int getChildCount(Class<T> clz) {
            List<T> list = this.getChildList(clz, false);
            return list == null ? 0 : list.size();
        }

        public <T extends ChildDBObject> List<T> getChildList(Class<T> clz, boolean create) {
            ChildList kids = null;
            for (ChildList list : this.m_childLists) {
                if (ChildList.ra$m_clz(list) != clz) continue;
                kids = list;
            }
            if (kids == null && create) {
                kids = new ChildList(clz);
                if (clz == Column.class || clz == PlSqlAttribute.class) {
                    this.m_childLists.add(0, kids);
                } else {
                    this.m_childLists.add(kids);
                }
            }
            return kids == null ? null : ChildList.ra$m_list(kids);
        }

        private <T extends ChildDBObject> void copyChildren(ChildSupport target, IDPolicy idPolicy) {
            target.clearAllChildren();
            ArrayList<ChildDBObject> copiedKids = null;
            if (idPolicy != null && AbstractDBObject.this instanceof SchemaObject) {
                copiedKids = new ArrayList<ChildDBObject>();
            }
            for (ChildList list : this.m_childLists) {
                for (ChildDBObject kid : ChildList.ra$m_list(list)) {
                    ChildDBObject targetKid = AbstractDBObject.this.copyObject(kid, target.getParent(), idPolicy);
                    target.addChild(ChildList.ra$m_clz(list), targetKid);
                    if (copiedKids == null) continue;
                    copiedKids.add(targetKid);
                }
            }
            if (copiedKids != null) {
                Map<DBObjectID, DBObjectID> idMap = idPolicy.getIDMap();
                for (ChildDBObject child : copiedKids) {
                    DBUtil.replaceReferenceIDs(child, idMap);
                }
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof ChildSupport && this.equalsImpl((ChildSupport)obj);
        }

        private boolean equalsImpl(ChildSupport other) {
            ArrayList<List> thisList = new ArrayList<List>();
            ArrayList<List> thatList = new ArrayList<List>();
            for (ChildList list : this.m_childLists) {
                if (ChildList.ra$m_list(list).isEmpty()) continue;
                thisList.add(ChildList.ra$m_list(list));
            }
            for (ChildList list : other.m_childLists) {
                if (ChildList.ra$m_list(list).isEmpty()) continue;
                thatList.add(ChildList.ra$m_list(list));
            }
            return thisList.equals(thatList);
        }

        private <T extends ChildDBObject> void getOwnedChildObjects(Collection<DBObject> objs, String ... types) {
            Metadata m = Metadata.getInstance();
            for (ChildList list : this.m_childLists) {
                if (!AbstractDBObject.mav$includesType(AbstractDBObject.this, ChildList.ra$m_clz(list), types)) continue;
                objs.addAll(ChildList.ra$m_list(list));
            }
        }

        private void clearAllChildren() {
            for (ChildList list : this.m_childLists) {
                this.clearChildren(ChildList.ra$m_list(list));
            }
        }

        public AbstractDBObject getParent() {
            return AbstractDBObject.this;
        }

        protected ChildSupport() {
            this.$init$();
        }

        static void mav$getOwnedChildObjects(ChildSupport childSupport, Collection collection, String[] stringArray) {
            childSupport.getOwnedChildObjects(collection, stringArray);
        }

        static boolean mav$isEmpty(ChildSupport childSupport) {
            return childSupport.isEmpty();
        }

        static void mav$clearAllChildren(ChildSupport childSupport) {
            childSupport.clearAllChildren();
        }

        static void mav$copyChildren(ChildSupport childSupport, ChildSupport childSupport2, IDPolicy iDPolicy) {
            childSupport.copyChildren(childSupport2, iDPolicy);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ChildList<T extends ChildDBObject> {
            private Class<T> m_clz;
            private final List<T> m_list;

            ChildList(Class<T> clz) {
                this.m_clz = clz;
                this.m_list = new ArrayList<T>();
            }

            public boolean equals(Object obj) {
                return obj instanceof ChildList && this.equalsImpl((ChildList)obj);
            }

            public int hashCode() {
                return this.m_clz == null ? 0 : this.m_clz.hashCode();
            }

            private boolean equalsImpl(ChildList<T> obj) {
                return this.m_clz == obj.m_clz && ModelUtil.areEqual(this.m_list, obj.m_list);
            }

            static List ra$m_list(ChildList childList) {
                return childList.m_list;
            }

            static Class ra$m_clz(ChildList childList) {
                return childList.m_clz;
            }
        }
    }
}

