/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectManager;

public abstract class AbstractDBObjectBuilder
implements DBObjectBuilder {
    private Boolean m_supportsTimestamp;
    private String m_type;
    private AbstractDBObjectProvider m_pro;

    protected AbstractDBObjectBuilder(AbstractDBObjectProvider pro, String type) {
        this.m_type = type;
        this.m_pro = pro;
    }

    protected String getObjectType() {
        return this.m_type;
    }

    protected AbstractDBObjectProvider getProvider() {
        return this.m_pro;
    }

    public abstract SchemaObject createObject(String var1, Schema var2, DBObjectID var3);

    public void buildObject(SchemaObject object) throws DBException {
        ((AbstractSchemaObject)object).setBuilder(null);
        this.updateTimestamp(object);
        this.fillInObject(object);
        this.markAsBuilt((AbstractSchemaObject)object);
        this.registerObject(object);
    }

    protected abstract void fillInObject(SchemaObject var1) throws DBException;

    protected void registerObject(SchemaObject object) throws DBException {
        SchemaObjectManager m;
        this.updateTimestamp(object);
        SchemaObjectManager schemaObjectManager = m = this.m_pro == null ? null : this.m_pro.getObjectManager();
        if (m != null) {
            m.registerObject(object, true);
        }
    }

    protected void updateTimestamp(SchemaObject object) throws DBException {
        this.updateTimestamp(object, false);
    }

    protected void updateTimestamp(SchemaObject object, boolean force) throws DBException {
        if (this.m_supportsTimestamp == null) {
            this.m_supportsTimestamp = this.getProvider().supportsTimestamps();
        }
        if (this.m_supportsTimestamp.booleanValue() && (force || object.getProperty("Timestamp") == null)) {
            object.setProperty("Timestamp", this.getProvider().getExternalTimestamp(object));
        }
    }

    protected boolean needsBuilding(AbstractSchemaObject obj, String key) {
        return this.needsBuilding(obj, key, false);
    }

    public boolean needsBuilding(AbstractSchemaObject obj, String key, boolean checkBuilder) {
        if (checkBuilder && !obj.needsInitialization()) {
            return false;
        }
        return obj.isBuilt(key) ^ true;
    }

    protected void markAsBuilt(AbstractSchemaObject obj) {
        obj.setBuilder(null);
        obj.clearBuiltList();
    }

    protected void ensureComponent(AbstractSchemaObject obj, String key) throws DBException {
        if (this.needsBuilding(obj, key)) {
            this.buildObjectComponent(obj, key);
        }
    }

    public void buildObjectComponent(SchemaObject object, String key) throws DBException {
        if (this.canBuildComponents()) {
            ((AbstractSchemaObject)object).setBuilt(key);
            this.fillInObjectComponent(object, key);
            this.registerObject(object);
        } else {
            this.buildObject(object);
        }
    }

    protected void fillInObjectComponent(SchemaObject object, String key) throws DBException {
        if (!key.equals("Timestamp")) {
            this.buildObject(object);
        }
    }

    protected boolean canBuildComponents() {
        return false;
    }
}

