/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractDBObjectID
implements DBObjectID {
    private DBObjectID m_parent;
    private String m_type;

    protected AbstractDBObjectID() {
    }

    protected AbstractDBObjectID(String type) {
        this.m_type = type;
    }

    protected AbstractDBObjectID(String type, DBObjectID parent) {
        this.m_type = type;
        this.m_parent = parent;
    }

    public final String getType() {
        return this.m_type;
    }

    public final void setType(String type) {
        if (ModelUtil.hasLength((String)this.m_type) && ModelUtil.areDifferent((Object)this.m_type, (Object)type)) {
            throw new IllegalStateException("cannot change the type of a DBObjectID");
        }
        this.m_type = type;
    }

    public final DBObjectID getParent() {
        return this.m_parent;
    }

    public void setParent(DBObjectID parent) {
        this.m_parent = parent;
    }

    protected DBObject resolveFromParent() throws DBException {
        DBObject parent;
        if (this.m_parent != null && (parent = this.m_parent.resolveID()) != null) {
            DBObject[] children = parent.getOwnedObjects(this.getType());
            int i = 0;
            while (children != null && i < children.length) {
                if (this.equals(children[i].getID(), true)) {
                    return children[i];
                }
                ++i;
            }
        }
        return null;
    }

    public final boolean equals(Object obj) {
        return obj instanceof DBObjectID && this.equals((DBObjectID)obj, true);
    }

    public final boolean equals(DBObjectID id, boolean strict) {
        if (id instanceof TemporaryObjectID || id instanceof ReferenceID && !(this instanceof ReferenceID)) {
            return id.equals(this, strict);
        }
        return id != null && this.hasSameParent(id, strict) && this.equalsImpl(id, strict);
    }

    protected boolean hasSameParent(DBObjectID other, boolean strict) {
        DBObjectID otherPar = other.getParent();
        if (this.m_parent == otherPar) {
            return true;
        }
        if (this.m_parent == null || otherPar == null) {
            return false;
        }
        return this.m_parent.equals(otherPar, strict);
    }

    protected abstract boolean equalsImpl(DBObjectID var1, boolean var2);

    protected boolean equalsImpl(AbstractDBObjectID target) {
        return ModelUtil.areEqual((Object)this.m_type, (Object)target.m_type);
    }

    protected void copyToImpl(AbstractDBObjectID target) {
        target.m_type = this.m_type;
        target.m_parent = this.m_parent == null ? null : (DBObjectID)this.m_parent.copyTo(null);
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public abstract String toString();
}

