/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBSQLException;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectListener;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSchemaObject
extends AbstractDBObject
implements SchemaObject {
    private Schema m_schema;
    private DBObjectBuilder m_builder;
    private Set<String> m_built;
    private transient List<SchemaObjectListener> m_listeners;

    protected AbstractSchemaObject() {
    }

    protected AbstractSchemaObject(String name, Schema schema, DBObjectID id) {
        super(name, id);
        this.m_schema = schema;
    }

    protected AbstractSchemaObject(String name, Schema schema) {
        this(name, schema, null);
    }

    protected void copyToImpl(AbstractSchemaObject copy, DBObject copyParent, IDPolicy idPolicy) {
        this.checkInit();
        copy.setBuilder(null);
        copy.clearBuiltList();
        copy.m_schema = this.m_schema;
        super.copyToImpl(copy, copyParent, idPolicy);
    }

    protected boolean equalsImpl(AbstractSchemaObject target) {
        this.checkInit();
        target.checkInit();
        return super.equalsImpl(target) && ModelUtil.areEqual((Object)this.m_schema, (Object)target.m_schema);
    }

    @Override
    public void setSchema(Schema schema) {
        this.m_schema = schema;
    }

    @Override
    public Schema getSchema() {
        return this.m_schema;
    }

    void setBuilder(DBObjectBuilder builder) {
        this.m_builder = builder;
    }

    void clearBuiltList() {
        this.m_built = null;
    }

    void setBuilt(String key) {
        if (key != null && this.m_builder != null) {
            if (this.m_built == null) {
                this.m_built = new HashSet<String>();
            }
            this.m_built.add(key);
        }
    }

    synchronized boolean isBuilt(String key) {
        return this.needsInitialization() && this.m_built != null && this.m_built.contains(key);
    }

    protected boolean needsInitialization() {
        return this.m_builder != null;
    }

    protected void checkInit(String key) {
        try {
            this.checkInitEx(key);
        }
        catch (DBSQLException sqle) {
            DBLog.getLogger().log(Level.SEVERE, "Error : " + sqle.getMessage() + "building {0}, executing sql:\n {1}", new Object[]{this.getName(), sqle.getSQL()});
        }
        catch (DBException dbe) {
            DBLog.getLogger().log(Level.SEVERE, "Error : " + dbe.getMessage() + "building " + this.getName(), dbe.getCause() == null ? dbe : dbe.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkInitEx(String key) throws DBException {
        DBObjectBuilder builder;
        AbstractSchemaObject abstractSchemaObject = this;
        synchronized (abstractSchemaObject) {
            if (this.m_builder == null) {
                return;
            }
            if (key != null && this.isBuilt(key)) {
                return;
            }
            builder = this.m_builder;
            if (key == null) {
                this.m_builder = null;
            } else {
                this.setBuilt(key);
            }
        }
        long millis = System.currentTimeMillis();
        try {
            try {
                if (key == null) {
                    builder.buildObject(this);
                } else {
                    builder.buildObjectComponent(this, key);
                }
            }
            catch (CancelledException ce) {
                this.m_builder = builder;
                if (key != null) {
                    this.m_built.remove(key);
                }
                throw ce;
            }
        }
        catch (Throwable throwable) {
            millis = System.currentTimeMillis() - millis;
            DBLog.getLogger().log(DBLog.getTimingLogLevel(), "Building {0} of {1}.{2} took {3}ms", new Object[]{key == null ? "all" : key, this.m_schema == null ? "null" : this.m_schema.getName(), this.getName(), Long.toString(millis)});
            throw throwable;
        }
        millis = System.currentTimeMillis() - millis;
        DBLog.getLogger().log(DBLog.getTimingLogLevel(), "Building {0} of {1}.{2} took {3}ms", new Object[]{key == null ? "all" : key, this.m_schema == null ? "null" : this.m_schema.getName(), this.getName(), Long.toString(millis)});
    }

    protected void checkInit() {
        if (this.m_builder == null) {
            return;
        }
        this.checkInit(null);
    }

    @Override
    public DBObject getParent() {
        return null;
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> c, String ... types) {
        if (types == null || types.length == 0) {
            this.checkInit();
        } else {
            int i = 0;
            while (i < types.length) {
                this.checkInit(types[i]);
                ++i;
            }
        }
        super.getOwnedObjectsImpl(c, types);
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        this.checkInit();
        super.getReferenceIDsImpl(refs);
    }

    @Override
    public final void removeObjectListener(SchemaObjectListener list) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(list);
        }
    }

    @Override
    public final void addObjectListener(SchemaObjectListener list) {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList<SchemaObjectListener>();
        }
        this.m_listeners.add(list);
    }

    @Override
    public final void fireObjectUpdated(DBObjectChange change) {
        change.log();
        if (this.m_listeners != null) {
            for (SchemaObjectListener list : new ArrayList<SchemaObjectListener>(this.m_listeners)) {
                if (list == null) continue;
                try {
                    list.schemaObjectUpdated(change);
                }
                catch (Exception e) {
                    DBLog.getLogger().log(Level.WARNING, MessageFormat.format("listener {0} threw exception:", list.getClass()), e);
                }
            }
        }
    }

    @Override
    public Map getProperties() {
        this.checkInit();
        return super.getProperties();
    }

    @Override
    public Object getProperty(String key) {
        this.checkInit(key);
        return super.getProperty(key);
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        this.checkInit(key);
        return super.getProperty(key, defaultValue);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.checkInit(key);
        super.setProperty(key, value);
    }

    @Override
    public void setProperties(Map properties) {
        this.checkInit();
        super.setProperties(properties);
    }
}

