/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CascadeRequiredException
extends DBException {
    private Collection<DBObjectID> m_deps;
    private Collection<DBObject> m_objs;
    private String m_detailMessage;

    public CascadeRequiredException(DBObject obj, String msg) {
        this(obj);
        this.m_detailMessage = msg;
    }

    public CascadeRequiredException(DBObject obj) {
        this(obj, (Collection<DBObjectID>)null);
    }

    public CascadeRequiredException(DBObject obj, Collection<DBObjectID> deps) {
        this(Arrays.asList(obj), deps);
    }

    public CascadeRequiredException(Collection<DBObject> objs, Collection<DBObjectID> deps) {
        super((Throwable)null);
        this.m_objs = objs;
        this.m_deps = deps;
    }

    public void include(CascadeRequiredException cre2) {
        if (this.m_objs == null) {
            this.m_objs = cre2.m_objs;
        } else {
            this.m_objs.addAll(cre2.m_objs);
        }
        if (this.m_deps == null) {
            this.m_deps = cre2.m_deps;
        } else {
            this.m_deps.addAll(cre2.m_deps);
        }
    }

    @Override
    public String getMessage() {
        if (this.m_objs == null || this.m_objs.size() == 0) {
            return DBArb.getString(3);
        }
        StringBuilder names = new StringBuilder();
        for (DBObject obj : this.m_objs) {
            if (obj == null) continue;
            names.append("\n").append(obj.getName());
        }
        names.append("\n");
        if (this.m_deps != null && this.m_deps.size() >= 0) {
            try {
                StringBuilder buff = new StringBuilder();
                for (DBObjectID dep : this.m_deps) {
                    DBObject depobj = dep.resolveID();
                    buff.append("\n").append(DBUtil.getFullyQualifiedName(depobj));
                }
                String string = DBArb.format(149, names, buff.toString());
                return string;
            }
            catch (DBException dbe) {
                DBLog.getLogger().log(Level.WARNING, "can't resolve dependent object id", dbe);
            }
        }
        String msg = DBArb.format(298, names);
        if (ModelUtil.hasLength((String)this.m_detailMessage)) {
            return msg + " " + this.m_detailMessage;
        }
        return msg;
    }

    @Override
    public DBObject getObject() {
        return this.m_objs == null || this.m_objs.size() == 0 ? super.getObject() : this.m_objs.iterator().next();
    }

    public Collection<DBObject> getObjects() {
        return this.m_objs;
    }

    public Collection<DBObjectID> getDependents() {
        return this.m_deps;
    }
}

