/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Transient;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ColumnConstraint
extends Constraint {
    private List<DBObjectID> m_ids;

    private void $init$() {
        this.m_ids = new ArrayList<DBObjectID>();
    }

    ColumnConstraint() {
        this.$init$();
    }

    ColumnConstraint(String name, Relation relation) {
        super(name, relation);
        this.$init$();
    }

    protected void copyToImpl(ColumnConstraint copy, Relation copyParent, IDPolicy idPolicy) {
        Relation r;
        super.copyToImpl(copy, (DBObject)copyParent, idPolicy);
        copy.m_ids.clear();
        if (copyParent == null) {
            copyParent = copy.getRelation();
        }
        if ((r = this.getRelation()) != null && copyParent != null) {
            for (DBObjectID id : this.m_ids) {
                Column c = (Column)r.findOwnedObject(id);
                if (c == null) continue;
                copy.addColumnImpl(c, copyParent);
            }
        } else {
            copy.m_ids.addAll(this.m_ids);
        }
    }

    protected boolean equalsImpl(ColumnConstraint target) {
        return super.equalsImpl(target) && ModelUtil.areEqual(this.m_ids, target.m_ids);
    }

    @Transient
    public Column[] getColumns() throws IllegalStateException {
        ArrayList<Column> _columns = new ArrayList<Column>();
        for (DBObjectID id : this.m_ids) {
            Relation parent = this.getRelation();
            if (parent == null) {
                throw new IllegalStateException(DBArb.getString(206));
            }
            Column c = (Column)parent.findOwnedObject(id);
            if (c == null) {
                throw new IllegalStateException(DBArb.getString(312));
            }
            _columns.add(c);
        }
        return _columns.toArray(new Column[_columns.size()]);
    }

    public void setColumns(Column[] columns) {
        this.m_ids.clear();
        if (columns != null) {
            int i = 0;
            while (i < columns.length) {
                this.addColumn(columns[i]);
                ++i;
            }
        }
    }

    private Column checkColumn(Column col, Relation relForColumn) {
        String colName;
        if (relForColumn == null) {
            throw new IllegalArgumentException("need a relation set to add columns to constraint " + this.getName());
        }
        if (col.getRelation() != relForColumn && (col = relForColumn.getColumn(colName = col.getName())) == null) {
            throw new IllegalArgumentException("cannot add column " + colName + " to constraint " + this.getName() + " - column doesn't exist on this relation");
        }
        return col;
    }

    public void addColumn(Column col) {
        if (col != null) {
            this.addColumnImpl(col, this.getRelation());
        }
    }

    private void addColumnImpl(Column col, Relation relForColumn) {
        DBObjectID id = (col = this.checkColumn(col, relForColumn)).getID();
        if (id == null) {
            id = TemporaryObjectID.createID(col);
            col.setID(id);
        }
        this.m_ids.add(id);
    }

    public boolean removeColumn(Column col) {
        if (col != null) {
            this.checkColumn(col, this.getRelation());
            DBObjectID id = col.getID();
            if (id != null) {
                return this.m_ids.remove(id);
            }
        }
        return false;
    }

    public DBObjectID[] getColumnIDs() {
        return this.m_ids.toArray(new DBObjectID[this.m_ids.size()]);
    }

    public void setColumnIDs(DBObjectID[] ids) {
        this.m_ids.clear();
        if (ids != null) {
            int i = 0;
            while (i < ids.length) {
                if (ids[i] != null) {
                    this.m_ids.add(ids[i]);
                }
                ++i;
            }
        }
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        super.getReferenceIDsImpl(refs);
        refs.addAll(this.m_ids);
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> idMap) {
        boolean replaced = super.replaceReferenceIDs(idMap);
        int i = 0;
        while (i < this.m_ids.size()) {
            DBObjectID id = this.m_ids.get(i);
            if (idMap.containsKey(id)) {
                this.m_ids.set(i, idMap.get(id));
                replaced = true;
            }
            ++i;
        }
        return replaced;
    }
}

