/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCore {
    private static final String IMPL_CLASS_NAME = "oracle.javatools.db.DBCoreImpl";
    private static DBCore s_instance;
    private Map<Class, Object> m_map;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBCore getInstance() {
        boolean doit = false;
        Class<DBCore> clazz = DBCore.class;
        synchronized (DBCore.class) {
            if (s_instance == null) {
                doit = true;
                s_instance = new DBCore();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (doit) {
                DBCore.init();
            }
            return s_instance;
        }
    }

    private void $init$() {
        this.m_map = new HashMap<Class, Object>();
    }

    private DBCore() {
        this.$init$();
    }

    public void put(Object obj) {
        this.m_map.put(obj.getClass(), obj);
    }

    public <T> T get(Class<T> clz) {
        return (T)this.m_map.get(clz);
    }

    public <T> T remove(Class<T> clz) {
        return (T)this.m_map.remove(clz);
    }

    private static void init() {
        try {
            Class<?> clz = Class.forName(IMPL_CLASS_NAME);
            Object obj = clz.newInstance();
        }
        catch (InstantiationException e) {
            DBLog.getLogger().severe("Cannot instantiate core database API implementation.");
        }
        catch (IllegalAccessException e) {
            DBLog.getLogger().severe("Cannot instantiate core database API implementation.");
        }
        catch (ClassNotFoundException e) {
            DBLog.getLogger().severe("Cannot find core database API implementation. Is dbapi-impl.jar on the classpath?");
        }
    }
}

