/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBObjectChange {
    public static final String NAME_PROPERTY = "name";
    private DBObject m_obj;
    private static final String ADD_KEY = "ADDED";
    private static final String KID_KEY = "CHILDREN";
    private static final String PROP_KEY = "PROPERTIES";
    private static final String DEL_KEY = "REMOVED";
    private static final String ORD_KEY = "ORDERED";

    protected DBObjectChange(DBObject obj) {
        this.m_obj = obj;
    }

    public DBObject getDBObject() {
        return this.m_obj;
    }

    public List<DBObject> getOwnedObjectsAdded() {
        return null;
    }

    public List<DBObject> getOwnedObjectsRemoved() {
        return null;
    }

    public Map<String, PropertyChangeEvent> getPropertiesChanged() {
        return null;
    }

    public Map<DBObject, DBObjectChange> getOwnedObjectsChanged() {
        return null;
    }

    Map<DBObject, PropertyChangeEvent> getOwnedObjectsReordered() {
        return null;
    }

    public boolean hasNameChanged() {
        Map<String, PropertyChangeEvent> m = this.getPropertiesChanged();
        return m != null && (m.containsKey(NAME_PROPERTY) || m.containsKey("Name "));
    }

    void log() {
        try {
            Logger log = DBLog.getLogger();
            Level level = DBLog.getEventLogLevel();
            if (log.isLoggable(level)) {
                DBObject obj = this.getDBObject();
                if (obj == null) {
                    log.log(level, "DBObjectChange fired on null object!");
                } else {
                    StringBuilder buff = new StringBuilder("DBObjectChange on ");
                    buff.append(obj.getType()).append(" ");
                    buff.append(DBUtil.getFullyQualifiedName(obj)).append(":\n");
                    this.logList(buff, "  objects added: ", this.getOwnedObjectsAdded());
                    this.logList(buff, "  objects removed: ", this.getOwnedObjectsRemoved());
                    this.logMap(buff, "  properties changed: ", this.getPropertiesChanged());
                    List<DBObjectChange> kidsChanged = this.logMap(buff, "  children changed: ", this.getOwnedObjectsChanged());
                    log.log(level, buff.toString());
                    if (kidsChanged != null) {
                        for (DBObjectChange kidChange : kidsChanged) {
                            kidChange.log();
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void logList(StringBuilder buff, String msg, List<DBObject> objs) {
        if (objs != null && objs.size() > 0) {
            buff.append(msg);
            for (DBObject obj : objs) {
                buff.append(obj.getName()).append(" ");
            }
            buff.append("\n");
        }
    }

    private List<DBObjectChange> logMap(StringBuilder buff, String msg, Map map) {
        if (map != null && map.size() > 0) {
            buff.append(msg);
            ArrayList<DBObjectChange> kidsChanged = new ArrayList<DBObjectChange>();
            for (Object key : map.keySet()) {
                if (key instanceof DBObject) {
                    String name = ((DBObject)key).getName();
                    if (!ModelUtil.hasLength((String)name)) {
                        name = ((DBObject)key).getType();
                    }
                    buff.append(name).append(" ");
                    kidsChanged.add((DBObjectChange)map.get(key));
                    continue;
                }
                buff.append(key).append(" ");
            }
            buff.append("\n");
            if (kidsChanged.size() > 0) {
                return kidsChanged;
            }
        }
        return null;
    }

    public static void fireObjectUpdated(SchemaObject obj) {
        Impl c = new Impl(obj, null);
        obj.fireObjectUpdated(c);
    }

    public static void fireChildrenAdded(SchemaObject obj, List added) {
        Impl c = new Impl(obj, null);
        Impl.ra$m_changes(c).put(ADD_KEY, added);
        obj.fireObjectUpdated(c);
    }

    public static void fireChildrenRemoved(SchemaObject obj, List removed) {
        Impl c = new Impl(obj, null);
        Impl.ra$m_changes(c).put(DEL_KEY, removed);
        obj.fireObjectUpdated(c);
    }

    public static void firePropertyChanged(SchemaObject obj, PropertyChangeEvent ... pces) {
        Impl c = new Impl(obj, null);
        HashMap<String, PropertyChangeEvent> props = new HashMap<String, PropertyChangeEvent>(1);
        PropertyChangeEvent[] propertyChangeEventArray = pces;
        int n = 0;
        while (n < propertyChangeEventArray.length) {
            PropertyChangeEvent pce = propertyChangeEventArray[n];
            props.put(pce.getPropertyName(), pce);
            ++n;
        }
        Impl.ra$m_changes(c).put(PROP_KEY, props);
        obj.fireObjectUpdated(c);
    }

    public static void firePropertiesChanged(SchemaObject obj, Map<String, PropertyChangeEvent> props) {
        Impl c = new Impl(obj, null);
        Impl.ra$m_changes(c).put(PROP_KEY, props);
        obj.fireObjectUpdated(c);
    }

    public static void fireObjectUpdated(SchemaObject obj, List<DBObject> added, List<DBObject> removed, Map<String, PropertyChangeEvent> props) {
        Impl c = new Impl(obj, null);
        Impl.ra$m_changes(c).put(ADD_KEY, added);
        Impl.ra$m_changes(c).put(DEL_KEY, removed);
        Impl.ra$m_changes(c).put(PROP_KEY, props);
        obj.fireObjectUpdated(c);
    }

    public static void fireChildUpdated(SchemaObject obj, DBObject child) {
        Impl c = new Impl(obj, null);
        HashMap<DBObject, Impl> map = new HashMap<DBObject, Impl>();
        map.put(child, new Impl(child, null));
        Impl.ra$m_changes(c).put(KID_KEY, map);
    }

    public static void fireSchemaUpdated(AbstractDBObjectProvider pro, Schema schema, Map<String, PropertyChangeEvent> props) {
        Impl c = new Impl(schema, null);
        Impl.ra$m_changes(c).put(PROP_KEY, props);
        pro.fireSchemaUpdated(c);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Impl
    extends DBObjectChange {
        private Map m_changes;

        private void $init$() {
            this.m_changes = new HashMap();
        }

        private Impl(DBObject obj) {
            super(obj);
            this.$init$();
        }

        private List getChangeList(String key) {
            if (this.m_changes.containsKey(key)) {
                return (List)this.m_changes.get(key);
            }
            return new ArrayList(0);
        }

        private Map getChangeMap(String key) {
            if (this.m_changes.containsKey(key)) {
                return (Map)this.m_changes.get(key);
            }
            return new HashMap(0);
        }

        @Override
        public List<DBObject> getOwnedObjectsAdded() {
            return this.getChangeList(DBObjectChange.ADD_KEY);
        }

        @Override
        public Map<DBObject, DBObjectChange> getOwnedObjectsChanged() {
            return this.getChangeMap(DBObjectChange.KID_KEY);
        }

        @Override
        public List<DBObject> getOwnedObjectsRemoved() {
            return this.getChangeList(DBObjectChange.DEL_KEY);
        }

        @Override
        public Map<DBObject, PropertyChangeEvent> getOwnedObjectsReordered() {
            return this.getChangeMap(DBObjectChange.ORD_KEY);
        }

        @Override
        public Map<String, PropertyChangeEvent> getPropertiesChanged() {
            return this.getChangeMap(DBObjectChange.PROP_KEY);
        }

        Impl(DBObject dBObject, 1 var2_2) {
            this(dBObject);
        }

        static Map ra$m_changes(Impl impl) {
            return impl.m_changes;
        }

        public final class 1 {
        }
    }
}

