/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DatabaseFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBObjectProviderFactory {
    private static final Lock s_lock = new ReentrantLock();
    private static List<Creator> s_factories;
    private static Map<Object, DBObjectProvider> s_providers;
    private static Collection<Listener> s_listeners;

    public static void registerListener(Listener l) {
        if (s_listeners == null) {
            s_listeners = new ArrayList<Listener>();
        }
        if (!s_listeners.contains(l)) {
            s_listeners.add(l);
        }
    }

    public static void unregisterListener(Listener l) {
        if (s_listeners != null && s_listeners.contains(l)) {
            s_listeners.remove(l);
        }
    }

    public static void registerFactory(Creator factory) {
        if (s_factories == null) {
            s_factories = new ArrayList<Creator>();
        }
        if (!s_factories.contains(factory)) {
            s_factories.add(factory);
        }
    }

    public static <T extends Creator> T findFactory(Class<T> clz) {
        for (Creator c : DBObjectProviderFactory.factories()) {
            if (!c.getClass().equals(clz)) continue;
            return (T)c;
        }
        return null;
    }

    public static DBObjectProvider findProvider(Object identifier) {
        DBObjectProvider pro = null;
        if (identifier != null) {
            if (s_providers != null) {
                pro = s_providers.get(identifier);
            }
            if (pro == null) {
                for (Creator c : DBObjectProviderFactory.factories()) {
                    pro = c.findProvider(identifier);
                    if (pro != null) break;
                }
            }
        }
        return pro;
    }

    public static DBObjectProvider findOrCreateProvider(Object identifier) throws DBException {
        DBObjectProvider pro = null;
        if (identifier != null) {
            if (!s_lock.tryLock()) {
                DBLog.getLogger().log(DBLog.getTraceLogLevel(), "provider cache is locked, peeking in there anyway...");
                DBObjectProvider cached = DBObjectProviderFactory.findProvider(identifier);
                if (cached != null) {
                    return cached;
                }
                DBLog.getLogger().log(DBLog.getTraceLogLevel(), "... provider wasn't already cached, so we'll have to wait.");
                s_lock.lock();
            }
            try {
                DBObjectProvider cached = DBObjectProviderFactory.findProvider(identifier);
                if (cached != null) {
                    DBObjectProvider dBObjectProvider = cached;
                    return dBObjectProvider;
                }
                for (Creator factory : DBObjectProviderFactory.factories()) {
                    pro = DBObjectProviderFactory.createProviderFromFactory(factory, identifier);
                    if (pro == null) continue;
                    break;
                }
            }
            finally {
                s_lock.unlock();
            }
            if (pro != null) {
                DBObjectProviderFactory.notifyOfCreation(identifier, pro);
            }
        }
        return pro;
    }

    protected static final Collection<Creator> factories() {
        ArrayList<Creator> retval = new ArrayList<Creator>();
        if (s_factories != null) {
            retval.addAll(s_factories);
        }
        retval.add(DatabaseFactory.getInstance());
        return retval;
    }

    protected static final Collection<DBObjectProvider> providers() {
        return Collections.unmodifiableCollection(s_providers.values());
    }

    private static final DBObjectProvider createProviderFromFactory(Creator factory, Object identifier) throws DBException {
        try {
            DBObjectProvider pro = factory.createProviderImpl(identifier);
            if (pro != null) {
                Object key = factory.getCacheKey(identifier, pro);
                if (key != null) {
                    DBObjectProviderFactory.cacheProvider(key, pro);
                }
                DBObjectProvider dBObjectProvider = pro;
                return dBObjectProvider;
            }
        }
        catch (Exception e) {
            if (e instanceof DBException) {
                throw (DBException)e;
            }
            DBLog.logStackTrace(e);
            throw new DBException(e);
        }
        return null;
    }

    protected static final void cacheProvider(Object identifier, DBObjectProvider pro) {
        if (s_providers == null) {
            s_providers = new HashMap<Object, DBObjectProvider>();
        }
        s_providers.put(identifier, pro);
    }

    public static final DBObjectProvider uncacheProvider(Object identifier) {
        if (identifier != null) {
            DBObjectProvider gone;
            if (s_providers != null && s_providers.containsKey(identifier) && (gone = s_providers.remove(identifier)) != null) {
                DBObjectProviderFactory.notifyOfRemoval(identifier, gone);
                return gone;
            }
            for (Creator c : DBObjectProviderFactory.factories()) {
                DBObjectProvider gone2 = c.uncacheProvider(identifier);
                if (gone2 == null) continue;
                DBObjectProviderFactory.notifyOfRemoval(identifier, gone2);
                return gone2;
            }
        }
        return null;
    }

    private static void notifyOfCreation(Object identifier, DBObjectProvider pro) {
        DBLog.getLogger().log(DBLog.getEventLogLevel(), "Provider created using key {0}: {1}", new Object[]{identifier, pro.getClass().getName()});
        if (s_listeners != null) {
            for (Listener l : new ArrayList<Listener>(s_listeners)) {
                try {
                    l.providerCreated(identifier, pro);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void notifyOfRemoval(Object identifier, DBObjectProvider pro) {
        DBLog.getLogger().log(DBLog.getEventLogLevel(), "Provider uncached using key {0}", identifier);
        if (s_listeners != null) {
            for (Listener l : new ArrayList<Listener>(s_listeners)) {
                try {
                    l.providerRemoved(identifier, pro);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void notifyOfDelete(Object identifier, DBObjectProvider pro) {
        DBLog.getLogger().log(DBLog.getEventLogLevel(), "Provider deleted using key {0}: {1}", new Object[]{identifier, pro.getClass().getName()});
        if (s_listeners != null) {
            for (Listener l : new ArrayList<Listener>(s_listeners)) {
                try {
                    l.providerDeleted(identifier, pro);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static void maS$notifyOfDelete(Object object, DBObjectProvider dBObjectProvider) {
        DBObjectProviderFactory.notifyOfDelete(object, dBObjectProvider);
    }

    public static interface Listener {
        public void providerCreated(Object var1, DBObjectProvider var2);

        public void providerRemoved(Object var1, DBObjectProvider var2);

        public void providerDeleted(Object var1, DBObjectProvider var2);
    }

    public static abstract class Creator {
        protected abstract DBObjectProvider createProviderImpl(Object var1) throws DBException;

        protected Object getCacheKey(Object identifier, DBObjectProvider pro) {
            return identifier;
        }

        protected DBObjectProvider uncacheProvider(Object identifier) {
            return null;
        }

        protected DBObjectProvider findProvider(Object identifier) {
            return null;
        }

        protected final void fireProviderDeleted(Object identifier, DBObjectProvider pro) {
            DBObjectProviderFactory.maS$notifyOfDelete(identifier, pro);
        }
    }
}

