/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBReferenceID;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectManager;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBUtil
implements Comparator<DBObject> {
    private static Comparator<DBObject> s_typeComparator;
    private static Comparator<DBObject> s_nameComparator;
    private boolean compareByType;

    protected DBUtil() {
    }

    @Override
    public int compare(DBObject o1, DBObject o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -10;
        }
        if (o2 == null) {
            return 10;
        }
        return this.compareImpl(o1, o2);
    }

    private int compareImpl(DBObject o1, DBObject o2) {
        int nameCompare;
        int typeCompare;
        if (this.compareByType && (typeCompare = this.compareType(o1, o2)) != 0) {
            return typeCompare;
        }
        String n1 = o1.getName();
        String n2 = o2.getName();
        int n = n1 == null && n2 == null ? 0 : (n1 == null ? -10 : (nameCompare = n2 == null ? 10 : n1.compareTo(n2)));
        if (nameCompare == 0 && !this.compareByType) {
            return this.compareType(o1, o2);
        }
        return nameCompare;
    }

    private int compareType(DBObject o1, DBObject o2) {
        String t1 = o1.getType();
        String t2 = o2.getType();
        return t1.compareTo(t2);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof DBUtil && ((DBUtil)obj).compareByType == this.compareByType;
    }

    public int hashCode() {
        return 42;
    }

    public static Comparator<DBObject> getTypeComparator() {
        if (s_typeComparator == null) {
            s_typeComparator = new DBUtil();
            ((DBUtil)DBUtil.s_typeComparator).compareByType = true;
        }
        return s_typeComparator;
    }

    public static Comparator<DBObject> getNameComparator() {
        if (s_nameComparator == null) {
            s_nameComparator = new DBUtil();
            ((DBUtil)DBUtil.s_nameComparator).compareByType = false;
        }
        return s_nameComparator;
    }

    public static Map<DBObjectID, DBObjectID> getTemporaryIDMap(DBObject[] objs) {
        HashMap<DBObjectID, DBObjectID> idMap = new HashMap<DBObjectID, DBObjectID>();
        DBObject[] dBObjectArray = objs;
        int n = 0;
        while (n < dBObjectArray.length) {
            DBObject col = dBObjectArray[n];
            DBObjectID newID = col.getID();
            if (newID instanceof TemporaryObjectID) {
                try {
                    DBObject obj = ((TemporaryObjectID)newID).resolveOriginalID();
                    if (obj.getID() != null) {
                        idMap.put(obj.getID(), newID);
                    }
                }
                catch (DBException dbe) {
                    // empty catch block
                }
            }
            ++n;
        }
        return idMap;
    }

    public static <D extends DBObject> D makeTemporaryCopy(D object) {
        return (D)object.copyTo(null, true);
    }

    public static void ensureObjectBuilt(SchemaObject object) throws DBException {
        if (object instanceof AbstractSchemaObject) {
            AbstractSchemaObject obj = (AbstractSchemaObject)object;
            if (obj.needsInitialization()) {
                obj.checkInitEx(null);
            }
        } else {
            object.getProperty("");
        }
    }

    public static Collection<DBObjectID> getReferenceIDs(DBObject obj, boolean recurse, IDQuery query, String ... types) {
        ArrayList<DBObjectID> refs = new ArrayList<DBObjectID>();
        DBUtil.getReferenceIDsImpl(obj, refs, recurse, query, new String[0]);
        return refs;
    }

    private static void getReferenceIDsImpl(DBObject obj, Collection<DBObjectID> refs, boolean recurse, IDQuery query, String ... types) {
        DBObjectID[] dBObjectIDArray = obj.getReferenceIDs();
        int n = 0;
        while (n < dBObjectIDArray.length) {
            DBObjectID ref = dBObjectIDArray[n];
            if (!(types != null && types.length > 0 && Arrays.binarySearch(types, ref.getType()) < 0 || (query == IDQuery.INTERNAL ? !DBUtil.isInternalRef(ref, obj) : query == IDQuery.EXTERNAL && DBUtil.isInternalRef(ref, obj)))) {
                refs.add(ref);
            }
            ++n;
        }
        DBObject[] dBObjectArray = obj.getOwnedObjects();
        int n2 = 0;
        while (n2 < dBObjectArray.length) {
            DBObject owned = dBObjectArray[n2];
            DBUtil.getReferenceIDsImpl(owned, refs, recurse, query, types);
            ++n2;
        }
    }

    public static boolean isInternalRef(DBObjectID ref, DBObject obj) {
        DBObject top = DBUtil.getUppermostParent(obj);
        DBObjectID topID = DBUtil.getUppermostParent(ref);
        return topID != null && ModelUtil.areEqual((Object)topID, (Object)top.getID());
    }

    public static boolean replaceReferenceIDs(DBObject obj, Map<DBObjectID, DBObjectID> idMap) {
        boolean retval = false;
        if (idMap != null && !idMap.isEmpty()) {
            retval = obj.replaceReferenceIDs(idMap);
            DBObject[] dBObjectArray = obj.getOwnedObjects();
            int n = 0;
            while (n < dBObjectArray.length) {
                DBObject kid = dBObjectArray[n];
                retval = DBUtil.replaceReferenceIDs(kid, idMap) || retval;
                ++n;
            }
        }
        return retval;
    }

    public static void updateObjectAndIDs(DBObject oldVersion, DBObject newVersion) {
        ((AbstractDBObject)newVersion).copyTo(oldVersion, new IDPolicy.SameIDPolicy());
    }

    private static void updateChildIDs(DBObject oldVersion, DBObject newVersion) {
        DBObject[] children = newVersion.getOwnedObjects();
        int i = 0;
        while (children != null && i < children.length) {
            DBObject oldChild = DBUtil.findMatchingChild(oldVersion, children[i]);
            if (oldChild != null) {
                oldChild.setID(children[i].getID());
                DBUtil.updateChildIDs(oldChild, children[i]);
            }
            ++i;
        }
    }

    private static DBObject findMatchingChild(DBObject copyOfParent, DBObject child) {
        String nameToSearchFor = child.getName();
        if (nameToSearchFor == null) {
            DBObject[] kidsOfType = copyOfParent.getOwnedObjects(child.getType());
            if (kidsOfType != null && kidsOfType.length == 1) {
                return kidsOfType[0];
            }
        } else {
            return copyOfParent.findOwnedObject(child.getType(), child.getName());
        }
        return null;
    }

    public static DBObject findChildInCopy(DBObject orig, DBObject copy, DBObject origChild) {
        if (orig == null || copy == null || origChild == null) {
            throw new IllegalArgumentException("Arguments cannot be null.");
        }
        if (orig == origChild) {
            return copy;
        }
        DBObject[] copyChildren = copy.getOwnedObjects();
        int i = 0;
        while (copyChildren != null && i < copyChildren.length) {
            DBObjectID id = copyChildren[i].getID();
            if (id instanceof TemporaryObjectID) {
                DBObject child;
                DBObject origFromID = null;
                try {
                    origFromID = ((TemporaryObjectID)id).resolveOriginalID();
                }
                catch (DBException dbe) {
                    // empty catch block
                }
                if (origFromID == origChild) {
                    return copyChildren[i];
                }
                if (origFromID != null && (child = DBUtil.findChildInCopy(origFromID, copyChildren[i], origChild)) != null) {
                    return child;
                }
            }
            ++i;
        }
        return null;
    }

    public static String getUniqueName(Collection existing, String base) {
        return DBUtil.getUniqueName(existing, base, true);
    }

    public static String getUniqueName(Collection existing, String base, boolean increment) {
        String retval = null;
        if (existing == null || !existing.contains(base)) {
            retval = base;
        } else {
            int start = 1;
            int n = base.length() - 1;
            if (increment) {
                while (Character.isDigit(base.charAt(n))) {
                    if (n > 0) {
                        --n;
                        continue;
                    }
                    n = base.length() - 1;
                    break;
                }
                try {
                    start = Integer.parseInt(base.substring(n + 1));
                    base = base.substring(0, n + 1);
                }
                catch (NumberFormatException e) {}
            } else if (Character.isDigit(base.charAt(n))) {
                base = base + "_";
            }
            int i = start;
            while (retval == null) {
                String tryThis = base + i;
                if (!existing.contains(tryThis)) {
                    retval = tryThis;
                }
                ++i;
            }
        }
        return retval;
    }

    public static String getFullyQualifiedName(DBObject obj) {
        return DBUtil.getFullyQualifiedName(obj, false);
    }

    public static String getFullyQualifiedName(DBObject obj, boolean incSchema) {
        Schema schema;
        DBObject par = obj.getParent();
        String name = null;
        name = par == null ? (obj instanceof SchemaObject && incSchema ? ((schema = ((SchemaObject)obj).getSchema()) == null ? "" : schema.getName() + ".") : "") : DBUtil.getFullyQualifiedName(par, incSchema) + ".";
        String objName = obj.getName();
        if (objName != null) {
            name = name + objName;
        }
        return name;
    }

    public static Schema getSchema(DBObject obj) {
        if (obj instanceof Schema) {
            return (Schema)obj;
        }
        if (obj instanceof SchemaObject) {
            return ((SchemaObject)obj).getSchema();
        }
        DBObject parent = obj == null ? null : obj.getParent();
        return parent == null ? null : DBUtil.getSchema(parent);
    }

    public static SchemaObject getSchemaObject(DBObject obj) {
        if (obj == null) {
            return null;
        }
        DBObject parent = obj.getParent();
        if (parent != null) {
            return DBUtil.getSchemaObject(parent);
        }
        if (obj instanceof SchemaObject) {
            return (SchemaObject)obj;
        }
        return null;
    }

    public static DBObject getUppermostParent(DBObject obj) {
        DBObject parent = obj.getParent();
        if (parent != null) {
            return DBUtil.getUppermostParent(parent);
        }
        return obj;
    }

    public static DBObjectID getUppermostParent(DBObjectID id) {
        DBObjectID parent;
        if (id instanceof TemporaryObjectID) {
            try {
                DBObject parent2;
                DBObjectID topID;
                DBObject obj = id.resolveID();
                if (obj != null && (topID = (parent2 = DBUtil.getUppermostParent(obj)).getID()) != null) {
                    DBObjectID dBObjectID = topID;
                    return dBObjectID;
                }
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        if ((parent = id.getParent()) != null) {
            return DBUtil.getUppermostParent(parent);
        }
        return id;
    }

    public static Map<Schema, Collection<SchemaObject>> sortIntoSchemas(SchemaObject ... objs) {
        TreeMap<DBObject, ArrayList<SchemaObject>> mapped = new TreeMap<DBObject, ArrayList<SchemaObject>>(DBUtil.getNameComparator());
        SchemaObject[] schemaObjectArray = objs;
        int n = 0;
        while (n < schemaObjectArray.length) {
            SchemaObject obj = schemaObjectArray[n];
            Schema s = obj.getSchema();
            ArrayList<SchemaObject> col = (ArrayList<SchemaObject>)mapped.get(s);
            if (col == null) {
                col = new ArrayList<SchemaObject>();
                mapped.put(s, col);
            }
            col.add(obj);
            ++n;
        }
        return mapped;
    }

    public static DBObject getProviderDefinition(DBObject obj, DBObjectProvider pro) throws DBException {
        DBObject proDefParent;
        if (obj instanceof SchemaObject) {
            return DBUtil.getProviderDefinition((SchemaObject)obj, pro);
        }
        DBObject parent = obj.getParent();
        if (parent != null && (proDefParent = DBUtil.getProviderDefinition(parent, pro)) != null) {
            return proDefParent.findOwnedObject(obj.getType(), obj.getName());
        }
        return null;
    }

    public static SchemaObject getProviderDefinition(SchemaObject obj, DBObjectProvider pro) throws DBException {
        return pro.getObject(obj.getType(), obj.getSchema(), obj.getName());
    }

    public static DBObject getProviderDefinition(DBObject obj, DBObjectProvider pro, String schemaName) throws DBException {
        DBObject proDefParent;
        if (obj instanceof SchemaObject) {
            return DBUtil.getProviderDefinition((SchemaObject)obj, pro, schemaName);
        }
        DBObject parent = obj.getParent();
        if (parent != null && (proDefParent = DBUtil.getProviderDefinition(parent, pro, schemaName)) != null) {
            return proDefParent.findOwnedObject(obj.getType(), obj.getName());
        }
        return null;
    }

    public static SchemaObject getProviderDefinition(SchemaObject obj, DBObjectProvider pro, String schemaName) throws DBException {
        SchemaObject result = null;
        Schema schema = pro.getSchema(schemaName);
        if (schema != null) {
            result = pro.getObject(obj.getType(), schema, obj.getName());
        }
        return result;
    }

    public static SchemaObject[] getProviderDefinitions(SchemaObject[] objs, DBObjectProvider pro) throws DBException {
        SchemaObject[] retval = new SchemaObject[objs.length];
        int i = 0;
        while (i < objs.length) {
            if (objs[i] != null) {
                retval[i] = DBUtil.getProviderDefinition(objs[i], pro);
            }
            ++i;
        }
        return retval;
    }

    public static DBObject getProviderDefinition(ReferenceID refID, DBObjectProvider pro) throws DBException {
        String type = refID.getType();
        if (ModelUtil.hasLength((String)type)) {
            String name = refID.getName();
            DBObjectID par = refID.getParent();
            if (par != null) {
                if (par instanceof ReferenceID) {
                    DBObject parObj = DBUtil.getProviderDefinition((ReferenceID)par, pro);
                    return parObj == null ? null : parObj.findOwnedObject(type, name);
                }
            } else {
                Schema s;
                String schemaName = refID.getSchemaName();
                if (ModelUtil.hasLength((String)schemaName) && ModelUtil.hasLength((String)name) && (s = pro.getSchema(schemaName)) != null) {
                    return pro.getObject(type, s, name);
                }
            }
        }
        return null;
    }

    public static <T> T[] stripNulls(T[] objs) {
        ArrayList<T> retval = new ArrayList<T>();
        int i = 0;
        while (i < objs.length) {
            if (objs[i] != null) {
                retval.add(objs[i]);
            }
            ++i;
        }
        return retval.toArray((Object[])Array.newInstance(objs.getClass().getComponentType(), retval.size()));
    }

    public static String quoteName(String name, String quote) {
        if (ModelUtil.hasLength((String)name) && ModelUtil.hasLength((String)quote)) {
            int idx = name.indexOf(quote);
            while (idx > -1 && idx < name.length()) {
                name = name.substring(0, idx) + quote + name.substring(idx);
                idx = name.indexOf(quote, idx + quote.length() + 1);
            }
            name = quote + name + quote;
        }
        return name;
    }

    public static boolean isDangling(DBObjectID refID) {
        boolean isDangling = false;
        if (refID instanceof DBReferenceID) {
            try {
                DBObject dbo = refID.resolveID();
                isDangling = dbo == null;
            }
            catch (DBException dbe) {
                isDangling = true;
            }
        }
        return isDangling;
    }

    public static Object getOriginalID(DBObject dbo) {
        Object id = dbo.getID();
        while (id != null && id instanceof TemporaryObjectID) {
            try {
                DBObject original = ((TemporaryObjectID)id).resolveOriginalID();
                id = original == null ? null : original.getID();
            }
            catch (Exception e) {
                DBLog.logStackTrace(e);
            }
        }
        if (id == null) {
            id = dbo.getName();
        }
        return id;
    }

    public static List<DBObject> getColumnUsages(DBObjectProvider prov, Column col) {
        ArrayList<DBObject> result = new ArrayList<DBObject>();
        Relation rel = col.getRelation();
        if (rel != null) {
            Constraint[] cons = rel.getConstraints();
            int i = 0;
            while (i < cons.length) {
                Column[] ccols = null;
                Constraint con = cons[i];
                if (con instanceof ColumnConstraint) {
                    ccols = ((ColumnConstraint)con).getColumns();
                }
                if (ccols != null) {
                    int j = 0;
                    while (j < ccols.length) {
                        if (col.equals(ccols[j])) {
                            result.add(con);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (rel instanceof Table) {
            Index[] indexArray = ((Table)rel).getIndexes();
            int n = 0;
            while (n < indexArray.length) {
                Index idx = indexArray[n];
                IndexObject[] indexObjectArray = idx.getColumnExpressions();
                int n2 = 0;
                while (n2 < indexObjectArray.length) {
                    IndexObject idxObject = indexObjectArray[n2];
                    SQLFragment expr = idxObject.getExpression();
                    if (expr != null) {
                        try {
                            for (String[] nameComponents : ParserUtils.getColumnNames(expr.getSQLText(), ParserUtils.ExpressionType.ARITHMETIC)) {
                                if (!col.getName().equals(prov.getInternalName(nameComponents[0]))) continue;
                                result.add(idx);
                                break;
                            }
                        }
                        catch (SQLQueryException e) {
                            DBLog.getLogger().warning(e.getMessage());
                        }
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return result;
    }

    public static FKConstraint[] getReferences(Constraint ucon, DBObjectProvider prov) {
        ArrayList<DBObject> result = new ArrayList<DBObject>();
        if (ucon instanceof UniqueConstraint) {
            SchemaObjectManager man = prov.getObjectManager();
            try {
                DBObjectID[] refs = man.getReferers(ucon);
                int j = 0;
                while (j < refs.length) {
                    DBObject obj = refs[j].resolveID();
                    if (obj instanceof FKConstraint) {
                        result.add(obj);
                    }
                    ++j;
                }
            }
            catch (Exception cme) {
                DBLog.getLogger().log(Level.SEVERE, "Unexpected exception in DNUtil.getReferences", cme);
            }
        }
        return result.toArray(new FKConstraint[0]);
    }

    public static String getDBObjectName(DBObjectID dbObjectID) {
        if (dbObjectID != null) {
            try {
                DBObject dbObject = dbObjectID.resolveID();
                if (dbObject != null) {
                    String string = dbObject.getName();
                    return string;
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (dbObjectID instanceof ReferenceID) {
                return ((ReferenceID)dbObjectID).getName();
            }
        }
        return "";
    }

    public static DBObject resolveInOtherProvider(BaseObjectID id, DBObjectProvider pro) throws DBException {
        BaseObjectID copy;
        DBObject res;
        DBObjectProvider idPro = id.getProvider();
        if (idPro == pro) {
            return id.resolveID();
        }
        if (pro instanceof AbstractDBObjectProvider && (res = (copy = BaseObjectID.copyWithNewProvider(id, (AbstractDBObjectProvider)pro)).resolveID()) != null) {
            return res;
        }
        if (id instanceof NameBasedID) {
            return pro.getObject(id.getType(), pro.getSchema(id.getSchemaName()), id.getName());
        }
        return null;
    }

    public static boolean areEqualIgnoreNullValues(Map map1, Map map2) {
        boolean mapsAreEqual = true;
        if (map1 != map2) {
            HashSet map1Keys = new HashSet();
            if (map1 != null) {
                map1Keys.addAll(map1.keySet());
            }
            HashSet map2Keys = new HashSet();
            if (map2 != null) {
                map2Keys.addAll(map2.keySet());
            }
            for (Object key : map1Keys) {
                Object val2;
                Object val1 = map1.get(key);
                Object v0 = val2 = map2 == null ? null : map2.get(key);
                if (ModelUtil.areDifferent(val1, val2)) {
                    mapsAreEqual = false;
                    break;
                }
                map2Keys.remove(key);
            }
            if (mapsAreEqual) {
                for (Object key : map2Keys) {
                    if (map2.get(key) == null) continue;
                    mapsAreEqual = false;
                    break;
                }
            }
        }
        return mapsAreEqual;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IDQuery
    extends Enum<IDQuery> {
        private static final /* synthetic */ IDQuery[] $v;
        public static final /* enum */ IDQuery INTERNAL;
        public static final /* enum */ IDQuery EXTERNAL;
        public static final /* enum */ IDQuery BOTH;

        public static IDQuery valueOf(String string) {
            return Enum.valueOf(IDQuery.class, string);
        }

        public static final IDQuery[] values() {
            return (IDQuery[])$v.clone();
        }

        static {
            IDQuery[] iDQueryArray = new IDQuery[3];
            iDQueryArray[2] = BOTH = new IDQuery("BOTH", 2);
            iDQueryArray[1] = EXTERNAL = new IDQuery("EXTERNAL", 1);
            iDQueryArray[0] = INTERNAL = new IDQuery("INTERNAL", 0);
            $v = iDQueryArray;
        }

        private IDQuery(String string2, int n2) {
        }
    }
}

