/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectValidator;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseDescriptor {
    public static final String FEATURE_TABLE_PARTITIONING = "TABLE PARTITIONING";
    public static final String FEATURE_GLOBAL_HASH_INDEX_PARTITIONING = "GLOBAL HASH INDEX PARTITIONING";
    public static final String FEATURE_COLUMN_SEQUENCES = "COLUMN SEQUENCES";
    public static final String FEATURE_STORAGE_OPTIONS = "STORAGE OPTIONS";
    public static final String FEATURE_BITMAP_INDEXING = "BITMAP INDEXING";
    public static final String FEATURE_LOB_PARAMETERS = "LOB PARAMETERS";
    public static final String FEATURE_RETENTION = "RETENTION";
    public static final String FEATURE_FREEPOOLS = "FREEPOOLS";
    private DatabaseDescriptor m_base;
    private Charset m_ideCharset;

    protected DatabaseDescriptor() {
    }

    protected DatabaseDescriptor(DatabaseDescriptor base) {
        this.m_base = base;
    }

    protected DatabaseDescriptor getBaseDescriptor() {
        return this.m_base;
    }

    public void setIdeCharset(Charset charSet) {
        this.m_ideCharset = charSet;
    }

    public Charset getIdeCharset() {
        return this.m_ideCharset;
    }

    public final boolean isValidName(String type, String name) {
        try {
            this.validateName(type, name);
        }
        catch (InvalidNameException ine) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public abstract void validateName(String var1, String var2) throws InvalidNameException;

    public abstract int getCasePolicy();

    public int getQuotedNameCasePolicy() {
        if (this.m_base != null) {
            return this.m_base.getQuotedNameCasePolicy();
        }
        return 3;
    }

    public abstract String getIdentifierQuoteString();

    public abstract int getMaxNameLength(String var1);

    public boolean supportsFeature(String feature) {
        if (this.m_base != null) {
            return this.m_base.supportsFeature(feature);
        }
        return false;
    }

    public void validateEncoding(String string, Object property) throws ValidationException {
    }

    protected boolean needsQuoting(String internalName) {
        if (this.m_base != null) {
            return this.m_base.needsQuoting(internalName);
        }
        if (ModelUtil.hasLength((String)internalName) && internalName.length() == internalName.trim().length() && this.isValidName(null, internalName)) {
            switch (this.getCasePolicy()) {
                case 2: {
                    return ModelUtil.areDifferent((Object)internalName, (Object)internalName.toUpperCase());
                }
                case 1: {
                    return ModelUtil.areDifferent((Object)internalName, (Object)internalName.toLowerCase());
                }
            }
            return false;
        }
        return true;
    }

    public String quoteIdentifier(String internalName, boolean force) throws DBException {
        if (this.m_base != null) {
            return this.m_base.quoteIdentifier(internalName, force);
        }
        String quote = this.getIdentifierQuoteString();
        String string = quote = quote != null ? quote.trim() : "";
        if (!ModelUtil.hasLength((String)internalName)) {
            internalName = null;
        } else if (quote.length() == 0) {
            if (!this.isValidName(null, internalName)) {
                internalName = null;
            }
        } else if ((force || this.needsQuoting(internalName)) && !this.isValidName(null, internalName = DBUtil.quoteName(internalName, quote))) {
            internalName = null;
        }
        if (internalName == null) {
            throw new DBException(null, "Invalid name");
        }
        return internalName;
    }

    public String getInternalName(String name, String objectType) {
        if (this.m_base != null) {
            return this.m_base.getInternalName(name, objectType);
        }
        String quote = this.getIdentifierQuoteString();
        int casePolicy = this.getCasePolicy();
        String internalName = name;
        if (ModelUtil.hasLength((String)name)) {
            name = name.trim();
            if (ModelUtil.hasLength((String)quote)) {
                int qLen = quote.length();
                int nLen = name.length();
                int idx1 = name.indexOf(quote);
                int idx2 = name.lastIndexOf(quote);
                if (nLen > qLen && idx1 == 0 && idx2 == nLen - qLen) {
                    internalName = name.substring(idx1 + qLen, idx2);
                    idx1 = internalName.indexOf(quote);
                    while (idx1 > -1 && idx1 < internalName.length()) {
                        idx2 = internalName.indexOf(quote, idx1 + qLen);
                        if (idx2 == idx1 + qLen) {
                            internalName = internalName.substring(0, idx1 + 1) + internalName.substring(idx2 + qLen);
                        }
                        idx1 = internalName.indexOf(quote, idx1 + qLen);
                    }
                }
            }
            if (ModelUtil.areEqual((Object)internalName, (Object)name)) {
                switch (casePolicy) {
                    case 2: {
                        internalName = name.toUpperCase();
                        break;
                    }
                    case 1: {
                        internalName = name.toLowerCase();
                        break;
                    }
                }
            }
        }
        return internalName;
    }

    public String getExternalName(String name, String objectType) {
        try {
            name = this.quoteIdentifier(name, false);
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return name;
    }

    public Map<String, DBObjectValidator> getValidators(Database pro) {
        return this.getValidators(pro.getClass(), pro);
    }

    public abstract Map<String, DBObjectValidator> getValidators(Class<? extends Database> var1, DBObjectProvider var2);

    public DDLGenerator getDDLGenerator(DBObjectProvider pro) {
        return null;
    }

    public static void validateIdentifier(String identifier, char quoter, int maxLength, String allowedChars, String excludedChars, boolean alphaStart, Set reservedWords, int casePolicy) throws InvalidNameException {
        if (!ModelUtil.hasLength((String)identifier)) {
            throw new InvalidNameException(null, DBArb.getString(201));
        }
        if (identifier.charAt(0) == quoter) {
            int len = identifier.length();
            if (identifier.charAt(len - 1) != quoter) {
                throw new InvalidNameException(null, DBArb.format(121, identifier));
            }
            if (len <= 2) {
                throw new InvalidNameException(null, DBArb.format(201, identifier));
            }
            int embeddedQuoteCount = 0;
            int idx = 1;
            while (idx < len - 1) {
                if (excludedChars != null && excludedChars.indexOf(identifier.charAt(idx)) >= 0) {
                    throw new InvalidNameException(null, DBArb.format(353, identifier));
                }
                if (identifier.charAt(idx) == quoter) {
                    if (++idx == len - 1 || identifier.charAt(idx) != quoter) {
                        throw new InvalidNameException(null, DBArb.format(353, identifier));
                    }
                    ++embeddedQuoteCount;
                }
                ++idx;
            }
            if (len - embeddedQuoteCount > maxLength + 2) {
                throw new InvalidNameException(null, DBArb.format(10, identifier));
            }
        } else {
            if (identifier.length() > maxLength) {
                throw new InvalidNameException(null, DBArb.format(10, identifier));
            }
            if (casePolicy == 2) {
                identifier = identifier.toUpperCase();
            } else if (casePolicy == 1) {
                identifier = identifier.toLowerCase();
            }
            if (reservedWords != null && reservedWords.contains(identifier)) {
                throw new InvalidNameException(null, DBArb.format(305, identifier));
            }
            char[] chars = identifier.toCharArray();
            if (alphaStart && !Character.isLetter(chars[0])) {
                throw new InvalidNameException(null, DBArb.format(5, identifier));
            }
            if (allowedChars != null) {
                int i = 1;
                while (i < chars.length) {
                    char c = chars[i];
                    if (!Character.isLetterOrDigit(c) && allowedChars.indexOf(c) < 0) {
                        throw new InvalidNameException(null, DBArb.format(353, identifier));
                    }
                    ++i;
                }
            }
        }
    }

    public static void validateIdentifier(String identifier, char quoter, int maxLength, String allowedChars, boolean alphaStart, Set reservedWords, int casePolicy) throws InvalidNameException {
        DatabaseDescriptor.validateIdentifier(identifier, quoter, maxLength, allowedChars, null, alphaStart, reservedWords, casePolicy);
    }

    public abstract void makeNameValidAndUnique(DBObject var1, DBObjectProvider var2) throws InvalidNameException;
}

