/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Collection;
import java.util.Map;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.ColumnConstraintReferenceID;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FKConstraint
extends ColumnConstraint {
    public static final String CONSTRAINT_TYPE = "FKConstraint";
    public static final int ON_DELETE_RESTRICT = 0;
    public static final int ON_DELETE_CASCADE = 1;
    public static final int ON_DELETE_SET_NULL = 2;
    @Deprecated
    public static final int ON_DELETE_NONE = 0;
    private int m_onDelete;
    private DBObjectID m_refID;
    private boolean m_ignorRefSchema;

    private void $init$() {
        this.m_ignorRefSchema = false;
    }

    public FKConstraint() {
        this.$init$();
    }

    public FKConstraint(String name, Relation relation) {
        super(name, relation);
        this.$init$();
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        FKConstraint copy = target != null ? (FKConstraint)target : new FKConstraint();
        this.copyToImpl(copy, (Relation)copyParent, idPolicy);
        return copy;
    }

    public boolean equals(Object target) {
        return target instanceof FKConstraint && this.equalsImpl((FKConstraint)target);
    }

    protected void copyToImpl(FKConstraint copy, Relation copyParent, IDPolicy idPolicy) {
        super.copyToImpl(copy, copyParent, idPolicy);
        copy.m_onDelete = this.m_onDelete;
        copy.m_refID = this.m_refID;
        if (copyParent != null && !(this.m_refID instanceof ColumnConstraintReferenceID)) {
            Constraint[] constraintArray = copyParent.getConstraints();
            int n = 0;
            while (n < constraintArray.length) {
                DBObjectID id;
                Constraint con = constraintArray[n];
                if (con instanceof PKConstraint && (id = con.getID()) != null && id.equals(this.m_refID, false)) {
                    copy.m_refID = id;
                    break;
                }
                ++n;
            }
        }
    }

    protected boolean equalsImpl(FKConstraint target) {
        return super.equalsImpl(target) && this.m_onDelete == target.m_onDelete && ModelUtil.areEqual((Object)this.m_refID, (Object)target.m_refID);
    }

    public void setIgnorReferencedSchema(boolean flag) {
        this.m_ignorRefSchema = flag;
    }

    public boolean isReferencedSchemaIgnored() {
        return this.m_ignorRefSchema;
    }

    public void setReferenceID(DBObjectID id) {
        this.m_refID = id;
    }

    public DBObjectID getReferenceID() {
        return this.m_refID;
    }

    @Override
    public String getConstraintType() {
        return CONSTRAINT_TYPE;
    }

    public int getDeleteMode() {
        return this.m_onDelete;
    }

    public void setDeleteMode(int onDelete) {
        this.m_onDelete = onDelete;
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        super.getReferenceIDsImpl(refs);
        if (this.m_refID != null) {
            refs.add(this.m_refID);
        }
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> idMap) {
        boolean replaced = super.replaceReferenceIDs(idMap);
        if (this.m_refID != null && idMap.containsKey(this.m_refID)) {
            this.m_refID = idMap.get(this.m_refID);
            replaced = true;
        }
        return replaced;
    }
}

