/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.math.BigDecimal;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.util.ModelUtil;

public class IdentifierBasedID
extends BaseObjectID {
    private Object m_id;

    public IdentifierBasedID() {
    }

    public IdentifierBasedID(String type, Object identifier) {
        this(type, identifier, null);
    }

    public IdentifierBasedID(String type, Object identifier, AbstractDBObjectProvider pro) {
        super(type, pro);
        this.m_id = identifier;
    }

    public IdentifierBasedID(DBObject obj, Object identifier, AbstractDBObjectProvider pro) {
        super(obj, pro);
        this.m_id = identifier;
    }

    public void construct(String id) {
        String[] items = id.split(":");
        String typeString = items[0];
        String idString = items[1];
        this.setType(typeString);
        this.m_id = idString;
        try {
            BigDecimal bd = new BigDecimal(idString);
            this.m_id = bd;
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (items.length > 2) {
            int index = typeString.length() + ":".length() + idString.length() + ":".length();
            this.setParent(BaseObjectID.createFromString(id.substring(index)));
        }
    }

    protected boolean equalsImpl(DBObjectID id, boolean strict) {
        if (strict) {
            return id instanceof IdentifierBasedID && this.equalsImpl((IdentifierBasedID)id);
        }
        if (id instanceof IdentifierBasedID && this.equalsImpl((IdentifierBasedID)id)) {
            return true;
        }
        if (id instanceof BaseObjectID) {
            return id instanceof BaseObjectID && this.hasSameObjectName((BaseObjectID)id);
        }
        return false;
    }

    public final Object getIdentifier() {
        return this.m_id;
    }

    public final void setIdentifier(Object id) {
        this.clearToString();
        this.m_id = id;
    }

    public Object copyTo(Object target) {
        if (target instanceof BaseObjectID && !(target instanceof IdentifierBasedID)) {
            this.copyToImpl((BaseObjectID)target);
            return target;
        }
        IdentifierBasedID copy = target == null ? new IdentifierBasedID() : (IdentifierBasedID)target;
        this.copyToImpl(copy);
        return copy;
    }

    protected void copyToImpl(IdentifierBasedID target) {
        super.copyToImpl(target);
        target.m_id = this.m_id;
    }

    private boolean equalsImpl(IdentifierBasedID target) {
        return ModelUtil.areEqual((Object)target.m_id, (Object)this.m_id) && ModelUtil.areEqual((Object)target.getType(), (Object)this.getType()) && ModelUtil.areEqual((Object)target.getParent(), (Object)this.getParent());
    }

    protected String toStringImpl() {
        StringBuilder builder = new StringBuilder();
        if (ModelUtil.hasLength((String)this.getType())) {
            builder.append(this.getType());
        } else {
            builder.append("UNSPECIFIED_TYPE");
        }
        builder.append(":").append(this.m_id);
        if (this.getParent() instanceof BaseObjectID) {
            builder.append(":").append(this.getParent().toString());
        }
        return builder.toString();
    }
}

