/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.ValidationException;

public class NameInUseException
extends ValidationException {
    private String m_name;
    private String m_userName;
    private String m_userType;

    public NameInUseException(DBObject obj) {
        super(obj, DBArb.format(75, obj == null ? null : obj.getName()));
    }

    public NameInUseException(String name) {
        super(null, DBArb.format(75, name));
    }

    public NameInUseException(String name, String userName, String userType) {
        super(null, NameInUseException.getMessage(name, userName, userType));
        this.m_userType = userType;
        this.m_userName = userName;
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public String getUserType() {
        return this.m_userType;
    }

    private static String getMessage(String name, String userName, String userType) {
        if (userName != null) {
            return DBArb.format(358, name, userType == null ? "" : userType.toLowerCase(), userName);
        }
        return DBArb.format(75, name);
    }
}

