/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DeclarativePlSql;
import oracle.javatools.db.DeclarativePlSqlDelegate;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.property.Transient;

public abstract class PlSqlSubprogram
extends PlSql
implements DeclarativePlSql {
    private final DeclarativePlSqlDelegate m_delegate = new DeclarativePlSqlDelegate(this);

    public PlSqlSubprogram() {
        this((String)null, (Schema)null);
    }

    public PlSqlSubprogram(String name, Schema schema) {
        super(name, schema);
    }

    protected void copyToImpl(PlSqlSubprogram copy, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(copy, copyParent, idPolicy);
        this.m_delegate.copyToImpl(copy.m_delegate, copyParent, idPolicy);
    }

    protected boolean equalsImpl(PlSqlSubprogram target) {
        return super.equalsImpl(target) && this.m_delegate.equalsImpl(target.m_delegate);
    }

    @Deprecated
    @Transient
    public DataType getReturnType() {
        this.checkInit();
        DataType dt = null;
        DBObjectID id = this.m_delegate.getReturnTypeID();
        if (id != null) {
            try {
                dt = (DataType)id.resolveID();
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return dt;
    }

    @Deprecated
    @Transient
    public void setReturnType(DataType returnType) {
        this.checkInit();
        this.m_delegate.setReturnTypeID(returnType.getID());
    }

    public DBObjectID getReturnTypeID() {
        this.checkInit();
        return this.m_delegate.getReturnTypeID();
    }

    public void setReturnTypeID(DBObjectID returnTypeID) {
        this.checkInit();
        this.m_delegate.setReturnTypeID(returnTypeID);
    }

    public void setParameters(PlSqlParameter[] newParams) {
        this.checkInit();
        this.m_delegate.setParameters(newParams);
    }

    public PlSqlParameter[] getParameters() {
        this.checkInit();
        return this.m_delegate.getParameters();
    }

    public void addParameter(PlSqlParameter p) {
        this.checkInit();
        this.m_delegate.addParameter(p);
    }

    public void addParameter(int index, PlSqlParameter param) {
        this.checkInit();
        this.m_delegate.addParameter(index, param);
    }

    public PlSqlParameter getParameter(String name) {
        this.checkInit();
        return this.m_delegate.getParameter(name);
    }

    public void removeParameter(PlSqlParameter param) {
        this.checkInit();
        this.m_delegate.removeParameter(param);
    }

    public String getBody() {
        this.checkInit();
        return this.m_delegate.getBody();
    }

    public void setBody(String body) {
        this.checkInit();
        this.m_delegate.setBody(body);
    }
}

