/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Database;
import oracle.javatools.db.StatementWrapper;

public class QueryWrapper
extends StatementWrapper {
    private ResultSet m_rs;
    private List m_params;
    private boolean m_msgFormat;

    private QueryWrapper() {
        super(null, (String[])null);
    }

    public QueryWrapper(Database db, String query, Object ... params) {
        super(db, query);
        this.setParams(params);
    }

    public QueryWrapper(String name, Connection conn, String query, Object ... params) {
        super(name, conn, query);
        this.setParams(Arrays.asList(params));
    }

    public QueryWrapper(Database db, String query, List params) {
        super(db, query);
        this.setParams(params);
    }

    private void setParams(Object ... params) {
        this.setParams(params == null ? null : Arrays.asList(params));
    }

    private void setParams(List params) {
        this.m_params = params;
        String query = this.getStatementString();
        boolean bl = this.m_msgFormat = query.indexOf("{0}") >= 0;
        if (!(!this.m_msgFormat && query.indexOf("?") < 0 || this.m_params != null && this.m_params.size() >= 1)) {
            throw new IllegalArgumentException("query expects parameters, none given.");
        }
    }

    public QueryWrapper(Database db, String query) {
        this(db, query, (List)null);
    }

    public Statement createStatment() throws SQLException {
        return this.getConnection().prepareStatement(this.getQuery());
    }

    protected String getStatementTextForLog() {
        return this.getQuery();
    }

    protected String getQuery() {
        if (this.m_msgFormat && this.m_params != null) {
            return MessageFormat.format(this.getStatementString(), this.m_params.toArray());
        }
        return this.getStatementString();
    }

    private String getStatementString() {
        return this.getStatementStrings()[0];
    }

    protected List getParameters() {
        if (!this.m_msgFormat && this.m_params != null) {
            return this.m_params;
        }
        return new ArrayList();
    }

    public final boolean execute() throws DBException {
        throw new UnsupportedOperationException("Use executeQuery to execute a QueryWrapper.");
    }

    public void executeQuery(int fetchSize, QueryRunnable run) throws DBException {
        this.doExecute(new 1(this, this, fetchSize, run));
    }

    private ResultSet executeQueryImpl(int fetchSize) throws SQLException {
        PreparedStatement stmt = (PreparedStatement)this.getStatement();
        List params = this.getParameters();
        Object[] convertedParams = null;
        if (params != null && params.size() > 0) {
            convertedParams = new Object[params.size()];
            int i = 0;
            while (i < params.size()) {
                convertedParams[i] = this.convertParam(params.get(i));
                if (!this.m_msgFormat) {
                    if (convertedParams[i] instanceof String) {
                        stmt.setString(i + 1, (String)convertedParams[i]);
                    } else if (convertedParams[i] instanceof Date) {
                        stmt.setDate(i + 1, (Date)convertedParams[i]);
                    } else if (convertedParams[i] instanceof Integer) {
                        stmt.setInt(i + 1, (Integer)convertedParams[i]);
                    } else {
                        stmt.setObject(i + 1, convertedParams[i]);
                    }
                }
                ++i;
            }
        }
        if (fetchSize > 0) {
            try {
                stmt.setFetchSize(fetchSize);
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        QueryWrapper.sqlTrace(this.getConnectionName(), this.getQuery(), convertedParams);
        this.queryStarted();
        try {
            if (this.getDatabase() != null && this.getDatabase() instanceof AbstractDatabase) {
                ((AbstractDatabase)this.getDatabase()).setStatement(stmt);
            }
            this.m_rs = stmt.executeQuery();
        }
        finally {
            if (this.getDatabase() != null && this.getDatabase() instanceof AbstractDatabase) {
                ((AbstractDatabase)this.getDatabase()).setStatement(null);
            }
        }
        return this.m_rs;
    }

    public void executeQuery(QueryRunnable run) throws DBException {
        this.executeQuery(0, run);
    }

    private Object convertParam(Object param) {
        if (param instanceof DBObject) {
            return AbstractDBObjectProvider.convertObject((DBObject)param);
        }
        if (param instanceof Object[]) {
            Object[] forIn = (Object[])param;
            StringBuffer buffy = new StringBuffer();
            int j = 0;
            while (j < forIn.length) {
                buffy.append(this.convertParam(forIn[j]));
                if (j < forIn.length - 1) {
                    buffy.append(", ");
                }
                ++j;
            }
            return buffy.toString();
        }
        return param;
    }

    public void close() {
        if (this.m_rs != null) {
            try {
                this.m_rs.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.close();
    }

    public static QueryWrapper union(QueryWrapper ... wrappers) {
        return new UnionQueryWrapper(wrappers, null);
    }

    QueryWrapper(1 var1_1) {
        this();
    }

    static ResultSet mav$executeQueryImpl(QueryWrapper queryWrapper, int n) {
        return queryWrapper.executeQueryImpl(n);
    }

    final class 1
    extends StatementWrapper.ExecutionRunnable {
        private final /* synthetic */ int v$fetchSize;
        private final /* synthetic */ QueryRunnable v$run;
        final /* synthetic */ QueryWrapper this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object runImpl() throws DBException {
            Connection connection = this.this$0.getConnection();
            synchronized (connection) {
                try {
                    try {
                        this.this$0.setExecuting(true);
                        ResultSet rs = QueryWrapper.mav$executeQueryImpl(this.this$0, this.v$fetchSize);
                        this.v$run.processResultSet(rs);
                    }
                    catch (SQLException sqe) {
                        this.this$0.throwDBException(sqe);
                    }
                }
                finally {
                    this.this$0.close();
                    this.this$0.setExecuting(false);
                }
            }
            return null;
        }

        public 1(QueryWrapper queryWrapper, StatementWrapper statementWrapper, int n, QueryRunnable queryRunnable) {
            this.v$run = queryRunnable;
            this.v$fetchSize = n;
            this.this$0 = queryWrapper;
            super(statementWrapper);
        }
    }

    private static class UnionQueryWrapper
    extends QueryWrapper {
        private static final String UNION_ALL = " UNION ALL\n";
        private QueryWrapper[] m_wrappers;
        private String m_bigQuery;
        private List m_allParams;

        private UnionQueryWrapper(QueryWrapper ... wrappers) {
            super(null);
            if (wrappers == null || wrappers.length < 1) {
                throw new IllegalArgumentException("Nothing to UNION");
            }
            this.m_wrappers = wrappers;
            super.setDatabase(this.m_wrappers[0].getDatabase());
        }

        protected String getQuery() {
            if (this.m_bigQuery == null) {
                this.processWrappers();
            }
            return this.m_bigQuery;
        }

        protected List getParameters() {
            if (this.m_allParams == null) {
                this.processWrappers();
            }
            return this.m_allParams;
        }

        private void processWrappers() {
            this.m_allParams = new ArrayList();
            StringBuffer bigQuery = new StringBuffer();
            int i = 0;
            while (i < this.m_wrappers.length) {
                bigQuery.append(this.m_wrappers[i].getQuery());
                this.m_allParams.addAll(this.m_wrappers[i].getParameters());
                if (i + 1 < this.m_wrappers.length) {
                    bigQuery.append(UNION_ALL);
                }
                ++i;
            }
            this.m_bigQuery = bigQuery.toString();
        }

        UnionQueryWrapper(QueryWrapper[] queryWrapperArray, 1 var2_2) {
            this(queryWrapperArray);
        }

        public final class 1 {
        }
    }

    public static interface QueryRunnable {
        public void processResultSet(ResultSet var1) throws DBException;
    }
}

