/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Collection;
import java.util.Map;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Schema;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Synonym
extends AbstractSchemaObject {
    public static final String TYPE = "SYNONYM";
    public static final String PUBLIC_TYPE = "PUBLIC_SYNONYM";
    private DBObjectID m_ref;
    private boolean m_public;

    public Synonym() {
    }

    public Synonym(String name, Schema schema, DBObjectID ref) {
        super(name, schema);
        this.m_ref = ref;
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        Synonym copy = target != null ? (Synonym)target : new Synonym();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(Synonym copy, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(copy, copyParent, idPolicy);
        copy.m_ref = this.m_ref;
        copy.m_public = this.m_public;
    }

    public boolean equals(Object target) {
        return target instanceof Synonym && this.equalsImpl((Synonym)target);
    }

    protected boolean equalsImpl(Synonym target) {
        return super.equalsImpl(target) && ModelUtil.areEqual((Object)this.m_ref, (Object)target.m_ref) && this.m_public == target.m_public;
    }

    public DBObjectID getReference() {
        this.checkInit();
        return this.m_ref;
    }

    public void setReference(DBObjectID ref) {
        this.checkInit();
        this.m_ref = ref;
    }

    public boolean isPublic() {
        this.checkInit();
        return this.m_public;
    }

    public void setPublic(boolean pub) {
        this.checkInit();
        this.m_public = pub;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        super.getReferenceIDsImpl(refs);
        if (this.m_ref != null) {
            refs.add(this.m_ref);
        }
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> idMap) {
        boolean replaced = super.replaceReferenceIDs(idMap);
        if (this.m_ref != null && idMap.containsKey(this.m_ref)) {
            this.m_ref = idMap.get(this.m_ref);
            replaced = true;
        }
        return replaced;
    }
}

