/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Collection;
import java.util.Map;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.sql.AbstractFromObjectUsage;
import oracle.javatools.db.sql.ColumnKeywordUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewColumn
extends Column {
    private DBObjectID m_selectID;

    public ViewColumn() {
    }

    public ViewColumn(DBObjectID selectID) {
        this.setSelectObjectID(selectID);
    }

    public DBObjectID getSelectObjectID() {
        return this.m_selectID;
    }

    public void setSelectObjectID(DBObjectID selectID) {
        this.m_selectID = selectID;
    }

    private SelectObject getSelectObject() {
        if (this.m_selectID != null) {
            try {
                SelectObject selectObject = (SelectObject)this.m_selectID.resolveID();
                return selectObject;
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getName() {
        String retval = super.getName();
        if (retval == null) {
            SelectObject sel = this.getSelectObject();
            if (sel != null) {
                if (ModelUtil.hasLength((String)sel.getAlias())) {
                    retval = sel.getAlias();
                } else {
                    SQLFragment exp = sel.getExpression();
                    if (exp != null && exp instanceof AbstractFromObjectUsage && (retval = sel.getName()) != null && retval.contains(".")) {
                        retval = retval.substring(retval.indexOf(".") + 1);
                    }
                }
            }
            this.setName(retval);
        }
        return retval == null ? "" : retval;
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        super.getReferenceIDsImpl(refs);
        if (this.m_selectID != null) {
            refs.add(this.m_selectID);
        }
    }

    @Override
    public boolean equals(Object target) {
        return target instanceof ViewColumn && this.equalsImpl((ViewColumn)target);
    }

    public boolean equalsImpl(ViewColumn copy) {
        return super.equalsImpl(copy) && ModelUtil.areEqual((Object)this.m_selectID, (Object)copy.m_selectID);
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        ViewColumn copy = target == null ? new ViewColumn() : (ViewColumn)target;
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(ViewColumn copy, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(copy, copyParent, idPolicy);
        copy.m_selectID = this.m_selectID;
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> idMap) {
        boolean replaced = super.replaceReferenceIDs(idMap);
        if (this.m_selectID != null && idMap.containsKey(this.m_selectID)) {
            this.m_selectID = idMap.get(this.m_selectID);
            replaced = true;
        }
        return replaced;
    }

    public boolean isAsterisk() {
        SelectObject sel = this.getSelectObject();
        if (sel != null && sel.getExpression() != null && sel.getExpression() instanceof ColumnKeywordUsage) {
            String name = sel.getName();
            if (name.indexOf(".") > 0) {
                name = name.substring(name.indexOf(".") + 1);
            }
            if ("*".equals(name)) {
                return true;
            }
        }
        return false;
    }
}

