/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.util.ModelUtil;

public class BaseDateTimeDataType
extends PredefinedDataType {
    private static final int ORACLE_FIRST_YEAR = -4712;
    private static final int ORACLE_LAST_YEAR = 9999;
    private static final List validStringTypes;
    private static final List validDateTimeFunctions;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BaseDateTimeDataType() {
    }

    public BaseDateTimeDataType(int domain, String name) {
        super(domain, name);
    }

    public BaseDateTimeDataType(int domain, String name, String definition, DataTypeAttribute[] attributes) {
        super(domain, name, definition, attributes);
    }

    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        BaseDateTimeDataType copy = target != null ? (BaseDateTimeDataType)target : new BaseDateTimeDataType();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(BaseDateTimeDataType target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
    }

    public boolean equals(Object obj) {
        return obj instanceof BaseDateTimeDataType && this.equalsImpl((BaseDateTimeDataType)obj);
    }

    protected boolean equalsImpl(BaseDateTimeDataType other) {
        return super.equalsImpl(other);
    }

    @Deprecated
    public String validateDateTime(Column column, SimpleDateFormat format, String equivalentOracleFormat) {
        if (column != null) {
            return this.validateDateTime((String)column.getDefault(), format, equivalentOracleFormat, column);
        }
        return null;
    }

    public String validateDateTime(Object defaultValue, SimpleDateFormat format, String equivalentOracleFormat, DBObject context) {
        String strDefaultValue;
        GlobalSettings settings;
        String errorMessage = null;
        if (defaultValue instanceof String && (settings = GlobalSettings.getInstance()) != null && settings.isValidateDateTime() && ModelUtil.hasLength((String)(strDefaultValue = defaultValue.toString().trim())) && !strDefaultValue.equalsIgnoreCase("null")) {
            errorMessage = this.isQuoted(strDefaultValue) ? this.validateUsingFormat(strDefaultValue, format, equivalentOracleFormat, context) : this.validateDateExpr(strDefaultValue, context);
        }
        return errorMessage;
    }

    static {
        $assertionsDisabled = BaseDateTimeDataType.class.desiredAssertionStatus() ^ true;
        validStringTypes = new ArrayList<Integer>(Arrays.asList(new Integer(5), new Integer(17), new Integer(23)));
        validDateTimeFunctions = new ArrayList<Integer>(Arrays.asList(new Integer(37), new Integer(38), new Integer(45), new Integer(46), new Integer(47), new Integer(48), new Integer(49), new Integer(50), new Integer(51), new Integer(52), new Integer(53), new Integer(54), new Integer(55), new Integer(56), new Integer(57), new Integer(58), new Integer(59), new Integer(60), new Integer(61), new Integer(62), new Integer(63), new Integer(64), new Integer(65), new Integer(66), new Integer(67), new Integer(68), new Integer(69), new Integer(70), new Integer(71), new Integer(72), new Integer(75), new Integer(76), new Integer(94), new Integer(95), new Integer(277), new Integer(278), new Integer(290), new Integer(374), new Integer(298), new Integer(169)));
    }

    private String validateDateExpr(String defaultValue, DBObject context) {
        String error = null;
        String errorMessage = null;
        PlsqlNode node = null;
        try {
            PlsqlRoot parseTree = ParserUtils.parseQueryString(defaultValue, 2);
            if (!$assertionsDisabled && parseTree.getUnits().length != 1) {
                throw new AssertionError((Object)("Expecting 1 parse unit but got " + parseTree.getUnits().length));
            }
            node = parseTree.getUnits()[0];
            ParserUtils.checkErrors(parseTree, defaultValue);
        }
        catch (SQLQueryException x) {
            error = DBArb.format(114, x.getMessage());
        }
        if (!ParserUtils.isAllowedStringType(node, validStringTypes) && !ParserUtils.isAllowedExpression(node, validDateTimeFunctions)) {
            error = DBArb.format(114, defaultValue);
        }
        if (error != null) {
            errorMessage = DBArb.format(286, this.getErrorMessageContext(defaultValue, context), error);
        }
        return errorMessage;
    }

    private String validateUsingFormat(String defaultValue, SimpleDateFormat format, String equivalentOracleFormat, DBObject context) {
        String errorMessage = null;
        HashMap pos = new HashMap();
        String strippedDef = this.stripSpacesAndSeperators(defaultValue, pos);
        boolean ok = true;
        int offset = 0;
        String error = "";
        ParsePosition parsePosn = new ParsePosition(0);
        Date date = format.parse(strippedDef, parsePosn);
        if (date == null || parsePosn.getIndex() != strippedDef.length()) {
            ok = false;
            offset = parsePosn.getErrorIndex();
            if (-1 == offset) {
                offset = parsePosn.getIndex();
            }
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int year = calendar.get(1);
            if (year < -4712 || year > 9999) {
                ok = false;
                error = DBArb.format(225, Integer.toString(year));
            }
        }
        if (!ok) {
            String errLocation = "";
            if (pos.containsKey(new Integer(offset))) {
                int oldOffset = (Integer)pos.get(new Integer(offset));
                errLocation = DBArb.format(182, defaultValue.substring(oldOffset));
            } else {
                errLocation = "ran out of input characters";
            }
            errorMessage = DBArb.format(285, new Object[]{this.getErrorMessageContext(defaultValue, context), errLocation, error, equivalentOracleFormat});
        }
        return errorMessage;
    }

    private String getErrorMessageContext(String defaultValue, DBObject context) {
        String dataTypeName;
        String dbObjectName = context != null ? context.getName() : "";
        String dbObjectType = context != null ? context.getType() : "";
        String string = dataTypeName = context instanceof DataType ? context.getName() : "";
        if (context instanceof Column) {
            try {
                dataTypeName = DataTypeHelper.getDataType(((Column)context).getDataTypeUsage()).getName();
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        String errorMessageContext = DBArb.format(179, new Object[]{dbObjectType, dbObjectName, dataTypeName, defaultValue});
        return errorMessageContext;
    }

    private boolean isQuoted(String defaultValue) {
        String trimmed = defaultValue.trim();
        return trimmed.length() > 1 && trimmed.startsWith("'") && trimmed.endsWith("'");
    }

    /*
     * Unable to fully structure code
     */
    private String stripSpacesAndSeperators(String defaultValue, HashMap pos) {
        def = new StringBuffer();
        chars = defaultValue.toCharArray();
        i = 0;
        j = 0;
        ** GOTO lbl20
        {
            ++i;
            do {
                if (i < chars.length && Character.isWhitespace(chars[i])) continue block0;
                if (chars.length == i) break block0;
                if (!Character.isLetterOrDigit(chars[i])) {
                    ++i;
                }
                while (i < chars.length && Character.isWhitespace(chars[i])) {
                    ++i;
                }
                if (chars.length == i) break block0;
                def.append(chars[i]);
                pos.put(new Integer(j++), new Integer(i++));
lbl20:
                // 2 sources

            } while (i < chars.length);
        }
        strippedDef = def.toString();
        return strippedDef;
    }
}

