/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.math.BigInteger;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DefaultValueValidationException;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.datatypes.PredefinedDataTypeUsage;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.parser.plsql.data.PlsqlNode;

public class BinaryDataType
extends PredefinedDataType {
    static final /* synthetic */ boolean $assertionsDisabled;

    public BinaryDataType() {
    }

    public BinaryDataType(int domain, String name) {
        super(domain, name);
    }

    public BinaryDataType(int domain, String name, String definition, DataTypeAttribute[] attributes) {
        super(domain, name, definition, attributes);
    }

    public BinaryDataType(int domain, String name, long minSize, long maxSize) {
        super(domain, name);
        this.addAttribute(new DataTypeAttribute("size", minSize, maxSize), 0);
    }

    public BinaryDataType(int domain, String name, String definition, long minSize, long maxSize, long defaultSize, boolean isSizeMandatory, DataTypeAttribute[] attributes) {
        super(domain, name, definition, attributes);
        this.addAttribute(new DataTypeAttribute("size", 311, minSize, new Long(maxSize), new Long(defaultSize), isSizeMandatory), 0);
    }

    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        BinaryDataType copy = target != null ? (BinaryDataType)target : new BinaryDataType();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(BinaryDataType target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
    }

    public boolean equals(Object obj) {
        return obj instanceof BinaryDataType && this.equalsImpl((BinaryDataType)obj);
    }

    protected boolean equalsImpl(BinaryDataType other) {
        return super.equalsImpl(other);
    }

    static {
        $assertionsDisabled = BinaryDataType.class.desiredAssertionStatus() ^ true;
    }

    public void validateDefaultValue(Object defaultValue, DataTypeUsage dataTypeUsage, DBObject dbObject) throws DefaultValueValidationException {
        super.validateDefaultValue(defaultValue, dataTypeUsage, dbObject);
        if (defaultValue instanceof String) {
            String strDefaultValue;
            String string = strDefaultValue = defaultValue == null ? null : defaultValue.toString().trim();
            if ("RAW".equals(this.getName())) {
                PlsqlNode node = BinaryDataType.parseDefaultValue(strDefaultValue, this, dbObject);
                String hexstr = ParserUtils.getHexToRawString(node);
                if (hexstr == null) {
                    hexstr = ParserUtils.getString(node);
                }
                if (hexstr != null) {
                    int defaultValueLength;
                    Long dataTypeSize;
                    hexstr = hexstr.replace('\'', ' ').trim();
                    try {
                        BigInteger hexval = new BigInteger(hexstr, 16);
                    }
                    catch (NumberFormatException ne) {
                        throw new DefaultValueValidationException(dbObject, this.getName(), DBArb.format(102, hexstr));
                    }
                    if (!$assertionsDisabled && !(dataTypeUsage instanceof PredefinedDataTypeUsage)) {
                        throw new AssertionError();
                    }
                    PredefinedDataTypeUsage usage = (PredefinedDataTypeUsage)dataTypeUsage;
                    DataTypeAttribute size = this.getDataTypeAttribute("size");
                    Long l = dataTypeSize = size != null && size.isDeclarable() ? DataTypeHelper.getLongAttributeValue(usage, "size") : size.getMaxValue();
                    if (dataTypeSize == null) {
                        dataTypeSize = (Long)size.getDefaultValue();
                    }
                    if (dataTypeSize != null && (long)(defaultValueLength = hexstr.length()) > dataTypeSize * (long)2) {
                        throw new DefaultValueValidationException(dbObject, this.getName(), DBArb.format(338, new Long(defaultValueLength), dataTypeSize));
                    }
                }
            } else if (dataTypeUsage != null && defaultValue != null && strDefaultValue.length() > 1 && strDefaultValue.charAt(0) == '\'' && strDefaultValue.charAt(strDefaultValue.length() - 1) == '\'') {
                CharacterDataType.validateDefaultValue(defaultValue, this, dataTypeUsage, dbObject);
            }
        }
    }
}

