/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.Map;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.DefaultValueValidationException;
import oracle.javatools.db.datatypes.ObjectTypeUsage;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexType
extends SpecPlSql
implements DataType {
    public static final String TYPE = "TYPE";
    public static final String OBJECT_TYPECODE = "OBJECT";
    public static final String COLLECTION_TYPECODE = "COLLECTION";
    public static final String BODY_TYPE = "TYPE BODY";
    public static final String TABLE_TYPE = "TABLE";
    public static final String VARRAY_TYPE = "VARYING ARRAY";
    private boolean m_isFinal;
    private boolean m_isInstantiable;
    private String m_typeCode;
    private String m_collType;

    private void $init$() {
        this.m_typeCode = OBJECT_TYPECODE;
        this.m_collType = "";
    }

    public ComplexType() {
        this.$init$();
    }

    public ComplexType(String name, Schema schema) {
        super(name, schema);
        this.$init$();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        ComplexType copy = target != null ? (ComplexType)target : new ComplexType();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    public boolean equals(Object target) {
        return target instanceof ComplexType && this.equalsImpl((ComplexType)target);
    }

    protected void copyToImpl(ComplexType copy, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(copy, copyParent, idPolicy);
        copy.m_typeCode = this.m_typeCode;
        copy.m_collType = this.m_collType;
        copy.m_isFinal = this.m_isFinal;
        copy.m_isInstantiable = this.m_isInstantiable;
    }

    protected boolean equalsImpl(ComplexType target) {
        return super.equalsImpl(target) && ModelUtil.areEqual((Object)this.m_typeCode, (Object)target.m_typeCode) && ModelUtil.areEqual((Object)this.m_collType, (Object)target.m_collType) && this.m_isFinal == target.m_isFinal && this.m_isInstantiable == target.m_isInstantiable;
    }

    public boolean isFinal() {
        this.checkInit();
        return this.m_isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.checkInit();
        this.m_isFinal = isFinal;
    }

    public boolean isInstantiable() {
        this.checkInit();
        return this.m_isInstantiable;
    }

    public void setInstantiable(boolean isInstantiable) {
        this.checkInit();
        this.m_isInstantiable = isInstantiable;
    }

    public String getTypeCode() {
        this.checkInit();
        return this.m_typeCode;
    }

    public void setTypeCode(String typeCode) {
        if (typeCode == null || typeCode.equals("")) {
            this.m_typeCode = typeCode;
            this.getChildSupport().clearChildren(DataTypeAttribute.class);
        } else if (OBJECT_TYPECODE.equals(typeCode) || COLLECTION_TYPECODE.equals(typeCode) || this.getSchema() != null && "SYS".equals(this.getSchema().getName()) && this.getName().equals(typeCode)) {
            this.m_typeCode = typeCode;
        } else {
            throw new IllegalArgumentException("ComplexType: Invalid typecode " + typeCode);
        }
    }

    public String getCollectionType() {
        this.checkInit();
        return this.m_collType;
    }

    public void setCollectionType(String collType) {
        if (collType == null || collType.equals("") || TABLE_TYPE.equals(collType) || VARRAY_TYPE.equals(collType)) {
            this.m_collType = collType == null ? "" : collType;
        } else if (collType != null && !collType.equals("")) {
            throw new IllegalArgumentException("ComplexType: Invalid collType " + collType);
        }
    }

    @Override
    public String getDDL(DataTypeUsage dataTypeUsage) {
        StringBuffer fsb = new StringBuffer();
        Schema s = this.getSchema();
        if (s != null) {
            fsb.append(s.getName()).append(".");
        }
        fsb.append(this.getName());
        return fsb.toString();
    }

    @Override
    public DataTypeAttribute[] getDataTypeAttributes() {
        return null;
    }

    @Override
    public boolean hasDataTypeAttribute(String name) {
        return false;
    }

    @Override
    public DataTypeAttribute getDataTypeAttribute(String name) {
        return null;
    }

    @Override
    public DataTypeUsage createDefaultUsage() {
        return new ObjectTypeUsage(this);
    }

    @Override
    public DataTypeUsage createUsage(Map<String, Object> attributes) {
        return new ObjectTypeUsage(this);
    }

    @Override
    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dbObject) throws DataTypeValidationException {
    }

    @Override
    public void validateDefaultValue(Object defaultValue, DataTypeUsage dataTypeUsage, DBObject dbObject) throws DefaultValueValidationException {
    }
}

