/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.ddl.DefaultTokenGenerator;
import oracle.javatools.db.ddl.TokenDDLGenerator;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BundleDDLGenerator<T extends DDLType>
extends TokenDDLGenerator<T> {
    private ResourceBundle[] m_bundles;

    public BundleDDLGenerator(DBObjectProvider pro, ResourceBundle ... bundles) {
        super(pro);
        this.m_bundles = bundles;
        this.registerBundleTokens();
    }

    protected final String findResource(String key) {
        MissingResourceException mre = null;
        if (this.m_bundles != null) {
            ResourceBundle[] resourceBundleArray = this.m_bundles;
            int n = 0;
            while (n < resourceBundleArray.length) {
                ResourceBundle rb = resourceBundleArray[n];
                try {
                    String string = rb.getString(key);
                    return string;
                }
                catch (MissingResourceException e) {
                    mre = e;
                    ++n;
                }
            }
        }
        if (mre == null) {
            mre = new MissingResourceException("no resource found for " + key, null, key);
        }
        throw mre;
    }

    protected final void registerBundleTokens() {
        if (this.m_bundles == null || this.m_bundles.length == 0) {
            DBLog.getLogger().severe("no registered resource bundles");
        } else {
            ResourceBundle[] resourceBundleArray = this.m_bundles;
            int n = 0;
            while (n < resourceBundleArray.length) {
                ResourceBundle rb = resourceBundleArray[n];
                Enumeration<String> keys = rb.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    String[] toks = key.split("\\.");
                    if (key.startsWith("GLOBAL")) {
                        if (toks.length > 1) {
                            this.registerTokenGenerator(key.substring(7), key);
                            continue;
                        }
                        DBLog.getLogger().log(Level.WARNING, "GLOBAL keyword found with no following .tokenName: " + key);
                        continue;
                    }
                    if (toks.length == 3) {
                        this.registerDDLFromBundle(toks, rb, key);
                        continue;
                    }
                    if (toks.length != 4) continue;
                    try {
                        Integer.parseInt(toks[3]);
                        this.registerDDLFromBundle(toks, rb, key);
                    }
                    catch (NumberFormatException nfe) {
                        DBLog.getLogger().log(Level.WARNING, "fourth component not an int for: " + key);
                    }
                }
                ++n;
            }
        }
    }

    private void registerTokenGenerator(String token, String key) {
        this.registerTokenGenerator(token, new DefaultTokenGenerator(this.findResource(key)));
    }

    private void registerDDLFromBundle(String[] toks, ResourceBundle bundle, String key) {
        String type = toks[0];
        String action = toks[1];
        String ddlTypeString = toks[2];
        if (!ModelUtil.hasLength((String)type)) {
            DBLog.getLogger().severe("invalid bundle key (missing type): " + key);
        } else {
            if (Metadata.getInstance().getObjectClass(type) == null) {
                DBLog.getLogger().warning("unknown object type for: " + key);
            }
            DDLType ddlType = null;
            try {
                ddlType = (DDLType)this.getDDLType(ddlTypeString);
            }
            catch (Exception e) {
                DBLog.getLogger().log(Level.SEVERE, "invalid bundle key (invalid ddltype): " + key, e);
            }
            if (ddlType == null) {
                DBLog.getLogger().severe("invalid bundle key (no ddltype): " + key);
            } else if (action.equals("CREATE")) {
                this.registerCreateDDL(type, bundle.getString(key), ddlType);
            } else if (action.equals("ALTER")) {
                this.registerAlterDDL(type, bundle.getString(key), ddlType);
            } else if (action.equals("DROP")) {
                this.registerDropDDL(type, bundle.getString(key), ddlType);
            } else if (action.equals("UNDELETE")) {
                this.registerUndeleteDDL(type, bundle.getString(key), ddlType);
            } else {
                DBLog.getLogger().severe("invalid bundle key (unknown action): " + key);
            }
        }
    }

    protected abstract T getDDLType(String var1);

    protected final void registerBundleCreateDDL(String type, String resName, T ddlType) {
        this.registerCreateDDL(type, this.findResource(resName), (DDLType)ddlType);
    }

    protected final void registerBundleDropDDL(String type, String resName, T ddlType) {
        this.registerDropDDL(type, this.findResource(resName), (DDLType)ddlType);
    }

    protected final void registerBundleUndeleteDDL(String type, String resName, T ddlType) {
        this.registerUndeleteDDL(type, this.findResource(resName), (DDLType)ddlType);
    }

    protected final void registerBundleAlterDDL(String type, String resName, T ddlType) {
        this.registerAlterDDL(type, this.findResource(resName), (DDLType)ddlType);
    }
}

