/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.List;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ddl.AbstractDDLGenerator;
import oracle.javatools.db.ddl.AlterDDLGenerator;
import oracle.javatools.db.ddl.CreateDDLGenerator;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.ddl.DropDDLGenerator;
import oracle.javatools.db.ddl.GeneratorCache;
import oracle.javatools.db.ddl.UndeleteDDLGenerator;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.property.PropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DDLGeneratorImpl<T extends DDLType>
extends AbstractDDLGenerator {
    private GeneratorCache m_cache;

    private void $init$() {
        this.m_cache = new GeneratorCache();
    }

    public DDLGeneratorImpl(DBObjectProvider pro) {
        super(pro);
        this.$init$();
    }

    private List<CreateDDLGenerator> getCreateGenerators(String type) {
        return this.m_cache.getGenerators(CreateDDLGenerator.class, type);
    }

    protected final void registerCreateGenerator(String type, CreateDDLGenerator creator) {
        this.m_cache.registerGenerator(CreateDDLGenerator.class, type, creator);
    }

    private List<DropDDLGenerator> getDropGenerators(String type) {
        return this.m_cache.getGenerators(DropDDLGenerator.class, type);
    }

    protected final void registerDropGenerator(String type, DropDDLGenerator dropper) {
        this.m_cache.registerGenerator(DropDDLGenerator.class, type, dropper);
    }

    private List<AlterDDLGenerator> getAlterGenerators(String type) {
        return this.m_cache.getGenerators(AlterDDLGenerator.class, type);
    }

    protected final void registerAlterGenerator(String type, AlterDDLGenerator deletor) {
        this.m_cache.registerGenerator(AlterDDLGenerator.class, type, deletor);
    }

    private List<UndeleteDDLGenerator> getUndeleteGenerators(String type) {
        return this.m_cache.getGenerators(UndeleteDDLGenerator.class, type);
    }

    protected final void registerUndeleteGenerator(String type, UndeleteDDLGenerator undeletor) {
        this.m_cache.registerGenerator(UndeleteDDLGenerator.class, type, undeletor);
    }

    @Override
    protected DDL<T> getCreateDDLImpl(DDLOptions options, DBObject ... objects) {
        DDL ddl = null;
        DBObject[] dBObjectArray = objects;
        int n = 0;
        while (n < dBObjectArray.length) {
            List<CreateDDLGenerator> gens;
            DBObject obj = dBObjectArray[n];
            if (ddl == null) {
                ddl = new DDL();
            }
            if ((gens = this.getCreateGenerators(obj.getType())) == null || gens.size() == 0) {
                throw new UnsupportedOperationException("Create DDL not supported for " + obj.getType());
            }
            boolean deleteRequired = true;
            for (CreateDDLGenerator gen : gens) {
                if (gen.canReplace()) {
                    deleteRequired = false;
                }
                ddl.append(gen.getCreateDDL(options, obj));
            }
            if (options.isReplace() && deleteRequired) {
                ddl.append(this.getDeleteDDL(options, obj));
            }
            ++n;
        }
        return this.finish(options, ddl);
    }

    @Override
    protected DDL<T> getDeleteDDLImpl(DDLOptions options, DBObject ... objects) {
        DDL ddl = null;
        DBObject[] dBObjectArray = objects;
        int n = 0;
        while (n < dBObjectArray.length) {
            List<DropDDLGenerator> gens;
            DBObject obj = dBObjectArray[n];
            if (ddl == null) {
                ddl = new DDL();
            }
            if ((gens = this.getDropGenerators(obj.getType())) == null || gens.size() == 0) {
                throw new UnsupportedOperationException("Delete DDL not supported for " + obj.getType());
            }
            for (DropDDLGenerator gen : gens) {
                ddl.append(gen.getDropDDL(options, obj));
            }
            ++n;
        }
        return this.finish(options, ddl);
    }

    @Override
    public DDL<T> getUndeleteDDL(DDLOptions options, DBObject ... objects) {
        DDL ddl = null;
        DBObject[] dBObjectArray = objects;
        int n = 0;
        while (n < dBObjectArray.length) {
            List<UndeleteDDLGenerator> gens;
            DBObject obj = dBObjectArray[n];
            if (ddl == null) {
                ddl = new DDL();
            }
            if ((gens = this.getUndeleteGenerators(obj.getType())) == null || gens.size() == 0) {
                throw new UnsupportedOperationException("Undelete not supported for " + obj.getType());
            }
            for (UndeleteDDLGenerator gen : gens) {
                ddl.append(gen.getUndeleteDDL(options, obj));
            }
            ++n;
        }
        return this.finish(options, ddl);
    }

    @Override
    protected DDL<T> getUpdateDDLImpl(DDLOptions options, ResultSet rs) {
        DBObject a = (DBObject)rs.a();
        String type = a.getType();
        List<AlterDDLGenerator> gens = this.getAlterGenerators(type);
        if (gens == null || gens.size() == 0) {
            throw new UnsupportedOperationException("Alter not supported for " + type);
        }
        DDL ddl = null;
        for (AlterDDLGenerator ddlgen : gens) {
            DDL next = ddlgen.getAlterDDL(options, rs);
            if (next == null || next.size() <= 0) continue;
            if (ddl == null) {
                ddl = next;
                continue;
            }
            ddl.append(next);
        }
        return this.finish(options, ddl);
    }

    @Override
    protected boolean canCreate(String type, String prop) {
        List<CreateDDLGenerator> gens = this.getCreateGenerators(type);
        for (CreateDDLGenerator ddlgen : gens) {
            if (!ddlgen.canCreate(prop)) continue;
            return true;
        }
        return super.canCreate(type, prop);
    }

    protected DDL<T> finish(DDLOptions options, DDL<T> ddl) {
        if (options.isIncludePrompts()) {
            return ddl.copyWithPrompts();
        }
        return ddl;
    }

    @Override
    public boolean supportsAction(String type, PropertyAction action) {
        boolean supported = false;
        switch (1.$sm$oracle$javatools$db$property$PropertyAction[action.ordinal()]) {
            case 1: 
            case 2: {
                supported = this.m_cache.containsType(CreateDDLGenerator.class, type);
                break;
            }
            case 3: {
                supported = this.m_cache.containsType(AlterDDLGenerator.class, type);
                break;
            }
            case 4: {
                supported = this.m_cache.containsType(DropDDLGenerator.class, type);
                break;
            }
            case 5: {
                supported = this.m_cache.containsType(UndeleteDDLGenerator.class, type);
                break;
            }
        }
        if (!supported) {
            supported = super.supportsAction(type, action);
        }
        return supported;
    }

    @Override
    protected boolean canChangeWithAlter(DBObject orig, DBObject update, String prop) {
        String type = update.getType();
        List<AlterDDLGenerator> gens = this.getAlterGenerators(type);
        for (AlterDDLGenerator ddlgen : gens) {
            if (!ddlgen.canAlter(prop)) continue;
            return true;
        }
        return false;
    }

    static class 1 {
        static final /* synthetic */ int[] $sm$oracle$javatools$db$property$PropertyAction;

        static {
            int[] nArray = new int[PropertyAction.values().length];
            $sm$oracle$javatools$db$property$PropertyAction = nArray;
            try {
                nArray[PropertyAction.CREATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$property$PropertyAction[PropertyAction.REPLACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$property$PropertyAction[PropertyAction.ALTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$property$PropertyAction[PropertyAction.DELETE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$property$PropertyAction[PropertyAction.UNDELETE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

