/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ddl.TokenContext;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyIterator;
import oracle.javatools.marshal.ToStringManager;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TokenProcessor {
    private Map<String, TokenGenerator> m_tokenGenerators;
    private PropertyHelper m_propHelper;

    private void $init$() {
        this.m_tokenGenerators = new HashMap<String, TokenGenerator>();
        this.m_propHelper = new PropertyHelper();
    }

    public TokenProcessor() {
        this.$init$();
        this.registerDefaults();
    }

    private void registerDefaults() {
        this.registerGenerator("replace", new TokenGenerator.ReplaceGenerator());
        this.registerGenerator("cascade", new TokenGenerator.CascadeGenerator());
        this.registerGenerator("schema.name", new TokenGenerator.NameGenerator());
    }

    public void registerGenerator(String name, TokenGenerator generator) {
        String[] reservedWords;
        String[] stringArray = reservedWords = new String[]{"each", "old", "this"};
        int n = 0;
        while (n < stringArray.length) {
            String s = stringArray[n];
            if (name.startsWith(s)) {
                throw new TokenProcessorException("cannot register generator token names starting with \"" + s + "\"");
            }
            ++n;
        }
        generator.setProcessor(this);
        TokenGenerator replaced = this.m_tokenGenerators.put(name, generator);
        if (replaced != null) {
            DBLog.getLogger().log(Level.CONFIG, "Replaced {0} with {1} for token {2}", new Object[]{replaced.getClass().getName(), generator.getClass().getName(), name});
        }
    }

    boolean canProcess(Object obj) {
        return this.m_tokenGenerators.containsKey(this.getKey(obj));
    }

    private String getKey(Object obj) {
        if (obj instanceof DBObject) {
            String type = ((DBObject)obj).getType();
            if (obj instanceof Constraint) {
                return type + "." + ((Constraint)obj).getConstraintType();
            }
            return type;
        }
        return null;
    }

    void process(Object obj, TokenContext context) {
        String key = this.getKey(obj);
        TokenGenerator gen = this.m_tokenGenerators.get(key);
        if (gen == null) {
            throw new TokenProcessorException("No generator found for object " + key);
        }
        context.setProcessor(this);
        gen.generateToken(context);
    }

    public void process(String code, TokenContext context) {
        context.setProcessor(this);
        this.process(code, 0, code.length() - 1, context);
    }

    private void process(String code, int startAt, int endAt, TokenContext context) {
        while (startAt >= 0 && startAt <= endAt) {
            startAt = this.processNext(code, startAt, endAt, context);
        }
    }

    private int processNext(String code, int startAt, int endAt, TokenContext context) {
        if (startAt >= code.length() || startAt > endAt) {
            return -1;
        }
        char start = code.charAt(startAt);
        if (start == '[') {
            int blockEnd = this.findMatching('[', ']', code, ++startAt);
            this.processBlock(code, startAt, blockEnd - 1, context);
            return this.skipWhitespace(code, blockEnd + 1, context);
        }
        if (start == '{') {
            int tokenEnd = this.findMatching('{', '}', code, ++startAt);
            this.processToken(code, startAt, tokenEnd - 1, context, TokenAction.GENERATE);
            return this.skipWhitespace(code, tokenEnd + 1, context);
        }
        context.append(Character.valueOf(start));
        return ++startAt;
    }

    private int findMatching(char open, char close, String code, int startAt) {
        int lookAt = startAt;
        int nest = 0;
        while (lookAt < code.length()) {
            char looking = code.charAt(lookAt);
            if (looking == open) {
                ++nest;
            } else if (looking == close && nest-- == 0) {
                return lookAt;
            }
            ++lookAt;
        }
        throw new TokenProcessorException(open, close, code, startAt);
    }

    private void processBlock(String code, int startAt, int endAt, TokenContext context) {
        block19: {
            int elseStart;
            int startAgainAt;
            block21: {
                Object[] tokenResult;
                int tokenEnd;
                boolean invert;
                block20: {
                    String block = code.substring(startAt, endAt + 1);
                    boolean loop = block.endsWith("...");
                    String seperator = "";
                    if (loop) {
                        endAt -= 3;
                        while (endAt > startAt) {
                            char sepTest = code.charAt(endAt);
                            if (sepTest == ' ') {
                                --endAt;
                                break;
                            }
                            if (sepTest == '}' || sepTest == ']') break;
                            seperator = seperator + sepTest;
                            --endAt;
                        }
                        if (seperator.length() == 0) {
                            seperator = ", ";
                        }
                    }
                    invert = false;
                    char start = code.charAt(startAt);
                    if (start == '!') {
                        invert = true;
                        start = code.charAt(++startAt);
                    }
                    if (start != '{') break block19;
                    tokenEnd = this.findMatching('{', '}', code, ++startAt);
                    tokenResult = this.processToken(code, startAt, tokenEnd - 1, context, loop ? TokenAction.FOREACH : TokenAction.IF);
                    if (!loop) break block20;
                    if (tokenResult != null) {
                        if (!(tokenResult instanceof Object[])) {
                            if (tokenResult instanceof Collection) {
                                tokenResult = ((Collection)tokenResult).toArray();
                            } else {
                                throw new TokenProcessorException("can't loop without an array property at index ", code, startAt);
                            }
                        }
                        int startAgainAt2 = this.skipWhitespace(code, tokenEnd + 1, context);
                        int length = context.length();
                        Object[] objectArray = tokenResult;
                        int n = 0;
                        while (n < objectArray.length) {
                            Object obj = objectArray[n];
                            if (obj != null) {
                                context.setLoopObject(obj);
                                if (context.length() > length) {
                                    context.append(seperator);
                                    length = context.length();
                                }
                                this.process(code, startAgainAt2, endAt, context);
                            }
                            ++n;
                        }
                    }
                    context.removeIfEndsWith(seperator);
                    context.setLoopObject(null);
                    break block19;
                }
                Boolean result = this.evaluateIf(tokenResult);
                if (result == null) break block19;
                startAgainAt = this.skipWhitespace(code, tokenEnd + 1, context);
                String blockCode = code.substring(startAgainAt, endAt + 1);
                elseStart = -1;
                int innerBlock = 0;
                int i = 0;
                while (i < blockCode.length()) {
                    char c = blockCode.charAt(i);
                    if (c == '[') {
                        ++innerBlock;
                    } else if (c == ']') {
                        ++innerBlock;
                    } else if (c == ':' && innerBlock == 0) {
                        elseStart = i;
                        break;
                    }
                    ++i;
                }
                if (result == null || result == invert) break block21;
                if (elseStart >= 0) {
                    endAt = this.ignoreWhitespace(code, startAgainAt + elseStart - 1, context);
                }
                this.process(code, startAgainAt, endAt, context);
                break block19;
            }
            if (elseStart < 0) break block19;
            startAgainAt = this.skipWhitespace(code, startAgainAt + elseStart + 1, context);
            this.process(code, startAgainAt, endAt, context);
        }
    }

    private Object processToken(String code, int startAt, int endAt, TokenContext context, TokenAction action) {
        String tokenName = code.substring(startAt, endAt + 1);
        return this.processToken(tokenName, context, action);
    }

    private Object processToken(String tokenName, TokenContext context, TokenAction action) {
        char firstChar;
        Operator op = Operator.findOperator(tokenName);
        if (op != null) {
            return this.processOperator(op, tokenName, context, action);
        }
        boolean quote = false;
        if (tokenName.charAt(0) == '\"') {
            if (tokenName.charAt(tokenName.length() - 1) != '\"') {
                throw new TokenProcessorException("tokens starting with \" should end with \" to indiate quoting is required.");
            }
            if (tokenName.charAt(1) != '$') {
                throw new TokenProcessorException("token quoting is only available on property lookups (i.e. \"$propName\"");
            }
            quote = true;
            tokenName = tokenName.substring(1, tokenName.length() - 1);
        }
        if (tokenName.startsWith("each")) {
            Object loopObj = context.getLoopObject();
            if (loopObj == null) {
                throw new TokenProcessorException("\"each\" cannot be used outside of a loop");
            }
            if (tokenName.equals("each")) {
                context.append(loopObj);
                return null;
            }
            if (tokenName.startsWith("each.")) {
                String eachToken = tokenName.substring(5).trim();
                TokenContext tc = context.newChildContext(loopObj);
                return this.processToken(eachToken, tc, action);
            }
        } else {
            if (tokenName.startsWith("old.")) {
                String oldToken = tokenName.substring(4);
                if (!context.isUpdate()) {
                    throw new TokenProcessorException("\"old\" can only be used in update DDL");
                }
                if (tokenName.length() < 1) {
                    throw new TokenProcessorException("\"old.\" must be followed by a valid token");
                }
                ResultSet rs = context.getResultSet();
                Object oldObj = rs.a();
                if (oldObj == null) {
                    throw new TokenProcessorException("no old object to process for token: " + tokenName);
                }
                return this.processToken(oldToken, context.newChildContext(oldObj), action);
            }
            if (tokenName.startsWith("this")) {
                if (tokenName.equals("this")) {
                    context.append(context.getObject());
                    return null;
                }
                if (tokenName.startsWith("this.")) {
                    tokenName = tokenName.substring(5);
                }
            }
        }
        if ((firstChar = tokenName.charAt(0)) == '$') {
            return this.processProperty(tokenName.substring(1), context, quote, action);
        }
        if (firstChar == '^') {
            if (!context.isUpdate()) {
                throw new TokenProcessorException("\"^\" can only be used in update DDL");
            }
            if (action == TokenAction.IF || action == TokenAction.FOREACH) {
                return this.getChangedProperty(tokenName.substring(1), context);
            }
            throw new TokenProcessorException("\"^\" can only be used in an if - e.g. [{^propThatChanged} NEW PROP TEXT]");
        }
        if (firstChar == '+' || firstChar == '-') {
            if (action != TokenAction.FOREACH) {
                throw new TokenProcessorException("\"+\" and \"-\" can only be used in a loop - e.g. [{+newChildren} {each} ...]");
            }
            if (!context.isUpdate()) {
                throw new TokenProcessorException("\"+\" and \"-\" can only be used in update DDL");
            }
            String propName = tokenName.substring(1);
            ResultSet rs = context.getResultSet();
            for (ResultSet propRS : rs.getAllObjectsMap().values()) {
                if (!propRS.getPropertyName().equals(propName)) continue;
                return this.getObjects(propRS, firstChar == '+');
            }
            return null;
        }
        TokenGenerator gen = this.m_tokenGenerators.get(tokenName);
        if (gen == null) {
            throw new GeneratorMissingException(tokenName);
        }
        if (action == TokenAction.GENERATE) {
            gen.generateToken(context);
            return null;
        }
        return gen.evaluateToken(context);
    }

    private String operatorArgToString(Object value) {
        if (value instanceof ResultSet) {
            return Boolean.toString(((ResultSet)value).isSame() ^ true);
        }
        if (ToStringManager.converterAvailable((Object)value)) {
            return ToStringManager.toString((Object)value);
        }
        return "" + value;
    }

    private boolean processOperator(Operator oper, String fullText, TokenContext context, TokenAction action) {
        String opText = Operator.toString(oper);
        int opStart = fullText.indexOf(opText);
        String param1 = fullText.substring(0, opStart).trim();
        String param2 = fullText.substring(opStart + opText.length()).trim();
        Object value1 = this.processToken(param1, context, action);
        String valueString1 = this.operatorArgToString(value1);
        Object value2 = null;
        String valueString2 = null;
        try {
            value2 = this.processToken(param2, context, action);
            valueString2 = this.operatorArgToString(value2);
        }
        catch (GeneratorMissingException gme) {
            valueString2 = param2;
        }
        if (valueString2.contains(",")) {
            String[] banana = valueString2.split(",");
            HashSet<String> vars = new HashSet<String>(banana.length);
            String[] stringArray = banana;
            int n = 0;
            while (n < stringArray.length) {
                String v = stringArray[n];
                vars.add(v.trim());
                ++n;
            }
            boolean result = vars.contains(valueString1);
            return oper == Operator.EQ == result;
        }
        boolean param2IsNull = valueString2.equals("null");
        if (oper == Operator.EQ) {
            if (value1 == null) {
                return param2IsNull;
            }
            return valueString1.equals(valueString2);
        }
        if (oper == Operator.NE) {
            if (value1 == null) {
                return param2IsNull ^ true;
            }
            return valueString1.equals(valueString2) ^ true;
        }
        if (oper == Operator.AND || oper == Operator.OR) {
            boolean b1 = false;
            if (valueString1 != null) {
                b1 = valueString1.equalsIgnoreCase("false") ^ true;
            }
            if (b1 && oper == Operator.OR) {
                return true;
            }
            if (!b1 && oper == Operator.AND) {
                return false;
            }
            boolean b2 = false;
            if (valueString2 != null) {
                b2 = valueString2.equalsIgnoreCase("false") ^ true;
            }
            return b2;
        }
        if (value1 instanceof Number) {
            int valueInt = ((Number)value1).intValue();
            Integer num = null;
            num = value2 instanceof Number ? Integer.valueOf(((Number)value2).intValue()) : Integer.valueOf(valueString2);
            int comparison = new Integer(valueInt).compareTo(num);
            if (oper == Operator.LE) {
                return comparison <= 0;
            }
            if (oper == Operator.GE) {
                return comparison >= 0;
            }
            if (oper == Operator.LT) {
                return comparison < 0;
            }
            if (oper == Operator.GT) {
                return comparison > 0;
            }
        }
        return false;
    }

    private Object[] getObjects(ResultSet propRS, boolean bOnly) {
        List<ResultSet> rss = bOnly ? propRS.getBonlyList() : propRS.getAonlyList();
        Object[] retval = new Object[rss == null ? 0 : rss.size()];
        int i = 0;
        while (i < retval.length) {
            ResultSet rs = rss.get(i);
            retval[i] = bOnly ? rs.b() : rs.a();
            ++i;
        }
        return retval;
    }

    private Object getChangedProperty(String tokenName, TokenContext context) {
        ResultSet rs = context.getResultSet();
        if (rs == null) {
            throw new TokenProcessorException("Processing update code requires a ResultSet");
        }
        String[] propPath = tokenName.split("/");
        boolean found = false;
        ResultSet propRs = rs;
        String[] stringArray = propPath;
        int n = 0;
        block0: while (n < stringArray.length) {
            String s = stringArray[n];
            found = false;
            if (!ModelUtil.hasLength((String)s)) {
                throw new TokenProcessorException("invalid property path " + tokenName);
            }
            for (ResultSet childRs : propRs.getAllObjectsMap().values()) {
                if (childRs == null || !s.equals(childRs.getName())) continue;
                propRs = childRs;
                found = true;
                ++n;
                continue block0;
            }
        }
        if (found) {
            if (propRs.getType() == "LIST") {
                return propRs.getModifiedObjectList();
            }
            return propRs;
        }
        return null;
    }

    private Object processProperty(String tokenName, TokenContext context, boolean quote, TokenAction action) {
        String propName = tokenName.trim();
        Object value = this.getPropertyValue(propName, context);
        if (action == TokenAction.GENERATE) {
            if (quote) {
                context.appendName((String)value);
            } else {
                context.append(value);
            }
        } else {
            return value;
        }
        return null;
    }

    private int skipWhitespace(String code, int startAt, TokenContext context) {
        if (context.length() == 0 || context.endsWithWhitespace()) {
            while (startAt < code.length() && ' ' == code.charAt(startAt)) {
                ++startAt;
            }
        }
        return startAt;
    }

    private int ignoreWhitespace(String code, int endAt, TokenContext context) {
        if (context.endsWithWhitespace()) {
            while (endAt >= 0 && Character.isWhitespace(code.charAt(endAt))) {
                --endAt;
            }
        }
        return endAt;
    }

    private Boolean evaluateIf(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof ResultSet) {
            return ((ResultSet)obj).isSame() ^ true;
        }
        return true;
    }

    private Object getPropertyValue(String propName, TokenContext context) {
        return this.m_propHelper.getPropertyValue(context.getObject(), propName);
    }

    public Collection<String> getCreatePropertyPaths(String code, String type, DBObjectProvider provider) {
        return this.findProperties(code, false, type, provider);
    }

    public Collection<String> getAlterPropertyPaths(String code, String type, DBObjectProvider provider) {
        return this.findProperties(code, true, type, provider);
    }

    Collection<String> findProperties(String code, boolean alter, String type, DBObjectProvider pro) {
        HashSet<String> retval = new HashSet<String>();
        this.findProperties(code, retval, alter, type, pro);
        return retval;
    }

    private void findProperties(String code, Collection<String> retval, boolean alter, String type, DBObjectProvider pro) {
        int i = 0;
        while (i < code.length()) {
            int blockEnd;
            String block;
            char next = code.charAt(i);
            if (next == '[' && (block = code.substring(i + 1, blockEnd = this.findMatching('[', ']', code, i + 1))).endsWith("...")) {
                ArrayList<String> blockToks = new ArrayList<String>();
                this.findProperties(block, blockToks, alter, type, pro);
                if (blockToks.size() > 0) {
                    PropertyIterator iter;
                    PropertyInfo info;
                    Class<? extends DBObject> objclz;
                    String baseTok = (String)blockToks.get(0);
                    retval.add(baseTok);
                    int j = 1;
                    while (j < blockToks.size()) {
                        retval.add(baseTok + "/" + (String)blockToks.get(j));
                        ++j;
                    }
                    if (!alter && block.contains("{each}") && (objclz = Metadata.getInstance().getObjectClass(type)) != null && (info = (iter = new PropertyIterator(objclz, pro == null ? null : pro.getClass())).getPropertyInfos().get(baseTok)) != null) {
                        String propType;
                        TokenGenerator g;
                        Class<?> propClass = info.getPropertyClass();
                        if (propClass.isArray()) {
                            propClass = propClass.getComponentType();
                        }
                        if (DBObject.class.isAssignableFrom(propClass) && (g = this.m_tokenGenerators.get(propType = Metadata.getType(propClass))) != null) {
                            for (String finallyThere : g.getPropertiesProcessed(propType, pro)) {
                                retval.add(baseTok + "/" + finallyThere);
                            }
                        }
                    }
                }
                i = blockEnd;
            } else if (next == '{') {
                int tokenEnd = this.findMatching('{', '}', code, i + 1);
                String token = code.substring(i + 1, tokenEnd);
                this.findPropertiesInToken(token, retval, alter, type, pro);
            }
            ++i;
        }
    }

    private void findPropertiesInToken(String token, Collection<String> retval, boolean alter, String type, DBObjectProvider pro) {
        Operator oper = Operator.findOperator(token);
        if (oper != null) {
            String[] args;
            String[] stringArray = args = token.split(Pattern.quote(Operator.toString(oper)));
            int n = 0;
            while (n < stringArray.length) {
                String s = stringArray[n];
                this.findPropertiesInToken(s.trim(), retval, alter, type, pro);
                ++n;
            }
        } else {
            char[] cArray;
            if (alter) {
                char[] cArray2 = new char[3];
                cArray2[0] = 94;
                cArray2[1] = 43;
                cArray = cArray2;
                cArray2[2] = 45;
            } else {
                char[] cArray3 = new char[1];
                cArray = cArray3;
                cArray3[0] = 36;
            }
            char[] ident = cArray;
            boolean prop = false;
            char start = token.charAt(0);
            int i = 0;
            while (i < ident.length) {
                if (start == ident[i]) {
                    prop = true;
                }
                ++i;
            }
            if (prop) {
                retval.add(token.substring(1));
            } else if (!alter) {
                if (token.startsWith("each.")) {
                    retval.add(token.substring(5));
                } else {
                    TokenGenerator g = this.m_tokenGenerators.get(token);
                    if (g != null) {
                        retval.addAll(g.getPropertiesProcessed(type, pro));
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TokenAction
    extends Enum<TokenAction> {
        private static final /* synthetic */ TokenAction[] $v;
        public static final /* enum */ TokenAction IF;
        public static final /* enum */ TokenAction FOREACH;
        public static final /* enum */ TokenAction GENERATE;

        public static TokenAction valueOf(String string) {
            return Enum.valueOf(TokenAction.class, string);
        }

        public static final TokenAction[] values() {
            return (TokenAction[])$v.clone();
        }

        static {
            TokenAction[] tokenActionArray = new TokenAction[3];
            tokenActionArray[2] = GENERATE = new TokenAction("GENERATE", 2);
            tokenActionArray[1] = FOREACH = new TokenAction("FOREACH", 1);
            tokenActionArray[0] = IF = new TokenAction("IF", 0);
            $v = tokenActionArray;
        }

        private TokenAction(String string2, int n2) {
        }
    }

    class TokenProcessorException
    extends IllegalStateException {
        public TokenProcessorException(String msg) {
            super(msg);
        }

        public TokenProcessorException(String error, String code, int startAt) {
            super(error + " at index " + startAt);
        }

        public TokenProcessorException(char open, char missing, String code, int startAt) {
            super("Missing " + missing + " to match opening " + open + " at index " + startAt);
        }
    }

    class GeneratorMissingException
    extends TokenProcessorException {
        public GeneratorMissingException(String token) {
            super("No generator found for token " + token);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Operator
    extends Enum<Operator> {
        private static final /* synthetic */ Operator[] $v;
        public static final /* enum */ Operator EQ;
        public static final /* enum */ Operator NE;
        public static final /* enum */ Operator LE;
        public static final /* enum */ Operator GE;
        public static final /* enum */ Operator LT;
        public static final /* enum */ Operator GT;
        public static final /* enum */ Operator OR;
        public static final /* enum */ Operator AND;
        private static String[] strings;

        public static Operator valueOf(String string) {
            return Enum.valueOf(Operator.class, string);
        }

        public static final Operator[] values() {
            return (Operator[])$v.clone();
        }

        static {
            Operator[] operatorArray = new Operator[8];
            operatorArray[7] = AND = new Operator("AND", 7);
            operatorArray[6] = OR = new Operator("OR", 6);
            operatorArray[5] = GT = new Operator("GT", 5);
            operatorArray[4] = LT = new Operator("LT", 4);
            operatorArray[3] = GE = new Operator("GE", 3);
            operatorArray[2] = LE = new Operator("LE", 2);
            operatorArray[1] = NE = new Operator("NE", 1);
            operatorArray[0] = EQ = new Operator("EQ", 0);
            $v = operatorArray;
            strings = new String[]{"==", "!=", "<=", ">=", "<", ">", "||", "&&"};
        }

        public static Operator findOperator(String haystack) {
            int i = 0;
            while (i < strings.length) {
                if (haystack.contains(strings[i])) {
                    return Operator.values()[i];
                }
                ++i;
            }
            return null;
        }

        public static String toString(Operator oper) {
            Operator[] opers = Operator.values();
            int i = 0;
            while (i < opers.length) {
                if (opers[i] == oper) {
                    return strings[i];
                }
                ++i;
            }
            return null;
        }

        private Operator(String string2, int n2) {
        }
    }
}

