/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.dictionary;

import java.sql.Connection;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.QueryWrapper;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.dictionary.DictionaryDatabase;

public abstract class DictionaryDBObjectBuilder
extends AbstractDBObjectBuilder {
    private DictionaryDatabase m_db;

    protected DictionaryDBObjectBuilder(DictionaryDatabase db, String type) {
        super(db, type);
        this.m_db = db;
    }

    protected DictionaryDatabase getDatabase() {
        return this.m_db;
    }

    protected final Connection getConnection() {
        return this.m_db.getConnection();
    }

    protected QueryWrapper newQueryWrapper(String query, Object ... params) {
        return new QueryWrapper((Database)this.m_db, query, params);
    }

    protected void sqlTrace(String query, Object[] params) {
        QueryWrapper.sqlTrace(this.m_db.getName(), query, params);
    }

    private String getTimestampKey(SchemaObject obj) {
        return this.getClass().getSimpleName() + ":" + obj.getType() + ":" + obj.getName();
    }

    public final void buildObject(SchemaObject object) throws DBException {
        this.m_db.suspendTimestampQueries(this.getTimestampKey(object));
        try {
            super.buildObject(object);
        }
        finally {
            this.m_db.resumeTimestampQueries(this.getTimestampKey(object));
        }
    }

    public final void buildObjectComponent(SchemaObject object, String key) throws DBException {
        this.m_db.suspendTimestampQueries(this.getTimestampKey(object));
        try {
            super.buildObjectComponent(object, key);
        }
        finally {
            this.m_db.resumeTimestampQueries(this.getTimestampKey(object));
        }
    }

    protected abstract void fillInObject(SchemaObject var1) throws DBException;
}

