/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.dictionary;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.QueryWrapper;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ddl.DDLDatabase;
import oracle.javatools.db.dictionary.DictionaryQueries;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DictionaryDatabase
extends DDLDatabase {
    private Map<DBObjectID, Long> m_timestamps;
    private Set<String> m_timestampKeys;

    private void $init$() {
        this.m_timestampKeys = new HashSet<String>();
    }

    protected DictionaryDatabase(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
        this.$init$();
    }

    protected final QueryWrapper newQueryWrapper(String query, Object ... params) {
        return this.newQueryWrapper(query, Arrays.asList(params));
    }

    protected QueryWrapper newQueryWrapper(String query, List params) {
        return new QueryWrapper((Database)this, query, params);
    }

    protected abstract DictionaryQueries getDictionaryQueries();

    protected boolean isSupportedType(String type) {
        return this.getBuilderForType(type) != null;
    }

    @Override
    public boolean supportsTimestamps() {
        return this.getDictionaryQueries().getTimestampQueryByID() != null || this.getDictionaryQueries().getTimestampQueryByName("TABLE") != null;
    }

    public synchronized void suspendTimestampQueries(String key) {
        if (this.m_timestamps == null) {
            this.m_timestamps = new HashMap<DBObjectID, Long>();
            DBLog.log("Database {0}: timestamp suspend", this.getName());
        } else {
            DBLog.log("Database {0}: timestamp suspend called for key {1} but suspend already active", this.getName(), key);
        }
        this.m_timestampKeys.add(key);
    }

    public synchronized void resumeTimestampQueries(String key) {
        if (this.m_timestampKeys.remove(key)) {
            if (this.m_timestampKeys.size() == 0) {
                this.m_timestamps = null;
                DBLog.log("Database {0}: timestamp resume", this.getName());
            } else {
                DBLog.log("Database {0}: timestamp resume called for key {1} but other keys remain.", this.getName(), key);
            }
        }
    }

    protected QueryWrapper[] getListQueries(String[] types, Schema schema, String ref) {
        QueryWrapper[] wrappers;
        DictionaryQueries dictionary = this.getDictionaryQueries();
        ArrayList<QueryWrapper> queries = new ArrayList<QueryWrapper>();
        ref = !ModelUtil.hasLength((String)ref) ? "%" : ref.replaceAll("\\'", "\\'\\'");
        Schema defSchema = null;
        try {
            defSchema = this.getDefaultSchema();
        }
        catch (DBException dbe) {
            // empty catch block
        }
        String schemaName = schema == null ? null : schema.getName();
        boolean defaultSchema = ModelUtil.areEqual((Object)schemaName, (Object)(defSchema == null ? null : defSchema.getName()));
        ArrayList<String> standardObj = new ArrayList<String>();
        int i = 0;
        while (i < types.length) {
            if (this.isSupportedType(types[i])) {
                if (dictionary.isCustomListQuery(types[i], defaultSchema, schemaName)) {
                    String query = dictionary.getCustomListQuery(types[i], defaultSchema, schemaName);
                    List params = this.getParameters(dictionary.getCustomListQueryParams(types[i], defaultSchema, schemaName), schema, ref, new String[]{types[i]});
                    QueryWrapper qw = this.newQueryWrapper(query, params);
                    qw.setIdentifier(types[i]);
                    queries.add(qw);
                } else {
                    standardObj.add(types[i]);
                }
            }
            ++i;
        }
        Object standardQueryParams = null;
        if (standardObj.size() > 0) {
            String[] standardTypes = standardObj.toArray(new String[standardObj.size()]);
            String query = dictionary.getStandardListQuery(standardTypes);
            List params = this.getParameters(dictionary.getStandardListQueryParams(), schema, ref, standardTypes);
            QueryWrapper qw = this.newQueryWrapper(query, params);
            queries.add(0, qw);
        }
        if ((wrappers = queries.toArray(new QueryWrapper[queries.size()])).length > 1 && dictionary.canUnionListQueries()) {
            wrappers = new QueryWrapper[]{QueryWrapper.union(wrappers)};
        }
        return wrappers;
    }

    private String convertArrayToList(String[] types) {
        StringBuffer buf = new StringBuffer(types.length * 32);
        if (types.length > 0) {
            buf.append('\'').append(types[0]).append('\'');
            int i = 1;
            while (i < types.length) {
                buf.append(',').append('\'').append(types[i]).append('\'');
                ++i;
            }
        }
        return buf.toString();
    }

    public final DBObjectID createID(Schema schema, String name, String type, Object id) {
        if (id == null) {
            return new NameBasedID(type, schema.getName(), name, this);
        }
        IdentifierBasedID ibid = new IdentifierBasedID(type, id, (AbstractDBObjectProvider)this);
        ibid.setName(name);
        if (schema != null) {
            ibid.setSchemaName(schema.getName());
        }
        return ibid;
    }

    @Override
    protected final Collection<SchemaObject> listObjectsImpl(String[] objectTypes, Schema schema, String ref) throws DBException {
        ArrayList<SchemaObject> objects = new ArrayList<SchemaObject>();
        QueryWrapper[] queries = this.getListQueries(objectTypes, schema, ref);
        if (queries != null) {
            Integer maxi = null;
            try {
                maxi = Integer.getInteger("oracle.db.MaxFetchCount");
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            int maxCount = maxi == null ? Integer.MAX_VALUE : maxi;
            int i = 0;
            while (i < queries.length) {
                QueryWrapper wrap = queries[i];
                1 r = new 1(this, wrap, schema, objects, maxCount);
                queries[i].executeQuery(500, r);
                ++i;
            }
        }
        return objects;
    }

    protected final List getParameters(DictionaryQueries.Params[] params, Schema schema, String nameref, String[] typeList) {
        return this.getParameters(params, schema == null ? null : schema.getName(), nameref, typeList);
    }

    protected final List getParameters(DictionaryQueries.Params[] params, String schema, String nameref, String[] typeList) {
        ArrayList<String> retval = new ArrayList<String>();
        int i = 0;
        while (i < params.length) {
            switch (7.$sm$oracle$javatools$db$dictionary$DictionaryQueries$Params[params[i].ordinal()]) {
                case 1: {
                    retval.add(schema);
                    break;
                }
                case 2: {
                    if (typeList.length > 0 && typeList[0].equals("DATABASE LINK") && nameref != null && !nameref.endsWith("%")) {
                        retval.add(nameref + "%");
                        break;
                    }
                    retval.add(nameref);
                    break;
                }
                case 3: {
                    String typeListString = this.convertArrayToList(typeList);
                    retval.add(typeListString);
                    break;
                }
                case 4: {
                    retval.addAll(Arrays.asList(typeList));
                    break;
                }
            }
            ++i;
        }
        return retval;
    }

    @Override
    public final Long getExternalTimestamp(SchemaObject object) throws DBException {
        Long ts;
        DBObjectID id = object.getID();
        Long l = ts = id != null ? this.getExternalTimestampByID(id) : this.getExternalTimestampByName(object.getType(), object.getSchema(), object.getName());
        if (ts != null) {
            AbstractDBObjectBuilder tableBuilder;
            String type = object.getType();
            if ("PACKAGE".equals(type) || "TYPE".equals(type)) {
                Long tsBody = this.getExternalTimestampByName(type + " BODY", object.getSchema(), object.getName());
                if (tsBody != null && tsBody.compareTo(ts) > 0) {
                    ts = tsBody;
                }
            } else if ("TABLE".equals(type) && !(tableBuilder = (AbstractDBObjectBuilder)this.getBuilderForType(type)).needsBuilding((AbstractSchemaObject)object, "INDEX", true)) {
                String key = "5501663 : Suspend getting timestamps while getting indexes";
                this.suspendTimestampQueries(key);
                Index[] indexes = ((Table)object).getIndexes();
                this.resumeTimestampQueries(key);
                Index[] indexArray = indexes;
                int n = 0;
                while (n < indexArray.length) {
                    Index index = indexArray[n];
                    Long idxTs = this.getExternalTimestamp(index);
                    if (idxTs == null && index.getID() != null) {
                        idxTs = this.getExternalTimestampByName(index.getType(), index.getSchema(), index.getName());
                    }
                    if (idxTs == null) {
                        Long existing = (Long)object.getProperty("Timestamp");
                        if (existing != null && existing.equals(ts)) {
                            ts = ts + 1L;
                        }
                    } else if (idxTs.compareTo(ts) > 0) {
                        ts = idxTs;
                    }
                    ++n;
                }
            }
        }
        return ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Long getExternalTimestampByID(DBObjectID id) throws DBException {
        Long result = null;
        DictionaryDatabase dictionaryDatabase = this;
        synchronized (dictionaryDatabase) {
            if (this.m_timestamps != null && this.m_timestamps.containsKey(id)) {
                DBLog.log("Database {0}: timestamp query skipped for id {1}", this.getName(), id);
                Long l = this.m_timestamps.get(id);
                return l;
            }
        }
        String query = this.getDictionaryQueries().getTimestampQueryByID();
        if (id instanceof IdentifierBasedID && query != null) {
            Holder holder = new Holder();
            QueryWrapper qw = this.newQueryWrapper(query, ((IdentifierBasedID)id).getIdentifier());
            2 r = new 2(this, holder, qw);
            qw.executeQuery(r);
            result = (Long)holder.get();
        } else if (id instanceof BaseObjectID) {
            BaseObjectID baseID = (BaseObjectID)id;
            Schema s = this.getSchema(baseID.getSchemaName());
            result = this.getExternalTimestampByName(baseID.getType(), s, baseID.getName());
        }
        if (result != null && this.m_timestamps != null) {
            this.m_timestamps.put(id, result);
        }
        return result;
    }

    protected final Long getExternalTimestampByName(String type, Schema schema, String objectName) {
        Long result = null;
        String query = this.getDictionaryQueries().getTimestampQueryByName(type);
        if (query != null) {
            Holder holder = new Holder();
            QueryWrapper qw = this.newQueryWrapper(query, schema, objectName, type);
            3 r = new 3(this, holder, qw);
            try {
                qw.executeQuery(r);
            }
            catch (DBException dbe) {
                // empty catch block
            }
            result = (Long)holder.get();
        }
        return result;
    }

    @Override
    protected synchronized Map<String, Schema> loadSchemasImpl() throws DBException {
        TreeMap<String, Schema> schemas = new TreeMap<String, Schema>();
        QueryWrapper wrap = this.newQueryWrapper(this.getDictionaryQueries().getSchemasQuery(), new Object[0]);
        4 r = new 4(this, schemas, wrap);
        wrap.executeQuery(500, r);
        return schemas;
    }

    @Override
    public final boolean exists(String type, String schema, String name) {
        DictionaryQueries dictionary = this.getDictionaryQueries();
        String query = dictionary.getExistsQuery(type);
        if (query == null) {
            return super.exists(type, schema, name);
        }
        Holder exists = new Holder((Object)false);
        List params = this.getParameters(dictionary.getExistsQueryParams(type), schema, name, new String[]{type});
        QueryWrapper wrap = this.newQueryWrapper(query, params);
        5 r = new 5(this, exists, wrap);
        try {
            wrap.executeQuery(r);
        }
        catch (DBException dbe) {
            DBLog.logStackTrace(dbe);
        }
        return (Boolean)exists.get();
    }

    @Override
    protected final SchemaObject createByIDImpl(DBObjectID id) throws DBException {
        AbstractSchemaObject object = null;
        String type = id.getType();
        DBObjectBuilder builder = this.getBuilderForType(type);
        if (builder != null) {
            if (id instanceof IdentifierBasedID) {
                String query;
                Object ident = ((IdentifierBasedID)id).getIdentifier();
                if (builder != null && (query = this.getDictionaryQueries().getObjectQueryByID(type)) != null) {
                    Holder holder = new Holder();
                    QueryWrapper wrap = this.newQueryWrapper(query, ident);
                    6 r = new 6(this, holder, builder, id, wrap);
                    wrap.executeQuery(r);
                    object = (AbstractSchemaObject)holder.get();
                }
            } else if (id instanceof NameBasedID) {
                Schema owner = this.getSchema(((NameBasedID)id).getSchemaName());
                String name = ((NameBasedID)id).getName();
                object = (AbstractSchemaObject)builder.createObject(name, owner, id);
            }
            if (object != null) {
                object.setID(id);
                this.markForLazyInit(object);
                this.cacheObject(object, true);
            }
        } else {
            object = (AbstractSchemaObject)super.createByIDImpl(id);
        }
        return object;
    }

    static Schema mav$createSchema(DictionaryDatabase dictionaryDatabase, String string) {
        return dictionaryDatabase.createSchema(string);
    }

    static SchemaObject mav$findObject(DictionaryDatabase dictionaryDatabase, String string, Schema schema, String string2) {
        return dictionaryDatabase.findObject(string, schema, string2);
    }

    static DBObjectBuilder mav$getBuilderForType(DictionaryDatabase dictionaryDatabase, String string) {
        return dictionaryDatabase.getBuilderForType(string);
    }

    static void mav$markForLazyInit(DictionaryDatabase dictionaryDatabase, AbstractSchemaObject abstractSchemaObject) {
        dictionaryDatabase.markForLazyInit(abstractSchemaObject);
    }

    static void mav$cacheObject(DictionaryDatabase dictionaryDatabase, SchemaObject schemaObject, boolean bl) {
        dictionaryDatabase.cacheObject(schemaObject, bl);
    }

    final class 1
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ QueryWrapper v$wrap;
        private final /* synthetic */ Schema v$schema;
        private final /* synthetic */ Collection v$objects;
        private final /* synthetic */ int v$maxCount;
        final /* synthetic */ DictionaryDatabase this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                int count = 0;
                while (rs.next()) {
                    if (!Thread.currentThread().isInterrupted()) {
                        Object idVal;
                        String type;
                        int cols = rs.getMetaData().getColumnCount();
                        String name = rs.getString(1);
                        String string = type = cols < 2 ? this.v$wrap.getIdentifier() : rs.getString(2).trim();
                        if (!ModelUtil.hasLength((String)type)) {
                            throw new DBException(null, "Query is listing objects with an unknown type.");
                        }
                        type = type.toUpperCase();
                        Object object = idVal = cols < 3 ? null : rs.getObject(3);
                        if (idVal instanceof String && ((String)idVal).equalsIgnoreCase("null") || idVal instanceof Number && ((Number)idVal).intValue() == 0) {
                            idVal = null;
                        }
                        DBObjectID id = this.this$0.createID(this.v$schema, name, type, idVal);
                        SchemaObject object2 = DictionaryDatabase.mav$findObject(this.this$0, type, this.v$schema, name);
                        if (object2 == null || ModelUtil.areDifferent((Object)object2.getID(), (Object)id)) {
                            DBObjectBuilder builder = DictionaryDatabase.mav$getBuilderForType(this.this$0, type);
                            if (builder == null) {
                                throw new DBException(null, "missing builder for type " + type);
                            }
                            object2 = builder.createObject(name, this.v$schema, id);
                            DictionaryDatabase.mav$markForLazyInit(this.this$0, (AbstractSchemaObject)object2);
                            DictionaryDatabase.mav$cacheObject(this.this$0, object2, true);
                        }
                        if (object2 != null) {
                            this.v$objects.add(object2);
                        }
                        if (++count < this.v$maxCount) {
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (SQLException sqe) {
                this.v$wrap.throwDBException(sqe);
            }
        }

        public 1(DictionaryDatabase dictionaryDatabase, QueryWrapper queryWrapper, Schema schema, Collection collection, int n) {
            this.v$maxCount = n;
            this.v$objects = collection;
            this.v$schema = schema;
            this.v$wrap = queryWrapper;
            this.this$0 = dictionaryDatabase;
        }
    }

    final class 2
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Holder v$holder;
        private final /* synthetic */ QueryWrapper v$qw;
        final /* synthetic */ DictionaryDatabase this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                Timestamp t;
                if (rs.next() && (t = rs.getTimestamp(1)) != null) {
                    this.v$holder.set((Object)new Long(t.getTime()));
                }
            }
            catch (SQLException ex) {
                this.v$qw.throwDBException(ex);
            }
        }

        public 2(DictionaryDatabase dictionaryDatabase, Holder holder, QueryWrapper queryWrapper) {
            this.v$qw = queryWrapper;
            this.v$holder = holder;
            this.this$0 = dictionaryDatabase;
        }
    }

    final class 3
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Holder v$holder;
        private final /* synthetic */ QueryWrapper v$qw;
        final /* synthetic */ DictionaryDatabase this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                Timestamp t;
                if (rs.next() && (t = rs.getTimestamp(1)) != null) {
                    this.v$holder.set((Object)new Long(t.getTime()));
                }
            }
            catch (SQLException ex) {
                this.v$qw.throwDBException(ex);
            }
        }

        public 3(DictionaryDatabase dictionaryDatabase, Holder holder, QueryWrapper queryWrapper) {
            this.v$qw = queryWrapper;
            this.v$holder = holder;
            this.this$0 = dictionaryDatabase;
        }
    }

    final class 4
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Map v$schemas;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ DictionaryDatabase this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    String username = rs.getString(1);
                    this.v$schemas.put(username, DictionaryDatabase.mav$createSchema(this.this$0, username));
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException(ex);
            }
        }

        public 4(DictionaryDatabase dictionaryDatabase, Map map, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$schemas = map;
            this.this$0 = dictionaryDatabase;
        }
    }

    final class 5
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Holder v$exists;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ DictionaryDatabase this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                this.v$exists.set((Object)rs.next());
            }
            catch (SQLException sqe) {
                this.v$wrap.throwDBException(sqe);
            }
        }

        public 5(DictionaryDatabase dictionaryDatabase, Holder holder, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$exists = holder;
            this.this$0 = dictionaryDatabase;
        }
    }

    final class 6
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Holder v$holder;
        private final /* synthetic */ DBObjectBuilder v$builder;
        private final /* synthetic */ DBObjectID v$id;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ DictionaryDatabase this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    Schema owner = this.this$0.getSchema(rs.getString(1));
                    String name = rs.getString(2);
                    this.v$holder.set((Object)((AbstractSchemaObject)this.v$builder.createObject(name, owner, this.v$id)));
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException((AbstractSchemaObject)this.v$holder.get(), ex);
            }
        }

        public 6(DictionaryDatabase dictionaryDatabase, Holder holder, DBObjectBuilder dBObjectBuilder, DBObjectID dBObjectID, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$id = dBObjectID;
            this.v$builder = dBObjectBuilder;
            this.v$holder = holder;
            this.this$0 = dictionaryDatabase;
        }
    }

    static class 7 {
        static final /* synthetic */ int[] $sm$oracle$javatools$db$dictionary$DictionaryQueries$Params;

        static {
            int[] nArray = new int[DictionaryQueries.Params.values().length];
            $sm$oracle$javatools$db$dictionary$DictionaryQueries$Params = nArray;
            try {
                nArray[DictionaryQueries.Params.SCHEMA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                7.$sm$oracle$javatools$db$dictionary$DictionaryQueries$Params[DictionaryQueries.Params.NAMEREF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                7.$sm$oracle$javatools$db$dictionary$DictionaryQueries$Params[DictionaryQueries.Params.TYPES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                7.$sm$oracle$javatools$db$dictionary$DictionaryQueries$Params[DictionaryQueries.Params.ALL_TYPES.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

