/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.diff.GenericDBObjectComparator;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyIterator;

public class ResultSetApplier {
    private List<DBObjectChange> m_events;

    public final void apply(ResultSet rs) {
        this.m_events = new ArrayList<DBObjectChange>();
        if (!rs.isSame()) {
            String rsType = rs.getType();
            if (rsType == "LIST") {
                List<ResultSet> change = rs.getModifiedObjectList();
                for (ResultSet child : change) {
                    if (child.getType() != "MAP") continue;
                    this.applyProperties(child, null);
                }
            } else if (rsType == "MAP") {
                this.applyProperties(rs, null);
            }
        }
    }

    private final void applyProperties(ResultSet rs, ResultSet parent) {
        Object b = rs.b();
        if (b != null) {
            TreeMap<PropertyInfo, ResultSet> process = new TreeMap<PropertyInfo, ResultSet>();
            Map<String, PropertyInfo> infos = PropertyIterator.getPropertyInfos(b);
            Map<String, ResultSet> changed = rs.getAllObjectsMap();
            for (String propertyName : changed.keySet()) {
                ResultSet change = changed.get(propertyName);
                if (change.isSame()) continue;
                Class objClass = rs.getResultSetClass();
                if (Map.class.isAssignableFrom(objClass)) {
                    ((Map)b).put(propertyName, change.a());
                    continue;
                }
                PropertyInfo info = infos.get(propertyName);
                if (info == null) {
                    throw new IllegalStateException("don't have a property info for property " + propertyName + " on object " + objClass);
                }
                process.put(info, change);
            }
            for (PropertyInfo info : process.keySet()) {
                ResultSet change = (ResultSet)process.get(info);
                Object[] value = null;
                boolean setProp = false;
                if (change.getType() == "MAP" && change.getModifiedObjectMap().size() > 0) {
                    this.applyProperties(change, rs);
                    if (change.b() == null) {
                        value = change.a();
                        setProp = true;
                    }
                } else if (change.getType() == "LEAF" || change.getType() == "MAP" && change.getModifiedObjectMap().size() == 0) {
                    value = change.a();
                    setProp = true;
                } else if (change.getType() == "LIST") {
                    List list = this.applyList(change, rs);
                    value = Array.newInstance(change.getResultSetClass().getComponentType(), list.size());
                    value = list.toArray((Object[])value);
                    setProp = true;
                }
                if (!setProp) continue;
                try {
                    info.setPropertyValue(b, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (parent == null) {
                this.m_events.add(new ResultSetChange(rs, null));
            }
        }
    }

    private final List applyList(ResultSet rs, ResultSet parent) {
        ArrayList<Object> value = new ArrayList<Object>();
        Iterator<ResultSet> changes = rs.getChildIterator();
        while (changes.hasNext()) {
            ResultSet child = changes.next();
            if (child.isSame()) {
                value.add(child.b());
                continue;
            }
            if (child.inAbutNotB()) {
                value.add(child.a());
                continue;
            }
            if (child.inBbutNotA() || !child.isModified()) continue;
            if (child.getType() == "LEAF") {
                value.add(child.a());
                continue;
            }
            if (child.a().getClass() != child.b().getClass()) {
                value.add(child.a());
                continue;
            }
            this.applyProperties(child, rs);
            value.add(child.b());
        }
        return value;
    }

    public void fireEvents() {
        for (DBObjectChange c : this.m_events) {
            DBObject obj = c.getDBObject();
            if (!(obj instanceof SchemaObject)) continue;
            ((SchemaObject)obj).fireObjectUpdated(c);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ResultSetChange
    extends DBObjectChange {
        private ResultSet m_rs;
        private List<DBObject> m_objectsAdded;
        private List<DBObject> m_objectsRemoved;
        private Map<DBObject, DBObjectChange> m_objectsChanged;
        private Map<String, PropertyChangeEvent> m_propsChanged;

        private ResultSetChange(ResultSet rs) {
            super((DBObject)rs.b());
            this.m_rs = rs;
        }

        @Override
        public List<DBObject> getOwnedObjectsAdded() {
            if (this.m_objectsAdded == null) {
                this.loadResultSet();
            }
            return this.m_objectsAdded;
        }

        @Override
        public Map<DBObject, DBObjectChange> getOwnedObjectsChanged() {
            if (this.m_objectsChanged == null) {
                this.loadResultSet();
            }
            return this.m_objectsChanged;
        }

        @Override
        public List<DBObject> getOwnedObjectsRemoved() {
            if (this.m_objectsRemoved == null) {
                this.loadResultSet();
            }
            return this.m_objectsRemoved;
        }

        @Override
        public Map<String, PropertyChangeEvent> getPropertiesChanged() {
            if (this.m_propsChanged == null) {
                this.loadResultSet();
            }
            return this.m_propsChanged;
        }

        private void loadResultSet() {
            HashMap<DBObject, ResultSetChange> objectsChanged = new HashMap<DBObject, ResultSetChange>();
            HashMap<String, PropertyChangeEvent> propsChanged = new HashMap<String, PropertyChangeEvent>();
            ArrayList<DBObject> objectsAdded = new ArrayList<DBObject>();
            ArrayList<DBObject> objectsRemoved = new ArrayList<DBObject>();
            Iterator<ResultSet> iter = this.m_rs.getChildIterator();
            while (iter.hasNext()) {
                ResultSet rs = iter.next();
                if (rs.isSame()) continue;
                boolean propChange = true;
                if (rs.getType() == "LIST") {
                    Class propClass = rs.getResultSetClass();
                    if (propClass.isArray() && DBObject.class.isAssignableFrom(propClass.getComponentType())) {
                        propChange = false;
                        Iterator<ResultSet> childIter = rs.getChildIterator();
                        while (childIter.hasNext()) {
                            ResultSet crs = childIter.next();
                            if (!crs.isSame()) {
                                DBObject a = (DBObject)crs.a();
                                DBObject b = (DBObject)crs.b();
                                if (a == null && b != null) {
                                    objectsRemoved.add(b);
                                } else if (a != null && b == null) {
                                    objectsAdded.add(a);
                                } else {
                                    objectsChanged.put(b, new ResultSetChange(crs));
                                }
                            }
                            int indexA = crs.getIndexOfA();
                            int indexB = crs.getIndexOfB();
                            if (indexA < 0 || indexB < 0 || indexA == indexB) continue;
                            objectsChanged.put((DBObject)crs.b(), new ResultSetChange(crs));
                        }
                    }
                } else if (rs.getType() == "MAP") {
                    GenericDBObjectComparator comparator;
                    Object a = rs.a();
                    Object b = rs.b();
                    if (a instanceof DBObject && b instanceof DBObject && (comparator = new GenericDBObjectComparator()).compare(a, b) == 0) {
                        propChange = false;
                        objectsChanged.put((DBObject)b, new ResultSetChange(rs));
                    }
                }
                if (!propChange) continue;
                String propName = rs.getPropertyName();
                PropertyChangeEvent pce = new PropertyChangeEvent(this.m_rs.b(), propName, rs.b(), rs.a());
                propsChanged.put(propName, pce);
            }
            this.m_objectsAdded = Collections.unmodifiableList(objectsAdded);
            this.m_objectsRemoved = Collections.unmodifiableList(objectsRemoved);
            this.m_objectsChanged = Collections.unmodifiableMap(objectsChanged);
            this.m_propsChanged = Collections.unmodifiableMap(propsChanged);
        }

        ResultSetChange(ResultSet resultSet, 1 var3_3) {
            this(resultSet);
        }

        public final class 1 {
        }
    }
}

