/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Schema;
import oracle.javatools.util.ModelUtil;

public class DatabaseLink
extends AbstractSchemaObject {
    public static final String TYPE = "DATABASE LINK";
    private String m_username;
    private String m_password;
    private String m_host;
    private String m_created;
    private DBObjectProvider m_dblink;
    private boolean m_public;
    private boolean m_shared;
    private boolean m_currentUser;
    private String m_authentificationUser;
    private String m_authentificationPassword;

    public DatabaseLink() {
    }

    public DatabaseLink(String name, Schema schema, DBObjectID id) {
        super(name, schema, id);
    }

    public String getType() {
        return TYPE;
    }

    public boolean isPublic() {
        this.checkInit();
        return this.m_public;
    }

    public void setPublic(boolean pub) {
        this.checkInit();
        this.m_public = pub;
    }

    public boolean isShared() {
        this.checkInit();
        return this.m_shared;
    }

    public void setShared(boolean shared) {
        this.checkInit();
        this.m_shared = shared;
    }

    public boolean isCurrentUser() {
        this.checkInit();
        return this.m_currentUser;
    }

    public void setCurrentUser(boolean currentUser) {
        this.checkInit();
        this.m_currentUser = currentUser;
    }

    public String getUsername() {
        this.checkInit();
        return this.m_username;
    }

    public void setUsername(String username) {
        this.checkInit();
        this.m_username = username;
    }

    public String getPassword() {
        this.checkInit();
        return this.m_password;
    }

    public void setPassword(String password) {
        this.checkInit();
        this.m_password = password;
    }

    public String getHost() {
        this.checkInit();
        return this.m_host;
    }

    public void setHost(String host) {
        this.checkInit();
        this.m_host = host;
    }

    public String getCreated() {
        this.checkInit();
        return this.m_created;
    }

    public void setCreated(String created) {
        this.checkInit();
        this.m_created = created;
    }

    public DBObjectProvider getDBLink() {
        this.checkInit();
        return this.m_dblink;
    }

    public String getAuthentificationUser() {
        this.checkInit();
        return this.m_authentificationUser;
    }

    public void setAuthentificationUsername(String username) {
        this.checkInit();
        this.m_authentificationUser = username;
    }

    public String getAuthentificationPassword() {
        this.checkInit();
        return this.m_authentificationPassword;
    }

    public void setAuthentificationPassword(String password) {
        this.checkInit();
        this.m_authentificationPassword = password;
    }

    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        DatabaseLink copy = target == null ? new DatabaseLink() : (DatabaseLink)target;
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(DatabaseLink copy, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(copy, copyParent, idPolicy);
        copy.m_created = this.m_created;
        copy.m_dblink = this.m_dblink;
        copy.m_host = this.m_host;
        copy.m_username = this.m_username;
        copy.m_password = this.m_password;
        copy.m_public = this.m_public;
        copy.m_shared = this.m_shared;
        copy.m_currentUser = this.m_currentUser;
        copy.m_authentificationUser = this.m_authentificationUser;
        copy.m_authentificationPassword = this.m_authentificationPassword;
    }

    public boolean equals(Object obj) {
        return obj instanceof DatabaseLink && this.equalsImpl((DatabaseLink)obj);
    }

    protected boolean equalsImpl(DatabaseLink target) {
        return super.equalsImpl(target) && ModelUtil.areEqual((Object)this.m_created, (Object)target.m_created) && ModelUtil.areEqual((Object)this.m_host, (Object)target.m_host) && ModelUtil.areEqual((Object)this.m_username, (Object)target.m_username) && ModelUtil.areEqual((Object)this.m_password, (Object)target.m_password) && ModelUtil.areEqual((Object)this.m_dblink, (Object)target.m_dblink) && ModelUtil.areEqual((Object)this.m_authentificationUser, (Object)target.m_authentificationUser) && ModelUtil.areEqual((Object)this.m_authentificationPassword, (Object)target.m_authentificationPassword) && this.m_public == target.m_public && this.m_shared == target.m_shared && this.m_currentUser == target.m_currentUser;
    }
}

